/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.mdi.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.mdi.client.AboutDialog;
import org.openswing.swing.mdi.client.ChangeLanguageDialog;
import org.openswing.swing.mdi.client.ClientFacade;
import org.openswing.swing.mdi.client.DesktopPane;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIController;
import org.openswing.swing.mdi.client.StatusBar;
import org.openswing.swing.mdi.client.TreeMenu;
import org.openswing.swing.mdi.client.WinIconsPanel;
import org.openswing.swing.mdi.client.WindowMenu;
import org.openswing.swing.mdi.java.ApplicationFunction;
import org.openswing.swing.util.client.ApplicationEventQueue;
import org.openswing.swing.util.client.BusyListener;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class MDIFrame
extends JFrame
implements BusyListener {
    private BorderLayout borderLayout1;
    private JPanel bottomPanel;
    private static Integer busyCount;
    static /* synthetic */ Class class$java$lang$String;
    private static MDIController client;
    private static Hashtable componentsHooks;
    private JPanel contentPane;
    private static DesktopPane desktopPane;
    private Hashtable functionsHooks;
    private Hashtable functionsMenuHooks;
    private GridBagLayout gridBagLayout1;
    private int lastTreeMenuWidth = 0;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu menuFile = new JMenu();
    private JMenuItem menuFileChangeLanguage;
    private JMenuItem menuFileChangeUser = new JMenuItem();
    private JMenuItem menuFileExit;
    private JMenu menuHelp;
    private JMenuItem menuHelpAbout;
    private static WindowMenu menuWindow;
    private JScrollPane scrollPane;
    private JSplitPane splitPane;
    private BasicSplitPaneUI splitPaneUI;
    private static StatusBar statusBar;
    private JToolBar toolbar;
    private boolean toolbarAdded = false;
    private static TreeMenu treeMenu;
    private HashSet uniqueInstances;
    private static WinIconsPanel winIconsPanel;

    static {
        try {
            if (!Beans.isDesignTime() && System.getProperty("os.name").toLowerCase().startsWith("linux") && System.getProperty("java.version").startsWith("1.6") && ClientSettings.LOOK_AND_FEEL_CLASS_NAME.endsWith("GTKLookAndFeel")) {
                ClientSettings.LOOK_AND_FEEL_CLASS_NAME = "javax.swing.plaf.metal.MetalLookAndFeel";
            }
            UIManager.setLookAndFeel(ClientSettings.LOOK_AND_FEEL_CLASS_NAME);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            JFrame.setDefaultLookAndFeelDecorated(ClientSettings.MDI_FRAME_DECORATED);
            JDialog.setDefaultLookAndFeelDecorated(ClientSettings.MDI_FRAME_DECORATED);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        menuWindow = new WindowMenu();
        statusBar = new StatusBar();
        desktopPane = new DesktopPane();
        treeMenu = null;
        busyCount = new Integer(0);
        client = null;
        winIconsPanel = new WinIconsPanel();
        componentsHooks = new Hashtable();
    }

    public MDIFrame(MDIController client) {
        super(client.getMDIFrameTitle());
        this.menuFileChangeLanguage = new JMenuItem();
        this.menuFileExit = new JMenuItem();
        this.menuHelp = new JMenu();
        this.menuHelpAbout = new JMenuItem();
        this.borderLayout1 = new BorderLayout();
        this.scrollPane = new JScrollPane(desktopPane);
        this.splitPane = new JSplitPane();
        this.splitPaneUI = new BasicSplitPaneUI();
        this.bottomPanel = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.toolbar = new JToolBar();
        this.functionsHooks = new Hashtable();
        this.functionsMenuHooks = new Hashtable();
        this.uniqueInstances = new HashSet();
        try {
            SwingUtilities.updateComponentTreeUI(this);
            MDIFrame.client = client;
            ClientUtils.addBusyListener(this);
            statusBar.removeAll();
            componentsHooks.clear();
            menuWindow.init();
            menuWindow.menuWindowCloseAll_actionPerformed(null);
            this.enableEvents(64L);
            desktopPane.init(client);
            winIconsPanel.init();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(screenSize);
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    MDIFrame.this.onWindowClosing();
                }
            });
            try {
                ClientSettings.getInstance().getUserGridProfiles().clear();
                ClientSettings.getInstance().getLastUserGridDigests().clear();
                ClientSettings.getInstance().getLastUserGridProfileIds().clear();
                ClientSettings.getInstance().getGridProfileDescriptions().clear();
                ClientSettings.getInstance().getGridPermissions().clear();
                ClientSettings.getInstance().getLastGridPermissionsDigests().clear();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            if (ClientSettings.MDI_TOOLBAR != null) {
                this.toolbar.add(ClientSettings.MDI_TOOLBAR);
                if (!this.toolbarAdded) {
                    this.toolbarAdded = true;
                    this.contentPane.add((Component)this.toolbar, "North");
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception ex1) {
                // empty catch block
            }
            this.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    2 v0 = this;
                    client.afterMDIcreation(MDIFrame.this);
                }
            });
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static final void add(InternalFrame frame, boolean maximum) {
        if (frame.isUniqueInstance()) {
            if (MDIFrame.getInstance().isUniqueInstanceAlreadyOpened(frame)) {
                return;
            }
            MDIFrame.getInstance().uniqueInstances.add(frame.getClass());
        }
        ClientUtils.fireBusyEvent(true);
        try {
            desktopPane.add(frame, maximum);
            menuWindow.addWindow(frame);
            if (client.viewOpenedWindowIcons()) {
                winIconsPanel.add(frame);
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        ClientUtils.fireBusyEvent(false);
    }

    public static final void add(InternalFrame frame) {
        MDIFrame.add(frame, false);
    }

    public final JButton addButtonToToolBar(Image image, String tooltipText, String buttonText) {
        JButton button = new JButton(ClientSettings.getInstance().getResources().getResource(buttonText), new ImageIcon(image));
        button.setToolTipText(ClientSettings.getInstance().getResources().getResource(tooltipText));
        this.toolbar.add(button);
        if (!this.toolbarAdded) {
            this.toolbarAdded = true;
            this.contentPane.add((Component)this.toolbar, "North");
        }
        return button;
    }

    public final JButton addButtonToToolBar(String imageName, String tooltipText, String buttonText) {
        return this.addButtonToToolBar(ClientUtils.getImage(imageName), tooltipText, buttonText);
    }

    public final JButton addButtonToToolBar(Image image, String tooltipText) {
        JButton button = new JButton(new ImageIcon(image));
        button.setToolTipText(ClientSettings.getInstance().getResources().getResource(tooltipText));
        this.toolbar.add(button);
        if (!this.toolbarAdded) {
            this.toolbarAdded = true;
            this.contentPane.add((Component)this.toolbar, "North");
        }
        return button;
    }

    public final JButton addButtonToToolBar(String imageName, String tooltipText) {
        return this.addButtonToToolBar(ClientUtils.getImage(imageName), tooltipText);
    }

    public final void addButtonToToolBar(JButton button) {
        this.toolbar.add(button);
        if (!this.toolbarAdded) {
            this.toolbarAdded = true;
            this.contentPane.add((Component)this.toolbar, "North");
        }
    }

    public final void addSeparatorOnToolBar(Dimension dim) {
        this.toolbar.addSeparator(dim);
        if (!this.toolbarAdded) {
            this.toolbarAdded = true;
            this.contentPane.add((Component)this.toolbar, "North");
        }
    }

    public final void addSeparatorToMenuBar(String topFunctionId, String bottomFunctionId) {
        JMenuItem topMenuItem = this.getMenuItem(topFunctionId);
        JMenu topMenu = (JMenu)this.functionsMenuHooks.get(topFunctionId);
        JMenu bottomMenu = (JMenu)this.functionsMenuHooks.get(bottomFunctionId);
        if (topMenu != null && bottomMenu != null) {
            int i = 0;
            while (i < topMenu.getMenuComponentCount()) {
                if (topMenu.getMenuComponent(i).equals(topMenuItem)) {
                    topMenu.insertSeparator(i + 1);
                    break;
                }
                ++i;
            }
        }
    }

    public final void addSeparatorToToolBar() {
        this.toolbar.addSeparator();
        if (!this.toolbarAdded) {
            this.toolbarAdded = true;
            this.contentPane.add((Component)this.toolbar, "North");
        }
    }

    public static final void addStatusComponent(String name, JComponent c) {
        if (name != null) {
            componentsHooks.put(name, c);
        }
        statusBar.addStatusComponent(c);
    }

    public static final void addStatusComponent(JComponent c) {
        MDIFrame.addStatusComponent(c.getName(), c);
    }

    /*
     * Unable to fully structure code
     */
    private void addSubFunctionsToMenuBar(JMenuItem parentMenu, ApplicationFunction parentFunction, HashSet mnem) {
        menu = null;
        i = 0;
        while (i < parentFunction.getChildCount()) {
            block13: {
                function = (ApplicationFunction)parentFunction.getChildAt(i);
                if (!function.isFolder()) break block13;
                menu = new JMenu(function.toString());
                if (ClientSettings.SHOW_TOOLTIP_IN_MENUBAR) {
                    menu.setToolTipText(function.getTooltipText());
                }
                this.maybeAddTooltipToStatusBar(menu, function);
                ** GOTO lbl37
            }
            if (function.isSeparator()) {
                parentMenu.add(new JSeparator());
            } else {
                if (function.getIconName() == null) {
                    menu = new JMenuItem(function.toString());
                    if (ClientSettings.SHOW_TOOLTIP_IN_MENUBAR) {
                        menu.setToolTipText(function.getTooltipText());
                    }
                    this.maybeAddTooltipToStatusBar(menu, function);
                } else {
                    menu = new JMenuItem(function.toString(), new ImageIcon(ClientUtils.getImage(function.getIconName())));
                    if (ClientSettings.SHOW_TOOLTIP_IN_MENUBAR) {
                        menu.setToolTipText(function.getTooltipText());
                    }
                    this.maybeAddTooltipToStatusBar(menu, function);
                }
                menu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MDIFrame.this.executeFunction(function);
                    }
                });
                if (function.getFunctionId() != null && !function.getFunctionId().trim().equals("")) {
                    this.functionsHooks.put(function.getFunctionId(), menu);
                    this.functionsMenuHooks.put(function.getFunctionId(), parentMenu);
                }
lbl37:
                // 4 sources

                j = 0;
                try {
                    while (j < menu.getText().length() && (mnem.contains(menu.getText().substring(j, j + 1)) || !Character.isLetterOrDigit(menu.getText().charAt(j)))) {
                        ++j;
                    }
                    if (j < menu.getText().length()) {
                        mnem.add(menu.getText().substring(j, j + 1));
                        menu.setMnemonic(menu.getText().substring(j, j + 1).charAt(0));
                    }
                }
                catch (Exception ex1) {
                    // empty catch block
                }
                parentMenu.add(menu);
                this.addSubFunctionsToMenuBar(menu, function, mnem);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void executeFunction(final ApplicationFunction node) {
        ClientUtils.fireBusyEvent(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    try {
                        MDIFrame.getClientFacade().getClass().getMethod(node.getMethodName(), new Class[0]).invoke((Object)MDIFrame.getClientFacade(), new Object[0]);
                        ClientUtils.fireBusyEvent(false);
                    }
                    catch (NoSuchMethodException ex1) {
                        MDIFrame.getClientFacade().getClass().getMethod(node.getMethodName(), class$java$lang$String == null ? (class$java$lang$String = MDIFrame.class$("java.lang.String")) : class$java$lang$String).invoke((Object)MDIFrame.getClientFacade(), node.getFunctionId());
                        ClientUtils.fireBusyEvent(false);
                    }
                }
                catch (Throwable ex) {
                    ClientUtils.fireBusyEvent(false);
                    ex.printStackTrace();
                    OptionPane.showMessageDialog(MDIFrame.this, ClientSettings.getInstance().getResources().getResource("Error while executing function") + " '" + node.getMethodName() + "'", ClientSettings.getInstance().getResources().getResource("Error"), 2);
                }
            }
        });
    }

    public static ClientFacade getClientFacade() {
        return client.getClientFacade();
    }

    public static Dimension getDesktopDimension() {
        return desktopPane.getSize();
    }

    public static MDIFrame getInstance() {
        Container c = desktopPane.getParent();
        while (c != null && !(c instanceof JFrame)) {
            c = c.getParent();
        }
        return (MDIFrame)c;
    }

    public final JMenu getMenuFile() {
        return this.menuFile;
    }

    public final JMenu getMenuHelp() {
        return this.menuHelp;
    }

    public final JMenuItem getMenuItem(String functionId) {
        return (JMenuItem)this.functionsHooks.get(functionId);
    }

    public final int getProgressBarValue() {
        return statusBar.getProgressBarValue();
    }

    public static InternalFrame getSelectedFrame() {
        return (InternalFrame)desktopPane.getSelectedFrame();
    }

    public static final StatusBar getStatusBar() {
        return statusBar;
    }

    public static final JComponent getStatusComponent(String name) {
        return (JComponent)componentsHooks.get(name);
    }

    public static WindowMenu getWindowMenu() {
        return menuWindow;
    }

    public final boolean isLocked() {
        return treeMenu.isLocked();
    }

    public final boolean isUniqueInstanceAlreadyOpened(InternalFrame frame) {
        return this.uniqueInstances.contains(frame.getClass());
    }

    private void jbInit() throws Exception {
        DefaultTreeModel functions;
        block19: {
            this.setIconImage(ClientUtils.getImage(ClientSettings.ICON_FILENAME));
            this.contentPane = (JPanel)this.getContentPane();
            this.contentPane.setLayout(this.borderLayout1);
            statusBar.setText(" ");
            this.menuFile.setText(ClientSettings.getInstance().getResources().getResource("file"));
            this.menuFile.setMnemonic(ClientSettings.getInstance().getResources().getResource("filemnemonic").charAt(0));
            this.menuFileExit.setText(ClientSettings.getInstance().getResources().getResource("exit"));
            this.menuFileExit.setMnemonic(ClientSettings.getInstance().getResources().getResource("exitmnemonic").charAt(0));
            this.menuFileExit.setAccelerator(KeyStroke.getKeyStroke(88, 2));
            this.menuFileExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MDIFrame.this.menuFileExit_actionPerformed(e);
                }
            });
            this.menuFileChangeUser.setText(ClientSettings.getInstance().getResources().getResource("change user"));
            this.menuFileChangeUser.setMnemonic(ClientSettings.getInstance().getResources().getResource("changeusermnemonic").charAt(0));
            this.menuFileChangeUser.setAccelerator(KeyStroke.getKeyStroke(85, 2));
            this.menuFileChangeUser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MDIFrame.this.menuFileChangeUser_actionPerformed(e);
                }
            });
            this.menuFileChangeLanguage.setText(ClientSettings.getInstance().getResources().getResource("change language"));
            this.menuFileChangeLanguage.setMnemonic(ClientSettings.getInstance().getResources().getResource("changelanguagemnemonic").charAt(0));
            this.menuFileChangeLanguage.setAccelerator(KeyStroke.getKeyStroke(76, 2));
            this.menuFileChangeLanguage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MDIFrame.this.menuFileChangeLanguage_actionPerformed(e);
                }
            });
            this.menuHelp.setText(ClientSettings.getInstance().getResources().getResource("help"));
            this.menuHelp.setMnemonic(ClientSettings.getInstance().getResources().getResource("helpmnemonic").charAt(0));
            this.menuHelpAbout.setText(ClientSettings.getInstance().getResources().getResource("about") + " " + client.getMDIFrameTitle());
            this.menuHelpAbout.setMnemonic(ClientSettings.getInstance().getResources().getResource("aboutmnemonic").charAt(0));
            this.menuHelpAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MDIFrame.this.menuHelpAbout_actionPerformed(e);
                }
            });
            if (client.viewLoginInMenuBar()) {
                this.menuFile.add(this.menuFileChangeUser);
            }
            if (client.viewChangeLanguageInMenuBar() && client.getLanguages().size() > 1) {
                this.menuFile.add(this.menuFileChangeLanguage);
            }
            this.menuFile.addSeparator();
            this.menuFile.add(this.menuFileExit);
            this.menuHelp.add(this.menuHelpAbout);
            this.menuBar.add(this.menuFile);
            functions = null;
            try {
                functions = client.getApplicationFunctions();
                if (!client.viewFunctionsInMenuBar()) break block19;
                JMenu menu = null;
                TreeNode root = (TreeNode)functions.getRoot();
                HashSet<String> mnem = new HashSet<String>();
                int i = 0;
                while (i < root.getChildCount()) {
                    block22: {
                        ApplicationFunction function;
                        block21: {
                            block20: {
                                function = (ApplicationFunction)root.getChildAt(i);
                                if (!function.isFolder()) break block20;
                                menu = new JMenu(function.toString());
                                if (ClientSettings.SHOW_TOOLTIP_IN_MENUBAR) {
                                    menu.setToolTipText(function.getTooltipText());
                                }
                                this.maybeAddTooltipToStatusBar(menu, function);
                                break block21;
                            }
                            if (function.isSeparator()) break block22;
                            menu = new JMenu(function.toString());
                            if (ClientSettings.SHOW_TOOLTIP_IN_MENUBAR) {
                                menu.setToolTipText(function.getTooltipText());
                            }
                            this.maybeAddTooltipToStatusBar(menu, function);
                            menu.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    MDIFrame.this.executeFunction(function);
                                }
                            });
                        }
                        int j = 0;
                        try {
                            while (j < function.toString().length() && mnem.contains(function.toString().substring(j, j + 1))) {
                                ++j;
                            }
                            if (j < function.toString().length()) {
                                mnem.add(function.toString().substring(j, j + 1));
                                menu.setMnemonic(function.toString().substring(j, j + 1).charAt(0));
                            }
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                        this.menuBar.add((Component)menu);
                        this.addSubFunctionsToMenuBar(menu, function, mnem);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                Logger.error(this.getClass().getName(), "jbInit", "Error while constructing the functions menu", ex);
            }
        }
        this.menuBar.add(menuWindow);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        JFrame.setDefaultLookAndFeelDecorated(ClientSettings.MDI_FRAME_DECORATED);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.setExtendedState(this.getExtendedState() | client.getExtendedState());
        desktopPane.setPreferredSize(new Dimension(this.getWidth() - ClientSettings.DIVIDER_WIDTH - 6 - ClientSettings.MENU_WIDTH, this.getHeight() - this.menuBar.getHeight() - statusBar.getHeight() - 103));
        if (client.viewFunctionsInTreePanel() && ((TreeNode)functions.getRoot()).getChildCount() > 0) {
            treeMenu = new TreeMenu(functions);
            treeMenu.setMinimumSize(new Dimension(ClientSettings.MIN_MENU_WIDTH, 0));
            treeMenu.setMaximumSize(new Dimension(ClientSettings.MAX_MENU_WIDTH, 0));
            treeMenu.addMouseListener(new MenuMouseListener());
            this.lastTreeMenuWidth = treeMenu.getWidth();
            this.splitPane.setLeftComponent(treeMenu);
            if (ClientSettings.SHOW_SCROLLBARS_IN_MDI) {
                this.scrollPane.setPreferredSize(new Dimension(this.getWidth() - ClientSettings.DIVIDER_WIDTH - 6 - ClientSettings.MENU_WIDTH, this.getHeight() - this.menuBar.getHeight() - statusBar.getHeight() - 103));
                desktopPane.setPreferredSize(new Dimension(this.getWidth() - ClientSettings.DIVIDER_WIDTH - 6 - ClientSettings.MENU_WIDTH - this.scrollPane.getVerticalScrollBar().getPreferredSize().width, this.getHeight() - this.menuBar.getHeight() - statusBar.getHeight() - 103 - this.scrollPane.getHorizontalScrollBar().getPreferredSize().height - 20));
                this.splitPane.setRightComponent(this.scrollPane);
                this.scrollPane.getViewport().add(desktopPane);
            } else {
                this.splitPane.setRightComponent(desktopPane);
            }
            this.resetSplitPane();
            this.contentPane.add((Component)this.splitPane, "Center");
            ApplicationEventQueue.getInstance().addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == ClientSettings.TREE_MENU_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.TREE_MENU_KEY.getModifiers()) {
                        treeMenu.getFindTF().requestFocus();
                    }
                }
            });
            treeMenu.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    JInternalFrame[] frames = desktopPane.getAllFrames();
                    int i = 0;
                    while (i < frames.length) {
                        frames[i].setLocation(MDIFrame.this.lastTreeMenuWidth - treeMenu.getWidth() + frames[i].getX(), frames[i].getY());
                        ++i;
                    }
                    MDIFrame.this.lastTreeMenuWidth = treeMenu.getWidth();
                }
            });
        } else if (ClientSettings.SHOW_SCROLLBARS_IN_MDI) {
            this.scrollPane.setPreferredSize(new Dimension(this.getWidth() - ClientSettings.DIVIDER_WIDTH - 6 - ClientSettings.MENU_WIDTH, this.getHeight() - this.menuBar.getHeight() - statusBar.getHeight() - 103));
            desktopPane.setPreferredSize(new Dimension(this.getWidth() - ClientSettings.DIVIDER_WIDTH - 6 - ClientSettings.MENU_WIDTH - this.scrollPane.getVerticalScrollBar().getPreferredSize().width, this.getHeight() - this.menuBar.getHeight() - statusBar.getHeight() - 103 - this.scrollPane.getHorizontalScrollBar().getPreferredSize().height - 20));
            this.scrollPane.getViewport().add(desktopPane);
            this.contentPane.add((Component)this.scrollPane, "Center");
        } else {
            this.contentPane.add((Component)desktopPane, "Center");
        }
        this.contentPane.add((Component)this.bottomPanel, "South");
        this.bottomPanel.setLayout(this.gridBagLayout1);
        if (client.viewOpenedWindowIcons()) {
            this.bottomPanel.add((Component)winIconsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.bottomPanel.add((Component)statusBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void maybeAddTooltipToStatusBar(JMenuItem menu, final ApplicationFunction function) {
        if (ClientSettings.SHOW_TOOLTIP_IN_MDISTATUSBAR) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            menu.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    MDIFrame.getStatusBar().setText(function.getTooltipText());
                }

                public void mouseExited(MouseEvent e) {
                    MDIFrame.getStatusBar().setText("");
                }
            });
        }
    }

    public void menuFileChangeLanguage_actionPerformed(ActionEvent e) {
        new ChangeLanguageDialog(this, client);
    }

    public void menuFileChangeUser_actionPerformed(ActionEvent e) {
        client.viewLoginDialog(this);
    }

    public void menuFileExit_actionPerformed(ActionEvent e) {
        this.onWindowClosing();
    }

    public void menuHelpAbout_actionPerformed(ActionEvent e) {
        AboutDialog dlg = new AboutDialog(this, client.getAboutText(), client.getAboutImage());
    }

    private void onWindowClosing() {
        Object[] opt = new Object[]{ClientSettings.getInstance().getResources().getResource("yes"), ClientSettings.getInstance().getResources().getResource("no")};
        if (JOptionPane.showOptionDialog(this, ClientSettings.getInstance().getResources().getResource("are you sure to quit application?"), ClientSettings.getInstance().getResources().getResource("quit application"), -1, 3, null, opt, opt[0]) == 0) {
            client.stopApplication();
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.onWindowClosing();
        } else {
            super.processWindowEvent(e);
        }
    }

    private void resetSplitPane() {
        this.splitPane.setUI(this.splitPaneUI);
        this.splitPane.setPreferredSize(this.getSize());
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(ClientSettings.DIVIDER_WIDTH);
        this.splitPane.setDividerLocation(ClientSettings.MENU_WIDTH);
        this.splitPane.setLastDividerLocation(0);
        this.splitPaneUI.getDivider().addMouseListener(new DivMouseListener());
    }

    public final void setBorderPainterOnToolBar(boolean borderPainted) {
        this.toolbar.setBorderPainted(borderPainted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBusy(boolean busy) {
        if (client == null) {
            return;
        }
        Integer n = busyCount;
        synchronized (n) {
            if (busyCount == 0 && busy) {
                statusBar.setBusy(true);
                try {
                    desktopPane.setCursor(new Cursor(3));
                    desktopPane.getToolkit().sync();
                    treeMenu.setCursor(new Cursor(3));
                    treeMenu.getToolkit().sync();
                }
                catch (Exception ex) {
                }
            }
            if (busy) {
                busyCount = new Integer(busyCount + 1);
            } else if (busyCount > 0) {
                busyCount = new Integer(busyCount - 1);
            }
            if (busyCount == 0) {
                statusBar.setBusy(false);
                try {
                    desktopPane.setCursor(new Cursor(0));
                    desktopPane.getToolkit().sync();
                    treeMenu.setCursor(new Cursor(0));
                    treeMenu.getToolkit().sync();
                }
                catch (Exception ex) {
                }
            }
        }
    }

    public final void setFloatableOnToolBar(boolean floatable) {
        this.toolbar.setFloatable(floatable);
    }

    public final void setLocked(boolean locked) {
        treeMenu.setLocked(locked);
        if (!locked && this.splitPane.getDividerLocation() > 0) {
            this.splitPane.setDividerLocation(0);
        }
    }

    public final void setOrientationOnToolBar(int orientation) {
        this.toolbar.setOrientation(orientation);
    }

    public final void setProgressBarValue(int progressBarValue) {
        statusBar.setProgressBarValue(progressBarValue);
    }

    public final void setRolloverOnToolBar(boolean rollover) {
        this.toolbar.setRollover(rollover);
    }

    public static final void setStatusBar(String text) {
        statusBar.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void windowClosed(JInternalFrame frame) {
        if (frame instanceof InternalFrame && ((InternalFrame)frame).isUniqueInstance()) {
            this.uniqueInstances.remove(frame.getClass());
        }
        Integer n = busyCount;
        synchronized (n) {
            busyCount = new Integer(1);
        }
        this.setBusy(false);
    }

    class DivMouseListener
    extends MouseAdapter {
        DivMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            if (!MDIFrame.this.isLocked() && MDIFrame.this.splitPane.getDividerLocation() <= 1) {
                MDIFrame.this.splitPane.setDividerLocation(MDIFrame.this.splitPane.getLastDividerLocation());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!MDIFrame.this.isLocked() && e.getX() > 0 && MDIFrame.this.splitPane.getDividerLocation() > 0) {
                MDIFrame.this.splitPane.setDividerLocation(0);
            }
        }
    }

    class MenuMouseListener
    extends MouseAdapter {
        MenuMouseListener() {
        }

        public void mouseExited(MouseEvent e) {
            if (!(MDIFrame.this.isLocked() || e.getY() >= 0 && e.getX() <= treeMenu.getWidth() || MDIFrame.this.splitPane.getDividerLocation() <= 0)) {
                MDIFrame.this.splitPane.setDividerLocation(0);
            }
        }
    }
}

