/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.mdi.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.openswing.swing.util.client.ClientSettings;

public class StatusBar
extends JPanel {
    private boolean busy = false;
    private int delay;
    GridBagLayout gridBagLayout1;
    private int pos = 2;
    JProgressBar progressBar;
    private Color progressBarColor;
    JTextField statusText = new JTextField();

    public StatusBar() {
        this.gridBagLayout1 = new GridBagLayout();
        this.progressBar = new JProgressBar(0, 15);
        this.delay = ClientSettings.PROGRESS_BAR_DELAY;
        this.progressBarColor = ClientSettings.PROGRESS_BAR_COLOR;
        try {
            this.jbInit();
            this.progressBar.setForeground(this.progressBarColor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void addStatusComponent(JComponent c) {
        this.add((Component)c, new GridBagConstraints(this.pos++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 2), 0, 0));
    }

    public final int getProgressBarValue() {
        return this.progressBar.getValue();
    }

    private void jbInit() throws Exception {
        this.statusText.setOpaque(false);
        this.statusText.setEditable(false);
        this.statusText.setText(" ");
        this.setLayout(this.gridBagLayout1);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.progressBar.setPreferredSize(new Dimension(200, (int)this.statusText.getPreferredSize().getHeight()));
        this.add((Component)this.progressBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 2), 0, 0));
        int pos = 1;
        this.add((Component)this.statusText, new GridBagConstraints(pos, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 2), 0, 0));
    }

    public void removeAll() {
        super.removeAll();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void setBusy(boolean busy) {
        this.busy = busy;
        if (busy) {
            this.statusText.setText(ClientSettings.getInstance().getResources().getResource("Operation in progress..."));
            new ProgressBarThread().start();
        } else {
            this.statusText.setText("");
        }
    }

    public void setProgressBarColor(Color progressBarColor) {
        this.progressBarColor = progressBarColor;
        this.progressBar.setForeground(progressBarColor);
    }

    public final void setProgressBarValue(int progressBarValue) {
        if (progressBarValue < 0) {
            progressBarValue = 0;
        }
        if (progressBarValue > this.progressBar.getMaximum()) {
            progressBarValue = this.progressBar.getMaximum();
        }
        this.progressBar.setValue(progressBarValue);
    }

    public final void setText(String text) {
        this.statusText.setText(text);
    }

    class ProgressBarThread
    extends Thread {
        private boolean leftToRight = true;

        ProgressBarThread() {
        }

        public void run() {
            while (StatusBar.this.busy) {
                if (StatusBar.this.progressBar.getValue() == StatusBar.this.progressBar.getMaximum()) {
                    this.leftToRight = false;
                } else if (StatusBar.this.progressBar.getValue() == StatusBar.this.progressBar.getMinimum()) {
                    this.leftToRight = true;
                }
                StatusBar.this.progressBar.setValue(StatusBar.this.progressBar.getValue() + (this.leftToRight ? 1 : -1));
                try {
                    Thread.sleep(StatusBar.this.delay);
                }
                catch (InterruptedException ex) {
                }
            }
            StatusBar.this.progressBar.setValue(StatusBar.this.progressBar.getMinimum());
        }
    }
}

