/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.mdi.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.mdi.client.SwitchDialog_cancelButton_actionAdapter;
import org.openswing.swing.mdi.client.SwitchDialog_list_mouseAdapter;
import org.openswing.swing.mdi.client.SwitchDialog_okButton_actionAdapter;
import org.openswing.swing.mdi.client.WindowsList;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class SwitchDialog
extends JDialog {
    JPanel buttonsPane;
    JButton cancelButton;
    TextControl controlFilter;
    JPanel filterPanel = new JPanel();
    FlowLayout flowLayout1;
    private ArrayList frames;
    GridBagLayout gridBagLayout1;
    private WindowsList internalFrames;
    LabelControl labelFilter;
    LabelControl labelTitle;
    JList list;
    JButton okButton;
    JScrollPane scrollPane;

    public SwitchDialog(WindowsList internalFrames) {
        super(MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource("switch"), true);
        this.buttonsPane = new JPanel();
        this.flowLayout1 = new FlowLayout();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.gridBagLayout1 = new GridBagLayout();
        this.labelFilter = new LabelControl();
        this.controlFilter = new TextControl();
        this.labelTitle = new LabelControl();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.internalFrames = new WindowsList();
        this.frames = new ArrayList();
        this.internalFrames = internalFrames;
        try {
            this.jbInit();
            this.init();
            this.setSize(300, 300);
            this.setDefaultCloseOperation(2);
            ClientUtils.centerDialog(MDIFrame.getInstance(), this);
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void init() {
        this.list.setSelectionForeground((Color)UIManager.get("TextField.foreground"));
        this.list.setBackground((Color)UIManager.get("TextField.background"));
        this.list.setSelectionBackground(ClientSettings.BACKGROUND_SEL_COLOR);
        ArrayList winList = this.internalFrames.getList();
        JInternalFrame f = null;
        DefaultListModel<String> model = new DefaultListModel<String>();
        int i = 0;
        while (i < winList.size()) {
            f = (JInternalFrame)winList.get(i);
            model.addElement(f.getTitle());
            this.frames.add(f);
            ++i;
        }
        this.list.setModel(model);
        final long t = System.currentTimeMillis();
        this.controlFilter.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (SwitchDialog.this.controlFilter.getText().length() > 0) {
                    int i = 0;
                    while (i < SwitchDialog.this.list.getModel().getSize()) {
                        if (SwitchDialog.this.list.getModel().getElementAt(i).toString().toLowerCase().startsWith(SwitchDialog.this.controlFilter.getText().toLowerCase())) {
                            SwitchDialog.this.list.setSelectedIndex(i);
                            break;
                        }
                        ++i;
                    }
                }
                if (e.getKeyCode() == 27) {
                    SwitchDialog.this.setVisible(false);
                }
                if (e.getKeyCode() == 10 && System.currentTimeMillis() > t + 1000L) {
                    SwitchDialog.this.setVisible(false);
                    JInternalFrame frame = (JInternalFrame)SwitchDialog.this.frames.get(SwitchDialog.this.list.getSelectedIndex());
                    try {
                        if (frame.isIcon()) {
                            frame.setIcon(false);
                        }
                        frame.toFront();
                        frame.setSelected(true);
                    }
                    catch (Exception ex) {
                        Logger.error(this.getClass().getName(), "list_mouseClicked", "Error while setting the internal frame to front", ex);
                    }
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.filterPanel.setLayout(this.gridBagLayout1);
        this.buttonsPane.setLayout(this.flowLayout1);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new SwitchDialog_list_mouseAdapter(this));
        this.labelFilter.setLabel("window name");
        this.labelTitle.setLabel("opened windows");
        this.labelTitle.setTextAlignment(2);
        this.okButton.setText(ClientSettings.getInstance().getResources().getResource("ok"));
        this.okButton.setMnemonic(this.okButton.getText().charAt(0));
        this.okButton.addActionListener(new SwitchDialog_okButton_actionAdapter(this));
        this.cancelButton.setText(ClientSettings.getInstance().getResources().getResource("cancel"));
        this.cancelButton.setMnemonic(this.cancelButton.getText().charAt(0));
        this.cancelButton.addActionListener(new SwitchDialog_cancelButton_actionAdapter(this));
        this.getContentPane().add((Component)this.filterPanel, "North");
        this.getContentPane().add((Component)this.buttonsPane, "South");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.list, null);
        this.filterPanel.add((Component)this.labelFilter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.filterPanel.add((Component)this.controlFilter, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.labelTitle, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.buttonsPane.add((Component)this.okButton, null);
        this.buttonsPane.add((Component)this.cancelButton, null);
    }

    void list_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.setVisible(false);
            JInternalFrame frame = (JInternalFrame)this.frames.get(this.list.getSelectedIndex());
            try {
                if (frame.isIcon()) {
                    frame.setIcon(false);
                }
                frame.toFront();
                frame.setSelected(true);
            }
            catch (Exception ex) {
                Logger.error(this.getClass().getName(), "list_mouseClicked", "Error while setting the internal frame to front", ex);
            }
        }
    }

    void okButton_actionPerformed(ActionEvent e) {
        if (this.list.getSelectedIndex() == -1) {
            return;
        }
        JInternalFrame frame = (JInternalFrame)this.frames.get(this.list.getSelectedIndex());
        try {
            if (frame.isIcon()) {
                frame.setIcon(false);
            }
            frame.toFront();
            frame.setSelected(true);
        }
        catch (Exception ex) {
            Logger.error(this.getClass().getName(), "list_mouseClicked", "Error while setting the internal frame to front", ex);
        }
        this.setVisible(false);
    }
}

