/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.mdi.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openswing.swing.client.ImagePanel;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.mdi.client.Tree;
import org.openswing.swing.mdi.client.TreeNodeRenderer;
import org.openswing.swing.mdi.java.ApplicationFunction;
import org.openswing.swing.tree.java.OpenSwingTreeNode;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class TreeMenu
extends JPanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    static /* synthetic */ Class class$java$lang$String;
    private TreePath currentPath = null;
    private Image findImage;
    JLabel findLabel;
    JTextField findTF;
    private GridBagLayout gridBagLayout1;
    private Image lockImage;
    private ImagePanel lockPanel;
    private boolean locked;
    private Tree menuTree = new Tree();
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JScrollPane treeScrollPane = new JScrollPane(this.menuTree);
    private Image unlockImage;

    public TreeMenu(DefaultTreeModel functions) {
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.gridBagLayout1 = new GridBagLayout();
        this.findLabel = new JLabel();
        this.findTF = new JTextField();
        this.createTree(functions);
        this.setBorder(BorderFactory.createBevelBorder(0));
        try {
            this.jbInit();
            MouseAdapter ml = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        TreeMenu.this.treeDoubleClick(e);
                    }
                }
            };
            KeyAdapter kl = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 32) {
                        TreeMenu.this.treeKeyPressed(e);
                    }
                }
            };
            this.menuTree.addMouseListener(ml);
            this.menuTree.addKeyListener(kl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final void collapseAllNodes() {
        int i = this.menuTree.getRowCount() - 1;
        while (i > 0) {
            this.menuTree.collapseRow(i--);
        }
    }

    private void copyChildNodes(DefaultMutableTreeNode oldNode, DefaultMutableTreeNode newNode) {
        ApplicationFunction oldChildNode = null;
        ApplicationFunction newChildNode = null;
        int i = 0;
        while (i < oldNode.getChildCount()) {
            oldChildNode = (ApplicationFunction)oldNode.getChildAt(i);
            if (!oldChildNode.isSeparator()) {
                newChildNode = oldChildNode.isFolder() ? new ApplicationFunction(oldChildNode.getDescription(), oldChildNode.getIconName(), oldChildNode.getTooltipText()) : new ApplicationFunction(oldChildNode.getDescription(), oldChildNode.getFunctionId(), oldChildNode.getIconName(), oldChildNode.getMethodName(), oldChildNode.getTooltipText());
                newNode.add(newChildNode);
                this.copyChildNodes(oldChildNode, newChildNode);
            }
            ++i;
        }
    }

    private void createTree(DefaultTreeModel functions) {
        try {
            DefaultMutableTreeNode oldRoot = (DefaultMutableTreeNode)functions.getRoot();
            DefaultMutableTreeNode newRoot = null;
            newRoot = oldRoot instanceof OpenSwingTreeNode ? new OpenSwingTreeNode() : (oldRoot instanceof ApplicationFunction ? new ApplicationFunction() : new DefaultMutableTreeNode());
            ((DefaultMutableTreeNode)newRoot).setUserObject(oldRoot.getUserObject());
            this.copyChildNodes(oldRoot, newRoot);
            DefaultTreeModel treeModel = new DefaultTreeModel(newRoot);
            this.menuTree.setModel(treeModel);
            this.menuTree.getSelectionModel().setSelectionMode(1);
            if (!ClientSettings.SHOW_TREE_MENU_ROOT) {
                this.menuTree.setRootVisible(false);
            }
            TreeNodeRenderer renderer = new TreeNodeRenderer(this.menuTree);
            this.menuTree.setCellRenderer(renderer);
            this.menuTree.revalidate();
            this.menuTree.setToolTipText("");
            if (ClientSettings.AUTO_EXPAND_TREE_MENU) {
                this.expandAllNodes();
            } else if (ClientSettings.AUTO_EXPAND_SUBTREE_MENU != null) {
                this.expandNodes(ClientSettings.getInstance().getResources().getResource(ClientSettings.AUTO_EXPAND_SUBTREE_MENU));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void executeFunction(final ApplicationFunction node) {
        if (node.isFolder()) {
            return;
        }
        if (node.isSeparator()) {
            return;
        }
        ClientUtils.fireBusyEvent(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    try {
                        MDIFrame.getClientFacade().getClass().getMethod(node.getMethodName(), new Class[0]).invoke((Object)MDIFrame.getClientFacade(), new Object[0]);
                        ClientUtils.fireBusyEvent(false);
                    }
                    catch (NoSuchMethodException ex1) {
                        MDIFrame.getClientFacade().getClass().getMethod(node.getMethodName(), class$java$lang$String == null ? (class$java$lang$String = TreeMenu.class$("java.lang.String")) : class$java$lang$String).invoke((Object)MDIFrame.getClientFacade(), node.getFunctionId());
                        ClientUtils.fireBusyEvent(false);
                    }
                }
                catch (Throwable ex) {
                    ClientUtils.fireBusyEvent(false);
                    ex.printStackTrace();
                    OptionPane.showMessageDialog(ClientUtils.getParentFrame(TreeMenu.this), ClientSettings.getInstance().getResources().getResource("Error while executing function") + " '" + node.getMethodName() + "'", ClientSettings.getInstance().getResources().getResource("Error"), 2);
                }
            }
        });
    }

    public final void expandAllNodes() {
        int i = 0;
        try {
            while (i < this.menuTree.getRowCount()) {
                this.menuTree.expandRow(i++);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void expandNodes(String nodeDescription) {
        DefaultMutableTreeNode node = this.findNode((DefaultMutableTreeNode)this.menuTree.getModel().getRoot(), nodeDescription);
        if (node != null) {
            this.menuTree.expandPath(new TreePath(node.getPath()));
            Enumeration<TreeNode> en = node.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                node = (DefaultMutableTreeNode)en.nextElement();
                this.menuTree.expandPath(new TreePath(node.getPath()));
            }
        } else {
            Logger.warn(this.getClass().getName(), "expandNodes", "There is not a node having the specified description '" + nodeDescription + "'");
        }
    }

    private boolean findNextFunction(TreePath thePath, TreeNode currentNode, String pattern) {
        Object[] newTreePath = new Object[thePath.getPathCount() + 1];
        System.arraycopy(thePath.getPath(), 0, newTreePath, 0, thePath.getPathCount());
        newTreePath[newTreePath.length - 1] = currentNode;
        TreePath path = new TreePath(newTreePath);
        if (currentNode.toString().toUpperCase().indexOf(pattern) != -1) {
            this.menuTree.setSelectionPath(path);
            this.menuTree.scrollPathToVisible(path);
            this.currentPath = path;
            return true;
        }
        int i = 0;
        while (i < currentNode.getChildCount()) {
            if (this.findNextFunction(path, currentNode.getChildAt(i), pattern)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public DefaultMutableTreeNode findNode(DefaultMutableTreeNode node, String nodeDescription) {
        if (node.toString().equals(nodeDescription)) {
            return node;
        }
        int i = 0;
        while (i < node.getChildCount()) {
            if (this.findNode((DefaultMutableTreeNode)node.getChildAt(i), nodeDescription) != null) {
                return (DefaultMutableTreeNode)node.getChildAt(i);
            }
            ++i;
        }
        return null;
    }

    void findTF_actionPerformed(ActionEvent e) {
        if (this.currentPath == null) {
            this.currentPath = new TreePath(new Object[]{(TreeNode)this.menuTree.getModel().getRoot()});
        }
        TreeNode currentNode = (TreeNode)this.currentPath.getLastPathComponent();
        int i = 0;
        while (i < currentNode.getChildCount()) {
            if (this.findNextFunction(this.currentPath, currentNode.getChildAt(i), this.findTF.getText().toUpperCase().trim())) {
                return;
            }
            ++i;
        }
        try {
            while (currentNode.getParent() != null) {
                Object[] newTreePath = new Object[this.currentPath.getPathCount() - 1];
                System.arraycopy(this.currentPath.getPath(), 0, newTreePath, 0, this.currentPath.getPathCount() - 1);
                this.currentPath = new TreePath(newTreePath);
                int i2 = currentNode.getParent().getIndex(currentNode) + 1;
                while (i2 < currentNode.getParent().getChildCount()) {
                    if (this.findNextFunction(this.currentPath, currentNode.getParent().getChildAt(i2), this.findTF.getText().toUpperCase().trim())) {
                        return;
                    }
                    ++i2;
                }
                currentNode = currentNode.getParent();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!this.currentPath.getLastPathComponent().equals(this.menuTree.getModel().getRoot())) {
            this.currentPath = new TreePath(new Object[]{(TreeNode)this.menuTree.getModel().getRoot()});
            this.findTF_actionPerformed(null);
        }
    }

    void findTF_keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n' && e.isControlDown() && this.menuTree.getSelectionPath() != null) {
            this.treeKeyPressed(null);
        }
    }

    public JTextField getFindTF() {
        return this.findTF;
    }

    public boolean isLocked() {
        return this.locked;
    }

    private void jbInit() throws Exception {
        this.lockImage = ClientUtils.getImage(ClientSettings.LOCK_ON);
        this.unlockImage = ClientUtils.getImage(ClientSettings.LOCK_OFF);
        ImagePanel findFunction = null;
        if (ClientSettings.FIND_FUNCTION_ICON != null) {
            this.findImage = ClientUtils.getImage(ClientSettings.FIND_FUNCTION_ICON);
            findFunction = new ImagePanel();
            findFunction.setImage(this.findImage);
            findFunction.setMinimumSize(new Dimension(25, 25));
            findFunction.setScrollBarsPolicy(21);
        }
        this.lockPanel = new ImagePanel();
        this.lockPanel.setImage(this.lockImage);
        this.lockPanel.setMinimumSize(new Dimension(25, 25));
        this.lockPanel.setScrollBarsPolicy(21);
        this.lockPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TreeMenu.this.lockPanel_mouseClicked(e);
            }
        });
        this.setLocked(true);
        this.setLayout(this.borderLayout1);
        this.titleLabel.setFont(new Font(this.titleLabel.getFont().getFontName(), 1, this.titleLabel.getFont().getSize()));
        this.titleLabel.setText(ClientSettings.getInstance().getResources().getResource("Functions"));
        this.titleLabel.setPreferredSize(new Dimension(100, 25));
        this.titlePanel.setLayout(this.gridBagLayout1);
        this.findLabel.setText(ClientSettings.getInstance().getResources().getResource("Find Function"));
        this.findTF.setText("");
        this.findTF.setToolTipText(ClientSettings.getInstance().getResources().getResource("Press ENTER to find function"));
        this.findTF.setColumns(15);
        this.findTF.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                TreeMenu.this.findTF_keyTyped(e);
            }
        });
        this.findTF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeMenu.this.findTF_actionPerformed(e);
            }
        });
        if (ClientSettings.SHOW_FUNCTIONS_LABEL) {
            this.titlePanel.add((Component)this.titleLabel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (ClientSettings.SHOW_PADLOCK_IN_TREE_MENU) {
            this.titlePanel.add((Component)this.lockPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 13, 3, new Insets(5, 10, 0, 10), 0, 0));
        }
        int pos = 0;
        if (findFunction != null) {
            this.titlePanel.add((Component)findFunction, new GridBagConstraints(pos++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (ClientSettings.SHOW_FIND_FUNCTION_LABEL) {
            this.titlePanel.add((Component)this.findLabel, new GridBagConstraints(pos++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.titlePanel.add((Component)this.findTF, new GridBagConstraints(pos++, 0, 1, 1, 1.0, 0.0, 17, ClientSettings.FILL_FIND_FUNCTION_FIELD ? 2 : 0, new Insets(5, 0, 5, 5), 100, 0));
        this.add((Component)this.treeScrollPane, "Center");
        this.add((Component)this.titlePanel, "North");
        this.findTF.requestFocus();
    }

    void lockPanel_mouseClicked(MouseEvent e) {
        this.setLocked(!this.locked);
    }

    public void setEnabled(boolean enabled) {
        this.menuTree.setEnabled(enabled);
    }

    public void setLocked(boolean value) {
        this.locked = value;
        if (this.locked) {
            this.lockPanel.setImage(this.lockImage);
        } else {
            this.lockPanel.setImage(this.unlockImage);
        }
    }

    private void treeDoubleClick(MouseEvent e) {
        try {
            int selRow = this.menuTree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = this.menuTree.getPathForLocation(e.getX(), e.getY());
            Object objNode = selPath.getPathComponent(selPath.getPathCount() - 1);
            ApplicationFunction node = null;
            if (objNode != null && objNode instanceof ApplicationFunction) {
                node = (ApplicationFunction)objNode;
            }
            if (node != null && node.getFunctionId() != null) {
                this.executeFunction(node);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void treeKeyPressed(KeyEvent e) {
        try {
            TreePath selPath = this.menuTree.getPathForRow(this.menuTree.getSelectionRows()[0]);
            Object objNode = selPath.getPathComponent(selPath.getPathCount() - 1);
            ApplicationFunction node = null;
            if (objNode != null && objNode instanceof ApplicationFunction) {
                node = (ApplicationFunction)objNode;
            }
            if (node != null) {
                this.executeFunction(node);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

