/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.mdi.client;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openswing.swing.mdi.java.ApplicationFunction;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class TreeNodeRenderer
extends DefaultTreeCellRenderer {
    private ImageIcon defaultFolderIcon = null;
    private ImageIcon defaultFunctionIcon = null;
    private JTree tree = null;

    public TreeNodeRenderer(JTree tree) {
        try {
            this.tree = tree;
            this.defaultFunctionIcon = new ImageIcon(ClientUtils.getImage(ClientSettings.PERC_TREE_NODE));
            this.defaultFolderIcon = new ImageIcon(ClientUtils.getImage(ClientSettings.PERC_TREE_FOLDER));
            this.setOpaque(false);
            this.setBackgroundNonSelectionColor(new Color(0, 0, 0, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        try {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof ApplicationFunction) {
                ApplicationFunction node = (ApplicationFunction)value;
                String iconName = node.getIconName();
                if (iconName != null) {
                    this.setIcon(new ImageIcon(ClientUtils.getImage(iconName)));
                } else if (!node.isFolder()) {
                    this.setIcon(this.defaultFunctionIcon);
                } else {
                    this.setIcon(this.defaultFolderIcon);
                }
                TreeNodeRenderer l = this;
                if (ClientSettings.SHOW_TOOLTIP_IN_TREEMENU) {
                    l.setToolTipText(node.getTooltipText());
                }
            } else {
                this.setIcon(this.defaultFolderIcon);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setOpaque(false);
        return this;
    }
}

