/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.mdi.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.openswing.swing.mdi.client.DesktopPane;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.util.client.ClientSettings;

public class WinIconsPanel
extends JPanel {
    private Hashtable buttons;
    private Hashtable buttonsNr;
    private JMenuItem closeMenu;
    FlowLayout flowLayout1 = new FlowLayout();
    private InternalFrame frameToClose = null;
    private JMenuItem iconMenu;
    private JPopupMenu menu;
    private int x = 0;

    public WinIconsPanel() {
        this.buttons = new Hashtable();
        this.buttonsNr = new Hashtable();
        this.menu = new JPopupMenu();
        this.closeMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("close window"));
        this.iconMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("reduce to icon"));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void add(final InternalFrame frame) {
        try {
            Integer n = (Integer)this.buttonsNr.get(frame.getTitle());
            if (n == null) {
                n = new Integer(1);
                this.buttonsNr.put(frame.getTitle(), n);
            } else {
                n = new Integer(n + 1);
                this.buttonsNr.put(frame.getTitle(), n);
            }
            final JToggleButton btn = new JToggleButton((n > 1 ? " [" + n + "] " : "") + frame.getTitle());
            btn.setToolTipText(frame.getTitle());
            int len = 120;
            btn.setMinimumSize(new Dimension(len, 24));
            btn.setMaximumSize(new Dimension(len, 24));
            btn.setPreferredSize(new Dimension(len, 24));
            btn.setSize(new Dimension(len, 24));
            while (this.x + len + 20 > this.getWidth() - 200) {
                if (this.getComponentCount() > 0) {
                    this.x -= this.getComponent(0).getWidth();
                }
                if (this.getComponentCount() > 0) {
                    this.remove(0);
                }
                this.revalidate();
                this.repaint();
            }
            this.add((Component)btn, null);
            this.x = this.x + len + 20;
            this.buttons.put(btn, frame);
            btn.setSelected(true);
            this.revalidate();
            this.repaint();
            btn.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        WinIconsPanel.this.frameToClose = (InternalFrame)WinIconsPanel.this.buttons.get(btn);
                        if (WinIconsPanel.this.frameToClose != null && WinIconsPanel.this.frameToClose.getDesktopPane() != null && ((DesktopPane)WinIconsPanel.this.frameToClose.getDesktopPane()).isModal() && !WinIconsPanel.this.frameToClose.isModal()) {
                            e.consume();
                            return;
                        }
                        WinIconsPanel.this.iconMenu.setVisible(WinIconsPanel.this.frameToClose.isIconifiable());
                        WinIconsPanel.this.menu.show(btn, e.getX(), e.getY());
                    }
                }

                public void mouseEntered(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        btn.setSelected(true);
                        InternalFrame f = (InternalFrame)WinIconsPanel.this.buttons.get(btn);
                        if (f != null && f.getDesktopPane() != null && ((DesktopPane)f.getDesktopPane()).isModal()) {
                            e.consume();
                            return;
                        }
                        f.toFront();
                        try {
                            f.setSelected(true);
                        }
                        catch (Exception ex) {
                        }
                    }
                }
            });
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (btn.isSelected()) {
                        InternalFrame f = (InternalFrame)WinIconsPanel.this.buttons.get(btn);
                        if (f != null && f.getDesktopPane() != null && ((DesktopPane)f.getDesktopPane()).isModal() && !f.isModal()) {
                            btn.setSelected(!btn.isSelected());
                            return;
                        }
                        f.toFront();
                        try {
                            f.setSelected(true);
                        }
                        catch (Exception ex) {
                        }
                    } else {
                        InternalFrame f = (InternalFrame)WinIconsPanel.this.buttons.get(btn);
                        if (f != null && f.getDesktopPane() != null && ((DesktopPane)f.getDesktopPane()).isModal() && !f.isModal()) {
                            btn.setSelected(!btn.isSelected());
                            return;
                        }
                        try {
                            f.setSelected(false);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        f.toBack();
                    }
                }
            });
            frame.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameActivated(InternalFrameEvent e) {
                    btn.setSelected(true);
                }

                public void internalFrameClosed(InternalFrameEvent e) {
                    try {
                        WinIconsPanel.this.buttons.remove(btn);
                        try {
                            if ((Integer)WinIconsPanel.this.buttonsNr.get(frame.getTitle()) == 1) {
                                WinIconsPanel.this.buttonsNr.remove(frame.getTitle());
                            } else if ((Integer)WinIconsPanel.this.buttonsNr.get(frame.getTitle()) > 1) {
                                int num = (Integer)WinIconsPanel.this.buttonsNr.get(frame.getTitle()) - 1;
                                WinIconsPanel.this.buttonsNr.put(frame.getTitle(), new Integer(num));
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        WinIconsPanel.this.remove(btn);
                        WinIconsPanel.this.revalidate();
                        WinIconsPanel.this.repaint();
                        WinIconsPanel.this.x = WinIconsPanel.this.x - btn.getWidth();
                    }
                    catch (Exception ex1) {
                    }
                }

                public void internalFrameDeactivated(InternalFrameEvent e) {
                    btn.setSelected(false);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void init() {
        this.removeAll();
        this.buttons.clear();
        this.buttonsNr.clear();
        this.setMinimumSize(new Dimension(2000, 26));
        this.setPreferredSize(new Dimension(2000, 26));
    }

    private void jbInit() throws Exception {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(0);
        this.setLayout(this.flowLayout1);
        this.menu.add(this.closeMenu);
        this.closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    WinIconsPanel.this.frameToClose.closeFrame();
                    WinIconsPanel.this.frameToClose = null;
                }
                catch (PropertyVetoException ex) {
                }
            }
        });
        this.menu.add(this.iconMenu);
        this.iconMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    WinIconsPanel.this.frameToClose.setIcon(true);
                }
                catch (PropertyVetoException ex) {
                    ex.printStackTrace();
                }
                WinIconsPanel.this.frameToClose = null;
            }
        });
    }
}

