/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.miscellaneous.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openswing.swing.client.ImagePanel;
import org.openswing.swing.miscellaneous.client.ProgressBar;
import org.openswing.swing.miscellaneous.client.ProgressEvent;
import org.openswing.swing.util.client.ClientSettings;

public class ProgressPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JButton buttonCancel;
    JTextArea controlMainMessage;
    private int currentRow = 0;
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout2;
    ImagePanel imagePanel = null;
    JLabel labelMainTitle;
    JLabel labelProgress;
    private ArrayList messages;
    ProgressBar progressBar;
    JPanel progressPanel;
    JScrollPane scrollPane;
    JPanel titlePanel = new JPanel();

    public ProgressPanel(String mainTitle, String mainMessage, String[] messageLabels, double minValue, double maxValue, boolean showCancelButton) {
        this.progressPanel = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.labelMainTitle = new JLabel();
        this.scrollPane = new JScrollPane();
        this.controlMainMessage = new JTextArea();
        this.gridBagLayout2 = new GridBagLayout();
        this.labelProgress = new JLabel();
        this.progressBar = new ProgressBar();
        this.buttonCancel = new JButton();
        this.messages = new ArrayList();
        this.progressBar.setMinValue(minValue);
        this.progressBar.setMaxValue(maxValue);
        try {
            this.jbInit();
            this.labelMainTitle.setText(ClientSettings.getInstance().getResources().getResource(mainTitle));
            this.controlMainMessage.setFont(new JLabel().getFont());
            this.controlMainMessage.setBackground(this.progressPanel.getBackground());
            int i = 0;
            while (i < messageLabels.length) {
                JLabel label1a = new JLabel(ClientSettings.getInstance().getResources().getResource(messageLabels[i]));
                JLabel label1b = new JLabel();
                this.messages.add(label1b);
                this.progressPanel.add((Component)label1a, new GridBagConstraints(0, this.currentRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.progressPanel.add((Component)label1b, new GridBagConstraints(1, this.currentRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                ++this.currentRow;
                ++i;
            }
            StringTokenizer st = new StringTokenizer(mainMessage, "\n");
            this.controlMainMessage.setRows(st.countTokens() + 1);
            this.controlMainMessage.setText(ClientSettings.getInstance().getResources().getResource(mainMessage));
            this.setMinimumValue(minValue);
            this.setMaximumValue(maxValue);
            if (showCancelButton) {
                this.progressPanel.add((Component)this.buttonCancel, new GridBagConstraints(1, this.currentRow + 3, 1, 1, 0.0, 1.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
            } else {
                this.progressPanel.add((Component)new JLabel(""), new GridBagConstraints(1, this.currentRow + 3, 1, 1, 0.0, 1.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
            }
            this.progressBar.setForeground(ClientSettings.GRID_SELECTION_BACKGROUND);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void addCancelButtonListener(ActionListener listener) {
        this.buttonCancel.addActionListener(listener);
    }

    public final boolean addColoredBand(double minValue, double maxValue, Color color) {
        return this.progressBar.addColoredBand(minValue, maxValue, color);
    }

    public final String getImageName() {
        return this.imagePanel == null ? null : this.imagePanel.getImageName();
    }

    public final double getMaximumValue() {
        return this.progressBar.getMaxValue();
    }

    public final double getMinimumValue() {
        return this.progressBar.getMinValue();
    }

    public final Color getProgressBarColor() {
        return this.progressBar.getBackground();
    }

    public final boolean isShowAllBands() {
        return this.progressBar.isShowAllBands();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.progressPanel.setBorder(BorderFactory.createEtchedBorder());
        this.progressPanel.setLayout(this.gridBagLayout2);
        this.titlePanel.setLayout(this.gridBagLayout1);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.controlMainMessage.setDoubleBuffered(false);
        this.controlMainMessage.setEditable(false);
        this.controlMainMessage.setText("");
        this.labelMainTitle.setFont(new Font(this.labelMainTitle.getFont().getName(), 1, this.labelMainTitle.getFont().getSize() + 1));
        this.labelProgress.setText(ClientSettings.getInstance().getResources().getResource("progress") + ":");
        this.buttonCancel.setText(ClientSettings.getInstance().getResources().getResource("cancel"));
        this.add((Component)this.titlePanel, "North");
        this.add((Component)this.progressPanel, "Center");
        this.titlePanel.add((Component)this.labelMainTitle, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.titlePanel.add((Component)this.scrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 25, 5, 5), 0, 0));
        this.scrollPane.getViewport().add((Component)this.controlMainMessage, null);
        this.progressPanel.add((Component)this.labelProgress, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.progressPanel.add((Component)this.progressBar, new GridBagConstraints(1, this.currentRow + 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public final void processProgressEvent(ProgressEvent event) {
        this.labelMainTitle.setText(ClientSettings.getInstance().getResources().getResource(event.getMainTitle()));
        this.controlMainMessage.setText(ClientSettings.getInstance().getResources().getResource(event.getMainMessage()));
        int i = 0;
        while (i < event.getText().length) {
            ((JLabel)this.messages.get(i)).setText(ClientSettings.getInstance().getResources().getResource(event.getText()[i]));
            ++i;
        }
        this.progressBar.setValue((int)event.getProgressValue());
    }

    public final void removeCancelButtonListener(ActionListener listener) {
        this.buttonCancel.removeActionListener(listener);
    }

    public final void setImageName(String imageName) {
        if (this.imagePanel == null) {
            this.imagePanel = new ImagePanel();
            this.imagePanel.setScrollBarsPolicy(21);
            this.titlePanel.add((Component)this.imagePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.imagePanel.setImageName(imageName);
    }

    public final void setMaximumValue(double maxValue) {
        this.progressBar.setMaxValue(maxValue);
    }

    public final void setMinimumValue(double minValue) {
        this.progressBar.setMinValue(minValue);
    }

    public final void setProgressBarColor(Color color) {
        this.progressBar.setBackground(color);
    }

    public final void setShowAllBands(boolean showAllBands) {
        this.progressBar.setShowAllBands(showAllBands);
    }
}

