/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.miscellaneous.util.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;
import org.openswing.swing.client.CheckBoxControl;
import org.openswing.swing.client.ImagePanel;
import org.openswing.swing.miscellaneous.client.TipPanelContent;
import org.openswing.swing.miscellaneous.util.client.TipPanelContainer;
import org.openswing.swing.miscellaneous.util.client.TipPanel_buttonClose_actionAdapter;
import org.openswing.swing.miscellaneous.util.client.TipPanel_buttonList_actionAdapter;
import org.openswing.swing.miscellaneous.util.client.TipPanel_buttonNext_actionAdapter;
import org.openswing.swing.miscellaneous.util.client.TipPanel_buttonPrev_actionAdapter;
import org.openswing.swing.miscellaneous.util.client.TipSelectDialog;
import org.openswing.swing.util.client.ClientSettings;

public class TipPanel
extends JPanel {
    JButton buttonClose;
    JButton buttonList;
    JButton buttonNext;
    JButton buttonPrev;
    JPanel buttonsPanel;
    CheckBoxControl controlShow;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2;
    private String imageName = "tip.gif";
    ImagePanel imagePanel = new ImagePanel();
    private int index = 0;
    JLabel labelTitle;
    JPanel mainPanel;
    JScrollPane scrollPane;
    private boolean showCheck = true;
    JEditorPane tipPane;
    private TipPanelContainer tipPanelContainer = null;
    private TipPanelContent tipPanelContent;

    public TipPanel(TipPanelContainer tipPanelContainer, TipPanelContent tipPanelContent) {
        this.buttonsPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.gridBagLayout2 = new GridBagLayout();
        this.labelTitle = new JLabel();
        this.scrollPane = new JScrollPane();
        this.tipPane = new JEditorPane();
        this.controlShow = new CheckBoxControl();
        this.buttonList = new JButton();
        this.buttonPrev = new JButton();
        this.buttonNext = new JButton();
        this.buttonClose = new JButton();
        this.tipPanelContainer = tipPanelContainer;
        this.tipPanelContent = tipPanelContent;
        try {
            this.jbInit();
            this.setImageName(this.imageName);
            this.tipPane.setFont(this.labelTitle.getFont());
            this.tipPane.setEditorKit(new HTMLEditorKit());
            this.index = (int)(Math.random() * (double)tipPanelContent.getTips().length);
            this.showTip();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void addNotify() {
        super.addNotify();
        if (this.isVisible()) {
            int w = ((Container)((Object)this.tipPanelContainer)).getWidth() - this.imagePanel.getImageWidth() - 30;
            int h = ((Container)((Object)this.tipPanelContainer)).getHeight() - this.imagePanel.getImageHeight() - 30;
            this.scrollPane.setMinimumSize(new Dimension(w, h));
            this.scrollPane.setMaximumSize(new Dimension(w, h));
            if (this.tipPanelContainer instanceof JInternalFrame) {
                ((JInternalFrame)((Object)this.tipPanelContainer)).setMinimumSize(new Dimension(((Container)((Object)this.tipPanelContainer)).getWidth(), ((Container)((Object)this.tipPanelContainer)).getHeight()));
            }
        }
    }

    void buttonClose_actionPerformed(ActionEvent e) {
        this.tipPanelContainer.closeTipPanel();
    }

    void buttonList_actionPerformed(ActionEvent e) {
        TipSelectDialog dlg = new TipSelectDialog(this.tipPanelContent);
        int idx = dlg.getTipIndex();
        if (idx >= 0 && idx < this.tipPanelContent.getTips().length) {
            this.index = idx;
            this.showTip();
        }
    }

    void buttonNext_actionPerformed(ActionEvent e) {
        if (this.index == this.tipPanelContent.getTips().length - 1 && this.tipPanelContent.getTips().length > 0) {
            this.index = 0;
        } else if (this.index < this.tipPanelContent.getTips().length - 1) {
            ++this.index;
        }
        this.showTip();
    }

    void buttonPrev_actionPerformed(ActionEvent e) {
        if (this.index == 0 && this.tipPanelContent.getTips().length > 0) {
            this.index = this.tipPanelContent.getTips().length - 1;
        } else if (this.index > 0) {
            --this.index;
        }
        this.showTip();
    }

    public final String getImageName() {
        return this.imageName;
    }

    public final boolean isShowCheck() {
        return this.showCheck;
    }

    public final boolean isShowToolTip() {
        return this.controlShow.isSelected();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.mainPanel.setLayout(this.gridBagLayout2);
        this.tipPane.setEditable(false);
        this.controlShow.setText("show 'tip of the day' after launching");
        this.controlShow.setFont(new Font(this.labelTitle.getFont().getName(), 0, 9));
        this.buttonList.setText(ClientSettings.getInstance().getResources().getResource("select tip"));
        this.buttonList.addActionListener(new TipPanel_buttonList_actionAdapter(this));
        this.buttonPrev.setText(ClientSettings.getInstance().getResources().getResource("previous tip"));
        this.buttonPrev.addActionListener(new TipPanel_buttonPrev_actionAdapter(this));
        this.buttonNext.setText(ClientSettings.getInstance().getResources().getResource("next tip"));
        this.buttonNext.addActionListener(new TipPanel_buttonNext_actionAdapter(this));
        this.buttonClose.setText(ClientSettings.getInstance().getResources().getResource("close"));
        this.buttonClose.addActionListener(new TipPanel_buttonClose_actionAdapter(this));
        this.labelTitle.setFont(new Font(this.labelTitle.getFont().getName(), 0, 14));
        this.add((Component)this.imagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.mainPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (this.showCheck) {
            this.mainPanel.add((Component)this.controlShow, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.mainPanel.add((Component)this.labelTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.buttonsPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.scrollPane.getViewport().add((Component)this.tipPane, null);
        this.buttonsPanel.add((Component)this.buttonList, null);
        this.buttonsPanel.add((Component)this.buttonPrev, null);
        this.buttonsPanel.add((Component)this.buttonNext, null);
        this.buttonsPanel.add((Component)this.buttonClose, null);
    }

    public final void setImageName(String imageName) {
        this.imageName = imageName;
        this.imagePanel.setImageName(imageName);
        this.imagePanel.setScrollBarsPolicy(21);
        this.imagePanel.setMinimumSize(new Dimension(this.imagePanel.getImageWidth(), this.imagePanel.getImageHeight()));
        this.imagePanel.setMaximumSize(new Dimension(this.imagePanel.getImageWidth(), this.imagePanel.getImageHeight()));
        this.imagePanel.setPreferredSize(new Dimension(this.imagePanel.getImageWidth(), this.imagePanel.getImageHeight()));
    }

    public final void setShowCheck(boolean showCheck) {
        if (this.showCheck && !showCheck) {
            this.mainPanel.remove(this.controlShow);
        } else if (!this.showCheck && showCheck) {
            this.mainPanel.add((Component)this.controlShow, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.mainPanel.revalidate();
        this.showCheck = showCheck;
    }

    public final void setShowToolTip(boolean showToolTip) {
        this.controlShow.setSelected(showToolTip);
    }

    private void showTip() {
        this.labelTitle.setText(ClientSettings.getInstance().getResources().getResource(this.tipPanelContent.getTitles()[this.index]));
        this.tipPane.setText(ClientSettings.getInstance().getResources().getResource(this.tipPanelContent.getTips()[this.index]));
    }
}

