/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.permissions.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.permissions.client.LoginController;
import org.openswing.swing.permissions.client.LoginDialog_exitButton_actionAdapter;
import org.openswing.swing.permissions.client.LoginDialog_loginButton_actionAdapter;
import org.openswing.swing.permissions.client.LoginDialog_passwdTF_actionAdapter;
import org.openswing.swing.permissions.client.LoginDialog_this_windowAdapter;
import org.openswing.swing.permissions.client.LoginDialog_usernameTF_actionAdapter;
import org.openswing.swing.permissions.java.CryptUtils;
import org.openswing.swing.util.client.ClientSettings;

public class LoginDialog
extends JDialog
implements ItemListener {
    private String appId;
    private int attempts = 1;
    JPanel buttonsPanel;
    private boolean changeLogin;
    private CryptUtils cipher;
    JPanel controlsPanel;
    private String currentLanguageIdentifier = null;
    JButton exitButton;
    private char exitButtonMnemonic;
    private String exitButtonText = null;
    private boolean fromOtherMethod = false;
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout2;
    GridBagLayout gridBagLayout3;
    private ComboBoxControl languagesComboBox;
    JButton loginButton;
    private char loginButtonMnemonic;
    private String loginButtonText = null;
    private LoginController loginController = null;
    JPanel mainPanel = new JPanel();
    private JFrame parentFrame = null;
    JLabel passwdLabel;
    JPasswordField passwdTF;
    private String passwordTextLabel = null;
    private String storeAccount = null;
    JCheckBox storeAccountCheckBox;
    private Properties supportedLanguageIds = null;
    private String title = null;
    JLabel usernameLabel;
    JTextField usernameTF;
    private String usernameTextLabel = null;

    static {
        try {
            UIManager.setLookAndFeel(ClientSettings.LOOK_AND_FEEL_CLASS_NAME);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LoginDialog(JFrame parentFrame, boolean changeLogin, LoginController loginController, String title, String loginButtonText, char loginButtonMnemonic, String exitButtonText, char exitButtonMnemonic, String storeAccount, String appId, CryptUtils cipher, Properties supportedLanguageIds, String currentLanguageIdentifier, String usernameTextLabel, String passwordTextLabel) {
        super(parentFrame == null ? new JFrame() : parentFrame, title, true);
        int lineHeight;
        int halfHeight;
        int halfWidth;
        int height;
        int width;
        this.controlsPanel = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.gridBagLayout3 = new GridBagLayout();
        this.usernameLabel = new JLabel();
        this.passwdLabel = new JLabel();
        this.usernameTF = new JTextField();
        this.passwdTF = new JPasswordField();
        this.gridBagLayout2 = new GridBagLayout();
        this.buttonsPanel = new JPanel();
        this.exitButton = new JButton();
        this.loginButton = new JButton();
        this.storeAccountCheckBox = new JCheckBox();
        this.languagesComboBox = new ComboBoxControl();
        this.parentFrame = parentFrame;
        this.title = title;
        this.loginButtonText = loginButtonText;
        this.loginButtonMnemonic = loginButtonMnemonic;
        this.exitButtonText = exitButtonText;
        this.exitButtonMnemonic = exitButtonMnemonic;
        this.storeAccount = storeAccount;
        this.appId = appId;
        this.cipher = cipher;
        this.supportedLanguageIds = supportedLanguageIds;
        this.currentLanguageIdentifier = currentLanguageIdentifier;
        this.usernameTextLabel = usernameTextLabel;
        this.passwordTextLabel = passwordTextLabel;
        if (Toolkit.getDefaultToolkit().getScreenResolution() == 96) {
            width = 380;
            height = 180;
            halfWidth = 190;
            halfHeight = 90;
            lineHeight = 20;
        } else {
            width = 476;
            height = 226;
            halfWidth = 238;
            halfHeight = 113;
            lineHeight = 25;
        }
        Dimension dim = new Dimension((int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2 - halfWidth, (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2 - halfHeight);
        if (parentFrame == null) {
            super.getParent().setVisible(true);
            super.getParent().setLocation(dim.width, dim.height);
        }
        this.changeLogin = changeLogin;
        this.loginController = loginController;
        try {
            this.jbInit();
            this.setSize(width, height + (appId != null && storeAccount != null ? lineHeight : 0) + (supportedLanguageIds != null ? lineHeight : 0));
            this.setLocation(dim.width, dim.height);
            if (storeAccount != null && appId != null) {
                this.loadAccount();
            }
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LoginDialog(JFrame parentFrame, boolean changeLogin, LoginController loginController, String title, String loginButtonText, char loginButtonMnemonic, String exitButtonText, char exitButtonMnemonic, String storeAccount, String appId, CryptUtils cipher, Properties supportedLanguageIds, String currentLanguageIdentifier) {
        this(parentFrame, changeLogin, loginController, title, loginButtonText, loginButtonMnemonic, exitButtonText, exitButtonMnemonic, storeAccount, appId, cipher, supportedLanguageIds, currentLanguageIdentifier, "Username", "Password");
    }

    public LoginDialog(JFrame parentFrame, boolean changeLogin, LoginController loginController, String title, String loginButtonText, char loginButtonMnemonic, String exitButtonText, char exitButtonMnemonic, String storeAccount, String appId, CryptUtils cipher) {
        this(parentFrame, changeLogin, loginController, title, loginButtonText, loginButtonMnemonic, exitButtonText, exitButtonMnemonic, storeAccount, appId, cipher, null, null);
    }

    public LoginDialog(JFrame parentFrame, boolean changeLogin, LoginController loginController, String title, String loginButtonText, char loginButtonMnemonic, String exitButtonText, char exitButtonMnemonic, String storeAccount, String appId) {
        this(parentFrame, changeLogin, loginController, title, loginButtonText, loginButtonMnemonic, exitButtonText, exitButtonMnemonic, storeAccount, appId, null);
    }

    public LoginDialog(JFrame parentFrame, boolean changeLogin, LoginController loginController) {
        this(parentFrame, changeLogin, loginController, "Logon", "Login", 'L', "Exit", 'E', null, null);
    }

    void exitButton_actionPerformed(ActionEvent e) {
        this.fromOtherMethod = true;
        this.setVisible(false);
        if (!this.changeLogin) {
            if (this.parentFrame == null) {
                this.getParent().setVisible(false);
                ((JFrame)this.getParent()).dispose();
            }
            this.loginController.stopApplication();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.updateLanguage((String)this.languagesComboBox.getValue());
        }
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.getContentPane().setLayout(this.gridBagLayout2);
        this.usernameLabel.setText(this.usernameTextLabel);
        this.passwdLabel.setText(this.passwordTextLabel);
        this.usernameTF.setColumns(15);
        this.usernameTF.setMinimumSize(new Dimension(this.usernameTF.getFontMetrics(this.usernameTF.getFont()).stringWidth("               "), this.usernameTF.getHeight()));
        this.passwdTF.setColumns(15);
        this.passwdTF.setMinimumSize(new Dimension(this.passwdTF.getFontMetrics(this.passwdTF.getFont()).stringWidth("               "), this.passwdTF.getHeight()));
        this.usernameTF.addActionListener(new LoginDialog_usernameTF_actionAdapter(this));
        this.passwdTF.addActionListener(new LoginDialog_passwdTF_actionAdapter(this));
        this.mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.exitButton.setMnemonic(this.exitButtonMnemonic);
        this.exitButton.setText(this.exitButtonText);
        this.exitButton.addActionListener(new LoginDialog_exitButton_actionAdapter(this));
        this.loginButton.setMnemonic(this.loginButtonMnemonic);
        this.loginButton.setText(this.loginButtonText);
        this.loginButton.addActionListener(new LoginDialog_loginButton_actionAdapter(this));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new LoginDialog_this_windowAdapter(this));
        this.storeAccountCheckBox.setText(this.storeAccount);
        this.getContentPane().add((Component)this.mainPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.controlsPanel.setLayout(this.gridBagLayout3);
        this.mainPanel.add((Component)this.controlsPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 3, new Insets(5, 5, 0, 5), 0, 0));
        this.controlsPanel.add((Component)this.usernameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.controlsPanel.add((Component)this.passwdLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.controlsPanel.add((Component)this.usernameTF, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 50, 0));
        this.controlsPanel.add((Component)this.passwdTF, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 50, 0));
        if (this.appId != null && this.storeAccount != null) {
            this.controlsPanel.add((Component)this.storeAccountCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.getContentPane().add((Component)this.buttonsPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.loginButton, null);
        this.buttonsPanel.add((Component)this.exitButton, null);
        if (this.supportedLanguageIds != null) {
            Domain domain = new Domain("LanguageSelectionInLoginDialogDomain");
            Enumeration<?> en = this.supportedLanguageIds.propertyNames();
            String langId = null;
            while (en.hasMoreElements()) {
                langId = en.nextElement().toString();
                domain.addDomainPair(langId, this.supportedLanguageIds.getProperty(langId));
            }
            this.languagesComboBox.setDomain(domain);
            if (this.currentLanguageIdentifier != null) {
                this.languagesComboBox.setValue(this.currentLanguageIdentifier);
                this.updateLanguage(this.currentLanguageIdentifier);
            }
            this.languagesComboBox.addItemListener(this);
            this.controlsPanel.add((Component)this.languagesComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    private void loadAccount() {
        try {
            if (this.cipher == null) {
                File f = new File(System.getProperty("user.home") + "/" + this.appId + ".acc");
                Properties p = new Properties();
                FileInputStream in = new FileInputStream(f);
                p.load(in);
                in.close();
                this.usernameTF.setText(p.getProperty("username"));
                this.passwdTF.setText(p.getProperty("password"));
                this.storeAccountCheckBox.setSelected(true);
            } else {
                File f = new File(System.getProperty("user.home") + "/" + this.appId + ".acc");
                FileInputStream in = new FileInputStream(f);
                byte[] bytes = new byte[(int)f.length()];
                in.read(bytes);
                in.close();
                int i = 0;
                i = 0;
                while (i < bytes.length) {
                    if (bytes[i] == 10) break;
                    ++i;
                }
                if (bytes[i] == 10) {
                    byte[] username = new byte[i];
                    byte[] password = new byte[bytes.length - i - 1];
                    System.arraycopy(bytes, 0, username, 0, username.length);
                    System.arraycopy(bytes, i + 1, password, 0, password.length);
                    this.usernameTF.setText(new String(username));
                    this.passwdTF.setText(this.cipher.decodeText(password));
                    this.storeAccountCheckBox.setSelected(true);
                }
            }
        }
        catch (Throwable ex) {
        }
    }

    void loginButton_actionPerformed(ActionEvent e) {
        boolean ok = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("username", this.usernameTF.getText());
            if (this.cipher == null) {
                map.put("password", this.passwdTF.getText());
            } else {
                map.put("password", this.cipher.encodeText(this.passwdTF.getText()));
            }
            ok = this.loginController.authenticateUser(map);
            if (!ok && this.attempts < this.loginController.getMaxAttempts()) {
                ++this.attempts;
                this.passwdTF.requestFocus();
                return;
            }
        }
        catch (Throwable ex) {
            if (this.attempts < this.loginController.getMaxAttempts()) {
                OptionPane.showMessageDialog(this.parentFrame, ex.getMessage(), "Error", 0);
                ++this.attempts;
                this.passwdTF.requestFocus();
                return;
            }
            ok = false;
        }
        if (!ok) {
            this.exitButton_actionPerformed(null);
            return;
        }
        if (this.parentFrame == null) {
            this.getParent().setVisible(false);
            ((JFrame)this.getParent()).dispose();
        } else {
            this.parentFrame.setVisible(false);
        }
        this.fromOtherMethod = true;
        this.setVisible(false);
        if (this.storeAccount != null && this.appId != null) {
            this.saveAccount();
        }
        this.loginController.loginSuccessful(map);
    }

    void passwdTF_actionPerformed(ActionEvent e) {
        this.loginButton_actionPerformed(null);
    }

    private void saveAccount() {
        try {
            File f = new File(System.getProperty("user.home") + "/" + this.appId + ".acc");
            if (this.storeAccountCheckBox.isSelected()) {
                if (this.cipher == null) {
                    Properties p = new Properties();
                    p.setProperty("username", this.usernameTF.getText());
                    p.setProperty("password", this.passwdTF.getText());
                    FileOutputStream out = new FileOutputStream(f);
                    p.store(out, "Stored account for " + this.appId);
                    out.close();
                } else {
                    byte[] username = this.usernameTF.getText().getBytes();
                    byte[] password = this.cipher.encodeText(this.passwdTF.getText());
                    FileOutputStream out = new FileOutputStream(f);
                    byte[] bytes = new byte[(int)f.length()];
                    out.write(username);
                    out.write(10);
                    out.write(password);
                    out.close();
                }
            } else {
                f.delete();
            }
        }
        catch (Throwable ex) {
        }
    }

    void this_windowClosed(WindowEvent e) {
        if (!this.fromOtherMethod && !this.changeLogin) {
            if (this.parentFrame == null) {
                this.getParent().setVisible(false);
                ((JFrame)this.getParent()).dispose();
            }
            this.loginController.stopApplication();
        }
    }

    private void updateLanguage(String lang) {
        ClientSettings.getInstance().setLanguage(lang);
        this.setTitle(ClientSettings.getInstance().getResources().getResource(this.title));
        this.loginButton.setText(ClientSettings.getInstance().getResources().getResource(this.loginButtonText));
        this.usernameLabel.setText(ClientSettings.getInstance().getResources().getResource(this.usernameTextLabel));
        this.passwdLabel.setText(ClientSettings.getInstance().getResources().getResource(this.passwordTextLabel));
        try {
            this.loginButton.setMnemonic(ClientSettings.getInstance().getResources().getResource(String.valueOf(this.loginButtonMnemonic)).charAt(0));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.exitButton.setText(ClientSettings.getInstance().getResources().getResource(this.exitButtonText));
        try {
            this.exitButton.setMnemonic(ClientSettings.getInstance().getResources().getResource(String.valueOf(this.exitButtonMnemonic)).charAt(0));
        }
        catch (Exception ex1) {
        }
    }

    void usernameTF_actionPerformed(ActionEvent e) {
        this.loginButton_actionPerformed(null);
    }
}

