/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.cellspantable.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.pivottable.cellspantable.client.CellSpanTable;

public class CellSpanTableUI
extends BasicTableUI {
    public void paint(Graphics g, JComponent c) {
        Rectangle oldClipBounds = g.getClipBounds();
        Rectangle clipBounds = new Rectangle(oldClipBounds);
        int tableWidth = this.table.getColumnModel().getTotalColumnWidth();
        clipBounds.width = Math.min(clipBounds.width, tableWidth);
        g.setClip(clipBounds);
        int firstIndex = this.table.rowAtPoint(new Point(0, clipBounds.y));
        int lastIndex = this.table.getRowCount() - 1;
        Rectangle rowRect = new Rectangle(0, 0, tableWidth, this.table.getRowHeight() + this.table.getRowMargin());
        rowRect.y = firstIndex * rowRect.height;
        int index = firstIndex;
        while (index <= lastIndex) {
            if (rowRect.intersects(clipBounds)) {
                this.paintRow(g, index);
            }
            rowRect.y += rowRect.height;
            ++index;
        }
        g.setClip(oldClipBounds);
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        int spacingHeight = this.table.getRowMargin();
        int spacingWidth = this.table.getColumnModel().getColumnMargin();
        Color c = g.getColor();
        g.setColor(this.table.getGridColor());
        if (this.table.getShowHorizontalLines() && this.table.getShowVerticalLines()) {
            g.drawRect(cellRect.x - 1, cellRect.y - 1, cellRect.width, cellRect.height);
        }
        g.setColor(c);
        cellRect.setBounds(cellRect.x + spacingWidth / 2 - 1, cellRect.y + spacingHeight / 2, cellRect.width - spacingWidth - 1, cellRect.height - spacingHeight);
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            if (component.getParent() == null) {
                this.rendererPane.add(component);
            }
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    private void paintRow(Graphics g, int row) {
        Rectangle rect = g.getClipBounds();
        boolean drawn = false;
        int numColumns = this.table.getColumnCount();
        int column = 0;
        while (column < numColumns) {
            int cellColumn;
            int cellRow;
            Rectangle cellRect = this.table.getCellRect(row, column, true);
            if (((CellSpanTable)this.table).isGridVisible(row, column)) {
                cellRow = row;
                cellColumn = column;
            } else {
                cellRow = row + ((CellSpanTable)this.table).getSpan(row, column)[0];
                cellColumn = column + ((CellSpanTable)this.table).getSpan(row, column)[1];
            }
            if (cellRect.intersects(rect)) {
                drawn = true;
                this.paintCell(g, cellRect, cellRow, cellColumn);
            } else if (drawn) break;
            ++column;
        }
    }
}

