/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.client;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.openswing.swing.pivottable.client.DraggableButtonEvent;
import org.openswing.swing.pivottable.client.DraggableButtonListener;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class DraggableButton
extends JPanel
implements DragSourceListener,
DropTargetListener {
    private Cursor dragCursor = null;
    private DragSource dragSource = new DragSource();
    private ArrayList draggableButtonListeners = new ArrayList();
    private DropTarget dropTarget = null;
    private String panelId = null;
    private int pos;

    public DraggableButton(String panelId, int pos) {
        this.panelId = panelId;
        this.pos = pos;
        try {
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, new DragGestureAdapter(this));
            this.dropTarget = new DropTarget(this, this);
            this.dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(ClientUtils.getImage("column.gif"), new Point(15, 10), ClientSettings.getInstance().getResources().getResource("drag"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void addDraggableButtonListener(DraggableButtonListener listener) {
        this.draggableButtonListeners.add(listener);
    }

    public final void dragDropEnd(DragSourceDropEvent event) {
    }

    public final void dragEnter(DropTargetDragEvent event) {
        event.acceptDrag(2);
    }

    public final void dragEnter(DragSourceDragEvent event) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public final void dragExit(DropTargetEvent event) {
    }

    public final void dragExit(DragSourceEvent event) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public final void dragOver(DropTargetDragEvent event) {
    }

    public final void dragOver(DragSourceDragEvent event) {
        this.setCursor(this.dragCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void drop(DropTargetDropEvent event) {
        block14: {
            block13: {
                this.setCursor(Cursor.getDefaultCursor());
                Transferable transferable = event.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String id = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (id != null && id.startsWith(this.panelId)) {
                        event.acceptDrop(2);
                        event.getDropTargetContext().dropComplete(true);
                        String[] tokens = id.split("_");
                        int draggedCompPos = Integer.parseInt(tokens[tokens.length - 1]);
                        if (draggedCompPos != this.pos) {
                            DraggableButtonEvent e = new DraggableButtonEvent(this.panelId, draggedCompPos, this.pos);
                            int i = 0;
                            while (i < this.draggableButtonListeners.size()) {
                                ((DraggableButtonListener)this.draggableButtonListeners.get(i)).dragEventFired(e);
                                ++i;
                            }
                        }
                    } else {
                        event.rejectDrop();
                    }
                    break block13;
                }
                event.rejectDrop();
            }
            Object var9_9 = null;
            try {
                this.setCursor(new Cursor(0));
            }
            catch (Exception ex2) {
            }
            break block14;
            {
                catch (Exception ex) {
                    ex.printStackTrace();
                    event.rejectDrop();
                    Object var9_10 = null;
                    try {
                        this.setCursor(new Cursor(0));
                    }
                    catch (Exception ex2) {
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    this.setCursor(new Cursor(0));
                }
                catch (Exception ex2) {
                }
                throw throwable;
            }
        }
    }

    public final void dropActionChanged(DropTargetDragEvent event) {
    }

    public final void dropActionChanged(DragSourceDragEvent event) {
    }

    public final void removeDraggableButtonListener(DraggableButtonListener listener) {
        this.draggableButtonListeners.remove(listener);
    }

    class DragGestureAdapter
    implements DragGestureListener {
        private DragSourceListener dragListener = null;

        public DragGestureAdapter(DragSourceListener dragListener) {
            this.dragListener = dragListener;
        }

        public final void dragGestureRecognized(DragGestureEvent event) {
            DraggableButton.this.setCursor(DraggableButton.this.dragCursor);
            try {
                DraggableButton.this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, new StringSelection(DraggableButton.this.panelId + "_" + DraggableButton.this.pos), this.dragListener);
            }
            catch (InvalidDnDOperationException ex) {
            }
        }
    }
}

