/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.pivottable.client.FilterDialog_cancelButton_actionAdapter;
import org.openswing.swing.pivottable.client.FilterDialog_okButton_actionAdapter;
import org.openswing.swing.pivottable.client.FilterGridPanel;
import org.openswing.swing.pivottable.client.PivotTable;
import org.openswing.swing.pivottable.java.ColumnField;
import org.openswing.swing.pivottable.java.DataField;
import org.openswing.swing.pivottable.java.PivotTableParameters;
import org.openswing.swing.pivottable.java.RowField;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class FilterDialog
extends JDialog {
    BorderLayout borderLayout1;
    BorderLayout borderLayout2;
    BorderLayout borderLayout3;
    BorderLayout borderLayout4;
    JPanel buttonsPanel;
    JButton cancelButton;
    FilterGridPanel colsGrid = null;
    JPanel colsPanel;
    FilterGridPanel dataGrid = null;
    JPanel dataPanel;
    JPanel filterPanel;
    FlowLayout flowLayout1;
    JPanel mainPanel = new JPanel();
    JButton okButton;
    private PivotTableParameters pars;
    FilterGridPanel rowsGrid = null;
    JPanel rowsPanel;
    JTabbedPane tabbedPane;
    private PivotTable table = null;

    public FilterDialog(PivotTable table, PivotTableParameters pars) {
        super(ClientUtils.getParentFrame(table), ClientSettings.getInstance().getResources().getResource("pivot table settings"), true);
        this.borderLayout1 = new BorderLayout();
        this.buttonsPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.flowLayout1 = new FlowLayout();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.dataPanel = new JPanel();
        this.rowsPanel = new JPanel();
        this.colsPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.borderLayout2 = new BorderLayout();
        this.borderLayout3 = new BorderLayout();
        this.borderLayout4 = new BorderLayout();
        this.pars = new PivotTableParameters();
        this.table = table;
        this.pars = pars;
        try {
            this.init();
            this.jbInit();
            this.setDefaultCloseOperation(2);
            this.setSize(250, 300);
            ClientUtils.centerDialog(ClientUtils.getParentFrame(table), this);
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void init() {
        HashMap dataFields = new HashMap();
        ArrayList list = this.table.getAllDataFields();
        int i = 0;
        while (i < list.size()) {
            dataFields.put(ClientSettings.getInstance().getResources().getResource(((DataField)list.get(i)).getDescription()), list.get(i));
            ++i;
        }
        this.dataGrid = new FilterGridPanel(dataFields, this.pars.getDataFields());
        HashMap colsFields = new HashMap();
        list = this.table.getAllColumnFields();
        int i2 = 0;
        while (i2 < list.size()) {
            colsFields.put(ClientSettings.getInstance().getResources().getResource(((ColumnField)list.get(i2)).getDescription()), list.get(i2));
            ++i2;
        }
        this.colsGrid = new FilterGridPanel(colsFields, this.pars.getColumnFields());
        HashMap rowsFields = new HashMap();
        list = this.table.getAllRowFields();
        int i3 = 0;
        while (i3 < list.size()) {
            rowsFields.put(ClientSettings.getInstance().getResources().getResource(((RowField)list.get(i3)).getDescription()), list.get(i3));
            ++i3;
        }
        this.rowsGrid = new FilterGridPanel(rowsFields, this.pars.getRowFields());
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(this.borderLayout1);
        this.buttonsPanel.setLayout(this.flowLayout1);
        this.okButton.setMnemonic(ClientSettings.getInstance().getResources().getResource("ok").charAt(0));
        this.okButton.setText(ClientSettings.getInstance().getResources().getResource("ok"));
        this.okButton.addActionListener(new FilterDialog_okButton_actionAdapter(this));
        this.cancelButton.setMnemonic(ClientSettings.getInstance().getResources().getResource("cancel").charAt(0));
        this.cancelButton.setText(ClientSettings.getInstance().getResources().getResource("cancel"));
        this.cancelButton.addActionListener(new FilterDialog_cancelButton_actionAdapter(this));
        this.flowLayout1.setAlignment(1);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.buttonsPanel.add((Component)this.okButton, null);
        this.buttonsPanel.add((Component)this.cancelButton, null);
        this.tabbedPane.add((Component)this.dataPanel, ClientSettings.getInstance().getResources().getResource("data fields"));
        this.tabbedPane.add((Component)this.rowsPanel, ClientSettings.getInstance().getResources().getResource("row fields"));
        this.tabbedPane.add((Component)this.colsPanel, ClientSettings.getInstance().getResources().getResource("column fields"));
        this.dataPanel.setLayout(this.borderLayout2);
        this.dataPanel.add((Component)this.dataGrid, "Center");
        this.rowsPanel.setLayout(this.borderLayout3);
        this.rowsPanel.add((Component)this.rowsGrid, "Center");
        this.colsPanel.setLayout(this.borderLayout4);
        this.colsPanel.add((Component)this.colsGrid, "Center");
    }

    void okButton_actionPerformed(ActionEvent e) {
        if (this.dataGrid.getSelectedFields().size() == 0) {
            OptionPane.showMessageDialog(ClientUtils.getParentFrame(this.table), "at least one data field must be selected", "Attention", 2);
            return;
        }
        this.rowsGrid.repaint();
        if (this.rowsGrid.getSelectedFields().size() == 0) {
            OptionPane.showMessageDialog(ClientUtils.getParentFrame(this.table), "at least one row field must be selected", "Attention", 2);
            return;
        }
        this.colsGrid.repaint();
        if (this.colsGrid.getSelectedFields().size() == 0) {
            OptionPane.showMessageDialog(ClientUtils.getParentFrame(this.table), "at least one column field must be selected", "Attention", 2);
            return;
        }
        this.pars.getDataFields().clear();
        this.pars.getDataFields().addAll(this.dataGrid.getSelectedFields());
        this.pars.getRowFields().clear();
        this.pars.getRowFields().addAll(this.rowsGrid.getSelectedFields());
        this.pars.getColumnFields().clear();
        this.pars.getColumnFields().addAll(this.colsGrid.getSelectedFields());
        this.table.compileDataInThread();
        this.setVisible(false);
    }
}

