/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.pivottable.client.FieldVO;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.java.GridDataLocator;

public class FilterGridPanel
extends JPanel {
    private HashMap allFields = null;
    BorderLayout borderLayout2;
    CheckBoxColumn colChecked;
    TextColumn colName;
    GridControl grid = new GridControl();
    private String gridId = null;
    private HashMap reverseAllFields;
    private int selRow = -1;
    private ArrayList selectedFields = null;

    public FilterGridPanel(HashMap allFields, ArrayList selectedFields) {
        this.borderLayout2 = new BorderLayout();
        this.colName = new TextColumn();
        this.colChecked = new CheckBoxColumn();
        this.reverseAllFields = new HashMap();
        this.allFields = allFields;
        this.selectedFields = selectedFields;
        this.gridId = String.valueOf(System.currentTimeMillis());
        Iterator it = allFields.keySet().iterator();
        Object desc = null;
        while (it.hasNext()) {
            desc = it.next();
            this.reverseAllFields.put(allFields.get(desc), desc);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final ArrayList getSelectedFields() {
        this.grid.transferFocus();
        ArrayList fields = new ArrayList();
        int i = 0;
        while (i < this.grid.getVOListTableModel().getRowCount()) {
            FieldVO vo = (FieldVO)this.grid.getVOListTableModel().getObjectForRow(i);
            if (vo.isSelected()) {
                fields.add(this.allFields.get(vo.getDescription()));
            }
            ++i;
        }
        return fields;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout2);
        this.grid.setValueObjectClassName("org.openswing.swing.pivottable.client.FieldVO");
        this.grid.setVisibleStatusPanel(false);
        this.grid.setShowFilterPanelOnGrid(false);
        this.colName.setColumnName("description");
        this.colName.setHeaderColumnName("field");
        this.colName.setPreferredWidth(150);
        this.colChecked.setColumnName("selected");
        this.colChecked.setEditableOnEdit(true);
        this.colChecked.setPreferredWidth(50);
        this.colChecked.setHeaderColumnName("checked");
        this.add((Component)this.grid, "Center");
        this.grid.getColumnContainer().add((Component)this.colName, null);
        this.grid.getColumnContainer().add((Component)this.colChecked, null);
        this.grid.setGridDataLocator(new GridDataLocator(){

            public Response loadData(int action, int startIndex, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, Map otherGridParams) {
                ArrayList<FieldVO> rows = new ArrayList<FieldVO>();
                Object field = null;
                String desc = null;
                FieldVO vo = null;
                int i = 0;
                while (i < FilterGridPanel.this.selectedFields.size()) {
                    field = FilterGridPanel.this.selectedFields.get(i);
                    desc = (String)FilterGridPanel.this.reverseAllFields.get(field);
                    vo = new FieldVO();
                    vo.setDescription(desc);
                    vo.setSelected(true);
                    rows.add(vo);
                    FilterGridPanel.this.reverseAllFields.remove(field);
                    ++i;
                }
                Iterator it = FilterGridPanel.this.reverseAllFields.keySet().iterator();
                while (it.hasNext()) {
                    field = it.next();
                    desc = (String)FilterGridPanel.this.reverseAllFields.get(field);
                    vo = new FieldVO();
                    vo.setDescription(desc);
                    vo.setSelected(false);
                    rows.add(vo);
                }
                return new VOListResponse(rows, false, rows.size());
            }
        });
        this.grid.enableDrag(this.gridId);
        this.grid.setController(new GridController(){

            public boolean dragEnabled() {
                FilterGridPanel.this.selRow = FilterGridPanel.this.grid.getSelectedRow();
                return true;
            }

            public boolean dropEnabled(String gridId) {
                boolean ok = gridId.equals(FilterGridPanel.this.gridId);
                if (ok) {
                    int newSelRow = FilterGridPanel.this.grid.getSelectedRow();
                    ValueObject vo = FilterGridPanel.this.grid.getVOListTableModel().getObjectForRow(FilterGridPanel.this.selRow);
                    FilterGridPanel.this.grid.getVOListTableModel().removeObjectAt(FilterGridPanel.this.selRow);
                    FilterGridPanel.this.grid.getVOListTableModel().insertObjectAt(vo, newSelRow);
                    FilterGridPanel.this.selRow = -1;
                    FilterGridPanel.this.grid.repaint();
                }
                return ok;
            }

            public void dropOver(int row) {
                FilterGridPanel.this.grid.setRowSelectionInterval(row, row);
            }

            public void loadDataCompleted(boolean error) {
                FilterGridPanel.this.grid.setMode(2);
            }
        });
    }
}

