/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.java;

import java.io.Serializable;
import java.text.NumberFormat;
import org.openswing.swing.pivottable.functions.java.GenericFunction;
import org.openswing.swing.pivottable.functions.java.SumFunction;

public class DataField
implements Serializable {
    private String columnName;
    private String description;
    private NumberFormat formatter = null;
    private GenericFunction function = new SumFunction();
    private int width;

    public DataField(String columnName, int width, String description, GenericFunction function) {
        this(columnName, width, description);
        this.function = function;
    }

    public DataField(String columnName, int width, GenericFunction function) {
        this(columnName, width, columnName, function);
    }

    public DataField(String columnName, int width, String description) {
        this.columnName = columnName;
        this.width = width;
        this.description = description;
    }

    public DataField(String columnName, int width) {
        this(columnName, width, columnName);
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DataField)) {
            return false;
        }
        return ((DataField)obj).getColumnName().equals(this.getColumnName()) && ((DataField)obj).getFunction().equals(this.getFunction());
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDescription() {
        return this.description;
    }

    public final NumberFormat getFormatter() {
        return this.formatter;
    }

    public GenericFunction getFunction() {
        return this.function;
    }

    public int getWidth() {
        return this.width;
    }

    public final int hashCode() {
        return this.getColumnName().hashCode() * this.getFunction().hashCode();
    }

    public final void setFormatter(NumberFormat formatter) {
        this.formatter = formatter;
    }
}

