/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.client;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openswing.swing.table.client.Grid;

public class GridUI
extends BasicTableUI {
    public void paint(Graphics g, JComponent c) {
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        if (((Grid)this.table).hasCellSpan()) {
            boolean ltr;
            int cMin;
            int rMin = this.table.rowAtPoint(upperLeft);
            if (rMin == -1) {
                rMin = 0;
            }
            int rMax = rMin;
            int h = 0;
            int i = rMin;
            while (i < this.table.getRowCount()) {
                if (h >= lowerRight.y) break;
                h += this.table.getRowHeight(i);
                rMax = i++;
            }
            if (rMax == -1) {
                rMax = this.table.getRowCount() - 1;
            }
            if ((cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight)) == -1) {
                cMin = 0;
            }
            int cMax = cMin;
            int w = 0;
            int i2 = cMin;
            while (i2 < this.table.getColumnCount()) {
                if (w >= lowerRight.x) break;
                w += this.table.getColumnModel().getColumn(i2).getWidth();
                cMax = i2++;
            }
            if (cMax == -1) {
                cMax = this.table.getColumnCount() - 1;
            }
            this.paintGrid(g, rMin, rMax, cMin, cMax);
            this.paintCells(g, rMin, rMax, cMin, cMax);
        } else {
            boolean ltr;
            int rMin = this.table.rowAtPoint(upperLeft);
            int rMax = this.table.rowAtPoint(lowerRight);
            if (rMin == -1) {
                rMin = 0;
            }
            if (rMax == -1) {
                rMax = this.table.getRowCount() - 1;
            }
            int cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
            int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
            if (cMin == -1) {
                cMin = 0;
            }
            if (cMax == -1) {
                cMax = this.table.getColumnCount() - 1;
            }
            this.paintGrid(g, rMin, rMax, cMin, cMax);
            this.paintCells(g, rMin, rMax, cMin, cMax);
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (!((Grid)this.table).isVisible(row, column)) {
            return;
        }
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int row = rMin;
        while (row <= rMax) {
            int column = cMin;
            while (column <= cMax) {
                Rectangle cellRect = this.table.getCellRect(row, column, false);
                TableColumn aColumn = cm.getColumn(column);
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, row, column);
                }
                ++column;
            }
            ++row;
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        int row = rMin;
        while (row <= rMax) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (this.table.getShowHorizontalLines()) {
                g.setColor(this.table.getGridColor());
                Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
                rcr.x += distance;
                int x1 = rcr.x;
                int y1 = rcr.y;
                int x2 = x1 + rcr.width - 1;
                int y2 = y1 + rcr.height - 1;
                if (((Grid)this.table).isVisible(row, draggedColumnIndex)) {
                    g.drawLine(x1, y2, x2, y2);
                }
            }
            ++row;
        }
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        TableColumnModel cm = this.table.getColumnModel();
        Rectangle cell = null;
        int col = cMin;
        while (col <= cMax) {
            int i;
            int row;
            if (this.table.getShowHorizontalLines()) {
                row = rMin;
                while (row <= rMax) {
                    int tableWidth = cm.getColumn(col).getWidth();
                    cell = this.table.getCellRect(row, col, true);
                    i = col + 1;
                    while (i < col + ((Grid)this.table).getSpan(row, col).getN2()) {
                        tableWidth += cm.getColumn(i).getWidth();
                        ++i;
                    }
                    g.drawLine(cell.x, cell.y - 1, cell.x + tableWidth - 1, cell.y - 1);
                    ++row;
                }
            }
            if (this.table.getShowVerticalLines()) {
                row = rMin;
                while (row <= rMax) {
                    cell = this.table.getCellRect(row, col, true);
                    int tableHeight = cell.y + cell.height;
                    i = col + 1;
                    while (i < col + ((Grid)this.table).getSpan(row, col).getN2()) {
                        cell.x += cm.getColumn(i).getWidth();
                        ++i;
                    }
                    g.drawLine(cell.x - 1, cell.y, cell.x - 1, tableHeight - 1);
                    ++row;
                }
            }
            ++col;
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            if (cm.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }
}

