/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openswing.swing.client.CopyButton;
import org.openswing.swing.client.DataController;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.ExpandableRowController;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.FilterButton;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.GenericButtonController;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.ImportButton;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.NavigatorBarController;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.export.client.ExportDialog;
import org.openswing.swing.export.java.ExportOptions;
import org.openswing.swing.export.java.ExportToCSV;
import org.openswing.swing.export.java.ExportToExcel;
import org.openswing.swing.export.java.ExportToHTML;
import org.openswing.swing.export.java.ExportToPDF;
import org.openswing.swing.export.java.ExportToRTF;
import org.openswing.swing.export.java.ExportToXML;
import org.openswing.swing.export.java.ExportToXMLFat;
import org.openswing.swing.export.java.GridExportOptions;
import org.openswing.swing.importdata.client.ImportDialog;
import org.openswing.swing.importdata.java.ImportFromCSV;
import org.openswing.swing.importdata.java.ImportFromExcel;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.BytesResponse;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.TextResponse;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.message.send.java.FilterWhereClause;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.GridStatusPanel;
import org.openswing.swing.table.columns.client.ButtonColumn;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.CodLookupColumn;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.ComboColumn;
import org.openswing.swing.table.filter.client.FilterDialog;
import org.openswing.swing.table.filter.client.QuickFilterPanel;
import org.openswing.swing.table.java.EJBGridDataLocator;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.table.java.ServerGridDataLocator;
import org.openswing.swing.table.model.client.VOListAdapter;
import org.openswing.swing.table.model.client.VOListTableModel;
import org.openswing.swing.table.model.client.VOListTableModelListener;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class Grids
extends JPanel
implements VOListTableModelListener,
DataController,
NavigatorBarController {
    private boolean allowInsertInEdit = false;
    private boolean anchorLockedColumnsToLeft = true;
    private HashSet bindedButtons;
    private int blockSize = -1;
    private Hashtable buttonsToDisable;
    private Hashtable cache;
    static /* synthetic */ Class class$org$openswing$swing$export$java$ExportOptions;
    private Column[] colProps = null;
    private CopyButton copyButton = null;
    private int currentEditingRow = -1;
    private Component currentNestedComponent = null;
    private int currentNestedComponentRow = -1;
    private int currentNumberOfNewRows = 0;
    private ArrayList currentSortedColumns;
    private ArrayList currentSortedVersusColumns;
    private HashMap currentValueButtons;
    private DeleteButton deleteButton = null;
    private EditButton editButton = null;
    private boolean editOnSingleRow = false;
    private ArrayList expandedRows;
    private ExportButton exportButton = null;
    private FilterButton filterButton = null;
    private FilterDialog filterDialog = null;
    private QuickFilterPanel filterPanel = null;
    private boolean firstTime = true;
    private String functionId = null;
    private ArrayList genericButtons;
    private Grid grid = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridControl gridControl = null;
    private GridController gridController = null;
    private GridDataLocator gridDataLocator = null;
    private int gridType;
    private ImportButton importButton = null;
    private InsertButton insertButton = null;
    private boolean insertRowsOnTop = true;
    private int lastIndex = -1;
    private boolean listenEvent = true;
    private ArrayList loadDataCompletedListeners;
    private int lockedColumns;
    private Grid lockedGrid = null;
    private int maxNumberOfRowsOnInsert = 1;
    private int maxSortedColumns = 1;
    private VOListTableModel model = null;
    private VOListAdapter modelAdapter = null;
    private boolean moreRows;
    private NavigatorBar navBar = null;
    private boolean onLoop = false;
    private Map otherGridParams = new HashMap();
    private GridPopup popup = new GridPopup();
    private ArrayList popupCommands;
    private Map quickFilterValues;
    private ReloadButton reloadButton = null;
    private JMenuItem removefilterItem = new JMenuItem(ClientSettings.getInstance().getResources().getResource("Remove Filter"), new ImageIcon(ClientUtils.getImage("filter-undo.gif")));
    private SaveButton saveButton = null;
    private JScrollPane scroll = null;
    private int selectedRowBeforeReloading = -1;
    private int startIndex = 0;
    private GridStatusPanel statusPanel = null;
    private int totalResultSetLength = -1;

    public Grids(GridControl gridControl, int lockedColumns, boolean anchorLockedColumnsToLeft, String valueObjectClassName, Column[] colProps, GridController gridController, GridStatusPanel statusPanel, GridDataLocator gridDataLocator, Map otherGridParams, boolean colorsInReadOnlyMode, ArrayList popupCommands, boolean anchorLastColumn, int expandableColumn, boolean singleExpandableRow, boolean overwriteRowWhenExpanding, ExpandableRowController expandableRowController, HashMap comboFilters, int headerHeight, boolean searchAdditionalRows, boolean allowColumnsSortingInEdit, int gridType) {
        this.quickFilterValues = new HashMap();
        this.popupCommands = new ArrayList();
        this.genericButtons = new ArrayList();
        this.currentSortedColumns = new ArrayList();
        this.currentSortedVersusColumns = new ArrayList();
        this.buttonsToDisable = new Hashtable();
        this.loadDataCompletedListeners = new ArrayList();
        this.expandedRows = new ArrayList();
        this.cache = new Hashtable();
        this.currentValueButtons = new HashMap();
        this.bindedButtons = new HashSet();
        this.gridControl = gridControl;
        this.lockedColumns = lockedColumns;
        this.anchorLockedColumnsToLeft = anchorLockedColumnsToLeft;
        this.colProps = colProps;
        this.gridController = gridController;
        this.statusPanel = statusPanel;
        this.gridDataLocator = gridDataLocator;
        this.otherGridParams = otherGridParams;
        this.popupCommands = popupCommands;
        this.gridType = gridType;
        try {
            int i = 0;
            while (i < colProps.length) {
                if (colProps[i].isAutoFitColumn()) {
                    colProps[i].setPreferredWidth(Toolkit.getDefaultToolkit().getFontMetrics(ClientSettings.HEADER_FONT == null ? new JLabel().getFont() : ClientSettings.HEADER_FONT).stringWidth(ClientSettings.getInstance().getResources().getResource(colProps[i].getHeaderColumnName())) + 10);
                }
                ++i;
            }
            this.modelAdapter = new VOListAdapter(Class.forName(valueObjectClassName), gridController, colProps, this);
            this.model = new VOListTableModel(this.modelAdapter, this);
        }
        catch (ClassNotFoundException ex) {
            Logger.error(this.getClass().getName(), "Grids", "Error while constructing grids: value object '" + valueObjectClassName + "' doesn't exist.", ex);
        }
        catch (Throwable t) {
            Logger.error(this.getClass().getName(), "Grids", "Error while constructing ", t);
        }
        this.grid = new Grid(this, colProps, statusPanel, anchorLockedColumnsToLeft ? lockedColumns : 0, anchorLockedColumnsToLeft ? colProps.length : colProps.length - lockedColumns, colorsInReadOnlyMode, this.model, this.modelAdapter, gridController, false, anchorLastColumn, expandableColumn, singleExpandableRow, overwriteRowWhenExpanding, expandableRowController, comboFilters, headerHeight, searchAdditionalRows, allowColumnsSortingInEdit, gridType);
        if (lockedColumns > 0) {
            if (anchorLockedColumnsToLeft) {
                int i = 0;
                while (i < lockedColumns) {
                    colProps[i].setColumnSelectable(false);
                    ++i;
                }
            } else {
                int i = colProps.length - lockedColumns;
                while (i < colProps.length) {
                    colProps[i].setColumnSelectable(false);
                    ++i;
                }
            }
            this.lockedGrid = new Grid(this, colProps, statusPanel, anchorLockedColumnsToLeft ? 0 : colProps.length - lockedColumns, anchorLockedColumnsToLeft ? lockedColumns : colProps.length, colorsInReadOnlyMode, this.model, this.modelAdapter, gridController, true, anchorLastColumn, expandableColumn, singleExpandableRow, overwriteRowWhenExpanding, expandableRowController, comboFilters, headerHeight, searchAdditionalRows, allowColumnsSortingInEdit, gridType);
            this.lockedGrid.setReorderingAllowed(false);
            this.lockedGrid.setResizingAllowed(false);
            this.grid.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    Grids.this.lockedGrid.stopCellEditing();
                }
            });
            this.lockedGrid.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    Grids.this.grid.stopCellEditing();
                }
            });
        }
        try {
            this.jbInit();
            this.setupScrollBars();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setNavBar(new NavigatorBar());
        this.removefilterItem.setAccelerator(ClientSettings.REMOVE_FILTER_KEY);
    }

    static /* synthetic */ NavigatorBar access$2800(Grids x0) {
        return x0.navBar;
    }

    static /* synthetic */ ReloadButton access$2900(Grids x0) {
        return x0.reloadButton;
    }

    static /* synthetic */ InsertButton access$3000(Grids x0) {
        return x0.insertButton;
    }

    static /* synthetic */ ExportButton access$3100(Grids x0) {
        return x0.exportButton;
    }

    static /* synthetic */ ImportButton access$3200(Grids x0) {
        return x0.importButton;
    }

    static /* synthetic */ CopyButton access$3300(Grids x0) {
        return x0.copyButton;
    }

    static /* synthetic */ EditButton access$3400(Grids x0) {
        return x0.editButton;
    }

    static /* synthetic */ DeleteButton access$3500(Grids x0) {
        return x0.deleteButton;
    }

    static /* synthetic */ SaveButton access$3600(Grids x0) {
        return x0.saveButton;
    }

    static /* synthetic */ boolean access$400(Grids x0) {
        return x0.listenEvent;
    }

    public final void addButtonsNotEnabled(HashSet buttons, GenericButtonController buttonController) {
        Iterator it = buttons.iterator();
        GenericButton genericButton = null;
        ArrayList<GenericButtonController> list = null;
        while (it.hasNext()) {
            genericButton = (GenericButton)it.next();
            list = (ArrayList<GenericButtonController>)this.buttonsToDisable.get(genericButton);
            if (list == null) {
                list = new ArrayList<GenericButtonController>();
                this.buttonsToDisable.put(genericButton, list);
            }
            list.add(buttonController);
        }
    }

    public final void addGenericButton(GenericButton button) {
        if (button != null) {
            this.genericButtons.add(button);
            button.addDataController(this);
        }
    }

    public final void addLoadDataCompletedListener(ActionListener listener) {
        this.loadDataCompletedListeners.add(listener);
    }

    public final void addNotify() {
        super.addNotify();
        if (this.firstTime) {
            this.firstTime = false;
            if (this.getSaveButton() != null) {
                this.getSaveButton().setEnabled(false);
            }
            if (this.getInsertButton() != null) {
                this.getInsertButton().setEnabled(false);
            }
            if (this.getExportButton() != null) {
                this.getExportButton().setEnabled(false);
            }
            if (this.getImportButton() != null) {
                this.getImportButton().setEnabled(false);
            }
            if (this.getCopyButton() != null) {
                this.getCopyButton().setEnabled(false);
            }
            if (this.getEditButton() != null) {
                this.getEditButton().setEnabled(false);
            }
            if (this.getFilterButton() != null) {
                this.getFilterButton().setEnabled(false);
            }
            this.setGenericButtonsEnabled(false);
            if (this.getDeleteButton() != null) {
                this.getDeleteButton().setEnabled(false);
            }
            this.resetButtonsState();
        }
    }

    private void afterNextRow() {
        this.grid.ensureRowIsVisible(this.grid.getSelectedRow());
        if (this.lockedGrid != null) {
            this.lockedGrid.ensureRowIsVisible(this.lockedGrid.getSelectedRow());
        }
        if (this.getNavBar() != null) {
            if (this.grid.getSelectedRow() != -1 && !this.moreRows && this.grid.getSelectedRow() == this.model.getRowCount() - 1) {
                this.getNavBar().setLastRow(true);
            } else {
                this.getNavBar().setLastRow(false);
            }
            if (this.grid.getSelectedRow() > 0 || this.lastIndex > this.model.getRowCount() - 1) {
                this.getNavBar().setFirstRow(false);
            } else {
                this.getNavBar().setFirstRow(true);
            }
        }
    }

    private void afterPreviousRow() {
        this.grid.ensureRowIsVisible(this.grid.getSelectedRow());
        if (this.lockedGrid != null) {
            this.lockedGrid.ensureRowIsVisible(this.lockedGrid.getSelectedRow());
        }
        if (this.getNavBar() != null) {
            if (this.grid.getSelectedRow() == 0 && this.lastIndex + 1 <= this.model.getRowCount()) {
                this.getNavBar().setFirstRow(true);
            } else {
                this.getNavBar().setFirstRow(false);
            }
            if (this.grid.getSelectedRow() < this.model.getRowCount() - 1 || this.moreRows) {
                this.getNavBar().setLastRow(false);
            } else {
                this.getNavBar().setLastRow(true);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final void clearData() {
        this.model.clear();
        this.expandedRows.clear();
        this.cache.clear();
        this.revalidate();
        this.grid.revalidate();
        this.grid.repaint();
        if (this.lockedGrid != null) {
            this.lockedGrid.revalidate();
            this.lockedGrid.repaint();
        }
        this.moreRows = false;
        this.startIndex = -1;
        this.lastIndex = -1;
    }

    public final void collapseRow(int row) {
        if (this.expandedRows.contains(new Integer(row))) {
            this.expandedRows.remove(new Integer(row));
        }
        this.currentNestedComponent = null;
    }

    public final void copy() {
        if (this.getMode() == 0) {
            try {
                if (!this.gridController.beforeCopyGrid(this.gridControl)) {
                    return;
                }
                ValueObject vo = (ValueObject)this.model.getObjectForRow(this.grid.getSelectedRow()).clone();
                this.currentNumberOfNewRows = 1;
                this.model.setMode(1);
                if (this.getInsertButton() != null) {
                    this.getInsertButton().setEnabled(false);
                }
                if (this.getExportButton() != null) {
                    this.getExportButton().setEnabled(false);
                }
                if (this.getImportButton() != null) {
                    this.getImportButton().setEnabled(false);
                }
                if (this.getCopyButton() != null) {
                    this.getCopyButton().setEnabled(false);
                }
                if (this.getDeleteButton() != null) {
                    this.getDeleteButton().setEnabled(false);
                }
                if (this.getEditButton() != null) {
                    this.getEditButton().setEnabled(false);
                }
                if (this.getFilterButton() != null) {
                    this.getFilterButton().setEnabled(false);
                }
                this.setGenericButtonsEnabled(false);
                if (this.getReloadButton() != null) {
                    this.getReloadButton().setEnabled(true);
                }
                if (this.getSaveButton() != null) {
                    this.getSaveButton().setEnabled(true);
                }
                String attributeName = null;
                Object attributeValue = null;
                int newRowIndex = this.isInsertRowsOnTop() ? 0 : this.model.getRowCount() - 1;
                int i = 0;
                while (i < this.model.getColumnCount()) {
                    attributeName = this.model.getColumnName(i);
                    if (this.modelAdapter.isFieldDuplicable(i)) {
                        attributeValue = this.modelAdapter.getField(vo, i);
                        this.modelAdapter.setField(this.model.getObjectForRow(newRowIndex), i, attributeValue);
                    }
                    ++i;
                }
                this.grid.setRowSelectionInterval(0, 0);
                this.grid.setColumnSelectionInterval(0, 0);
                if (this.lockedGrid != null) {
                    this.lockedGrid.setRowSelectionInterval(0, 0);
                    this.lockedGrid.setColumnSelectionInterval(0, 0);
                }
                this.resetButtonsState();
                int col = 0;
                if (this.lockedGrid != null) {
                    while (col < this.lockedGrid.getColumnCount() && !this.lockedGrid.isCellEditable(this.lockedGrid.getSelectedRow(), col)) {
                        ++col;
                    }
                    if (col < this.lockedGrid.getColumnCount()) {
                        this.lockedGrid.setColumnSelectionInterval(col, col);
                    }
                    if (this.lockedGrid.getSelectedColumn() != -1) {
                        this.lockedGrid.editCellAt(this.lockedGrid.getSelectedRow(), this.lockedGrid.getSelectedColumn());
                    }
                    this.lockedGrid.requestFocus();
                }
                if (this.lockedGrid == null || col == this.lockedGrid.getColumnCount()) {
                    col = 0;
                    while (col < this.grid.getColumnCount() && !this.grid.isCellEditable(this.grid.getSelectedRow(), col)) {
                        ++col;
                    }
                    if (col < this.grid.getColumnCount()) {
                        this.grid.setColumnSelectionInterval(col, col);
                    }
                    this.grid.editCellAt(this.grid.getSelectedRow(), this.grid.getSelectedColumn());
                    this.grid.requestFocus();
                }
            }
            catch (Throwable ex) {
                Logger.error(this.getClass().getName(), "copy", "Error on duplicating a v.o.", ex);
            }
        } else {
            Logger.error(this.getClass().getName(), "copy", "Setting grid to insert mode is not allowed: grid must be in read only mode.", null);
        }
    }

    public final void delete() {
        block17: {
            if (this.getMode() == 0) {
                if (!this.gridController.beforeDeleteGrid(this.gridControl)) {
                    return;
                }
                int[] selRows = this.grid.getSelectedRows();
                if (selRows.length != 0 && OptionPane.showConfirmDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Delete Rows?"), ClientSettings.getInstance().getResources().getResource("Delete Confirmation"), 0) == 0) {
                    ArrayList<ValueObject> vos = new ArrayList<ValueObject>();
                    int i = 0;
                    while (i < selRows.length) {
                        vos.add(this.model.getObjectForRow(selRows[i]));
                        ++i;
                    }
                    try {
                        Response response = this.gridController.deleteRecords(vos);
                        if (!response.isError()) {
                            Arrays.sort(selRows);
                            int i2 = 0;
                            while (i2 < selRows.length) {
                                this.model.removeObjectAt(selRows[i2] - i2);
                                ++i2;
                            }
                            this.lastIndex -= selRows.length;
                            this.gridController.afterDeleteGrid();
                            break block17;
                        }
                        OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while deleting rows.") + "\n" + ClientSettings.getInstance().getResources().getResource(response.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Deleting Error"), 0);
                    }
                    catch (Throwable ex) {
                        Logger.error(this.getClass().getName(), "delete", "Error while deleting rows.", ex);
                        OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while deleting rows.") + "\n" + ex.getMessage(), ClientSettings.getInstance().getResources().getResource("Deleting Error"), 0);
                    }
                }
            } else if ((this.getMode() == 1 || this.getMode() == 2) && this.getCurrentNumberOfNewRows() > 0 && this.grid.getSelectedRow() != -1) {
                this.grid.stopCellEditing();
                int row = this.grid.getSelectedRow();
                this.setCurrentNumberOfNewRows(this.getCurrentNumberOfNewRows() - 1);
                this.model.removeObjectAt(row);
                this.model.getChangedRowIndexes().remove(new Integer(row));
                row = this.model.getRowCount() > 0 && row > 0 ? --row : (this.model.getRowCount() > 0 ? 0 : -1);
                if (row != -1) {
                    this.setRowSelectionInterval(row, row);
                    this.grid.setColumnSelectionInterval(0, 0);
                    this.grid.ensureRowIsVisible(row);
                    if (this.getLockedGrid() != null) {
                        this.getLockedGrid().setRowSelectionInterval(row, row);
                        this.getLockedGrid().setColumnSelectionInterval(0, 0);
                        this.getLockedGrid().ensureRowIsVisible(row);
                        this.getLockedGrid().editCellAt(row, 0);
                        this.getLockedGrid().requestFocus();
                    } else {
                        this.grid.editCellAt(row, 0);
                        this.requestFocus();
                    }
                }
                if (this.getDeleteButton() != null && this.getMode() == 1 && this.getCurrentNumberOfNewRows() == 1) {
                    this.getDeleteButton().setEnabled(false);
                } else if (this.getDeleteButton() != null && this.getMode() == 2 && this.getCurrentNumberOfNewRows() == 0) {
                    this.getDeleteButton().setEnabled(false);
                }
            } else {
                Logger.error(this.getClass().getName(), "delete", "Delete rows is not allowed: grid must be in read only mode.", null);
            }
        }
    }

    public final void edit() {
        if (this.getMode() == 0) {
            if (!this.gridController.beforeEditGrid(this.gridControl)) {
                return;
            }
            this.model.setMode(2);
            if (this.getInsertButton() != null) {
                this.getInsertButton().setEnabled(false);
            }
            if (this.getExportButton() != null) {
                this.getExportButton().setEnabled(false);
            }
            if (this.getImportButton() != null) {
                this.getImportButton().setEnabled(false);
            }
            if (this.getCopyButton() != null) {
                this.getCopyButton().setEnabled(false);
            }
            if (this.getDeleteButton() != null) {
                this.getDeleteButton().setEnabled(false);
            }
            if (this.getEditButton() != null) {
                this.getEditButton().setEnabled(false);
            }
            if (this.getFilterButton() != null) {
                this.getFilterButton().setEnabled(false);
            }
            this.setGenericButtonsEnabled(false);
            if (this.getReloadButton() != null) {
                this.getReloadButton().setEnabled(true);
            }
            if (this.getSaveButton() != null) {
                this.getSaveButton().setEnabled(true);
            }
            if (this.getVOListTableModel().getRowCount() > 0) {
                if (this.grid.getSelectedRow() == -1) {
                    this.grid.setRowSelectionInterval(0, 0);
                    if (this.lockedGrid != null) {
                        this.lockedGrid.setRowSelectionInterval(0, 0);
                    }
                }
                this.grid.setColumnSelectionInterval(0, 0);
                if (this.lockedGrid != null) {
                    this.lockedGrid.setColumnSelectionInterval(0, 0);
                }
            }
            this.resetButtonsState();
            if (this.lockedGrid != null) {
                this.lockedGrid.requestFocus();
            } else {
                this.grid.requestFocus();
            }
            int col = 0;
            if (this.lockedGrid != null) {
                while (col < this.lockedGrid.getColumnCount() && !this.lockedGrid.isCellEditable(this.lockedGrid.getSelectedRow(), col)) {
                    ++col;
                }
                if (col < this.lockedGrid.getColumnCount()) {
                    this.lockedGrid.setColumnSelectionInterval(col, col);
                }
                if (this.lockedGrid.getSelectedColumn() != -1) {
                    this.lockedGrid.editCellAt(this.lockedGrid.getSelectedRow(), this.lockedGrid.getSelectedColumn());
                }
                this.lockedGrid.requestFocus();
            }
            if (this.lockedGrid == null || col == this.lockedGrid.getColumnCount()) {
                col = 0;
                while (col < this.grid.getColumnCount() && !this.grid.isCellEditable(this.grid.getSelectedRow(), col)) {
                    ++col;
                }
                if (col < this.grid.getColumnCount()) {
                    this.grid.setColumnSelectionInterval(col, col);
                }
                this.grid.editCellAt(this.grid.getSelectedRow(), this.grid.getSelectedColumn());
                this.grid.requestFocus();
            }
        } else {
            Logger.error(this.getClass().getName(), "edit", "Setting grid to edit mode is not allowed: grid must be in read only mode.", null);
        }
    }

    public final void enableDrag(String gridId) {
        this.grid.enableDrag(gridId);
        if (this.lockedGrid != null) {
            this.lockedGrid.enableDrag(gridId);
        }
    }

    public boolean executeReload() {
        try {
            this.grid.editingCanceled(null);
            if (this.lockedGrid != null) {
                this.lockedGrid.editingCanceled(null);
            }
            this.model.setMode(0);
            this.reloadData();
            super.repaint();
            if (this.getSaveButton() != null) {
                this.getSaveButton().setEnabled(false);
            }
            if (this.getEditButton() != null) {
                this.getEditButton().setEnabled(this.model.getRowCount() > 0);
            }
            if (this.getDeleteButton() != null) {
                this.getDeleteButton().setEnabled(this.model.getRowCount() > 0);
            }
            if (this.getInsertButton() != null) {
                this.getInsertButton().setEnabled(true);
            }
            if (this.getExportButton() != null) {
                this.getExportButton().setEnabled(this.model.getRowCount() > 0);
            }
            if (this.getImportButton() != null) {
                this.getImportButton().setEnabled(true);
            }
            if (this.getCopyButton() != null) {
                this.getCopyButton().setEnabled(this.model.getRowCount() > 0);
            }
            if (this.getFilterButton() != null) {
                this.getFilterButton().setEnabled(this.model.getRowCount() > 0);
            }
            this.gridController.afterReloadGrid();
            this.resetButtonsState();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public final void expandRow(int row) {
        if (!this.expandedRows.contains(new Integer(row))) {
            this.expandedRows.add(new Integer(row));
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void export(ArrayList exportColumns, ArrayList exportAttrColumns, String exportType) {
        block33: {
            columnsWidth = new Hashtable<String, Integer>(this.colProps.length);
            columnsType = new Hashtable<String, Integer>(this.colProps.length);
            i = 0;
            while (i < this.colProps.length) {
                columnsWidth.put(this.colProps[i].getColumnName(), new Integer(this.colProps[i].getPreferredWidth()));
                columnsType.put(this.colProps[i].getColumnName(), new Integer(this.colProps[i].getColumnType()));
                ++i;
            }
            topRows = new ArrayList<E>();
            if (this.gridControl != null && this.gridControl.getTopTable() != null) {
                topRows.addAll(this.gridControl.getTopTable().getVOListTableModel().getDataVector());
            }
            bottomRows = new ArrayList<E>();
            if (this.gridControl != null && this.gridControl.getBottomTable() != null) {
                bottomRows.addAll(this.gridControl.getBottomTable().getVOListTableModel().getDataVector());
            }
            attributeDescriptions = new Hashtable<String, String>();
            i = 0;
            while (i < this.colProps.length) {
                attributeDescriptions.put(this.colProps[i].getColumnName(), ClientSettings.getInstance().getResources().getResource(this.colProps[i].getHeaderColumnName()));
                ++i;
            }
            opt = new ExportOptions(new GridExportOptions(exportColumns, exportAttrColumns, this.quickFilterValues, this.currentSortedColumns, this.currentSortedVersusColumns, this.otherGridParams, ClientSettings.MAX_EXPORTABLE_ROWS, this.modelAdapter.getValueObjectType(), this.gridDataLocator, columnsWidth, columnsType, attributeDescriptions, topRows, bottomRows), ClientSettings.getInstance().getResources().getDateMask(1), ClientSettings.getInstance().getResources().getDateMask(3), ClientSettings.getInstance().getResources().getDateMask(2), exportType, ClientSettings.EXPORT_TO_PDF_ADAPTER, ClientSettings.EXPORT_TO_RTF_ADAPTER);
            gridExportOptions = (GridExportOptions)opt.getComponentsExportOptions().get(0);
            gridExportOptions.setShowFilteringConditions(ClientSettings.SHOW_FILTERING_CONDITIONS_IN_EXPORT);
            if (ClientSettings.SHOW_FRAME_TITLE_IN_EXPORT) {
                intFrame = ClientUtils.getParentInternalFrame(this);
                if (intFrame != null) {
                    if (!intFrame.getTitle().equals("")) {
                        gridExportOptions.setTitle(intFrame.getTitle());
                    }
                } else {
                    frame = ClientUtils.getParentFrame(this);
                    if (frame != null && !frame.getTitle().equals("")) {
                        gridExportOptions.setTitle(frame.getTitle());
                    }
                }
            }
            this.gridController.exportGrid(opt);
            try {
                block35: {
                    block34: {
                        if (this.gridDataLocator instanceof ServerGridDataLocator) {
                            if (((ServerGridDataLocator)this.gridDataLocator).getServerMethodName() == null) {
                                Logger.error(this.getClass().getName(), "export", "You cannot export data: 'serverMethodName' property in ServerGridDataLocator must be defined.", null);
                                return;
                            }
                            gridExportOptions.getOtherGridParams().put("LOAD_ALL", Boolean.TRUE);
                            gridExportOptions.setServerMethodName(((ServerGridDataLocator)this.gridDataLocator).getServerMethodName());
                            response = ClientUtils.getData("exportDataGrid", opt);
                            gridExportOptions.getOtherGridParams().remove("LOAD_ALL");
                            if (response.isError()) {
                                OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource(response.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Error"), 2);
                            } else {
                                ClientUtils.showDocument(((TextResponse)response).getMessage());
                            }
                        }
                        if (this.gridDataLocator instanceof EJBGridDataLocator) {
                            if (((EJBGridDataLocator)this.gridDataLocator).getServerMethodName() == null) {
                                Logger.error(this.getClass().getName(), "export", "You cannot export data: 'serverMethodName' property in EJBGridDataLocator must be defined.", null);
                                return;
                            }
                            if (((EJBGridDataLocator)this.gridDataLocator).getInitialContext() == null) {
                                Logger.error(this.getClass().getName(), "export", "You cannot export data: 'initialContext' property in EJBGridDataLocator must be defined.", null);
                                return;
                            }
                            if (((EJBGridDataLocator)this.gridDataLocator).getEjbName() == null) {
                                Logger.error(this.getClass().getName(), "export", "You cannot export data: 'ejbName' property in EJBGridDataLocator must be defined.", null);
                                return;
                            }
                            obj = ((EJBGridDataLocator)this.gridDataLocator).getInitialContext().lookup(ClientSettings.EJB_EXPORT_BEAN_NAME);
                            response = (Response)obj.getClass().getMethod("export", new Class[]{Grids.class$org$openswing$swing$export$java$ExportOptions == null ? (Grids.class$org$openswing$swing$export$java$ExportOptions = Grids.class$("org.openswing.swing.export.java.ExportOptions")) : Grids.class$org$openswing$swing$export$java$ExportOptions}).invoke(obj, new Object[]{opt});
                            if (response.isError()) {
                                OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource(response.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Error"), 2);
                            } else {
                                bytes = ((BytesResponse)response).getBytes();
                                fileName = ((BytesResponse)response).getFileName();
                                out = new FileOutputStream(fileName);
                                out.write(bytes);
                                out.close();
                                ClientUtils.displayURL("file://" + fileName);
                            }
                            break block33;
                        }
                        fileName = System.getProperty("java.io.tmpdir").replace('\\', '/');
                        if (!fileName.endsWith("/")) {
                            fileName = fileName + "/";
                        }
                        doc = null;
                        gridExportOptions.getOtherGridParams().put("LOAD_ALL", Boolean.TRUE);
                        if (!opt.getExportType().equals("XLS")) break block34;
                        doc = new ExportToExcel().getDocument(opt);
                        fileName = fileName + "doc" + System.currentTimeMillis() + ".xls";
                        break block35;
                    }
                    if (opt.getExportType().equals("CSV (,)")) ** GOTO lbl-1000
                    if (opt.getExportType().equals("CSV (;)")) lbl-1000:
                    // 2 sources

                    {
                        doc = new ExportToCSV().getDocument(opt);
                        fileName = fileName + "doc" + System.currentTimeMillis() + ".csv";
                    } else if (opt.getExportType().equals("XML (small format)")) {
                        doc = new ExportToXML().getDocument(opt);
                        fileName = fileName + "doc" + System.currentTimeMillis() + ".xml";
                    } else if (opt.getExportType().equals("XML (large format)")) {
                        doc = new ExportToXMLFat().getDocument(opt);
                        fileName = fileName + "doc" + System.currentTimeMillis() + ".xml";
                    } else if (opt.getExportType().equals("HTML")) {
                        doc = new ExportToHTML().getDocument(opt);
                        fileName = fileName + "doc" + System.currentTimeMillis() + ".html";
                    } else if (opt.getExportType().equals("PDF")) {
                        doc = new ExportToPDF().getDocument(opt);
                        fileName = fileName + "doc" + System.currentTimeMillis() + ".pdf";
                    } else if (opt.getExportType().equals("RTF")) {
                        doc = new ExportToRTF().getDocument(opt);
                        fileName = fileName + "doc" + System.currentTimeMillis() + ".rtf";
                    }
                }
                gridExportOptions.getOtherGridParams().remove("LOAD_ALL");
                out = new FileOutputStream(fileName);
                out.write(doc);
                out.close();
                ClientUtils.displayURL("file://" + fileName);
            }
            catch (Throwable ex) {
                Logger.error(this.getClass().getName(), "export", "Error while exporting data:\n" + ex.getMessage(), ex);
            }
        }
    }

    public final void export() {
        if (this.getMode() == 0) {
            HashSet<String> colsVisible = new HashSet<String>();
            int i = 0;
            while (i < this.colProps.length) {
                if (this.colProps[i].isVisible()) {
                    colsVisible.add(this.colProps[i].getColumnName());
                }
                ++i;
            }
            ExportDialog d = new ExportDialog(ClientUtils.getParentFrame(this), this, colsVisible);
        } else {
            Logger.error(this.getClass().getName(), "export", "You cannot export data: grid must be in read only mode.", null);
        }
    }

    public final void filterSort() {
        if (this.getMode() == 0) {
            if (this.filterDialog == null) {
                this.filterDialog = new FilterDialog(this.colProps, this);
            }
            this.filterDialog.init();
        }
    }

    public final void finalize() {
        if (this.filterDialog != null) {
            this.filterDialog.dispose();
        }
        try {
            if (this.grid == null) {
                return;
            }
            this.grid.finalize();
            if (this.lockedGrid != null) {
                this.lockedGrid.finalize();
            }
            FocusListener[] fl = this.getFocusListeners();
            int i = 0;
            while (i < fl.length) {
                this.removeFocusListener(fl[i]);
                ++i;
            }
            MouseListener[] ml = this.getMouseListeners();
            int i2 = 0;
            while (i2 < ml.length) {
                this.removeMouseListener(ml[i2]);
                ++i2;
            }
            KeyListener[] ll = this.getKeyListeners();
            int i3 = 0;
            while (i3 < ll.length) {
                this.removeKeyListener(ll[i3]);
                ++i3;
            }
            this.lockedGrid = null;
            this.grid = null;
            this.model = null;
            this.gridController = null;
            this.insertButton = null;
            this.exportButton = null;
            this.importButton = null;
            this.copyButton = null;
            this.filterButton = null;
            this.editButton = null;
            this.reloadButton = null;
            this.deleteButton = null;
            this.saveButton = null;
            this.modelAdapter = null;
            this.navBar = null;
            this.gridDataLocator = null;
            this.gridControl = null;
            this.filterPanel = null;
            this.popup = null;
            this.removefilterItem = null;
            this.popupCommands = null;
            this.genericButtons = null;
            this.statusPanel = null;
            this.colProps = null;
            this.buttonsToDisable = null;
            this.filterDialog = null;
            this.loadDataCompletedListeners = null;
            this.expandedRows = null;
            this.cache = null;
            this.currentNestedComponent = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void firstRow(final NavigatorBar navBar) {
        if (!this.listenEvent) {
            return;
        }
        if (this.getMode() != 0) {
            return;
        }
        this.listenEvent = false;
        new Thread(){

            public void run() {
                boolean errorOnLoad = true;
                if (Grids.this.getNavBar() != null) {
                    Grids.this.getNavBar().setEnabled(false);
                }
                if (Grids.this.getReloadButton() != null) {
                    Grids.this.getReloadButton().setEnabled(false);
                }
                if (Grids.this.getInsertButton() != null) {
                    Grids.this.getInsertButton().setEnabled(false);
                }
                if (Grids.this.getExportButton() != null) {
                    Grids.this.getExportButton().setEnabled(false);
                }
                if (Grids.this.getImportButton() != null) {
                    Grids.this.getImportButton().setEnabled(false);
                }
                if (Grids.this.getCopyButton() != null) {
                    Grids.this.getCopyButton().setEnabled(false);
                }
                if (Grids.this.getDeleteButton() != null) {
                    Grids.this.getDeleteButton().setEnabled(false);
                }
                if (Grids.this.getEditButton() != null) {
                    Grids.this.getEditButton().setEnabled(false);
                }
                if (Grids.this.getFilterButton() != null) {
                    Grids.this.getFilterButton().setEnabled(false);
                }
                if (Grids.this.getSaveButton() != null) {
                    Grids.this.getSaveButton().setEnabled(false);
                }
                Grids.this.startIndex = 0;
                boolean bl = errorOnLoad = !Grids.this.loadData(1);
                if (Grids.this.getNavBar() != null) {
                    Grids.this.getNavBar().setEnabled(false);
                }
                Grids.this.lastIndex = Grids.this.model.getRowCount() - 1;
                if (Grids.this.getNavBar() != null) {
                    if (Grids.this.lastIndex <= 0) {
                        Grids.this.getNavBar().setFirstRow(true);
                    } else {
                        Grids.this.getNavBar().setFirstRow(false);
                    }
                    if (Grids.this.model.getRowCount() <= 1 && !Grids.this.moreRows) {
                        Grids.this.getNavBar().setLastRow(true);
                    } else {
                        Grids.this.getNavBar().setLastRow(false);
                    }
                }
                if (Grids.this.getReloadButton() != null) {
                    Grids.this.getReloadButton().setEnabled(true);
                }
                if (Grids.this.model.getRowCount() > 0) {
                    Grids.this.grid.setRowSelectionInterval(0, 0);
                    Grids.this.grid.ensureRowIsVisible(Grids.this.grid.getSelectedRow());
                    if (Grids.this.lockedGrid != null) {
                        Grids.this.lockedGrid.setRowSelectionInterval(0, 0);
                        Grids.this.lockedGrid.ensureRowIsVisible(Grids.this.grid.getSelectedRow());
                    }
                    if (Grids.this.getNavBar() != null && Grids.this.lastIndex == Grids.this.model.getRowCount() - 1) {
                        Grids.this.getNavBar().setFirstRow(true);
                    }
                    if (Grids.this.lockedGrid == null) {
                        Grids.this.grid.requestFocus();
                    } else {
                        Grids.this.lockedGrid.requestFocus();
                    }
                    Grids.this.listenEvent = true;
                }
                if (Grids.this.gridController != null) {
                    Grids.this.gridController.loadDataCompleted(errorOnLoad);
                }
                if (!errorOnLoad) {
                    int i = 0;
                    while (i < Grids.this.loadDataCompletedListeners.size()) {
                        ((ActionListener)Grids.this.loadDataCompletedListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, "Load Data Completed"));
                        ++i;
                    }
                }
                Grids.this.resetButtonsState();
                if (navBar != null) {
                    navBar.fireButtonPressedEvent("FIRST_BUTTON");
                }
            }
        }.start();
    }

    public final HashSet getBindedButtons() {
        return this.bindedButtons;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final Component getComponentInCache(int row) {
        return (Component)this.cache.get(new Integer(row));
    }

    public CopyButton getCopyButton() {
        return this.copyButton;
    }

    public final int getCurrentEditingRow() {
        return this.currentEditingRow;
    }

    public final Component getCurrentNestedComponent() {
        return this.currentNestedComponent;
    }

    public final int getCurrentNestedComponentRow() {
        return this.currentNestedComponentRow;
    }

    public final int getCurrentNumberOfNewRows() {
        return this.currentNumberOfNewRows;
    }

    public final ArrayList getCurrentSortedColumns() {
        return this.currentSortedColumns;
    }

    public final ArrayList getCurrentSortedVersusColumns() {
        return this.currentSortedVersusColumns;
    }

    public final boolean getCurrentValue(GenericButton button) {
        Boolean currentValue = (Boolean)this.currentValueButtons.get(button);
        if (currentValue == null) {
            return true;
        }
        return currentValue;
    }

    public final GridExportOptions getDefaultGridExportOptions(HashSet attributesToExport) {
        Hashtable<String, Integer> columnsWidth = new Hashtable<String, Integer>(this.colProps.length);
        Hashtable<String, Integer> columnsType = new Hashtable<String, Integer>(this.colProps.length);
        int i = 0;
        while (i < this.colProps.length) {
            columnsWidth.put(this.colProps[i].getColumnName(), new Integer(this.colProps[i].getPreferredWidth()));
            columnsType.put(this.colProps[i].getColumnName(), new Integer(this.colProps[i].getColumnType()));
            ++i;
        }
        ArrayList topRows = new ArrayList();
        if (this.gridControl != null && this.gridControl.getTopTable() != null) {
            topRows.addAll(this.gridControl.getTopTable().getVOListTableModel().getDataVector());
        }
        ArrayList bottomRows = new ArrayList();
        if (this.gridControl != null && this.gridControl.getBottomTable() != null) {
            bottomRows.addAll(this.gridControl.getBottomTable().getVOListTableModel().getDataVector());
        }
        Hashtable<String, String> attributeDescriptions = new Hashtable<String, String>();
        int i2 = 0;
        while (i2 < this.colProps.length) {
            attributeDescriptions.put(this.colProps[i2].getColumnName(), ClientSettings.getInstance().getResources().getResource(this.colProps[i2].getHeaderColumnName()));
            ++i2;
        }
        ArrayList<String> exportColumns = new ArrayList<String>();
        ArrayList<String> exportAttrColumns = new ArrayList<String>();
        int i3 = 0;
        while (i3 < this.model.getColumnCount()) {
            if (attributesToExport.contains(this.model.getColumnName(i3))) {
                exportColumns.add(this.getHeaderColumnName(this.model.getColumnName(i3)));
                exportAttrColumns.add(this.model.getColumnName(i3));
            }
            ++i3;
        }
        return new GridExportOptions(exportColumns, exportAttrColumns, this.quickFilterValues, this.currentSortedColumns, this.currentSortedVersusColumns, this.otherGridParams, ClientSettings.MAX_EXPORTABLE_ROWS, this.modelAdapter.getValueObjectType(), this.gridDataLocator, columnsWidth, columnsType, attributeDescriptions, topRows, bottomRows);
    }

    public final GridExportOptions getDefaultGridExportOptions() {
        HashSet<String> colsVisible = new HashSet<String>();
        int i = 0;
        while (i < this.colProps.length) {
            if (this.colProps[i].isVisible()) {
                colsVisible.add(this.colProps[i].getColumnName());
            }
            ++i;
        }
        return this.getDefaultGridExportOptions(colsVisible);
    }

    public final int getDefaultQuickFilterCriteria() {
        return this.gridControl == null ? ClientSettings.DEFAULT_QUICK_FILTER_CRITERIA : this.gridControl.getDefaultQuickFilterCriteria();
    }

    public DeleteButton getDeleteButton() {
        return this.deleteButton;
    }

    public EditButton getEditButton() {
        return this.editButton;
    }

    public ExportButton getExportButton() {
        return this.exportButton;
    }

    public FilterButton getFilterButton() {
        return this.filterButton;
    }

    public QuickFilterPanel getFilterPanel() {
        return this.filterPanel;
    }

    public final String getFunctionId() {
        return this.functionId;
    }

    public ArrayList getGenericButtons() {
        return this.genericButtons;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public GridControl getGridControl() {
        return this.gridControl;
    }

    public final GridController getGridController() {
        return this.gridController;
    }

    public final String getHeaderColumnName(String attributeName) {
        int i = 0;
        while (i < this.colProps.length) {
            if (this.colProps[i].getColumnName().equals(attributeName)) {
                return ClientSettings.getInstance().getResources().getResource(this.colProps[i].getHeaderColumnName());
            }
            ++i;
        }
        return attributeName;
    }

    public ImportButton getImportButton() {
        return this.importButton;
    }

    public InsertButton getInsertButton() {
        return this.insertButton;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public Grid getLockedGrid() {
        return this.lockedGrid;
    }

    public final int getMaxNumberOfRowsOnInsert() {
        return this.maxNumberOfRowsOnInsert;
    }

    public final int getMaxSortedColumns() {
        return this.maxSortedColumns;
    }

    public final int getMode() {
        return this.grid.getMode();
    }

    public final NavigatorBar getNavBar() {
        return this.navBar;
    }

    public final Map getOtherGridParams() {
        return this.otherGridParams;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public ArrayList getPopupCommands() {
        return this.popupCommands;
    }

    public Map getQuickFilterValues() {
        return this.quickFilterValues;
    }

    public ReloadButton getReloadButton() {
        return this.reloadButton;
    }

    public JMenuItem getRemovefilterItem() {
        return this.removefilterItem;
    }

    public SaveButton getSaveButton() {
        return this.saveButton;
    }

    public final JScrollPane getScroll() {
        return this.scroll;
    }

    public int getSelectedRow() {
        return this.grid.getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this.grid.getSelectedRows();
    }

    public final int getTotalResultSetLength() {
        return this.totalResultSetLength;
    }

    public final VOListTableModel getVOListTableModel() {
        return this.grid.getVOListTableModel();
    }

    public final int getstartIndex() {
        return this.startIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void importData(ArrayList columnTypes, ArrayList importAttrColumns, String importType) {
        block33: {
            ArrayList rows;
            block31: {
                FileInputStream in;
                block30: {
                    JFileChooser f = new JFileChooser();
                    f.setDialogTitle(ClientSettings.getInstance().getResources().getResource("file to import"));
                    f.setApproveButtonText(ClientSettings.getInstance().getResources().getResource("import"));
                    f.setApproveButtonMnemonic(ClientSettings.getInstance().getResources().getResource("importmnemonic").charAt(0));
                    if (importType.equals("XLS")) {
                        f.setFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                return f.isDirectory() || f.getName().toLowerCase().endsWith(".xls");
                            }

                            public String getDescription() {
                                return "Excel documents (*.xls)";
                            }
                        });
                    } else if (importType.equals("CSV (,)") || importType.equals("CSV (;)")) {
                        f.setFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                return f.isDirectory() || f.getName().toLowerCase().endsWith(".csv") || f.getName().toLowerCase().endsWith(".txt");
                            }

                            public String getDescription() {
                                return "Comma separated documents (*.csv;*.txt)";
                            }
                        });
                    }
                    int res = f.showOpenDialog(ClientUtils.getParentFrame(this));
                    if (res != 0) break block33;
                    File file = f.getSelectedFile();
                    in = null;
                    try {
                        in = new FileInputStream(file);
                    }
                    catch (Exception ex2) {
                        Logger.error(this.getClass().getName(), "import", "Error while importing data:\n" + ex2.getMessage(), ex2);
                        OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while importing data") + ":\n" + ex2.getMessage(), "Error", 0);
                        return;
                    }
                    rows = null;
                    if (importType.equals("XLS")) {
                        rows = new ImportFromExcel().importData(importAttrColumns.size(), in);
                        break block30;
                    }
                    if (!importType.equals("CSV (,)") && !importType.equals("CSV (;)")) break block30;
                    int[] colTypes = new int[columnTypes.size()];
                    int i = 0;
                    while (i < columnTypes.size()) {
                        colTypes[i] = (Integer)columnTypes.get(i);
                        ++i;
                    }
                    SimpleDateFormat sdfdate = new SimpleDateFormat(ClientSettings.getInstance().getResources().getDateMask(1));
                    SimpleDateFormat sdftime = new SimpleDateFormat(ClientSettings.getInstance().getResources().getDateMask(3));
                    SimpleDateFormat sdfdatetime = new SimpleDateFormat(ClientSettings.getInstance().getResources().getDateMask(2));
                    rows = new ImportFromCSV(importType, sdfdate, sdftime, sdfdatetime).importData(colTypes, importAttrColumns, in);
                }
                Object var15_18 = null;
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    break block31;
                }
                catch (Exception ex1) {
                }
                break block31;
                {
                    catch (Throwable ex) {
                        Logger.error(this.getClass().getName(), "import", "Error while importing data:\n" + ex.getMessage(), ex);
                        OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while importing data") + ":\n" + ex.getMessage(), "Error", 0);
                        Object var15_19 = null;
                        try {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                        }
                        catch (Exception ex1) {
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_20 = null;
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (Exception ex1) {
                    }
                    throw throwable;
                }
            }
            try {
                ValueObject vo = null;
                String attrName = null;
                Object[] row = null;
                ArrayList<ValueObject> vos = new ArrayList<ValueObject>();
                int[] rowNumbers = new int[rows.size()];
                while (rows.size() > 0) {
                    rowNumbers[rowNumbers.length - rows.size()] = rowNumbers.length - rows.size();
                    row = (Object[])rows.get(0);
                    rows.remove(0);
                    vo = (ValueObject)this.model.getValueObjectType().newInstance();
                    this.gridController.createValueObject(vo);
                    this.model.insertObjectAt(vo, 0);
                    int j = 0;
                    while (j < importAttrColumns.size()) {
                        attrName = importAttrColumns.get(j).toString();
                        this.model.setValueAt(row[j], 0, this.modelAdapter.getFieldIndex(attrName));
                        ++j;
                    }
                    vos.add(vo);
                }
                if (this.maxNumberOfRowsOnInsert == 1) {
                    Response result = null;
                    ArrayList singleVO = new ArrayList();
                    int[] singleIndex = new int[]{0};
                    int j = 0;
                    while (j < rowNumbers.length) {
                        singleIndex[0] = rowNumbers[j];
                        singleVO.clear();
                        singleVO.add(vos.get(j));
                        result = this.gridController.insertRecords(singleIndex, singleVO);
                        if (result.isError()) {
                            OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while importing data") + ":\n" + result.getErrorMessage(), "Error", 0);
                            int i = j;
                            while (i < rowNumbers.length) {
                                this.model.removeObjectAt(0);
                                ++i;
                            }
                            this.lastIndex += j;
                            return;
                        }
                        ++j;
                    }
                    this.lastIndex += rowNumbers.length;
                    OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("import completed"), "import", 1);
                } else {
                    Response result = this.gridController.insertRecords(rowNumbers, vos);
                    if (result.isError()) {
                        OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while importing data") + ":\n" + result.getErrorMessage(), "Error", 0);
                        int i = 0;
                        while (i < rowNumbers.length) {
                            this.model.removeObjectAt(0);
                            ++i;
                        }
                    } else {
                        this.lastIndex += rowNumbers.length;
                        OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("import completed"), "import", 1);
                    }
                }
            }
            catch (Throwable ex) {
                Logger.error(this.getClass().getName(), "import", "Error while importing data:\n" + ex.getMessage(), ex);
                OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while importing data") + ":\n" + ex.getMessage(), "Error", 0);
            }
        }
    }

    public final void importData() {
        if (this.getMode() == 0) {
            HashSet<String> colsVisible = new HashSet<String>();
            int i = 0;
            while (i < this.colProps.length) {
                if (this.colProps[i].isVisible()) {
                    colsVisible.add(this.colProps[i].getColumnName());
                }
                ++i;
            }
            ImportDialog d = new ImportDialog(ClientUtils.getParentFrame(this), this, colsVisible);
        } else {
            Logger.error(this.getClass().getName(), "export", "You cannot import data: grid must be in read only mode.", null);
        }
    }

    public final void insert() {
        if (this.getMode() == 0) {
            if (!this.gridController.beforeInsertGrid(this.gridControl)) {
                return;
            }
            this.currentNumberOfNewRows = 1;
            this.model.setMode(1);
            if (this.getInsertButton() != null) {
                this.getInsertButton().setEnabled(false);
            }
            if (this.getExportButton() != null) {
                this.getExportButton().setEnabled(false);
            }
            if (this.getImportButton() != null) {
                this.getImportButton().setEnabled(false);
            }
            if (this.getCopyButton() != null) {
                this.getCopyButton().setEnabled(false);
            }
            if (this.getDeleteButton() != null) {
                this.getDeleteButton().setEnabled(false);
            }
            if (this.getEditButton() != null) {
                this.getEditButton().setEnabled(false);
            }
            if (this.getFilterButton() != null) {
                this.getFilterButton().setEnabled(false);
            }
            this.setGenericButtonsEnabled(false);
            if (this.getReloadButton() != null) {
                this.getReloadButton().setEnabled(true);
            }
            if (this.getSaveButton() != null) {
                this.getSaveButton().setEnabled(true);
            }
            int rowToSel = 0;
            if (!this.isInsertRowsOnTop()) {
                rowToSel = this.model.getRowCount() - 1;
            }
            this.grid.setRowSelectionInterval(rowToSel, rowToSel);
            this.grid.setColumnSelectionInterval(0, 0);
            if (this.lockedGrid != null) {
                this.lockedGrid.setRowSelectionInterval(rowToSel, rowToSel);
                this.lockedGrid.setColumnSelectionInterval(0, 0);
            }
            this.resetButtonsState();
            int col = 0;
            if (this.lockedGrid != null) {
                while (col < this.lockedGrid.getColumnCount() && !this.lockedGrid.isCellEditable(rowToSel, col)) {
                    ++col;
                }
                if (col < this.lockedGrid.getColumnCount()) {
                    this.lockedGrid.setColumnSelectionInterval(col, col);
                }
                if (this.lockedGrid.getSelectedColumn() != -1) {
                    this.lockedGrid.editCellAt(rowToSel, this.lockedGrid.getSelectedColumn());
                }
                this.lockedGrid.requestFocus();
            }
            if (this.lockedGrid == null || col == this.lockedGrid.getColumnCount()) {
                col = 0;
                while (col < this.grid.getColumnCount() && !this.grid.isCellEditable(rowToSel, col)) {
                    ++col;
                }
                if (col < this.grid.getColumnCount()) {
                    this.grid.setColumnSelectionInterval(col, col);
                }
                this.grid.editCellAt(rowToSel, this.grid.getSelectedColumn());
                this.grid.requestFocus();
            }
        } else {
            Logger.error(this.getClass().getName(), "insert", "Setting grid to insert mode is not allowed: grid must be in read only mode.", null);
        }
    }

    public final boolean isAllowInsertInEdit() {
        return this.allowInsertInEdit;
    }

    public final boolean isAnchorLockedColumnsToLeft() {
        return this.anchorLockedColumnsToLeft;
    }

    public final boolean isButtonDisabled(GenericButton button) {
        ArrayList list = (ArrayList)this.buttonsToDisable.get(button);
        if (list != null) {
            GenericButtonController buttonController = null;
            int i = 0;
            while (i < list.size()) {
                buttonController = (GenericButtonController)list.get(i);
                if (buttonController.isButtonDisabled(button)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public final boolean isEditOnSingleRow() {
        return this.editOnSingleRow;
    }

    public final boolean isEnableInReadOnlyMode(int columnIndex) {
        if (this.colProps[columnIndex].getColumnType() == 11) {
            return ((ButtonColumn)this.colProps[columnIndex]).isEnableInReadOnlyMode();
        }
        if (this.colProps[columnIndex].getColumnType() == 19) {
            return true;
        }
        if (this.colProps[columnIndex].getColumnType() == 6) {
            return ((CheckBoxColumn)this.colProps[columnIndex]).isEnableInReadOnlyMode();
        }
        return false;
    }

    public final boolean isFieldEditable(int rowNumber, String attributeName) {
        return this.modelAdapter.isFieldEditable(this.getMode(), rowNumber, this.modelAdapter.getFieldIndex(attributeName));
    }

    public final boolean isInsertRowsOnTop() {
        return this.insertRowsOnTop;
    }

    public boolean isListenEvent() {
        return this.listenEvent;
    }

    public boolean isMoreRows() {
        return this.moreRows;
    }

    public final boolean isRowExpanded(int row) {
        return this.expandedRows.contains(new Integer(row));
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.scroll = new JScrollPane(this.grid);
        if (this.lockedColumns > 0) {
            this.lockedGrid.setAutoResizeMode(0);
            this.lockedGrid.setSelectionMode(0);
            JViewport viewport = new JViewport();
            viewport.setView(this.lockedGrid);
            viewport.setPreferredSize(this.lockedGrid.getPreferredSize());
            if (this.anchorLockedColumnsToLeft) {
                this.scroll.setRowHeaderView(viewport);
            }
            if (this.lockedGrid.getTableHeader() != null) {
                JPanel headerPanel = new JPanel();
                headerPanel.setLayout(new GridLayout(this.lockedGrid.hasColSpan() ? 2 : 1, 1));
                if (this.lockedGrid.hasColSpan() && (this.gridType == 0 && this.gridControl == null || this.gridType == 0 && this.gridControl != null && this.gridControl.getTopTable() == null || this.gridType == 1)) {
                    JPanel additionalColHeaders = new JPanel();
                    additionalColHeaders.setLayout(new FlowLayout(0, 0, 0));
                    int span = 0;
                    int w = 0;
                    int rest = 0;
                    JLabel h = null;
                    JPanel hp = null;
                    Color backcolor = new JButton().getBackground();
                    int i = 0;
                    while (i < this.colProps.length) {
                        if (this.colProps[i].getAdditionalHeaderColumnSpan() > 0) {
                            span = this.colProps[i].getAdditionalHeaderColumnSpan();
                            hp = new JPanel();
                            if (this.colProps[i].getHeaderTextHorizontalAlignment() == 0) {
                                hp.setLayout(new FlowLayout(1, 0, 0));
                            } else if (this.colProps[i].getHeaderTextHorizontalAlignment() == 2) {
                                hp.setLayout(new FlowLayout(0, 0, 0));
                            } else if (this.colProps[i].getHeaderTextHorizontalAlignment() == 4) {
                                hp.setLayout(new FlowLayout(2, 0, 0));
                            }
                            hp.setBorder(BorderFactory.createRaisedBevelBorder());
                            hp.setBackground(backcolor);
                            h = new JLabel();
                            if (this.colProps[i].getHeaderFont() != null) {
                                h.setFont(this.colProps[i].getHeaderFont());
                            }
                            if (this.colProps[i].getHeaderForegroundColor() != null) {
                                h.setForeground(this.colProps[i].getHeaderForegroundColor());
                            }
                            hp.add((Component)h, null);
                            h.setText(ClientSettings.getInstance().getResources().getResource(this.colProps[i].getAdditionalHeaderColumnName()));
                            rest = span - 1;
                            w = this.colProps[i].getPreferredWidth();
                            ArrayList<Integer> list = new ArrayList<Integer>();
                            list.add(new Integer(i));
                        } else {
                            w += this.colProps[i].getPreferredWidth();
                            --rest;
                        }
                        if (rest == 0 && h != null) {
                            hp.setPreferredSize(new Dimension(w, ClientSettings.HEADER_HEIGHT));
                            if (i < this.lockedColumns) {
                                additionalColHeaders.add((Component)hp, null);
                            }
                        }
                        ++i;
                    }
                    headerPanel.add(additionalColHeaders);
                }
                headerPanel.add(this.lockedGrid.getTableHeader());
                if (this.anchorLockedColumnsToLeft) {
                    this.scroll.setCorner("UPPER_LEFT_CORNER", headerPanel);
                } else {
                    final JScrollPane lockedscroll = new JScrollPane(this.lockedGrid);
                    lockedscroll.setBorder(BorderFactory.createEmptyBorder());
                    lockedscroll.setHorizontalScrollBarPolicy(31);
                    this.add((Component)lockedscroll, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 18, 3, new Insets(1, 0, this.scroll.getHorizontalScrollBar().getPreferredSize().height, 0), this.lockedGrid.getPreferredSize().width, 0));
                    SwingUtilities.invokeLater(new Runnable(){

                        static /* synthetic */ Grids access$300(7 x0) {
                            return x0.Grids.this;
                        }

                        static /* synthetic */ JScrollPane access$600(7 x0) {
                            return x0.lockedscroll;
                        }

                        public void run() {
                            lockedscroll.getVerticalScrollBar().hide();
                            Grids.this.scroll.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(this){
                                private final /* synthetic */ 7 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void adjustmentValueChanged(AdjustmentEvent e) {
                                    Grids.access$402(7.access$300(this.this$1), false);
                                    7.access$600(this.this$1).getVerticalScrollBar().setValue(Grids.access$500(7.access$300(this.this$1)).getVerticalScrollBar().getValue());
                                    Grids.access$402(7.access$300(this.this$1), true);
                                }
                            });
                            lockedscroll.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(this){
                                private final /* synthetic */ 7 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void adjustmentValueChanged(AdjustmentEvent e) {
                                    if (Grids.access$400(7.access$300(this.this$1))) {
                                        Grids.access$500(7.access$300(this.this$1)).getVerticalScrollBar().setValue(7.access$600(this.this$1).getVerticalScrollBar().getValue());
                                    }
                                }
                            });
                            Grids.this.scroll.setVerticalScrollBarPolicy(21);
                        }
                    });
                }
            }
            this.add((Component)this.scroll, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)this.scroll, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(this.anchorLockedColumnsToLeft ? 0 : 1, 0, 0, 0), 0, 0));
    }

    public final void lastRow(final NavigatorBar navBar) {
        if (!this.listenEvent) {
            return;
        }
        if (this.getMode() != 0) {
            return;
        }
        this.listenEvent = false;
        new Thread(){

            static /* synthetic */ Grids access$1900(14 x0) {
                return x0.Grids.this;
            }

            static /* synthetic */ NavigatorBar access$2000(14 x0) {
                return x0.navBar;
            }

            public void run() {
                boolean errorOnLoad = true;
                if (Grids.this.getNavBar() != null) {
                    Grids.this.getNavBar().setEnabled(false);
                }
                if (Grids.this.getReloadButton() != null) {
                    Grids.this.getReloadButton().setEnabled(false);
                }
                if (Grids.this.getInsertButton() != null) {
                    Grids.this.getInsertButton().setEnabled(false);
                }
                if (Grids.this.getExportButton() != null) {
                    Grids.this.getExportButton().setEnabled(false);
                }
                if (Grids.this.getImportButton() != null) {
                    Grids.this.getImportButton().setEnabled(false);
                }
                if (Grids.this.getCopyButton() != null) {
                    Grids.this.getCopyButton().setEnabled(false);
                }
                if (Grids.this.getDeleteButton() != null) {
                    Grids.this.getDeleteButton().setEnabled(false);
                }
                if (Grids.this.getEditButton() != null) {
                    Grids.this.getEditButton().setEnabled(false);
                }
                if (Grids.this.getFilterButton() != null) {
                    Grids.this.getFilterButton().setEnabled(false);
                }
                if (Grids.this.getSaveButton() != null) {
                    Grids.this.getSaveButton().setEnabled(false);
                }
                Grids.this.startIndex = -1;
                boolean bl = errorOnLoad = !Grids.this.loadData(2);
                if (Grids.this.getNavBar() != null) {
                    Grids.this.getNavBar().setLastRow(true);
                    if (Grids.this.model.getRowCount() == 1 && Grids.this.lastIndex + 1 == Grids.this.model.getRowCount()) {
                        Grids.this.getNavBar().setFirstRow(true);
                    } else {
                        Grids.this.getNavBar().setFirstRow(false);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Grids.access$100(14.access$1900(this.this$1)).revalidate();
                        Grids.access$100(14.access$1900(this.this$1)).repaint();
                        Grids.access$100(14.access$1900(this.this$1)).setRowSelectionInterval(Grids.access$1000(14.access$1900(this.this$1)).getRowCount() - 1, Grids.access$1000(14.access$1900(this.this$1)).getRowCount() - 1);
                        Grids.access$100(14.access$1900(this.this$1)).ensureRowIsVisible(Grids.access$100(14.access$1900(this.this$1)).getSelectedRow());
                        if (Grids.access$000(14.access$1900(this.this$1)) != null) {
                            Grids.access$000(14.access$1900(this.this$1)).revalidate();
                            Grids.access$000(14.access$1900(this.this$1)).repaint();
                            Grids.access$000(14.access$1900(this.this$1)).setRowSelectionInterval(Grids.access$1000(14.access$1900(this.this$1)).getRowCount() - 1, Grids.access$1000(14.access$1900(this.this$1)).getRowCount() - 1);
                            Grids.access$000(14.access$1900(this.this$1)).ensureRowIsVisible(Grids.access$000(14.access$1900(this.this$1)).getSelectedRow());
                        }
                        if (14.access$2000(this.this$1) != null) {
                            14.access$2000(this.this$1).fireButtonPressedEvent("LAST_BUTTON");
                        }
                    }
                });
                if (Grids.this.getReloadButton() != null) {
                    Grids.this.getReloadButton().setEnabled(true);
                }
                Grids.this.listenEvent = true;
                if (Grids.this.gridController != null) {
                    Grids.this.gridController.loadDataCompleted(errorOnLoad);
                }
                if (!errorOnLoad) {
                    int i = 0;
                    while (i < Grids.this.loadDataCompletedListeners.size()) {
                        ((ActionListener)Grids.this.loadDataCompletedListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, "Load Data Completed"));
                        ++i;
                    }
                }
                Grids.this.resetButtonsState();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean loadData(final int action) {
        boolean result;
        block14: {
            result = false;
            int selMode = this.grid.getSelectionModel().getSelectionMode();
            try {
                Response answer;
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ListSelectionModel listSelectionModel = Grids.this.grid.getSelectionModel();
                            Grids.this.grid.getSelectionModel();
                            listSelectionModel.setSelectionMode(0);
                            if (Grids.this.gridType == 0) {
                                Grids.this.statusPanel.setText(ClientSettings.getInstance().getResources().getResource("Loading data..."));
                                Grids.this.statusPanel.setPage("");
                            }
                            ClientUtils.fireBusyEvent(true);
                            try {
                                ClientUtils.getParentFrame(Grids.this).setCursor(new Cursor(3));
                                ClientUtils.getParentFrame(Grids.this).getToolkit().sync();
                            }
                            catch (Exception ex3) {
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    if (this.startIndex < 0) {
                        this.startIndex = 0;
                    }
                    answer = this.gridDataLocator.loadData(action, this.startIndex, this.quickFilterValues, this.currentSortedColumns, this.currentSortedVersusColumns, this.modelAdapter.getValueObjectType(), this.otherGridParams);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                try {
                                    ClientUtils.getParentFrame(Grids.this).setCursor(new Cursor(0));
                                    ClientUtils.getParentFrame(Grids.this).getToolkit().sync();
                                }
                                catch (Exception ex2) {
                                    // empty catch block
                                }
                                ClientUtils.fireBusyEvent(false);
                            }
                        });
                    }
                    catch (Exception ex) {
                    }
                    throw throwable;
                }
                try {
                    SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception ex) {
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            Grids.this.model.clear();
                            Grids.this.grid.revalidate();
                            Grids.this.grid.repaint();
                            if (Grids.this.lockedGrid != null) {
                                Grids.this.lockedGrid.revalidate();
                                Grids.this.lockedGrid.repaint();
                            }
                            if (answer == null || answer instanceof ErrorResponse) {
                                Grids.this.lastIndex = -1;
                                Grids.this.moreRows = false;
                                if (answer != null) {
                                    OptionPane.showMessageDialog(ClientUtils.getParentFrame(Grids.this), ClientSettings.getInstance().getResources().getResource("Error while loading data") + ":\n" + answer.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Loading Data Error"), 0);
                                }
                            } else {
                                List data = ((VOListResponse)answer).getRows();
                                Grids.this.moreRows = ((VOListResponse)answer).isMoreRows();
                                if (action == 1) {
                                    Grids.this.lastIndex = Grids.this.startIndex + data.size() - 1;
                                } else if (action == 0) {
                                    Grids.this.startIndex = Grids.this.startIndex - data.size();
                                    Grids.this.lastIndex = Grids.this.startIndex + data.size() - 1;
                                } else if (action == 2) {
                                    Grids.this.lastIndex = ((VOListResponse)answer).getResultSetLength() - 1;
                                    Grids.this.startIndex = Grids.this.lastIndex - data.size() + 1;
                                }
                                Grids.this.grid.clearSelection();
                                if (Grids.this.lockedGrid != null) {
                                    Grids.this.lockedGrid.clearSelection();
                                }
                                try {
                                    int i = 0;
                                    while (i < data.size()) {
                                        Grids.this.model.addObject((ValueObject)data.get(i));
                                        ++i;
                                    }
                                }
                                catch (ClassCastException ex1) {
                                    Logger.error(this.getClass().getName(), "loadData", "Error while fetching data: value object is not an instance of ValueObject class.", null);
                                    throw ex1;
                                }
                                Grids.this.expandedRows.clear();
                                Grids.this.cache.clear();
                                if (Grids.this.model.getRowCount() == 0) {
                                    Grids.this.statusPanel.setPage("");
                                    Grids.this.totalResultSetLength = -1;
                                    if (Grids.this.getNavBar() != null) {
                                        if (Grids.this.startIndex > 0 && Grids.this.blockSize > 0) {
                                            Grids.this.getNavBar().updatePageNumber(Grids.this.startIndex / Grids.this.blockSize + 1);
                                        } else {
                                            Grids.this.getNavBar().updatePageNumber(0);
                                        }
                                    }
                                } else if (!((VOListResponse)answer).isMoreRows() && Grids.this.startIndex == 0) {
                                    Grids.this.statusPanel.setPage("");
                                    if (Grids.this.getNavBar() != null) {
                                        Grids.this.getNavBar().updatePageNumber(0);
                                    }
                                    Grids.this.totalResultSetLength = Grids.this.model.getRowCount();
                                } else {
                                    if (Grids.this.blockSize == -1) {
                                        Grids.this.blockSize = Grids.this.model.getRowCount();
                                    }
                                    String page = ClientSettings.getInstance().getResources().getResource("page") + " " + (Grids.this.getLastIndex() / Grids.this.blockSize + 1);
                                    if (((VOListResponse)answer).getTotalAmountOfRows() > 0) {
                                        page = page + " " + ClientSettings.getInstance().getResources().getResource("of") + " " + ((((VOListResponse)answer).getTotalAmountOfRows() % Grids.this.blockSize == 0 ? 0 : 1) + ((VOListResponse)answer).getTotalAmountOfRows() / Grids.this.blockSize);
                                        Grids.this.totalResultSetLength = ((VOListResponse)answer).getTotalAmountOfRows();
                                    } else {
                                        Grids.this.totalResultSetLength = -1;
                                    }
                                    Grids.this.statusPanel.setPage(page);
                                    if (Grids.this.getNavBar() != null) {
                                        Grids.this.getNavBar().updatePageNumber(Grids.this.getLastIndex() / Grids.this.blockSize + 1);
                                    }
                                }
                                Grids.this.grid.revalidate();
                                Grids.this.grid.repaint();
                                Grids.this.revalidate();
                                Grids.this.repaint();
                            }
                            if (Grids.this.getInsertButton() != null) {
                                Grids.this.getInsertButton().setEnabled(true);
                            }
                            if (Grids.this.getExportButton() != null) {
                                Grids.this.getExportButton().setEnabled(Grids.this.model.getRowCount() > 0);
                            }
                            if (Grids.this.getImportButton() != null) {
                                Grids.this.getImportButton().setEnabled(true);
                            }
                            if (Grids.this.getCopyButton() != null) {
                                Grids.this.getCopyButton().setEnabled(Grids.this.model.getRowCount() > 0);
                            }
                            if (Grids.this.getEditButton() != null) {
                                Grids.this.getEditButton().setEnabled(Grids.this.model.getRowCount() > 0);
                            }
                            if (Grids.this.getFilterButton() != null) {
                                Grids.this.getFilterButton().setEnabled(Grids.this.model.getRowCount() > 0);
                            }
                            Grids.this.setGenericButtonsEnabled(Grids.this.model.getRowCount() > 0);
                            if (Grids.this.getDeleteButton() != null) {
                                Grids.this.getDeleteButton().setEnabled(Grids.this.model.getRowCount() > 0);
                            }
                            Grids.this.resetButtonsState();
                        }
                    });
                }
                catch (Exception ex) {
                    // empty catch block
                }
                result = true;
                Object var9_13 = null;
                this.grid.getSelectionModel().setSelectionMode(selMode);
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                this.grid.getSelectionModel().setSelectionMode(selMode);
                throw throwable;
            }
            {
                break block14;
                catch (Throwable ex) {
                    Logger.error(this.getClass().getName(), "loadData", "Error while fetching data.", ex);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            OptionPane.showMessageDialog(ClientUtils.getParentFrame(Grids.this), ClientSettings.getInstance().getResources().getResource("Error while loading data"), ClientSettings.getInstance().getResources().getResource("Loading Data Error"), 0);
                        }
                    });
                    Object var9_14 = null;
                    this.grid.getSelectionModel().setSelectionMode(selMode);
                }
            }
        }
        return result;
    }

    public final void loadPage(int pageNr) {
        if (this.blockSize != -1 && (this.moreRows || this.startIndex > 0)) {
            this.startIndex = this.blockSize * (pageNr - 1);
            if (!this.listenEvent) {
                return;
            }
            this.listenEvent = false;
            new LoadDataThread().start();
        }
    }

    public final boolean mergeCells(int[] rows, int[] columns) {
        return this.grid.mergeCells(rows, columns);
    }

    public final void modeChanged(int mode) {
        if (this.model.getRowCount() > 0) {
            if (mode == 0) {
                int row = this.grid.getEditingRow();
                int col = this.grid.getEditingColumn();
                if (row != -1 && col != -1) {
                    this.grid.getCellEditor(row, col).stopCellEditing();
                } else if (this.lockedGrid != null) {
                    col = this.lockedGrid.getEditingColumn();
                    if (row != -1 && col != -1) {
                        this.lockedGrid.getCellEditor(row, col).stopCellEditing();
                    }
                }
                if (this.lockedGrid != null) {
                    this.lockedGrid.requestFocus();
                } else {
                    this.grid.requestFocus();
                }
            } else if (mode == 1) {
                int rowToSel = 0;
                if (!this.isInsertRowsOnTop()) {
                    rowToSel = this.model.getRowCount() - 1;
                }
                try {
                    ValueObject vo = this.model.getObjectForRow(rowToSel);
                    this.gridController.createValueObject(vo);
                    int i = 0;
                    while (i < this.colProps.length) {
                        if (this.colProps[i] instanceof ComboColumn && !((ComboColumn)this.colProps[i]).isNullAsDefaultValue()) {
                            this.model.setValueAt(((ComboColumn)this.colProps[i]).getDomain().getDomainPairList()[0].getCode(), rowToSel, this.model.findColumn(((ComboColumn)this.colProps[i]).getColumnName()));
                        }
                        ++i;
                    }
                }
                catch (Throwable ex) {
                    Logger.error(this.getClass().getName(), "modeChanged", "Error while constructing value object '" + this.modelAdapter.getValueObjectType().getName() + "'", ex);
                }
                this.grid.setRowSelectionInterval(rowToSel, rowToSel);
                this.grid.setColumnSelectionInterval(0, 0);
                this.grid.ensureRowIsVisible(rowToSel);
                if (this.lockedGrid != null) {
                    this.lockedGrid.setRowSelectionInterval(rowToSel, rowToSel);
                    this.lockedGrid.setColumnSelectionInterval(0, 0);
                    this.lockedGrid.ensureRowIsVisible(rowToSel);
                    this.lockedGrid.editCellAt(rowToSel, 0);
                    this.lockedGrid.requestFocus();
                } else {
                    this.grid.editCellAt(rowToSel, 0);
                    this.grid.requestFocus();
                }
            } else if (mode == 2) {
                if (this.grid.getSelectedRow() == -1) {
                    if (this.lockedGrid == null) {
                        this.grid.editCellAt(0, 0);
                        this.grid.requestFocus();
                    } else {
                        this.lockedGrid.editCellAt(0, 0);
                        this.lockedGrid.requestFocus();
                    }
                } else {
                    if (this.lockedGrid == null) {
                        this.grid.editCellAt(this.grid.getSelectedRow(), this.grid.getSelectedColumn() == -1 ? 0 : this.grid.getSelectedColumn());
                        this.grid.requestFocus();
                    } else {
                        this.lockedGrid.editCellAt(this.lockedGrid.getSelectedRow(), this.lockedGrid.getSelectedColumn() == -1 ? 0 : this.lockedGrid.getSelectedColumn());
                        this.lockedGrid.requestFocus();
                    }
                    this.currentEditingRow = this.grid.getSelectedRow();
                }
            }
            if (this.navBar != null) {
                if (mode == 0) {
                    this.navBar.setEnabled(true);
                } else {
                    this.navBar.setEnabled(false);
                }
            }
        } else if (this.navBar != null) {
            this.navBar.setEnabled(false);
        }
        this.revalidate();
        this.repaint();
        if (mode == 0) {
            this.grid.setRowSelectionAllowed(true);
            if (this.lockedGrid != null) {
                this.lockedGrid.setRowSelectionAllowed(true);
            }
        } else {
            this.grid.setRowSelectionAllowed(false);
            if (this.lockedGrid != null) {
                this.lockedGrid.setRowSelectionAllowed(false);
            }
        }
        this.resetButtonsState();
        if (this.gridController != null) {
            this.gridController.modeChanged(mode);
        }
    }

    public final void nextPage(NavigatorBar navBar) {
        this.grid.nextPage(navBar);
    }

    public final void nextRow(final NavigatorBar navBar, final ActionEvent e) {
        if (this.getMode() != 0) {
            return;
        }
        if (!this.listenEvent) {
            return;
        }
        if (this.grid.getSelectedRow() != -1 && this.grid.getSelectedRow() == this.model.getRowCount() - 1) {
            if (this.moreRows) {
                this.listenEvent = false;
                new Thread(){

                    public void run() {
                        boolean errorOnLoad = true;
                        if (Grids.this.getNavBar() != null) {
                            Grids.this.getNavBar().setEnabled(false);
                        }
                        if (Grids.this.getReloadButton() != null) {
                            Grids.this.getReloadButton().setEnabled(false);
                        }
                        if (Grids.this.getInsertButton() != null) {
                            Grids.this.getInsertButton().setEnabled(false);
                        }
                        if (Grids.this.getExportButton() != null) {
                            Grids.this.getExportButton().setEnabled(false);
                        }
                        if (Grids.this.getImportButton() != null) {
                            Grids.this.getImportButton().setEnabled(false);
                        }
                        if (Grids.this.getCopyButton() != null) {
                            Grids.this.getCopyButton().setEnabled(false);
                        }
                        if (Grids.this.getDeleteButton() != null) {
                            Grids.this.getDeleteButton().setEnabled(false);
                        }
                        if (Grids.this.getEditButton() != null) {
                            Grids.this.getEditButton().setEnabled(false);
                        }
                        if (Grids.this.getFilterButton() != null) {
                            Grids.this.getFilterButton().setEnabled(false);
                        }
                        if (Grids.this.getSaveButton() != null) {
                            Grids.this.getSaveButton().setEnabled(false);
                        }
                        Grids.this.startIndex = Grids.this.lastIndex + 1;
                        boolean bl = errorOnLoad = !Grids.this.loadData(1);
                        if (Grids.this.model.getRowCount() > 0) {
                            Grids.this.grid.setRowSelectionInterval(0, 0);
                            if (Grids.this.lockedGrid != null) {
                                Grids.this.lockedGrid.setRowSelectionInterval(0, 0);
                            }
                        }
                        Grids.this.afterNextRow();
                        if (Grids.this.getReloadButton() != null) {
                            Grids.this.getReloadButton().setEnabled(true);
                        }
                        Grids.this.listenEvent = true;
                        if (Grids.this.gridController != null) {
                            Grids.this.gridController.loadDataCompleted(errorOnLoad);
                        }
                        if (!errorOnLoad) {
                            int i = 0;
                            while (i < Grids.this.loadDataCompletedListeners.size()) {
                                ((ActionListener)Grids.this.loadDataCompletedListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, "Load Data Completed"));
                                ++i;
                            }
                        }
                        Grids.this.resetButtonsState();
                        if (navBar != null && e != null) {
                            navBar.fireButtonPressedEvent(e.getActionCommand());
                        }
                    }
                }.start();
            }
        } else {
            this.grid.setRowSelectionInterval(this.grid.getSelectedRow() + 1, this.grid.getSelectedRow() + 1);
            if (this.lockedGrid != null) {
                this.lockedGrid.setRowSelectionInterval(this.lockedGrid.getSelectedRow(), this.lockedGrid.getSelectedRow());
            }
            this.afterNextRow();
            if (navBar != null && e != null) {
                navBar.fireButtonPressedEvent(e.getActionCommand());
            }
            this.listenEvent = true;
        }
    }

    public final void previousPage(NavigatorBar navBar) {
        this.grid.previousPage(navBar);
    }

    public final void previousRow(final NavigatorBar navBar, final ActionEvent e) {
        if (this.getMode() != 0) {
            return;
        }
        if (!this.listenEvent) {
            return;
        }
        if (this.grid.getSelectedRow() == 0 && this.lastIndex + 1 > this.model.getRowCount()) {
            this.listenEvent = false;
            new Thread(){

                static /* synthetic */ Grids access$1500(12 x0) {
                    return x0.Grids.this;
                }

                static /* synthetic */ NavigatorBar access$1600(12 x0) {
                    return x0.navBar;
                }

                static /* synthetic */ ActionEvent access$1700(12 x0) {
                    return x0.e;
                }

                public void run() {
                    boolean errorOnLoad = true;
                    if (Grids.this.getNavBar() != null) {
                        Grids.this.getNavBar().setEnabled(false);
                    }
                    if (Grids.this.getReloadButton() != null) {
                        Grids.this.getReloadButton().setEnabled(false);
                    }
                    if (Grids.this.getInsertButton() != null) {
                        Grids.this.getInsertButton().setEnabled(false);
                    }
                    if (Grids.this.getExportButton() != null) {
                        Grids.this.getExportButton().setEnabled(false);
                    }
                    if (Grids.this.getImportButton() != null) {
                        Grids.this.getImportButton().setEnabled(false);
                    }
                    if (Grids.this.getCopyButton() != null) {
                        Grids.this.getCopyButton().setEnabled(false);
                    }
                    if (Grids.this.getDeleteButton() != null) {
                        Grids.this.getDeleteButton().setEnabled(false);
                    }
                    if (Grids.this.getEditButton() != null) {
                        Grids.this.getEditButton().setEnabled(false);
                    }
                    if (Grids.this.getFilterButton() != null) {
                        Grids.this.getFilterButton().setEnabled(false);
                    }
                    if (Grids.this.getSaveButton() != null) {
                        Grids.this.getSaveButton().setEnabled(false);
                    }
                    errorOnLoad = !Grids.this.loadData(0);
                    Grids.this.grid.revalidate();
                    Grids.this.grid.repaint();
                    if (Grids.this.lockedGrid != null) {
                        Grids.this.lockedGrid.revalidate();
                        Grids.this.lockedGrid.repaint();
                    }
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            Grids.access$100(12.access$1500(this.this$1)).setRowSelectionInterval(Grids.access$1000(12.access$1500(this.this$1)).getRowCount() - 1, Grids.access$1000(12.access$1500(this.this$1)).getRowCount() - 1);
                            if (Grids.access$000(12.access$1500(this.this$1)) != null) {
                                Grids.access$000(12.access$1500(this.this$1)).setRowSelectionInterval(Grids.access$1000(12.access$1500(this.this$1)).getRowCount(), Grids.access$1000(12.access$1500(this.this$1)).getRowCount());
                            }
                            if (12.access$1600(this.this$1) != null && 12.access$1700(this.this$1) != null) {
                                12.access$1600(this.this$1).fireButtonPressedEvent(12.access$1700(this.this$1).getActionCommand());
                            }
                        }
                    });
                    Grids.this.afterPreviousRow();
                    if (Grids.this.getReloadButton() != null) {
                        Grids.this.getReloadButton().setEnabled(true);
                    }
                    Grids.this.listenEvent = true;
                    if (Grids.this.gridController != null) {
                        Grids.this.gridController.loadDataCompleted(errorOnLoad);
                    }
                    if (!errorOnLoad) {
                        int i = 0;
                        while (i < Grids.this.loadDataCompletedListeners.size()) {
                            ((ActionListener)Grids.this.loadDataCompletedListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, "Load Data Completed"));
                            ++i;
                        }
                    }
                    Grids.this.resetButtonsState();
                }
            }.start();
        } else {
            if (this.grid.getSelectedRow() > 0) {
                this.grid.setRowSelectionInterval(this.grid.getSelectedRow() - 1, this.grid.getSelectedRow() - 1);
                if (this.lockedGrid != null) {
                    this.lockedGrid.setRowSelectionInterval(this.lockedGrid.getSelectedRow(), this.lockedGrid.getSelectedRow());
                }
            }
            this.afterPreviousRow();
            if (navBar != null && e != null) {
                navBar.fireButtonPressedEvent(e.getActionCommand());
            }
            this.listenEvent = true;
        }
    }

    public final void putComponentInCache(int row, Component comp) {
        this.cache.put(new Integer(row), comp);
    }

    public final void reload() {
        if (ClientSettings.MDI_TOOLBAR != null && !ClientSettings.MDI_TOOLBAR.containsDataController(this)) {
            ClientSettings.MDI_TOOLBAR.setDataController(this);
        }
        if (this.getMode() != 0) {
            boolean ok = true;
            if (this.gridControl != null && this.gridControl.isShowWarnMessageBeforeReloading()) {
                boolean bl = ok = OptionPane.showConfirmDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Cancel changes and reload data?"), ClientSettings.getInstance().getResources().getResource("Attention"), 0) == 0;
            }
            if (ok) {
                this.executeReload();
            }
        } else if (this.getMode() == 0) {
            int i = 0;
            while (i < this.expandedRows.size()) {
                this.grid.collapseRow((Integer)this.expandedRows.get(i));
                ++i;
            }
            this.currentNestedComponent = null;
            this.currentNestedComponentRow = -1;
            if (this.grid.getTableHeader() != null) {
                this.grid.getTableHeader().repaint();
            }
            if (this.lockedGrid != null && this.lockedGrid.getTableHeader() != null) {
                this.lockedGrid.getTableHeader().repaint();
            }
            this.reloadData();
        }
    }

    private final void reloadData() {
        if (!this.listenEvent) {
            return;
        }
        this.listenEvent = false;
        new LoadDataThread().start();
    }

    public final void reloadDataFromStart() {
        if (this.model.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 0);
            this.startIndex = 0;
        } else {
            this.startIndex = -1;
        }
        this.reload();
    }

    public final void removeComponentInCache(int row) {
        this.cache.remove(new Integer(row));
    }

    public final void removeGenericButton(GenericButton button) {
        if (button != null) {
            this.genericButtons.remove(button);
        }
    }

    public final void removeLoadDataCompletedListener(ActionListener listener) {
        this.loadDataCompletedListeners.remove(listener);
    }

    public final void resetButtonsState() {
        if (this.insertButton != null && this.isButtonDisabled(this.insertButton)) {
            this.insertButton.setEnabled(false);
        }
        if (this.copyButton != null && this.isButtonDisabled(this.copyButton)) {
            this.copyButton.setEnabled(false);
        }
        if (this.editButton != null && this.isButtonDisabled(this.editButton)) {
            this.editButton.setEnabled(false);
        }
        if (this.reloadButton != null && this.isButtonDisabled(this.reloadButton)) {
            this.reloadButton.setEnabled(false);
        }
        if (this.saveButton != null && this.isButtonDisabled(this.saveButton)) {
            this.saveButton.setEnabled(false);
        }
        if (this.deleteButton != null && this.isButtonDisabled(this.deleteButton)) {
            this.deleteButton.setEnabled(false);
        }
        if (this.exportButton != null && this.isButtonDisabled(this.exportButton)) {
            this.exportButton.setEnabled(false);
        }
        if (this.importButton != null && this.isButtonDisabled(this.importButton)) {
            this.importButton.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int retrieveAdditionalRows(String attributeName, String textToSearch) {
        List data;
        block30: {
            data = null;
            try {
                Object value = this.gridController.beforeRetrieveAdditionalRows(attributeName, textToSearch);
                ClientUtils.fireBusyEvent(true);
                try {
                    ClientUtils.getParentFrame(this).setCursor(new Cursor(3));
                    ClientUtils.getParentFrame(this).getToolkit().sync();
                }
                catch (Exception ex3) {
                    // empty catch block
                }
                FilterWhereClause[] filter = new FilterWhereClause[]{new FilterWhereClause(attributeName, ClientSettings.LIKE, value), null};
                this.quickFilterValues.put(attributeName, filter);
                Response answer = null;
                try {
                    answer = this.gridDataLocator.loadData(1, 0, this.quickFilterValues, this.currentSortedColumns, this.currentSortedVersusColumns, this.modelAdapter.getValueObjectType(), this.otherGridParams);
                }
                finally {
                    try {
                        ClientUtils.getParentFrame(this).setCursor(new Cursor(0));
                        ClientUtils.getParentFrame(this).getToolkit().sync();
                    }
                    catch (Exception ex2) {}
                    ClientUtils.fireBusyEvent(false);
                    this.quickFilterValues.remove(attributeName);
                }
                if (answer == null || answer instanceof ErrorResponse) {
                    if (answer != null) {
                        Logger.error(this.getClass().getName(), "loadData", "Error while fetching data:\n" + answer.getErrorMessage(), null);
                    }
                    break block30;
                }
                data = ((VOListResponse)answer).getRows();
                this.lastIndex += data.size();
                this.startIndex = this.lastIndex + 1;
                try {
                    int i = 0;
                    while (i < data.size()) {
                        this.model.addObject((ValueObject)data.get(i));
                        ++i;
                    }
                }
                catch (ClassCastException ex1) {
                    Logger.error(this.getClass().getName(), "loadData", "Error while fetching data: value object is not an instance of ValueObject class.", null);
                    throw ex1;
                }
                if (this.model.getRowCount() == 0) {
                    this.statusPanel.setPage("");
                    this.totalResultSetLength = -1;
                    if (this.getNavBar() != null) {
                        if (this.startIndex > 0 && this.blockSize > 0) {
                            this.getNavBar().updatePageNumber(this.startIndex / this.blockSize + 1);
                        } else {
                            this.getNavBar().updatePageNumber(0);
                        }
                    }
                } else if (!((VOListResponse)answer).isMoreRows() && this.startIndex == 0) {
                    this.statusPanel.setPage("");
                    if (this.getNavBar() != null) {
                        this.getNavBar().updatePageNumber(0);
                    }
                    this.totalResultSetLength = this.model.getRowCount();
                } else {
                    if (this.blockSize == -1) {
                        this.blockSize = this.model.getRowCount();
                    }
                    String page = ClientSettings.getInstance().getResources().getResource("page") + " " + (this.getLastIndex() / this.blockSize + 1);
                    if (((VOListResponse)answer).getTotalAmountOfRows() > 0) {
                        page = page + " " + ClientSettings.getInstance().getResources().getResource("of") + " " + ((VOListResponse)answer).getTotalAmountOfRows() / this.blockSize;
                        this.totalResultSetLength = ((VOListResponse)answer).getTotalAmountOfRows();
                    } else {
                        this.totalResultSetLength = -1;
                    }
                    this.statusPanel.setPage(page);
                    if (this.getNavBar() != null) {
                        this.getNavBar().updatePageNumber(this.getLastIndex() / this.blockSize + 1);
                    }
                }
                this.grid.revalidate();
                this.grid.repaint();
                this.revalidate();
                this.repaint();
            }
            catch (Throwable ex) {
                Logger.error(this.getClass().getName(), "loadData", "Error while fetching data.", ex);
            }
        }
        if (data.size() > 0) {
            return this.getVOListTableModel().getRowCount() - data.size();
        }
        return -1;
    }

    public final boolean save() {
        Response response;
        block37: {
            if (this.grid.getCellEditor() != null) {
                this.grid.getCellEditor().stopCellEditing();
            }
            if (this.lockedGrid != null && this.lockedGrid.getCellEditor() != null) {
                this.lockedGrid.getCellEditor().stopCellEditing();
            }
            response = null;
            if (this.getMode() != 0) {
                try {
                    if (!this.validateRows()) {
                        return false;
                    }
                }
                catch (Exception ex) {
                    Logger.error(this.getClass().getName(), "save", "Error on grid validation.", ex);
                }
                int[] newRowsIndexes = new int[this.currentNumberOfNewRows];
                try {
                    int i;
                    int previousMode = this.getMode();
                    if (this.getMode() == 1) {
                        ArrayList<ValueObject> newRows = new ArrayList<ValueObject>();
                        i = 0;
                        while (i < this.currentNumberOfNewRows) {
                            if (this.isInsertRowsOnTop()) {
                                newRowsIndexes[i] = i;
                                newRows.add(this.model.getObjectForRow(newRowsIndexes[i]));
                            } else {
                                newRowsIndexes[i] = this.model.getRowCount() - this.currentNumberOfNewRows + i;
                                newRows.add(this.model.getObjectForRow(newRowsIndexes[i]));
                            }
                            ++i;
                        }
                        response = this.gridController.insertRecords(newRowsIndexes, newRows);
                    } else if (this.getMode() == 2) {
                        response = this.gridController.updateRecords(this.model.getChangedRowNumbers(), this.model.getOldVOsChanged(), this.model.getChangedRows());
                    }
                    if (!response.isError()) {
                        try {
                            int row = this.grid.getEditingRow();
                            int col = this.grid.getEditingColumn();
                            if (this.colProps[col].getColumnType() == 12 && row >= 0 && col >= 0) {
                                this.grid.setVisibleColumn(col, false);
                                this.grid.setVisibleColumn(col, true);
                            }
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                        if (this.getMode() == 1) {
                            int i2 = 0;
                            while (i2 < this.currentNumberOfNewRows) {
                                this.model.updateObjectAt((ValueObject)((VOListResponse)response).getRows().get(i2), newRowsIndexes[i2]);
                                ++i2;
                            }
                            this.lastIndex += this.currentNumberOfNewRows;
                        } else {
                            int i3 = 0;
                            while (i3 < this.currentNumberOfNewRows) {
                                this.model.updateObjectAt((ValueObject)((VOListResponse)response).getRows().get(i3), newRowsIndexes[i3]);
                                ++i3;
                            }
                            i = 0;
                            while (i < this.model.getChangedRowNumbers().length) {
                                this.model.updateObjectAt((ValueObject)((VOListResponse)response).getRows().get(i), this.model.getChangedRowNumbers()[i]);
                                ++i;
                            }
                        }
                        this.currentNumberOfNewRows = 0;
                        this.model.setMode(0);
                        if (this.getReloadButton() != null) {
                            this.getReloadButton().setEnabled(true);
                        }
                        if (this.getSaveButton() != null) {
                            this.getSaveButton().setEnabled(false);
                        }
                        if (this.getEditButton() != null) {
                            this.getEditButton().setEnabled(this.model.getRowCount() > 0);
                        }
                        if (this.getCopyButton() != null) {
                            this.getCopyButton().setEnabled(this.model.getRowCount() > 0);
                        }
                        this.setGenericButtonsEnabled(true);
                        if (this.getDeleteButton() != null) {
                            this.getDeleteButton().setEnabled(this.model.getRowCount() > 0);
                        }
                        if (this.getInsertButton() != null) {
                            this.getInsertButton().setEnabled(true);
                        }
                        if (this.getExportButton() != null) {
                            this.getExportButton().setEnabled(this.model.getRowCount() > 0);
                        }
                        if (this.getImportButton() != null) {
                            this.getImportButton().setEnabled(true);
                        }
                        if (this.getFilterButton() != null) {
                            this.getFilterButton().setEnabled(this.model.getRowCount() > 0);
                        }
                        this.resetButtonsState();
                        switch (previousMode) {
                            case 1: {
                                this.gridController.afterInsertGrid(this.gridControl);
                                break;
                            }
                            case 2: {
                                this.gridController.afterEditGrid(this.gridControl);
                            }
                        }
                        break block37;
                    }
                    OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while saving") + ":\n" + ClientSettings.getInstance().getResources().getResource(response.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Saving Error"), 0);
                }
                catch (Exception ex) {
                    Logger.error(this.getClass().getName(), "save", "Error while saving.", ex);
                    OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while saving") + ":\n" + ex.getMessage(), ClientSettings.getInstance().getResources().getResource("Saving Error"), 0);
                }
            } else {
                Logger.error(this.getClass().getName(), "save", "Saving data is not allowed in read only mode.", null);
            }
        }
        return !response.isError();
    }

    public final void setAllowInsertInEdit(boolean allowInsertInEdit) {
        this.allowInsertInEdit = allowInsertInEdit;
    }

    public final void setColorsInReadOnlyMode(boolean colorsInReadOnlyMode) {
        this.grid.setColorsInReadOnlyMode(colorsInReadOnlyMode);
    }

    public void setCopyButton(CopyButton copyButton) {
        if (this.copyButton != null) {
            this.copyButton.removeDataController(this);
        }
        this.copyButton = copyButton;
        if (copyButton != null) {
            copyButton.addDataController(this);
            this.bindedButtons.add(copyButton);
            copyButton.setEnabled(true);
        }
    }

    public final void setCurrentNestedComponent(int currentNestedComponentRow, Component currentNestedComponent) {
        this.currentNestedComponentRow = currentNestedComponentRow;
        this.currentNestedComponent = currentNestedComponent;
    }

    public void setCurrentNumberOfNewRows(int currentNumberOfNewRows) {
        this.currentNumberOfNewRows = currentNumberOfNewRows;
    }

    public final void setCurrentValue(GenericButton button, boolean currentValue) {
        this.currentValueButtons.put(button, new Boolean(currentValue));
    }

    public void setDeleteButton(DeleteButton deleteButton) {
        if (this.deleteButton != null) {
            this.deleteButton.removeDataController(this);
        }
        this.deleteButton = deleteButton;
        if (deleteButton != null) {
            deleteButton.addDataController(this);
            this.bindedButtons.add(deleteButton);
            deleteButton.setEnabled(true);
        }
    }

    public void setEditButton(EditButton editButton) {
        if (this.editButton != null) {
            this.editButton.removeDataController(this);
        }
        this.editButton = editButton;
        if (editButton != null) {
            editButton.addDataController(this);
            this.bindedButtons.add(editButton);
            editButton.setEnabled(true);
        }
    }

    public final void setEditOnSingleRow(boolean editOnSingleRow) {
        this.editOnSingleRow = editOnSingleRow;
    }

    public void setExportButton(ExportButton exportButton) {
        if (this.exportButton != null) {
            this.exportButton.removeDataController(this);
        }
        this.exportButton = exportButton;
        if (exportButton != null) {
            exportButton.addDataController(this);
            this.bindedButtons.add(exportButton);
            exportButton.setEnabled(true);
        }
    }

    public void setFilterButton(FilterButton filterButton) {
        if (this.filterButton != null) {
            this.filterButton.removeDataController(this);
        }
        this.filterButton = filterButton;
        if (filterButton != null) {
            filterButton.addDataController(this);
            this.bindedButtons.add(filterButton);
            filterButton.setEnabled(true);
        }
    }

    public void setFilterPanel(QuickFilterPanel filterPanel) {
        this.filterPanel = filterPanel;
    }

    public final void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public void setGenericButtonsEnabled(boolean enabled) {
        int i = 0;
        while (i < this.getGenericButtons().size()) {
            ((GenericButton)this.getGenericButtons().get(i)).setEnabled(enabled);
            ++i;
        }
    }

    public void setImportButton(ImportButton importButton) {
        if (this.importButton != null) {
            this.importButton.removeDataController(this);
        }
        this.importButton = importButton;
        if (importButton != null) {
            importButton.addDataController(this);
            this.bindedButtons.add(importButton);
            importButton.setEnabled(true);
        }
    }

    public void setInsertButton(InsertButton insertButton) {
        if (this.insertButton != null) {
            this.insertButton.removeDataController(this);
        }
        this.insertButton = insertButton;
        if (insertButton != null) {
            insertButton.addDataController(this);
            this.bindedButtons.add(insertButton);
            insertButton.setEnabled(true);
        }
    }

    public final void setInsertRowsOnTop(boolean insertRowsOnTop) {
        this.insertRowsOnTop = insertRowsOnTop;
    }

    public void setIntercellSpacing(Dimension spacing) {
        this.grid.setIntercellSpacing(spacing);
        if (this.lockedGrid != null) {
            this.lockedGrid.setIntercellSpacing(spacing);
        }
    }

    public void setListenEvent(boolean listenEvent) {
        this.listenEvent = listenEvent;
    }

    public final void setMaxNumberOfRowsOnInsert(int maxNumberOfRowsOnInsert) {
        this.maxNumberOfRowsOnInsert = maxNumberOfRowsOnInsert;
    }

    public final void setMaxSortedColumns(int maxSortedColumns) {
        this.maxSortedColumns = maxSortedColumns;
    }

    public final void setMode(int mode) {
        this.model.setMode(mode);
    }

    public final void setNavBar(NavigatorBar navBar) {
        if (navBar != null) {
            this.navBar = navBar;
            navBar.initNavigator(this);
            this.bindedButtons.add(navBar);
        }
    }

    public final void setOtherGridParams(Map otherGridParams) {
        this.otherGridParams = otherGridParams;
    }

    public void setReloadButton(ReloadButton reloadButton) {
        if (this.reloadButton != null) {
            this.reloadButton.removeDataController(this);
        }
        this.reloadButton = reloadButton;
        if (reloadButton != null) {
            reloadButton.addDataController(this);
            this.bindedButtons.add(reloadButton);
            reloadButton.setEnabled(true);
        }
    }

    public final void setReorderingAllowed(boolean reorderingAllowed) {
        this.grid.setReorderingAllowed(reorderingAllowed);
    }

    public final void setResizingAllowed(boolean resizingAllowed) {
        this.grid.setResizingAllowed(resizingAllowed);
    }

    public void setRowMargin(int rowMargin) {
        this.grid.setRowMargin(rowMargin);
        if (this.lockedGrid != null) {
            this.lockedGrid.setRowMargin(rowMargin);
        }
    }

    public void setRowSelectionInterval(int startRow, int endRow) {
        if (startRow == -1 || endRow == -1) {
            return;
        }
        if (this.onLoop) {
            return;
        }
        this.onLoop = true;
        this.grid.setRowSelectionInterval(startRow, endRow);
        this.grid.ensureRowIsVisible(startRow);
        if (this.lockedGrid != null) {
            this.lockedGrid.setRowSelectionInterval(startRow, endRow);
            this.lockedGrid.ensureRowIsVisible(startRow);
        }
        this.onLoop = false;
    }

    public void setSaveButton(SaveButton saveButton) {
        if (this.saveButton != null) {
            this.saveButton.removeDataController(this);
        }
        this.saveButton = saveButton;
        if (saveButton != null) {
            saveButton.addDataController(this);
            this.bindedButtons.add(saveButton);
            saveButton.setEnabled(true);
        }
    }

    public final void setSelectionMode(int selectionMode) {
        if (this.lockedColumns > 0) {
            return;
        }
        this.grid.setSelectionMode(selectionMode);
        if (this.lockedGrid != null) {
            this.lockedGrid.setSelectionMode(selectionMode);
        }
    }

    public final void setVisibleColumn(String attributeName, boolean colVisible) {
        int columnModelIndex = this.modelAdapter.getFieldIndex(attributeName);
        this.grid.setVisibleColumn(columnModelIndex, colVisible);
    }

    private void setupScrollBars() {
        if (this.gridControl != null && this.gridControl.getLockedRowsOnTop() > 0 && this.gridControl.getLockedRowsOnBottom() == 0 && this.gridType == 1) {
            this.scroll.setHorizontalScrollBarPolicy(31);
        } else if (this.gridControl != null && this.gridControl.getLockedRowsOnTop() == 0 && this.gridControl.getLockedRowsOnBottom() > 0 && this.gridType == 0) {
            this.scroll.setHorizontalScrollBarPolicy(31);
        } else if (this.gridControl != null && this.gridControl.getLockedRowsOnTop() > 0 && this.gridControl.getLockedRowsOnBottom() > 0 && this.gridType != 2) {
            this.scroll.setHorizontalScrollBarPolicy(31);
        }
        if (this.gridControl != null && this.gridControl.getLockedRowsOnTop() > 0 && this.gridType == 1) {
            this.scroll.setVerticalScrollBarPolicy(22);
            this.scroll.setVerticalScrollBar(new JScrollBar(){

                public void paint(Graphics g) {
                }
            });
        }
        if (this.gridControl != null && this.gridControl.getLockedRowsOnBottom() > 0 && this.gridType == 2) {
            this.scroll.setVerticalScrollBarPolicy(22);
            this.scroll.setVerticalScrollBar(new JScrollBar(){

                public void paint(Graphics g) {
                }
            });
        }
        this.scroll.setBorder(BorderFactory.createEmptyBorder());
        if (this.gridControl != null && (this.gridControl.getLockedRowsOnTop() > 0 || this.gridControl.getLockedRowsOnBottom() > 0) && this.gridType != 0) {
            this.scroll.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (Grids.this.gridControl.getTable().getScroll().getHorizontalScrollBar().getValue() != e.getValue()) {
                        Grids.this.gridControl.getTable().getScroll().getHorizontalScrollBar().setValue(e.getValue());
                    }
                }
            });
        }
        if (this.gridControl != null && (this.gridControl.getLockedRowsOnTop() > 0 || this.gridControl.getLockedRowsOnBottom() > 0) && this.gridType == 0) {
            this.scroll.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (Grids.this.getGridControl() != null && Grids.this.getGridControl().getTopTable() != null && Grids.this.getGridControl().getTopTable().getScroll().getHorizontalScrollBar().getValue() != e.getValue()) {
                        Grids.this.getGridControl().getTopTable().getScroll().getHorizontalScrollBar().setValue(e.getValue());
                    }
                    if (Grids.this.getGridControl() != null && Grids.this.getGridControl().getBottomTable() != null && Grids.this.getGridControl().getBottomTable().getScroll().getHorizontalScrollBar().getValue() != e.getValue()) {
                        Grids.this.getGridControl().getBottomTable().getScroll().getHorizontalScrollBar().setValue(e.getValue());
                    }
                }
            });
        }
    }

    public final void transferFocus() {
        try {
            if (this.grid.getCellEditor() != null) {
                this.grid.getCellEditor().stopCellEditing();
            }
            if (this.lockedGrid != null && this.lockedGrid.getCellEditor() != null) {
                this.lockedGrid.getCellEditor().stopCellEditing();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        super.transferFocus();
    }

    public final void updateColumnHeaderIcons() {
        this.grid.updateColumnHeaderIcons();
        if (this.lockedGrid != null) {
            this.lockedGrid.updateColumnHeaderIcons();
        }
    }

    public final boolean validateRows() {
        try {
            if (this.getMode() != 0) {
                int i;
                if (!this.grid.stopCellEditing()) {
                    return false;
                }
                if (this.lockedGrid != null && !this.lockedGrid.stopCellEditing()) {
                    return false;
                }
                int[] rows = new int[]{};
                if (this.getMode() == 1) {
                    rows = new int[this.currentNumberOfNewRows];
                    i = 0;
                    while (i < this.currentNumberOfNewRows) {
                        rows[i] = this.isInsertRowsOnTop() ? i : this.model.getRowCount() - this.currentNumberOfNewRows + i;
                        ++i;
                    }
                } else if (this.getMode() == 2) {
                    rows = this.model.getChangedRowNumbers();
                }
                i = 0;
                while (i < rows.length) {
                    int j = 0;
                    while (j < this.colProps.length) {
                        Column cfr_ignored_0 = this.colProps[j];
                        if (this.colProps[j].getColumnType() == 8 && ((CodLookupColumn)this.colProps[j]).getLookupController() != null && !((CodLookupColumn)this.colProps[j]).getLookupController().isCodeValid()) {
                            return false;
                        }
                        if (this.colProps[j].isColumnRequired() && (this.model.getValueAt(rows[i], j) == null || this.model.getValueAt(rows[i], j).toString().equals(""))) {
                            OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("A mandatory column is empty.") + ": " + ClientSettings.getInstance().getResources().getResource(this.colProps[j].getHeaderColumnName()), ClientSettings.getInstance().getResources().getResource("Value not valid"), 0);
                            if (this.anchorLockedColumnsToLeft && j < this.lockedColumns) {
                                this.lockedGrid.editCellAt(rows[i], j);
                                this.lockedGrid.requestFocus();
                            } else if (!this.anchorLockedColumnsToLeft && this.lockedColumns > 0 && j >= this.colProps.length - this.lockedColumns) {
                                this.lockedGrid.editCellAt(rows[i], j - this.colProps.length - this.lockedColumns);
                                this.lockedGrid.requestFocus();
                            } else {
                                this.grid.editCellAt(i, j - this.lockedColumns);
                                this.grid.requestFocus();
                            }
                            return false;
                        }
                        ++j;
                    }
                    ++i;
                }
                return true;
            }
            return true;
        }
        catch (Throwable ex) {
            Logger.error(this.getClass().getName(), "validate", "Error on validating columns.", ex);
            return false;
        }
    }

    class LoadDataThread
    extends Thread {
        private boolean errorOnLoad = true;

        LoadDataThread() {
        }

        static /* synthetic */ Grids access$2700(LoadDataThread x0) {
            return x0.Grids.this;
        }

        static /* synthetic */ boolean access$3900(LoadDataThread x0) {
            return x0.errorOnLoad;
        }

        public void run() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(this){
                    private final /* synthetic */ LoadDataThread this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (Grids.access$2800(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$2800(LoadDataThread.access$2700(this.this$1)).setEnabled(false);
                        }
                        if (Grids.access$2900(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$2900(LoadDataThread.access$2700(this.this$1)).setEnabled(false);
                        }
                        if (Grids.access$3000(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$3000(LoadDataThread.access$2700(this.this$1)).setEnabled(false);
                        }
                        if (Grids.access$3100(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$3100(LoadDataThread.access$2700(this.this$1)).setEnabled(false);
                        }
                        if (Grids.access$3200(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$3200(LoadDataThread.access$2700(this.this$1)).setEnabled(false);
                        }
                        if (Grids.access$3300(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$3300(LoadDataThread.access$2700(this.this$1)).setEnabled(false);
                        }
                        if (Grids.access$3400(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$3400(LoadDataThread.access$2700(this.this$1)).setEnabled(false);
                        }
                        LoadDataThread.access$2700(this.this$1).setGenericButtonsEnabled(false);
                        if (Grids.access$3500(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$3500(LoadDataThread.access$2700(this.this$1)).setEnabled(false);
                        }
                        if (Grids.access$3600(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$3600(LoadDataThread.access$2700(this.this$1)).setEnabled(false);
                        }
                    }
                });
            }
            catch (Exception ex) {
                // empty catch block
            }
            Grids.this.currentNumberOfNewRows = 0;
            Grids.this.repaint();
            Grids.this.selectedRowBeforeReloading = Grids.this.getSelectedRow();
            boolean bl = this.errorOnLoad = !Grids.this.loadData(1);
            if (Grids.this.model.getRowCount() > 0) {
                if (Grids.this.selectedRowBeforeReloading == -1) {
                    Grids.this.selectedRowBeforeReloading = 0;
                } else if (Grids.this.selectedRowBeforeReloading > Grids.this.model.getRowCount() - 1) {
                    Grids.this.selectedRowBeforeReloading = Grids.this.model.getRowCount() - 1;
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ LoadDataThread this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (Grids.access$3800(LoadDataThread.access$2700(this.this$1)) == -1) {
                            return;
                        }
                        Grids.access$100(LoadDataThread.access$2700(this.this$1)).setRowSelectionInterval(Grids.access$3800(LoadDataThread.access$2700(this.this$1)), Grids.access$3800(LoadDataThread.access$2700(this.this$1)));
                        if (Grids.access$000(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$000(LoadDataThread.access$2700(this.this$1)).setRowSelectionInterval(Grids.access$3800(LoadDataThread.access$2700(this.this$1)), Grids.access$3800(LoadDataThread.access$2700(this.this$1)));
                        }
                        Grids.access$100(LoadDataThread.access$2700(this.this$1)).ensureRowIsVisible(Grids.access$3800(LoadDataThread.access$2700(this.this$1)));
                        if (Grids.access$000(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$000(LoadDataThread.access$2700(this.this$1)).ensureRowIsVisible(Grids.access$3800(LoadDataThread.access$2700(this.this$1)));
                        }
                        if (Grids.access$1200(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$1200(LoadDataThread.access$2700(this.this$1)).loadDataCompleted(LoadDataThread.access$3900(this.this$1));
                        }
                        if (!LoadDataThread.access$3900(this.this$1)) {
                            int i = 0;
                            while (i < Grids.access$1300(LoadDataThread.access$2700(this.this$1)).size()) {
                                ((ActionListener)Grids.access$1300(LoadDataThread.access$2700(this.this$1)).get(i)).actionPerformed(new ActionEvent(this, 1001, "Load Data Completed"));
                                ++i;
                            }
                        }
                    }
                });
            } else {
                Grids.this.statusPanel.setText("");
                Grids.this.selectedRowBeforeReloading = 0;
                if (Grids.this.gridController != null) {
                    Grids.this.gridController.loadDataCompleted(this.errorOnLoad);
                }
                if (!this.errorOnLoad) {
                    int i = 0;
                    while (i < Grids.this.loadDataCompletedListeners.size()) {
                        ((ActionListener)Grids.this.loadDataCompletedListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, "Load Data Completed"));
                        ++i;
                    }
                }
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(this){
                    private final /* synthetic */ LoadDataThread this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (Grids.access$2800(LoadDataThread.access$2700(this.this$1)) != null) {
                            if (Grids.access$100(LoadDataThread.access$2700(this.this$1)).getSelectedRow() != -1 && !Grids.access$1100(LoadDataThread.access$2700(this.this$1)) && Grids.access$100(LoadDataThread.access$2700(this.this$1)).getSelectedRow() == Grids.access$1000(LoadDataThread.access$2700(this.this$1)).getRowCount() - 1 || Grids.access$1000(LoadDataThread.access$2700(this.this$1)).getRowCount() == 0) {
                                Grids.access$2800(LoadDataThread.access$2700(this.this$1)).setLastRow(true);
                            } else {
                                Grids.access$2800(LoadDataThread.access$2700(this.this$1)).setLastRow(false);
                            }
                            if (Grids.access$100(LoadDataThread.access$2700(this.this$1)).getSelectedRow() > 0 || Grids.access$900(LoadDataThread.access$2700(this.this$1)) > Grids.access$1000(LoadDataThread.access$2700(this.this$1)).getRowCount() - 1) {
                                Grids.access$2800(LoadDataThread.access$2700(this.this$1)).setFirstRow(false);
                            } else {
                                Grids.access$2800(LoadDataThread.access$2700(this.this$1)).setFirstRow(true);
                            }
                        }
                        if (Grids.access$2900(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$2900(LoadDataThread.access$2700(this.this$1)).setEnabled(true);
                        }
                        if (Grids.access$3600(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$3600(LoadDataThread.access$2700(this.this$1)).setEnabled(false);
                        }
                        Grids.access$100(LoadDataThread.access$2700(this.this$1)).revalidate();
                        Grids.access$100(LoadDataThread.access$2700(this.this$1)).repaint();
                        if (Grids.access$100(LoadDataThread.access$2700(this.this$1)).getTableHeader() != null) {
                            Grids.access$100(LoadDataThread.access$2700(this.this$1)).getTableHeader().revalidate();
                            Grids.access$100(LoadDataThread.access$2700(this.this$1)).getTableHeader().repaint();
                        }
                        if (Grids.access$000(LoadDataThread.access$2700(this.this$1)) != null) {
                            Grids.access$000(LoadDataThread.access$2700(this.this$1)).revalidate();
                            Grids.access$000(LoadDataThread.access$2700(this.this$1)).repaint();
                            if (Grids.access$000(LoadDataThread.access$2700(this.this$1)).getTableHeader() != null) {
                                Grids.access$000(LoadDataThread.access$2700(this.this$1)).getTableHeader().revalidate();
                                Grids.access$000(LoadDataThread.access$2700(this.this$1)).getTableHeader().repaint();
                            }
                        }
                    }
                });
            }
            catch (Exception ex) {
                // empty catch block
            }
            Grids.this.listenEvent = true;
            if (Grids.this.gridType == 0) {
                if (Grids.this.getGridControl() != null && Grids.this.getGridControl().getTopTable() != null) {
                    if (Grids.this.getGridControl().getTopGridDataLocator() == null) {
                        Logger.error(this.getClass().getName(), "reloadData", "'topGridDataLocator' property was not defined for grid control", null);
                        Grids.this.getGridControl().setTopGridDataLocator(new GridDataLocator(this){
                            private final /* synthetic */ LoadDataThread this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public Response loadData(int action, int startIndex, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, Map otherGridParams) {
                                ArrayList<?> rows = new ArrayList<?>();
                                int i = 0;
                                while (i < LoadDataThread.access$2700(this.this$1).getGridControl().getLockedRowsOnTop()) {
                                    try {
                                        rows.add(Class.forName(LoadDataThread.access$2700(this.this$1).getGridControl().getValueObjectClassName()).newInstance());
                                    }
                                    catch (Throwable t) {
                                        Logger.error(this.getClass().getName(), "reloadData", "Error while attempting to fill in the top grid", t);
                                    }
                                    ++i;
                                }
                                return new VOListResponse(rows, false, rows.size());
                            }
                        });
                    }
                    Grids.this.getGridControl().getTopTable().reload();
                    Grids.this.getGridControl().getTopTable().revalidate();
                    Grids.this.getGridControl().getTopTable().repaint();
                }
                if (Grids.this.getGridControl() != null && Grids.this.getGridControl().getBottomTable() != null) {
                    if (Grids.this.getGridControl().getBottomGridDataLocator() == null) {
                        Logger.error(this.getClass().getName(), "reloadData", "'bottomGridDataLocator' property was not defined for grid control", null);
                        Grids.this.getGridControl().setBottomGridDataLocator(new GridDataLocator(this){
                            private final /* synthetic */ LoadDataThread this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public Response loadData(int action, int startIndex, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, Map otherGridParams) {
                                ArrayList<?> rows = new ArrayList<?>();
                                int i = 0;
                                while (i < LoadDataThread.access$2700(this.this$1).getGridControl().getLockedRowsOnBottom()) {
                                    try {
                                        rows.add(Class.forName(LoadDataThread.access$2700(this.this$1).getGridControl().getValueObjectClassName()).newInstance());
                                    }
                                    catch (Throwable t) {
                                        Logger.error(this.getClass().getName(), "reloadData", "Error while attempting to fill in the bottom grid", t);
                                    }
                                    ++i;
                                }
                                return new VOListResponse(rows, false, rows.size());
                            }
                        });
                    }
                    Grids.this.getGridControl().getBottomTable().reload();
                    Grids.this.getGridControl().getBottomTable().revalidate();
                    Grids.this.getGridControl().getBottomTable().repaint();
                }
            }
            Grids.this.resetButtonsState();
        }
    }

    class GridPopup
    extends JPopupMenu {
        GridPopup() {
        }

        public final void setVisible(boolean v) {
            super.setVisible(v);
            if (!v && Grids.this.grid != null && !Grids.this.grid.hasFocus()) {
                Grids.this.grid.requestFocus();
            }
        }
    }
}

