/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollBarUI;
import javax.swing.plaf.metal.MetalScrollButton;
import org.openswing.swing.table.client.PaginationVerticalScrollbarUI;

public class MetalPaginationVerticalScrollbarUI
extends MetalScrollBarUI
implements PaginationVerticalScrollbarUI {
    protected JButton nextPgButton;
    protected JButton prevPgButton;

    protected JButton createPageButton(int orientation) {
        return new PageArrowButton(orientation);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MetalPaginationVerticalScrollbarUI();
    }

    public JButton getDecrButton() {
        return this.decrButton;
    }

    public JButton getIncrButton() {
        return this.incrButton;
    }

    public JButton getNextPgButton() {
        return this.nextPgButton;
    }

    public JButton getPrevPgButton() {
        return this.prevPgButton;
    }

    protected void installDefaults() {
        super.installDefaults();
        this.nextPgButton = this.createPageButton(5);
        this.prevPgButton = this.createPageButton(1);
        this.scrollbar.add(this.prevPgButton);
        this.scrollbar.add(this.nextPgButton);
    }

    protected void installListeners() {
        super.installListeners();
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int prevPgButtonH = this.prevPgButton.getPreferredSize().height;
        int prevPgButtonY = sbInsets.top;
        int decrButtonH = this.decrButton.getPreferredSize().height;
        int decrButtonY = prevPgButtonY + prevPgButtonH;
        int incrButtonH = this.incrButton.getPreferredSize().height;
        int nextPgButtonH = this.nextPgButton.getPreferredSize().height;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH + nextPgButtonH);
        int nextPgButtonY = sbSize.height - (sbInsets.bottom + nextPgButtonH);
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH + prevPgButtonH + nextPgButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = incrButtonY - thumbH;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += decrButtonY + decrButtonH;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = decrButtonH = sbAvailButtonH / 2;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.prevPgButton.setBounds(itemX, prevPgButtonY, itemW, prevPgButtonH);
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        this.nextPgButton.setBounds(itemX, nextPgButtonY, itemW, nextPgButtonH);
        int itrackY = decrButtonY + decrButtonH;
        int itrackH = incrButtonY - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > incrButtonY) {
                thumbY = incrButtonY - thumbH;
            }
            if (thumbY < decrButtonY + decrButtonH) {
                thumbY = decrButtonY + decrButtonH + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    class PageArrowButton
    extends MetalScrollButton {
        private Color arrowColor;
        private Color highlightColor;
        private Color shadowColor;

        public PageArrowButton(int direction) {
            super(direction, MetalPaginationVerticalScrollbarUI.this.incrButton == null ? MetalPaginationVerticalScrollbarUI.this.scrollBarWidth : ((MetalPaginationVerticalScrollbarUI)MetalPaginationVerticalScrollbarUI.this).incrButton.getPreferredSize().width, true);
            this.highlightColor = UIManager.getColor("ScrollBar.highlight");
            this.shadowColor = UIManager.getColor("ScrollBar.darkShadow");
            this.arrowColor = MetalLookAndFeel.getControlInfo();
        }

        public void paint(Graphics g) {
            boolean isPressed = this.getModel().isPressed();
            int width = this.getWidth();
            int height = this.getHeight();
            int w = width;
            int h = height;
            int arrowHeight = (height + 1) / 4;
            int arrowWidth = (height + 1) / 2;
            if (isPressed) {
                g.setColor(MetalLookAndFeel.getControlShadow());
            } else {
                g.setColor(this.getBackground());
            }
            g.fillRect(0, 0, width, height);
            if (this.getDirection() == 1) {
                if (!MetalPaginationVerticalScrollbarUI.this.isFreeStanding) {
                    ++height;
                    g.translate(0, -1);
                    width += 2;
                }
                g.setColor(this.arrowColor);
                int startY = h + 1 - arrowHeight - 3;
                int startX = w / 2;
                int line = 0;
                while (line < arrowHeight) {
                    g.drawLine(startX - line, startY + line, startX + line + 1, startY + line);
                    ++line;
                }
                startY = arrowHeight;
                int line2 = 0;
                while (line2 < arrowHeight) {
                    g.drawLine(startX - line2, startY + line2, startX + line2 + 1, startY + line2);
                    ++line2;
                }
                g.setColor(this.highlightColor);
                if (!isPressed) {
                    g.drawLine(1, 1, width - 3, 1);
                    g.drawLine(1, 1, 1, height - 1);
                }
                g.drawLine(width - 1, 1, width - 1, height - 1);
                g.setColor(this.shadowColor);
                g.drawLine(0, 0, width - 2, 0);
                g.drawLine(0, 0, 0, height - 1);
                g.drawLine(width - 2, 2, width - 2, height - 1);
                if (!MetalPaginationVerticalScrollbarUI.this.isFreeStanding) {
                    --height;
                    g.translate(0, 1);
                    width -= 2;
                }
            } else if (this.getDirection() == 5) {
                if (!MetalPaginationVerticalScrollbarUI.this.isFreeStanding) {
                    ++height;
                    width += 2;
                }
                g.setColor(this.arrowColor);
                int startY = h + 1 - arrowHeight - 2;
                int startX = w / 2;
                int line = 0;
                while (line < arrowHeight) {
                    g.drawLine(startX - line, startY - line, startX + line + 1, startY - line);
                    ++line;
                }
                startY = arrowHeight + 2;
                int line3 = 0;
                while (line3 < arrowHeight) {
                    g.drawLine(startX - line3, startY - line3, startX + line3 + 1, startY - line3);
                    ++line3;
                }
                g.setColor(this.highlightColor);
                if (!isPressed) {
                    g.drawLine(1, 0, width - 3, 0);
                    g.drawLine(1, 0, 1, height - 3);
                }
                g.drawLine(1, height - 1, width - 1, height - 1);
                g.drawLine(width - 1, 0, width - 1, height - 1);
                g.setColor(this.shadowColor);
                g.drawLine(0, 0, 0, height - 2);
                g.drawLine(width - 2, 0, width - 2, height - 2);
                g.drawLine(2, height - 2, width - 2, height - 2);
                if (!MetalPaginationVerticalScrollbarUI.this.isFreeStanding) {
                    --height;
                    width -= 2;
                }
            }
        }
    }
}

