/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.client;

import com.sun.java.swing.plaf.windows.WindowsScrollBarUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openswing.swing.table.client.PaginationVerticalScrollbarUI;

public class WindowsPaginationVerticalScrollbarUI
extends WindowsScrollBarUI
implements PaginationVerticalScrollbarUI {
    protected JButton nextPgButton;
    protected JButton prevPgButton;

    protected JButton createPageButton(int orientation) {
        return new PageArrowButton(orientation);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WindowsPaginationVerticalScrollbarUI();
    }

    public JButton getDecrButton() {
        return this.decrButton;
    }

    public JButton getIncrButton() {
        return this.incrButton;
    }

    public JButton getNextPgButton() {
        return this.nextPgButton;
    }

    public JButton getPrevPgButton() {
        return this.prevPgButton;
    }

    protected void installDefaults() {
        super.installDefaults();
        this.nextPgButton = this.createDecreaseButton(5);
        this.prevPgButton = this.createIncreaseButton(1);
        this.scrollbar.add(this.prevPgButton);
        this.scrollbar.add(this.nextPgButton);
    }

    protected void installListeners() {
        super.installListeners();
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int prevPgButtonH = this.prevPgButton.getPreferredSize().height;
        int prevPgButtonY = sbInsets.top;
        int decrButtonH = this.decrButton.getPreferredSize().height;
        int decrButtonY = prevPgButtonY + prevPgButtonH;
        int incrButtonH = this.incrButton.getPreferredSize().height;
        int nextPgButtonH = this.nextPgButton.getPreferredSize().height;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH + nextPgButtonH);
        int nextPgButtonY = sbSize.height - (sbInsets.bottom + nextPgButtonH);
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH + prevPgButtonH + nextPgButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = incrButtonY - thumbH;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += decrButtonY + decrButtonH;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = decrButtonH = sbAvailButtonH / 2;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.prevPgButton.setBounds(itemX, prevPgButtonY, itemW, prevPgButtonH);
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        this.nextPgButton.setBounds(itemX, nextPgButtonY, itemW, nextPgButtonH);
        int itrackY = decrButtonY + decrButtonH;
        int itrackH = incrButtonY - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > incrButtonY) {
                thumbY = incrButtonY - thumbH;
            }
            if (thumbY < decrButtonY + decrButtonH) {
                thumbY = decrButtonY + decrButtonH + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    class PageArrowButton
    extends BasicArrowButton {
        public PageArrowButton(int direction) {
            super(direction);
        }

        public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
            super.paintTriangle(g, x, y - 2, size, direction, isEnabled);
            super.paintTriangle(g, x, y + 2, size, direction, isEnabled);
        }
    }
}

