/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Beans;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.client.ListFilterController;
import org.openswing.swing.util.client.ClientSettings;

public class Column
extends JPanel {
    public static final int TYPE_BUTTON = 11;
    public static final int TYPE_CHECK = 6;
    public static final int TYPE_COMBO = 7;
    public static final int TYPE_COMBO_VO = 17;
    public static final int TYPE_CURRENCY = 10;
    public static final int TYPE_DATE = 1;
    public static final int TYPE_DATE_TIME = 2;
    public static final int TYPE_DEC = 5;
    public static final int TYPE_FILE = 18;
    public static final int TYPE_FORMATTED_TEXT = 13;
    public static final int TYPE_IMAGE = 12;
    public static final int TYPE_INT = 4;
    public static final int TYPE_LINK = 19;
    public static final int TYPE_LOOKUP = 8;
    public static final int TYPE_MULTIPLE_TYPE = 15;
    public static final int TYPE_MULTI_LINE_TEXT = 14;
    public static final int TYPE_PERC = 9;
    public static final int TYPE_PROGRESS_BAR = 16;
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_TIME = 3;
    private String additionalHeaderColumnName = null;
    private int additionalHeaderColumnSpan = 0;
    public boolean autoFitColumn;
    private JLabel colHeader;
    private JPanel colRow = new JPanel();
    private boolean columnDuplicable = false;
    private boolean columnFilterable = false;
    private String columnName = "columnname";
    private boolean columnRequired = true;
    private boolean columnSelectable = true;
    private boolean columnSortable = false;
    private boolean columnVisible = true;
    private static Class designColumnType;
    private boolean editableOnEdit = false;
    private boolean editableOnInsert = false;
    private ListFilterController filter = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private String headerColumnName = null;
    private Font headerFont;
    private Color headerForegroundColor;
    private int headerTextHorizontalAlignment = 0;
    private int headerTextVerticalAlignment;
    private int maxWidth = 500;
    private int minWidth = 0;
    private int preferredWidth = 100;
    private String sortVersus = "NO_SORT";
    private int sortingOrder = 0;
    private Grids table;
    private int textAlignment = 2;

    public Column() {
        this.colHeader = new JLabel();
        this.headerFont = ClientSettings.HEADER_FONT;
        this.headerForegroundColor = ClientSettings.HEADER_FOREGROUND_COLOR;
        this.headerTextVerticalAlignment = ClientSettings.HEADER_TEXT_VERTICAL_ALIGNMENT;
        this.autoFitColumn = ClientSettings.AUTO_FIT_COLUMNS;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final String getAdditionalHeaderColumnName() {
        return this.additionalHeaderColumnName;
    }

    public final int getAdditionalHeaderColumnSpan() {
        return this.additionalHeaderColumnSpan;
    }

    public TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new DefaultTableCellEditor();
    }

    public TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new DefaultTableCellRenderer();
    }

    public final String getColumnName() {
        try {
            designColumnType = this.getClass();
        }
        catch (Throwable ex) {}
        return this.columnName;
    }

    public int getColumnType() {
        throw new UnsupportedOperationException("This method must be override in " + this.getClass().getName() + " class.");
    }

    public static Class getDesignColumnType() {
        return designColumnType;
    }

    public final String getHeaderColumnName() {
        return this.headerColumnName == null || this.headerColumnName.equals("") ? this.getColumnName() : this.headerColumnName;
    }

    public final Font getHeaderFont() {
        return this.headerFont;
    }

    public final Color getHeaderForegroundColor() {
        return this.headerForegroundColor;
    }

    public final int getHeaderTextHorizontalAlignment() {
        return this.headerTextHorizontalAlignment;
    }

    public final int getHeaderTextVerticalAlignment() {
        return this.headerTextVerticalAlignment;
    }

    public final ListFilterController getListFilter() {
        return this.filter;
    }

    public final int getMaxWidth() {
        return this.maxWidth;
    }

    public final int getMinWidth() {
        return this.minWidth;
    }

    public final int getPreferredWidth() {
        return this.preferredWidth;
    }

    public final String getSortVersus() {
        return this.sortVersus;
    }

    public final int getSortingOrder() {
        return this.sortingOrder;
    }

    public final Grids getTable() {
        return this.table;
    }

    public final int getTextAlignment() {
        return this.textAlignment;
    }

    public final boolean isAutoFitColumn() {
        return this.autoFitColumn;
    }

    public final boolean isColumnDuplicable() {
        return this.columnDuplicable;
    }

    public final boolean isColumnFilterable() {
        return this.columnFilterable;
    }

    public final boolean isColumnRequired() {
        return this.columnRequired;
    }

    public final boolean isColumnSelectable() {
        return this.columnSelectable;
    }

    public final boolean isColumnSortable() {
        return this.columnSortable;
    }

    public final boolean isColumnVisible() {
        return this.columnVisible;
    }

    public boolean isEditableOnEdit() {
        return this.editableOnEdit;
    }

    public boolean isEditableOnInsert() {
        return this.editableOnInsert;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.colRow.setBackground(Color.white);
        this.colRow.setBorder(BorderFactory.createEtchedBorder());
        this.colRow.setPreferredSize(new Dimension(this.preferredWidth, ClientSettings.CELL_HEIGHT));
        this.colHeader.setPreferredSize(new Dimension(this.preferredWidth, ClientSettings.HEADER_HEIGHT));
        this.colHeader.setText(this.columnName);
        this.colHeader.setBorder(BorderFactory.createRaisedBevelBorder());
        this.add((Component)this.colHeader, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.colRow, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public final void setAdditionalHeaderColumnName(String additionalHeaderColumnName) {
        this.additionalHeaderColumnName = additionalHeaderColumnName;
    }

    public final void setAdditionalHeaderColumnSpan(int additionalHeaderColumnSpan) {
        this.additionalHeaderColumnSpan = additionalHeaderColumnSpan;
    }

    public final void setAutoFitColumn(boolean autoFitColumn) {
        this.autoFitColumn = autoFitColumn;
    }

    public final void setColumnDuplicable(boolean columnDuplicable) {
        this.columnDuplicable = columnDuplicable;
    }

    public final void setColumnFilterable(boolean columnFilterable) {
        this.columnFilterable = columnFilterable;
    }

    public final void setColumnName(String columnName) {
        this.columnName = columnName;
        if (this.headerColumnName == null || this.headerColumnName.equals("")) {
            this.colHeader.setText(columnName);
            this.additionalHeaderColumnName = columnName;
        }
    }

    public final void setColumnRequired(boolean columnRequired) {
        this.columnRequired = columnRequired;
    }

    public final void setColumnSelectable(boolean columnSelectable) {
        this.columnSelectable = columnSelectable;
    }

    public final void setColumnSortable(boolean columnSortable) {
        this.columnSortable = columnSortable;
    }

    public final void setColumnVisible(boolean columnVisible) {
        this.columnVisible = columnVisible;
        super.setVisible(columnVisible);
    }

    public final void setEditableOnEdit(boolean editableOnEdit) {
        this.editableOnEdit = editableOnEdit;
    }

    public final void setEditableOnInsert(boolean editableOnInsert) {
        this.editableOnInsert = editableOnInsert;
    }

    public final void setHeaderColumnName(String headerColumnName) {
        this.headerColumnName = headerColumnName;
        if (headerColumnName != null && !headerColumnName.equals("")) {
            this.colHeader.setText(headerColumnName);
            this.additionalHeaderColumnName = headerColumnName;
        } else {
            this.colHeader.setText(this.columnName);
            this.additionalHeaderColumnName = this.columnName;
        }
    }

    public final void setHeaderFont(Font headerFont) {
        this.headerFont = headerFont;
        if (headerFont != null && Beans.isDesignTime()) {
            this.colHeader.setFont(headerFont);
        }
    }

    public final void setHeaderForegroundColor(Color headerForegroundColor) {
        this.headerForegroundColor = headerForegroundColor;
        if (headerForegroundColor != null && Beans.isDesignTime()) {
            this.colHeader.setForeground(headerForegroundColor);
        }
    }

    public final void setHeaderTextHorizontalAlignment(int alignment) {
        this.headerTextHorizontalAlignment = alignment;
        try {
            if (!Beans.isDesignTime()) {
                return;
            }
            this.remove(this.colHeader);
            int align = 18;
            if (alignment == 4) {
                align = 12;
            } else if (alignment == 0) {
                align = 11;
            }
            this.add((Component)this.colHeader, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, align, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.revalidate();
            this.repaint();
        }
        catch (Exception ex) {
        }
    }

    public final void setHeaderTextVerticalAlignment(int alignment) {
        this.headerTextVerticalAlignment = alignment;
    }

    public final void setListFilter(ListFilterController filter) {
        this.filter = filter;
    }

    public final void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public final void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public final void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
        this.colHeader.setPreferredSize(new Dimension(preferredWidth, ClientSettings.HEADER_HEIGHT));
        this.colRow.setPreferredSize(new Dimension(preferredWidth, ClientSettings.CELL_HEIGHT));
    }

    public final void setSortVersus(String sortVersus) {
        this.sortVersus = sortVersus;
    }

    public final void setSortingOrder(int sortingOrder) {
        this.sortingOrder = sortingOrder;
    }

    public final void setTable(Grids table) {
        this.table = table;
    }

    public final void setTextAlignment(int alignment) {
        this.textAlignment = alignment;
    }

    class DefaultTableCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        public DefaultTableCellEditor() {
            super(new JTextField());
        }
    }
}

