/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.awt.ComponentOrientation;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.editors.client.DomainCellEditor;
import org.openswing.swing.table.renderers.client.DomainTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class ComboColumn
extends Column {
    private int bottomMargin = 0;
    private Domain domain;
    private String domainId;
    private DomainCellEditor editor = null;
    private ArrayList itemListeners = new ArrayList();
    private int leftMargin = 2;
    private boolean nullAsDefaultValue = false;
    private ComponentOrientation orientation = ClientSettings.TEXT_ORIENTATION;
    private DomainTableCellRenderer renderer = null;
    private int rightMargin = 0;
    private int topMargin = 0;
    private boolean translateItemDescriptions = true;

    public final void addItemListener(ItemListener listener) {
        this.itemListeners.add(listener);
    }

    public final int getBottomMargin() {
        return this.bottomMargin;
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        if (this.getDomainId() == null && this.getDomain() == null) {
            Logger.error(this.getClass().getName(), "getCellEditor", "You must set the 'domainId' property for the column '" + this.getColumnName() + "'.", null);
            return null;
        }
        Domain domain = this.getDomain();
        if (domain == null) {
            domain = ClientSettings.getInstance().getDomain(this.getDomainId());
        }
        if (domain != null) {
            if (this.editor == null) {
                this.editor = new DomainCellEditor(domain, this.translateItemDescriptions, this.isColumnRequired(), this.getTextOrientation(), this.getItemListeners());
            }
            return this.editor;
        }
        Logger.error(this.getClass().getName(), "getCellEditor", "The domainId '" + this.getDomainId() + "' for the column '" + this.getColumnName() + "' doesn't exist.", null);
        return null;
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        if (this.getDomainId() == null && this.getDomain() == null) {
            Logger.error(this.getClass().getName(), "getCellRenderer", "You must set the 'domainId' property for the column '" + this.getColumnName() + "'.", null);
            return null;
        }
        Domain domain = this.getDomain();
        if (domain == null) {
            domain = ClientSettings.getInstance().getDomain(this.getDomainId());
        }
        if (domain != null) {
            if (this.renderer == null) {
                this.renderer = new DomainTableCellRenderer(domain, this.translateItemDescriptions, tableContainer, this.getTextAlignment(), this.getLeftMargin(), this.getRightMargin(), this.getTopMargin(), this.getBottomMargin(), this.getTextOrientation(), this.getColumnName());
            }
            return this.renderer;
        }
        Logger.error(this.getClass().getName(), "getCellRenderer", "The domainId '" + this.getDomainId() + "' for the column '" + this.getColumnName() + "' " + " doesn't exist.", null);
        return null;
    }

    public int getColumnType() {
        return 7;
    }

    public Domain getDomain() {
        if (this.domain == null && this.domainId != null) {
            this.domain = ClientSettings.getInstance().getDomain(this.domainId);
        }
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public final ArrayList getItemListeners() {
        return this.itemListeners;
    }

    public final int getLeftMargin() {
        return this.leftMargin;
    }

    public final int getRightMargin() {
        return this.rightMargin;
    }

    public final ComponentOrientation getTextOrientation() {
        return this.orientation;
    }

    public final int getTopMargin() {
        return this.topMargin;
    }

    public final boolean isNullAsDefaultValue() {
        return this.nullAsDefaultValue;
    }

    public final boolean isTranslateItemDescriptions() {
        return this.translateItemDescriptions;
    }

    public final void removeItemListener(ItemListener listener) {
        this.itemListeners.remove(listener);
    }

    public final void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
        if (this.renderer != null) {
            this.renderer.setDomain(domain);
        }
        if (this.editor != null) {
            this.editor.setDomain(domain);
        }
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
        if (this.renderer != null) {
            this.renderer.setDomain(this.getDomain());
        }
        if (this.editor != null) {
            this.editor.setDomain(this.getDomain());
        }
    }

    public final void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public final void setNullAsDefaultValue(boolean nullAsDefaultValue) {
        this.nullAsDefaultValue = nullAsDefaultValue;
    }

    public final void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public final void setTextOrientation(ComponentOrientation orientation) {
        this.orientation = orientation;
    }

    public final void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    public final void setTranslateItemDescriptions(boolean translateItemDescriptions) {
        this.translateItemDescriptions = translateItemDescriptions;
    }
}

