/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.DecimalColumn;
import org.openswing.swing.table.editors.client.CurrencyCellEditor;
import org.openswing.swing.table.renderers.client.CurrencyTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class CurrencyColumn
extends DecimalColumn {
    private String currencySymbol = ClientSettings.getInstance().getResources().getCurrencySymbol();
    private boolean currencySymbolOnLeft = ClientSettings.CURRENCY_SYMBOL_ON_LEFT;

    public CurrencyColumn() {
        this.setTextAlignment(4);
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new CurrencyCellEditor(10, this.getDecimals(), this.isColumnRequired(), this.isCurrencySymbolOnLeft(), this.getMinValue(), this.getMaxValue(), this.getCurrencySymbol(), this.getDynamicSettings(), this.isSelectDataOnEdit());
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new CurrencyTableCellRenderer(this.getDecimals(), this.isGrouping(), this.isHideZeroDigits(), this.isCurrencySymbolOnLeft(), this.getCurrencySymbol(), tableContainer, this.getDynamicSettings(), this.getTextAlignment(), this.getLeftMargin(), this.getRightMargin(), this.getTopMargin(), this.getBottomMargin(), this.getColumnName());
    }

    public int getColumnType() {
        return 10;
    }

    public final String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public final boolean isCurrencySymbolOnLeft() {
        return this.currencySymbolOnLeft;
    }

    public final void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public final void setCurrencySymbolOnLeft(boolean currencySymbolOnLeft) {
        this.currencySymbolOnLeft = currencySymbolOnLeft;
    }
}

