/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.client.DateChangedListener;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.DateColumnSettings;
import org.openswing.swing.table.editors.client.DateCellEditor;
import org.openswing.swing.table.renderers.client.DateTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class DateTimeColumn
extends Column {
    private int dateFormat;
    private ArrayList dateListeners;
    private Calendar defaultDate = null;
    private DateColumnSettings dynamicSettings = null;
    private Date lowerLimit = null;
    private char separator = (char)47;
    private boolean showCentury = true;
    private String timeFormat = null;
    private Date upperLimit = null;

    public DateTimeColumn() {
        this.dateListeners = new ArrayList();
        this.setTextAlignment(0);
        try {
            this.dateFormat = ClientSettings.getInstance().getResources().getDateFormat();
            this.timeFormat = ClientSettings.getInstance().getResources().getTimeFormat();
        }
        catch (Exception ex) {
        }
    }

    public final void addDateChangedListener(DateChangedListener listener) {
        this.dateListeners.add(listener);
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new DateCellEditor(this.isColumnRequired(), 2, this.getFormat(), this.getDateListeners(), this.defaultDate);
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new DateTableCellRenderer(2, tableContainer, this.getTextAlignment(), this.getSeparator(), this.getFormat(), this.isShowCentury(), this.getTimeFormat(), this.getDynamicSettings(), this.getColumnName());
    }

    public int getColumnType() {
        return 2;
    }

    public final ArrayList getDateListeners() {
        return this.dateListeners;
    }

    public final Calendar getDefaultDate() {
        return this.defaultDate;
    }

    public final DateColumnSettings getDynamicSettings() {
        return this.dynamicSettings;
    }

    public final int getFormat() {
        return this.dateFormat;
    }

    public final Date getLowerLimit() {
        return this.lowerLimit;
    }

    public final char getSeparator() {
        return this.separator;
    }

    public final String getTimeFormat() {
        return this.timeFormat;
    }

    public final Date getUpperLimit() {
        return this.upperLimit;
    }

    public final boolean isShowCentury() {
        return this.showCentury;
    }

    public final void removeDateChangedListener(DateChangedListener listener) {
        this.dateListeners.remove(listener);
    }

    public final void setDefaultDate(Calendar defaultDate) {
        this.defaultDate = defaultDate;
    }

    public final void setDynamicSettings(DateColumnSettings dynamicSettings) {
        this.dynamicSettings = dynamicSettings;
    }

    public final void setFormat(int dateFormat) {
        if (dateFormat < 0 || dateFormat > 3) {
            dateFormat = 0;
        }
        this.dateFormat = dateFormat;
    }

    public final void setLowerLimit(Date lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public final void setSeparator(char separator) {
        if (Character.isLetterOrDigit(separator) || separator == ' ') {
            return;
        }
        this.separator = separator;
    }

    public final void setShowCentury(boolean showCentury) {
        this.showCentury = showCentury;
        this.setFormat(this.dateFormat);
    }

    public final void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public final void setUpperLimit(Date upperLimit) {
        this.upperLimit = upperLimit;
    }
}

