/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.DecimalColumnSettings;
import org.openswing.swing.table.editors.client.NumericCellEditor;
import org.openswing.swing.table.renderers.client.NumericTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class DecimalColumn
extends Column {
    private int bottomMargin = 0;
    private int decimals = 0;
    private DecimalColumnSettings dynamicSettings = null;
    private boolean grouping = false;
    private boolean hideZeroDigits = ClientSettings.HIDE_ZERO_DIGITS;
    private int leftMargin = 0;
    private double maxValue = 2.147483647E9;
    private double minValue = 0.0;
    private int rightMargin = 2;
    private boolean selectDataOnEdit = ClientSettings.SELECT_DATA_IN_EDITABLE_GRID;
    private int topMargin = 0;

    public DecimalColumn() {
        this.setTextAlignment(4);
    }

    public final int getBottomMargin() {
        return this.bottomMargin;
    }

    public TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new NumericCellEditor(5, this.getDecimals(), this.isColumnRequired(), this.getMinValue(), this.getMaxValue(), this.getDynamicSettings(), this.selectDataOnEdit);
    }

    public TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new NumericTableCellRenderer(this.getDecimals(), this.isGrouping(), this.isHideZeroDigits(), tableContainer, this.getDynamicSettings(), this.getTextAlignment(), this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.getColumnName());
    }

    public int getColumnType() {
        return 5;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public final DecimalColumnSettings getDynamicSettings() {
        return this.dynamicSettings;
    }

    public final int getLeftMargin() {
        return this.leftMargin;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public final int getRightMargin() {
        return this.rightMargin;
    }

    public final int getTopMargin() {
        return this.topMargin;
    }

    public final boolean isGrouping() {
        return this.grouping;
    }

    public final boolean isHideZeroDigits() {
        return this.hideZeroDigits;
    }

    public final boolean isSelectDataOnEdit() {
        return this.selectDataOnEdit;
    }

    public final void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    public final void setDynamicSettings(DecimalColumnSettings dynamicSettings) {
        this.dynamicSettings = dynamicSettings;
    }

    public final void setGrouping(boolean grouping) {
        this.grouping = grouping;
    }

    public final void setHideZeroDigits(boolean hideZeroDigits) {
        this.hideZeroDigits = hideZeroDigits;
    }

    public final void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public final void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public final void setSelectDataOnEdit(boolean selectDataOnEdit) {
        this.selectDataOnEdit = selectDataOnEdit;
    }

    public final void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }
}

