/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.editors.client.FileCellEditor;
import org.openswing.swing.table.renderers.client.FileTableCellRenderer;

public class FileColumn
extends Column {
    private FileFilter fileFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isFile() || f.isDirectory();
        }

        public String getDescription() {
            return "All file formats (*.*)";
        }
    };
    private String fileNameAttributeName = null;
    private boolean showDownloadButton = true;
    private boolean showUploadButton = true;

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new FileCellEditor(tableContainer, this.getFileFilter(), this.isShowUploadButton(), this.isShowDownloadButton(), this.getColumnName(), this.getFileNameAttributeName());
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new FileTableCellRenderer(tableContainer, this.getColumnName(), this.isShowUploadButton(), this.isShowDownloadButton(), this.getFileNameAttributeName());
    }

    public int getColumnType() {
        return 18;
    }

    public final FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public final String getFileNameAttributeName() {
        return this.fileNameAttributeName;
    }

    public final boolean isShowDownloadButton() {
        return this.showDownloadButton;
    }

    public final boolean isShowUploadButton() {
        return this.showUploadButton;
    }

    public final void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public final void setFileNameAttributeName(String fileNameAttributeName) {
        this.fileNameAttributeName = fileNameAttributeName;
    }

    public final void setShowDownloadButton(boolean showDownloadButton) {
        this.showDownloadButton = showDownloadButton;
    }

    public final void setShowUploadButton(boolean showUploadButton) {
        this.showUploadButton = showUploadButton;
    }
}

