/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.editors.client.ImageCellEditor;
import org.openswing.swing.table.renderers.client.ImageTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class ImageColumn
extends Column {
    private FileFilter fileFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".gif") || f.getName().toLowerCase().endsWith(".jpg") || f.isDirectory();
        }

        public String getDescription() {
            return "JPEG/GIF image (*.jpg; *.gif)";
        }
    };
    private ArrayList listeners = new ArrayList();
    private boolean showButton = true;
    public static boolean showPreview = ClientSettings.SHOW_PREVIEW_OF_IMAGE;

    public final void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new ImageCellEditor(this.isShowButton(), this.getFileFilter(), this.getListeners(), showPreview);
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new ImageTableCellRenderer(tableContainer, this.getTextAlignment(), this.getColumnName());
    }

    public int getColumnType() {
        return 12;
    }

    public final FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public final ArrayList getListeners() {
        return this.listeners;
    }

    public final boolean isShowButton() {
        return this.showButton;
    }

    public final boolean isShowPreview() {
        return showPreview;
    }

    public final void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public final void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public final void setShowButton(boolean showButton) {
        this.showButton = showButton;
    }

    public final void setShowPreview(boolean showPreview) {
        ImageColumn.showPreview = showPreview;
    }
}

