/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.IntegerColumnSettings;
import org.openswing.swing.table.editors.client.NumericCellEditor;
import org.openswing.swing.table.renderers.client.NumericTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class IntegerColumn
extends Column {
    private int bottomMargin = 0;
    private IntegerColumnSettings dynamicSettings = null;
    private boolean grouping = false;
    private int leftMargin = 0;
    private int maxValue = Integer.MAX_VALUE;
    private int minValue = 0;
    private int rightMargin = 2;
    private boolean selectDataOnEdit = ClientSettings.SELECT_DATA_IN_EDITABLE_GRID;
    private int topMargin = 0;

    public IntegerColumn() {
        this.setTextAlignment(4);
    }

    public final int getBottomMargin() {
        return this.bottomMargin;
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new NumericCellEditor(4, 0, this.isColumnRequired(), this.getMinValue(), this.getMaxValue(), this.getDynamicSettings(), this.selectDataOnEdit);
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new NumericTableCellRenderer(0, this.isGrouping(), true, tableContainer, this.getDynamicSettings(), this.getTextAlignment(), this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.getColumnName());
    }

    public int getColumnType() {
        return 4;
    }

    public int getDecimals() {
        return 0;
    }

    public final IntegerColumnSettings getDynamicSettings() {
        return this.dynamicSettings;
    }

    public final int getLeftMargin() {
        return this.leftMargin;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public final int getRightMargin() {
        return this.rightMargin;
    }

    public final int getTopMargin() {
        return this.topMargin;
    }

    public final boolean isGrouping() {
        return this.grouping;
    }

    public final boolean isSelectDataOnEdit() {
        return this.selectDataOnEdit;
    }

    public final void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public final void setDynamicSettings(IntegerColumnSettings dynamicSettings) {
        this.dynamicSettings = dynamicSettings;
    }

    public final void setGrouping(boolean grouping) {
        this.grouping = grouping;
    }

    public final void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public final void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public final void setSelectDataOnEdit(boolean selectDataOnEdit) {
        this.selectDataOnEdit = selectDataOnEdit;
    }

    public final void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }
}

