/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.awt.ComponentOrientation;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.editors.client.MultiLineTextCellEditor;
import org.openswing.swing.table.renderers.client.MultiLineTextTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class MultiLineTextColumn
extends Column {
    private int bottomMargin = 0;
    private int leftMargin = 2;
    private int maxCharacters = 255;
    private ComponentOrientation orientation;
    private int rightMargin = 0;
    private boolean selectDataOnEdit = ClientSettings.SELECT_DATA_IN_EDITABLE_GRID;
    private int topMargin = 0;

    public MultiLineTextColumn() {
        this.orientation = ClientSettings.TEXT_ORIENTATION;
    }

    public final int getBottomMargin() {
        return this.bottomMargin;
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new MultiLineTextCellEditor(this.getMaxCharacters(), this.isColumnRequired(), this.selectDataOnEdit, this.getTextOrientation());
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new MultiLineTextTableCellRenderer(tableContainer, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.getTextOrientation(), this.getColumnName());
    }

    public int getColumnType() {
        return 14;
    }

    public final int getLeftMargin() {
        return this.leftMargin;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public final int getRightMargin() {
        return this.rightMargin;
    }

    public final ComponentOrientation getTextOrientation() {
        return this.orientation;
    }

    public final int getTopMargin() {
        return this.topMargin;
    }

    public final boolean isSelectDataOnEdit() {
        return this.selectDataOnEdit;
    }

    public final void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public final void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public final void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public final void setSelectDataOnEdit(boolean selectDataOnEdit) {
        this.selectDataOnEdit = selectDataOnEdit;
    }

    public final void setTextOrientation(ComponentOrientation orientation) {
        this.orientation = orientation;
    }

    public final void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }
}

