/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.editors.client.TextCellEditor;
import org.openswing.swing.table.renderers.client.ProgressBarTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class ProgressBarColumn
extends Column {
    private ArrayList coloredBands = new ArrayList();
    private Color currentColor = ClientSettings.GRID_SELECTION_BACKGROUND;
    private double maxValue;
    private double minValue;
    private boolean showAllBands = true;

    public final void addColoredBand(double minValue, double maxValue, Color color) {
        this.coloredBands.add(new Object[]{new Double(minValue), new Double(maxValue), color});
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new TextCellEditor(0, false);
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new ProgressBarTableCellRenderer(tableContainer, this.getColoredBands(), this.getMinValue(), this.getMaxValue(), this.isShowAllBands(), this.getColor(), this.getColumnName());
    }

    public final Color getColor() {
        return this.currentColor;
    }

    public final ArrayList getColoredBands() {
        return this.coloredBands;
    }

    public final int getColumnType() {
        return 16;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public final boolean isEditableOnEdit() {
        return false;
    }

    public final boolean isEditableOnInsert() {
        return false;
    }

    public final boolean isShowAllBands() {
        return this.showAllBands;
    }

    public final void setColor(Color currentColor) {
        this.currentColor = currentColor;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public final void setShowAllBands(boolean showAllBands) {
        this.showAllBands = showAllBands;
    }
}

