/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.client.AutoCompletitionInputControl;
import org.openswing.swing.client.AutoCompletitionListener;
import org.openswing.swing.lookup.client.LookupAutoCompletitionDataLocator;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupParent;
import org.openswing.swing.lookup.client.RestoreFocusOnInvalidCodeException;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.table.editors.client.TextBox;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class CodLookupCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
LookupParent {
    private boolean alreadyValidated = false;
    private String codAttributeName = null;
    private TextBox codBox;
    private boolean codBoxEditable = false;
    private boolean codBoxVisible = false;
    private ValueObject gridValueObject = null;
    private Object lastCodeValue = null;
    private JButton lookupButton = new JButton("...");
    private LookupController lookupController = null;
    private boolean numericValue;
    private JPanel panel;
    private JButton plusButton = new JButton(){

        public void paint(Graphics g) {
            super.paint(g);
            int width = g.getFontMetrics().stringWidth("+");
            g.drawString("+", (this.getWidth() - width + 1) / 2, this.getHeight() / 2 + 4);
        }
    };
    private boolean required;
    private boolean selectDataOnEdit;
    private int selectedRow = -1;
    private Grid table = null;

    public CodLookupCellEditor(int maxCharacters, LookupController lookupController, boolean required, boolean numericValue, boolean codBoxVisible, boolean codBoxEditable, boolean buttonVisible, final String controllerClassName, final String controllerMethodName, final long autoCompletitionWaitTime, String codAttributeName, ComponentOrientation orientation, boolean selectDataOnEdit) {
        this.codBox = new TextBox();
        this.panel = new JPanel(){
            private KeyEvent oldEv = null;

            public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getSource() != null && e.getSource() instanceof Grid) {
                    try {
                        if (this.oldEv == null || !e.equals(this.oldEv)) {
                            this.oldEv = e;
                            CodLookupCellEditor.this.codBox.processKeyEvent(e);
                            this.oldEv = null;
                        }
                    }
                    catch (Exception ex) {
                    }
                } else if (e.getKeyChar() == '\t' || e.getKeyChar() == '\n') {
                    CodLookupCellEditor.this.stopCellEditing();
                    try {
                        CodLookupCellEditor.this.table.setColumnSelectionInterval(CodLookupCellEditor.this.table.getSelectedColumn() + 1, CodLookupCellEditor.this.table.getSelectedColumn() + 1);
                    }
                    catch (Exception ex) {
                    }
                }
                return true;
            }
        };
        this.selectDataOnEdit = ClientSettings.SELECT_DATA_IN_EDITABLE_GRID;
        this.lookupController = lookupController;
        this.required = required;
        this.numericValue = numericValue;
        this.codBoxVisible = codBoxVisible;
        this.codBoxEditable = codBoxEditable;
        this.codAttributeName = codAttributeName;
        this.selectDataOnEdit = selectDataOnEdit;
        this.codBox.setColumns(maxCharacters);
        this.codBox.setEnabled(codBoxEditable);
        if (orientation != null) {
            this.codBox.setComponentOrientation(orientation);
        }
        this.panel.setLayout(new GridBagLayout());
        if (codBoxVisible) {
            this.panel.add((Component)this.codBox, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            if (buttonVisible) {
                this.lookupButton.setMinimumSize(new Dimension(20, this.panel.getPreferredSize().height));
                this.panel.add((Component)this.lookupButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            if (controllerMethodName != null && !controllerMethodName.equals("")) {
                this.plusButton.setMinimumSize(new Dimension(16, this.panel.getPreferredSize().height));
                this.panel.add((Component)this.plusButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        } else {
            if (buttonVisible) {
                this.panel.add((Component)this.lookupButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
            if (controllerMethodName != null || controllerMethodName != null) {
                this.plusButton.setMinimumSize(new Dimension(16, this.panel.getPreferredSize().height));
                this.panel.add((Component)this.plusButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        this.lookupButton.addActionListener(this);
        this.plusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (controllerClassName != null) {
                    try {
                        Class.forName(controllerClassName).newInstance();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                } else if (controllerMethodName != null) {
                    try {
                        MDIFrame.getClientFacade().getClass().getMethod(controllerMethodName, new Class[0]).invoke((Object)MDIFrame.getClientFacade(), new Object[0]);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        if (autoCompletitionWaitTime >= 0L && codAttributeName != null) {
            this.codBox.addKeyListener(new AutoCompletitionListener(new VirtualInputControl(), new LookupAutoCompletitionDataLocator(lookupController, codAttributeName), autoCompletitionWaitTime));
        }
        this.codBox.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == ClientSettings.LOOKUP_OPEN_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.LOOKUP_OPEN_KEY.getModifiers()) {
                    CodLookupCellEditor.this.actionPerformed(null);
                }
                if (e.getKeyCode() == ClientSettings.LOOKUP_CONTROLLER_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.LOOKUP_CONTROLLER_KEY.getModifiers()) {
                    if (controllerClassName != null) {
                        try {
                            Class.forName(controllerClassName).newInstance();
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    } else if (controllerMethodName != null) {
                        try {
                            MDIFrame.getClientFacade().getClass().getMethod(controllerMethodName, new Class[0]).invoke((Object)MDIFrame.getClientFacade(), new Object[0]);
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        this.codBox.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                CodLookupCellEditor.this.alreadyValidated = false;
            }

            public void insertUpdate(DocumentEvent e) {
                CodLookupCellEditor.this.alreadyValidated = false;
            }

            public void removeUpdate(DocumentEvent e) {
                CodLookupCellEditor.this.alreadyValidated = false;
            }
        });
        lookupController.addLookupListener(new LookupListener(){

            public void beforeLookupAction(ValueObject parentVO) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                if (CodLookupCellEditor.this.codAttributeName == null) {
                    return;
                }
                try {
                    Object newValue = null;
                    String attrName = CodLookupCellEditor.this.codAttributeName;
                    if (parentVO != null) {
                        String aux = attrName;
                        Object obj = parentVO;
                        while (aux.indexOf(".") != -1) {
                            obj = ClientUtils.getPropertyDescriptor(obj.getClass(), aux.substring(0, aux.indexOf("."))).getReadMethod().invoke(obj, new Object[0]);
                            aux = aux.substring(aux.indexOf(".") + 1);
                        }
                        newValue = ClientUtils.getPropertyDescriptor(obj.getClass(), aux).getReadMethod().invoke(obj, new Object[0]);
                    } else {
                        newValue = null;
                    }
                    if (newValue == null) {
                        CodLookupCellEditor.this.codBox.setText("");
                    } else {
                        CodLookupCellEditor.this.codBox.setText(newValue.toString());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    JFrame c = ClientUtils.getParentFrame(CodLookupCellEditor.this.table);
                    if (c != null && c instanceof MDIFrame) {
                        CodLookupCellEditor.this.table.requestFocus();
                    }
                }
            }

            public void codeValidated(boolean validated) {
            }

            public void forceValidate() {
            }
        });
        this.codBox.addKeyListener(new KeyAdapter(){

            static /* synthetic */ CodLookupCellEditor access$400(7 x0) {
                return x0.CodLookupCellEditor.this;
            }

            public void keyPressed(KeyEvent e) {
                block8: {
                    block9: {
                        block6: {
                            block7: {
                                if (CodLookupCellEditor.this.table == null) break block6;
                                if (e.getKeyCode() == 38) break block7;
                                if (e.getKeyCode() != 40) break block6;
                            }
                            if (autoCompletitionWaitTime >= 0L) break block6;
                            CodLookupCellEditor.this.stopCellEditing();
                            if (CodLookupCellEditor.this.table != null) {
                                new Thread(this){
                                    private final /* synthetic */ 7 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    public void run() {
                                        Thread.yield();
                                        try {
                                            Thread.sleep(500L);
                                        }
                                        catch (InterruptedException ex) {
                                            // empty catch block
                                        }
                                        CodLookupCellEditor.access$100(7.access$400(this.this$1)).requestFocus();
                                    }
                                }.start();
                            }
                            CodLookupCellEditor.this.table.dispatchEvent(e);
                            break block8;
                        }
                        if (e.getKeyCode() == 9) break block9;
                        if (e.getKeyCode() != 10) break block8;
                    }
                    if (CodLookupCellEditor.this.codBoxEditable && CodLookupCellEditor.this.codBox.getText() != null) {
                        CodLookupCellEditor.this.codBox.setText(CodLookupCellEditor.this.codBox.getText().toUpperCase().trim());
                    }
                    CodLookupCellEditor.this.stopCellEditing();
                    if (CodLookupCellEditor.this.table != null) {
                        new Thread(this){
                            private final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                Thread.yield();
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException ex) {
                                    // empty catch block
                                }
                                CodLookupCellEditor.access$100(7.access$400(this.this$1)).requestFocus();
                            }
                        }.start();
                    }
                }
            }
        });
    }

    private final Component _prepareEditor(Object value) {
        this.codBox.setText(value == null ? null : value.toString());
        if (this.selectDataOnEdit) {
            this.codBox.select(0, this.codBox.getText().length());
        }
        return this.panel;
    }

    public final void actionPerformed(ActionEvent e) {
        if (this.lookupController != null) {
            this.lookupController.openLookupFrame(ClientUtils.getParentFrame(this.table), (LookupParent)this);
            int colIndex = this.table.getVOListTableModel().findColumn(this.codAttributeName);
            Object value = this.table.getVOListTableModel().getValueAt(this.selectedRow, colIndex);
            this.codBox.setText(value == null ? null : value.toString());
            this.fireEditingStopped();
            if (this.table != null) {
                this.table.repaint();
                if (!this.table.hasFocus()) {
                    this.table.requestFocus();
                }
            }
        }
    }

    public final void finalize() {
        this.table = null;
        this.lookupController = null;
    }

    public final void forceValidate() {
        this.lookupController.forceValidate();
    }

    public final Object getCellEditorValue() {
        this.lastCodeValue = this.table.getVOListTableModel().getValueAt(this.selectedRow, this.table.getColumnIndex(this.codAttributeName));
        if (this.numericValue) {
            if (this.codBox.getText().trim().length() == 0) {
                return null;
            }
            return new BigDecimal(this.codBox.getText());
        }
        return this.codBox.getText();
    }

    public Object getLookupCodeParentValue() {
        return this.lastCodeValue;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!this.codBoxVisible) {
            this.lookupButton.setMinimumSize(new Dimension(this.panel.getPreferredSize().width - 5, this.panel.getPreferredSize().height - 6));
            this.lookupButton.setMaximumSize(new Dimension(this.panel.getPreferredSize().width - 5, this.panel.getPreferredSize().height - 6));
        }
        this.table = (Grid)table;
        this.gridValueObject = ((Grid)table).getVOListTableModel().getObjectForRow(row);
        this.table.getVOListTableModel().setValueAt(value, row, table.convertColumnIndexToModel(column));
        JComponent c = (JComponent)this._prepareEditor(value);
        this.codAttributeName = this.table.getVOListTableModel().getColumnName(table.convertColumnIndexToModel(column));
        this.selectedRow = row;
        if (this.required) {
            c.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_REQUIRED_CELL_BORDER));
        }
        new Thread(){

            public void run() {
                Thread.yield();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                CodLookupCellEditor.this.codBox.requestFocus();
            }
        }.start();
        return c;
    }

    public ValueObject getValueObject() {
        if (this.selectedRow != -1) {
            return this.table.getVOListTableModel().getObjectForRow(this.selectedRow);
        }
        return null;
    }

    public void setValue(String attributeName, Object value) {
        if (this.selectedRow != -1) {
            this.table.getVOListTableModel().setValueAt(value, this.selectedRow, this.table.getColumnIndex(attributeName));
        }
    }

    public final boolean stopCellEditing() {
        return this.validate();
    }

    public final boolean validate() {
        this.fireEditingStopped();
        if (!this.alreadyValidated && this.lookupController != null && this.codBox.getText() != null && this.codBox.isEnabled()) {
            try {
                if (this.lastCodeValue == null || this.lastCodeValue != null && !this.lastCodeValue.toString().toUpperCase().equals(this.codBox.getText().toUpperCase())) {
                    this.lookupController.validateCode(this.table, this.codBox.getText().toUpperCase(), this);
                }
            }
            catch (RestoreFocusOnInvalidCodeException ex) {
                final int row = this.selectedRow;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CodLookupCellEditor.this.table.editCellAt(row, CodLookupCellEditor.this.table.getColumnIndex(CodLookupCellEditor.this.codAttributeName));
                        if (!CodLookupCellEditor.this.codBox.hasFocus()) {
                            CodLookupCellEditor.this.codBox.requestFocus();
                        }
                    }
                });
            }
        }
        this.alreadyValidated = true;
        if (this.table != null) {
            this.table.repaint();
        }
        return true;
    }

    class VirtualInputControl
    implements AutoCompletitionInputControl {
        VirtualInputControl() {
        }

        public void addAncestorListener(AncestorListener listener) {
            CodLookupCellEditor.this.codBox.addAncestorListener(listener);
        }

        public void addFocusListener(FocusListener l) {
            CodLookupCellEditor.this.codBox.addFocusListener(l);
        }

        public int getHeight() {
            return CodLookupCellEditor.this.codBox.getHeight();
        }

        public Point getLocationOnScreen() {
            return CodLookupCellEditor.this.codBox.getLocationOnScreen();
        }

        public Object getValue() {
            return CodLookupCellEditor.this.codBox.getText();
        }

        public int getWidth() {
            return CodLookupCellEditor.this.codBox.getWidth();
        }

        public void setValue(Object value) {
            CodLookupCellEditor.this.codBox.setText(value == null ? null : value.toString());
        }
    }
}

