/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.items.client.ItemRenderer;
import org.openswing.swing.items.client.ItemsDataLocator;
import org.openswing.swing.items.client.ItemsMapper;
import org.openswing.swing.items.client.ItemsParent;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class ComboBoxVOCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ItemsParent {
    private int allColumnPreferredWidth = 100;
    private boolean allColumnVisible = false;
    private String attributeName;
    private Column[] colProperties;
    private JComboBox field = new JComboBox(){
        private KeyEvent oldEv = null;

        public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (e.getSource() != null && e.getSource() instanceof Grid) {
                try {
                    if (this.oldEv == null || !e.equals(this.oldEv)) {
                        this.oldEv = e;
                        ComboBoxVOCellEditor.this.field.processKeyEvent(e);
                        this.oldEv = null;
                    }
                }
                catch (Exception ex) {
                }
            } else if (e.getKeyChar() == '\t' || e.getKeyChar() == '\n') {
                ComboBoxVOCellEditor.this.stopCellEditing();
                try {
                    if (!ComboBoxVOCellEditor.this.table.hasFocus()) {
                        ComboBoxVOCellEditor.this.table.requestFocus();
                    }
                    if (ComboBoxVOCellEditor.this.table.getSelectedRow() != -1) {
                        ComboBoxVOCellEditor.this.table.setRowSelectionInterval(ComboBoxVOCellEditor.this.table.getSelectedRow(), ComboBoxVOCellEditor.this.table.getSelectedRow());
                    }
                    ComboBoxVOCellEditor.this.table.setColumnSelectionInterval(ComboBoxVOCellEditor.this.table.getSelectedColumn() + 1, ComboBoxVOCellEditor.this.table.getSelectedColumn() + 1);
                }
                catch (Exception ex) {
                }
            }
            return true;
        }
    };
    private String foreignKeyAttributeName;
    private Hashtable getters;
    private ArrayList items = null;
    private ItemsDataLocator itemsDataLocator = null;
    private ItemsMapper itemsMapper;
    private ValueObject itemsVO = null;
    private DefaultComboBoxModel model;
    private JPanel p = new JPanel();
    private ItemRenderer rend;
    private boolean required;
    private int row = -1;
    private JTable table = null;

    static {
        UIManager.put("ComboBox.disabledForeground", UIManager.get("ComboBox.foreground"));
        UIManager.put("ComboBox.disabledBackground", UIManager.get("TextField.inactiveBackground"));
        UIManager.put("ComboBox.selectionForeground", Color.black);
        UIManager.put("ComboBox.selectionBackground", ClientSettings.BACKGROUND_SEL_COLOR);
    }

    public ComboBoxVOCellEditor(ItemsMapper itemsMapper, ItemsDataLocator itemsDataLocator, String attributeName, ValueObject itemsVO, Column[] colProperties, boolean allColumnVisible, int allColumnPreferredWidth, Hashtable getters, boolean required, ArrayList itemListeners, String foreignKeyAttributeName, int leftMargin, int rightMargin, int topMargin, int bottomMargin, ComponentOrientation orientation) {
        Response res;
        this.model = new DefaultComboBoxModel();
        this.colProperties = new Column[0];
        this.getters = new Hashtable();
        this.rend = new ItemRenderer();
        this.itemsMapper = new ItemsMapper();
        this.itemsMapper = itemsMapper;
        this.itemsDataLocator = itemsDataLocator;
        this.attributeName = attributeName;
        this.itemsVO = itemsVO;
        this.colProperties = colProperties;
        this.allColumnVisible = allColumnVisible;
        this.allColumnPreferredWidth = allColumnPreferredWidth;
        this.getters = getters;
        this.required = required;
        this.foreignKeyAttributeName = foreignKeyAttributeName;
        if (orientation != null) {
            this.field.setComponentOrientation(orientation);
        }
        if (itemsDataLocator != null && itemsVO != null && !(res = itemsDataLocator.loadData(itemsVO.getClass())).isError()) {
            List items = ((VOListResponse)res).getRows();
            int i = 0;
            while (i < items.size()) {
                this.model.addElement(items.get(i));
                ++i;
            }
            this.field.setModel(this.model);
            this.field.revalidate();
            this.field.repaint();
            this.field.setSelectedIndex(-1);
        }
        ItemRenderer rend = new ItemRenderer();
        rend.init(getters, colProperties, leftMargin, rightMargin, topMargin, bottomMargin);
        this.field.setRenderer(rend);
        this.field.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ComboBoxVOCellEditor.this.itemsVO = (ValueObject)e.getItem();
                    ComboBoxVOCellEditor.this.updateParentModel(ComboBoxVOCellEditor.this);
                }
            }
        });
        int i = 0;
        while (i < itemListeners.size()) {
            this.field.addItemListener((ItemListener)itemListeners.get(i));
            ++i;
        }
        this.p.setOpaque(true);
        this.p.setLayout(new GridBagLayout());
        this.p.add((Component)this.field, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private final Component _prepareEditor(Object value) {
        if (value == null) {
            this.field.setSelectedIndex(-1);
        }
        if (this.getFKAttributeName() != null) {
            Object obj = null;
            try {
                this.field.setSelectedIndex(-1);
                int i = 0;
                while (i < this.model.getSize()) {
                    obj = ((Method)this.getters.get(this.getFKAttributeName())).invoke(this.model.getElementAt(i), new Object[0]);
                    if (value.equals(obj)) {
                        this.field.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable ex) {
                this.field.setSelectedIndex(-1);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!ComboBoxVOCellEditor.this.field.hasFocus()) {
                    ComboBoxVOCellEditor.this.field.requestFocus();
                }
            }
        });
        return this.field;
    }

    public final void finalize() {
        this.colProperties = null;
        this.table = null;
        this.field = null;
        this.itemsMapper = null;
        this.itemsDataLocator = null;
        this.rend = null;
    }

    public final Object getCellEditorValue() {
        int selIndex = this.field.getSelectedIndex();
        if (selIndex == -1) {
            return null;
        }
        try {
            return ((Method)this.getters.get(this.getFKAttributeName())).invoke(this.model.getElementAt(selIndex), new Object[0]);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private String getFKAttributeName() {
        return this.foreignKeyAttributeName == null || this.foreignKeyAttributeName.equals("") ? this.attributeName : this.foreignKeyAttributeName;
    }

    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        if (this.required) {
            this.field.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_REQUIRED_CELL_BORDER));
        }
        this._prepareEditor(value);
        return this.p;
    }

    public ValueObject getValueObject() {
        if (this.row == -1) {
            return null;
        }
        return ((Grid)this.table).getVOListTableModel().getObjectForRow(this.row);
    }

    public final void reloadItems() {
        Response res;
        if (this.itemsDataLocator != null && this.itemsVO != null && !(res = this.itemsDataLocator.loadData(this.itemsVO.getClass())).isError()) {
            List items = ((VOListResponse)res).getRows();
            this.model = new DefaultComboBoxModel();
            int i = 0;
            while (i < items.size()) {
                this.model.addElement(items.get(i));
                ++i;
            }
            this.field.setModel(this.model);
            this.field.revalidate();
            this.field.repaint();
            this.field.setSelectedIndex(-1);
        }
    }

    public void setValue(String attributeName, Object value) {
        if (this.row != -1) {
            ((Grid)this.table).getVOListTableModel().setField(this.row, attributeName, value);
        }
    }

    public final boolean stopCellEditing() {
        return this.validate();
    }

    private void updateParentModel(ItemsParent itemsParent) {
        if (this.itemsVO != null && this.itemsMapper != null) {
            try {
                Enumeration itemsAttributes = this.itemsMapper.getItemsChangedAttributes();
                Object attrName = null;
                while (itemsAttributes.hasMoreElements()) {
                    String itemsAttributeName = (String)itemsAttributes.nextElement();
                    if (itemsAttributeName.length() == 0) {
                        if (this.itemsMapper.setParentAttribute(itemsParent, itemsAttributeName, this.itemsVO.getClass(), this.itemsVO)) continue;
                        Logger.error(this.getClass().getName(), "updateParentModel", "Error while setting items container value object.", null);
                        continue;
                    }
                    String itemsMethodName = "get" + String.valueOf(Character.toUpperCase(itemsAttributeName.charAt(0))) + itemsAttributeName.substring(1);
                    Method itemsMethod = this.itemsVO.getClass().getMethod(itemsMethodName, new Class[0]);
                    if (this.itemsMapper.setParentAttribute(itemsParent, itemsAttributeName, itemsMethod.getReturnType(), itemsMethod.invoke((Object)this.itemsVO, new Object[0]))) continue;
                    Logger.error(this.getClass().getName(), "updateParentModel", "Error while setting items container value object.", null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            catch (Error er) {
                er.printStackTrace();
            }
        } else {
            Logger.error(this.getClass().getName(), "updateParentModel", "You must set 'itemsMapper' property", null);
        }
    }

    private final boolean validate() {
        this.fireEditingStopped();
        return true;
    }
}

