/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.client.DateChangedListener;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class DateCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private ArrayList dateListeners = null;
    private DateControl field = new DateControl(){

        public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (e.getSource() != null && e.getSource() instanceof Grid) {
                DateCellEditor.this.field.processKeyEvent(e);
            } else if (e.getKeyChar() == '\t' || e.getKeyChar() == '\n') {
                DateCellEditor.this.stopCellEditing();
            }
            return true;
        }
    };
    private boolean required;
    private int selectedCol = -1;
    private int selectedRow = -1;
    private JTable table = null;

    public DateCellEditor(boolean required, int columnType, int format, ArrayList dateListeners, Calendar defaultDate) {
        this.required = required;
        this.dateListeners = dateListeners;
        this.field.setDateType(columnType);
        this.field.setDefaultDate(defaultDate);
        this.field.setFormat(format);
        int i = 0;
        while (i < dateListeners.size()) {
            this.field.addDateChangedListener((DateChangedListener)dateListeners.get(i));
            ++i;
        }
        this.field.getDateField().addKeyListener(new KeyAdapter(){

            static /* synthetic */ DateCellEditor access$200(2 x0) {
                return x0.DateCellEditor.this;
            }

            public void keyPressed(KeyEvent e) {
                block5: {
                    block4: {
                        if (e.getKeyCode() == 9) break block4;
                        if (e.getKeyCode() != 10) break block5;
                    }
                    DateCellEditor.this.stopCellEditing();
                    if (DateCellEditor.this.table != null) {
                        new Thread(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                Thread.yield();
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                DateCellEditor.access$100(2.access$200(this.this$1)).requestFocus();
                                try {
                                    DateCellEditor.access$100(2.access$200(this.this$1)).setColumnSelectionInterval(DateCellEditor.access$300(2.access$200(this.this$1)) + 1, DateCellEditor.access$300(2.access$200(this.this$1)) + 1);
                                }
                                catch (Exception ex1) {
                                }
                            }
                        }.start();
                    }
                }
            }
        });
    }

    private Component _prepareEditor(Object value) {
        if (value != null && value instanceof Date) {
            this.field.setDate((Date)value);
        } else {
            this.field.setDate(null);
        }
        return this.field;
    }

    static /* synthetic */ int access$300(DateCellEditor x0) {
        return x0.selectedCol;
    }

    public final void finalize() {
        try {
            if (this.field != null) {
                this.field.finalize();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.field = null;
        this.table = null;
    }

    public final Object getCellEditorValue() {
        return this.field.getDate();
    }

    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.selectedRow = row;
        this.selectedCol = column;
        JComponent c = (JComponent)this._prepareEditor(value);
        new Thread(){

            public void run() {
                Thread.yield();
                DateCellEditor.this.field.getDateField().requestFocus();
            }
        }.start();
        if (this.required) {
            this.field.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_REQUIRED_CELL_BORDER));
        }
        return c;
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        return this._prepareEditor(value);
    }

    public final boolean stopCellEditing() {
        this.field.focusLost(null);
        return this.validate();
    }

    private boolean validate() {
        this.fireEditingStopped();
        if (this.table != null) {
            this.table.requestFocus();
        }
        return true;
    }
}

