/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.CheckBoxControl;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.client.CurrencyControl;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.ImageControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.client.NumericControl;
import org.openswing.swing.client.TextAreaControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.TypeController;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class MultipleTypeCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private String attributeName;
    private Font defaultFont = null;
    private GridControl grid;
    private GridController gridController = null;
    private InputControl ic = null;
    private Hashtable inputControls = new Hashtable();
    private JPanel p = new JPanel();
    private boolean required;
    private int row = -1;
    private JTable table = null;
    private TypeController typeController = null;

    public MultipleTypeCellEditor(GridController gridController, TypeController typeController, String attributeName, GridControl grid, boolean required) {
        this.gridController = gridController;
        this.typeController = typeController;
        this.attributeName = attributeName;
        this.grid = grid;
        this.required = required;
        this.p.setOpaque(true);
        this.p.setLayout(new GridBagLayout());
    }

    private final InputControl _prepareEditor() {
        InputControl ic = this.typeController.getAdditionalProperties(this.row, this.attributeName, this.grid);
        if (ic != null) {
            return ic;
        }
        int type = this.typeController.getCellType(this.row, this.attributeName, this.grid);
        ic = (InputControl)this.inputControls.get(new Integer(type));
        if (ic == null) {
            switch (type) {
                case 0: {
                    ic = new TextControl();
                    break;
                }
                case 1: {
                    ic = new DateControl();
                    break;
                }
                case 2: {
                    ic = new DateControl();
                    ((DateControl)ic).setDateType(2);
                    break;
                }
                case 3: {
                    ic = new DateControl();
                    ((DateControl)ic).setDateType(3);
                    break;
                }
                case 4: {
                    ic = new NumericControl();
                    break;
                }
                case 5: {
                    ic = new NumericControl();
                    ((NumericControl)ic).setDecimals(5);
                    break;
                }
                case 6: {
                    ic = new CheckBoxControl();
                    break;
                }
                case 9: {
                    ic = new NumericControl();
                    ((NumericControl)ic).setMaxValue(100.0);
                    break;
                }
                case 10: {
                    ic = new CurrencyControl();
                    break;
                }
                case 12: {
                    ic = new ImageControl();
                    break;
                }
                case 14: {
                    ic = new TextAreaControl();
                    break;
                }
                default: {
                    ic = new TextControl();
                }
            }
            this.inputControls.put(new Integer(type), ic);
        }
        return ic;
    }

    public final void finalize() {
        this.table = null;
        this.gridController = null;
        this.typeController = null;
        this.grid = null;
        this.inputControls.clear();
    }

    public final Object getCellEditorValue() {
        return this.ic.getValue();
    }

    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        this.ic = this._prepareEditor();
        this.ic.setValue(value);
        JComponent c = null;
        c = this.ic instanceof BaseInputControl ? ((BaseInputControl)this.ic).getBindingComponent() : (JComponent)((Object)this.ic);
        if (this.required) {
            c.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_REQUIRED_CELL_BORDER));
        }
        this.p.removeAll();
        if (c instanceof JComboBox) {
            this.p.add((Component)c, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        } else if (this.ic instanceof CodLookupControl) {
            this.p.add((Component)c, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.p.add(((JComponent)((Object)this.ic)).getComponent(1), new GridBagConstraints(1, 0, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.p.add((Component)((JComponent)((Object)this.ic)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.p;
    }

    public final boolean stopCellEditing() {
        return this.validate();
    }

    private final boolean validate() {
        this.fireEditingStopped();
        return true;
    }
}

