/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.filter.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.CurrencyControl;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.FormatterController;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.NumericControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.domains.java.DomainPair;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.send.java.FilterWhereClause;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.CodLookupColumn;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.ComboColumn;
import org.openswing.swing.table.columns.client.DecimalColumn;
import org.openswing.swing.table.columns.client.FormattedTextColumn;
import org.openswing.swing.table.columns.client.IntegerColumn;
import org.openswing.swing.table.columns.client.ProgressBarColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class FilterPanel
extends JPanel {
    private BorderLayout borderLayout2;
    private BorderLayout borderLayout3;
    private GenericButton closePanel;
    private Column[] colProperties = null;
    private JPanel fPanel;
    private GenericButton filterButton;
    private ArrayList filterColNames;
    private ArrayList filterColOps;
    private ArrayList filterColValues;
    private Hashtable filterColumns;
    private JPanel filterPanel;
    private int filterPanelOnGridPolicy;
    private JScrollPane filterScrollPane;
    private FlowLayout flowLayout1;
    private Grids grid = null;
    private GridBagLayout gridBagLayout1;
    private GridBagLayout gridBagLayout2;
    private GridBagLayout gridBagLayout3;
    private GridBagLayout gridBagLayout4;
    GridBagLayout gridBagLayout5;
    private Map initialFilterList;
    private ArrayList initialOrderList;
    private ImageIcon lockImage;
    private GenericButton lockPanel;
    private boolean locked;
    private JPanel mainPanel = new JPanel();
    private JPanel oPanel;
    private Hashtable orderColumns;
    private JPanel orderPanel;
    private JScrollPane orderScrollPane;
    private ArrayList sortColNames;
    private ArrayList sortVersus;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel topPanel;
    private ImageIcon unlockImage;

    public FilterPanel(Column[] colProperties, Grids grid, int filterPanelOnGridPolicy) {
        this.borderLayout2 = new BorderLayout();
        this.orderPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.orderScrollPane = new JScrollPane();
        this.borderLayout3 = new BorderLayout();
        this.filterScrollPane = new JScrollPane();
        this.oPanel = new JPanel();
        this.fPanel = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.gridBagLayout2 = new GridBagLayout();
        this.filterButton = new GenericButton(new ImageIcon(ClientUtils.getImage("filter.gif")));
        this.flowLayout1 = new FlowLayout();
        this.topPanel = new JPanel();
        this.gridBagLayout4 = new GridBagLayout();
        this.gridBagLayout3 = new GridBagLayout();
        this.filterColNames = new ArrayList();
        this.filterColOps = new ArrayList();
        this.filterColValues = new ArrayList();
        this.filterColumns = new Hashtable();
        this.initialFilterList = new HashMap();
        this.sortColNames = new ArrayList();
        this.sortVersus = new ArrayList();
        this.orderColumns = new Hashtable();
        this.initialOrderList = new ArrayList();
        this.gridBagLayout5 = new GridBagLayout();
        this.colProperties = colProperties;
        this.grid = grid;
        this.filterPanelOnGridPolicy = filterPanelOnGridPolicy;
        try {
            this.jbInit();
            if (filterPanelOnGridPolicy == 2 || filterPanelOnGridPolicy == 3) {
                this.lockImage = new ImageIcon(ClientUtils.getImage(ClientSettings.FILTER_PANEL_LOCK_ON));
                this.unlockImage = new ImageIcon(ClientUtils.getImage(ClientSettings.FILTER_PANEL_LOCK_OFF));
                this.lockPanel = new GenericButton(this.lockImage);
                this.lockPanel.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        FilterPanel.this.lockPanel_mouseClicked(e);
                    }
                });
                this.setLocked(filterPanelOnGridPolicy == 2);
                this.topPanel.add((Component)this.lockPanel, null);
            } else if (filterPanelOnGridPolicy == 1) {
                this.closePanel = new GenericButton(new ImageIcon(ClientUtils.getImage(ClientSettings.CLOSE_BUTTON_ON_FILTER_PANEL)));
                this.closePanel.setToolTipText(ClientSettings.getInstance().getResources().getResource("close window"));
                this.topPanel.add((Component)this.closePanel, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JComponent createValueComponent(Column colProperties) {
        JComponent result = null;
        if (colProperties.getColumnType() == 7) {
            Domain domain = ClientSettings.getInstance().getDomain(((ComboColumn)colProperties).getDomainId());
            Object couple = null;
            DomainPair[] pairs = domain.getDomainPairList();
            Vector<String> items = new Vector<String>();
            items.add("");
            int i = 0;
            while (i < pairs.length) {
                items.add(ClientSettings.getInstance().getResources().getResource(pairs[i].getDescription()));
                ++i;
            }
            final JComboBox list = new JComboBox(items);
            JPanel listPanel = new JPanel(){

                public void addFocusListener(FocusListener l) {
                    if (list != null) {
                        list.addFocusListener(l);
                    }
                }
            };
            listPanel.setLayout(new FlowLayout(0, 5, 0));
            listPanel.add(list, null);
            return listPanel;
        }
        if (colProperties.getColumnType() == 6) {
            JCheckBox check = new JCheckBox();
            JPanel listPanel = new JPanel();
            listPanel.setLayout(new FlowLayout(0, 5, 0));
            listPanel.add((Component)check, null);
            return listPanel;
        }
        switch (colProperties.getColumnType()) {
            case 1: 
            case 2: 
            case 3: {
                result = new DateControl();
                result.setDateType(colProperties.getColumnType());
                break;
            }
            case 4: {
                NumericControl num = new NumericControl();
                if (colProperties != null) {
                    try {
                        num.setDecimals(0);
                        num.setMaxValue(((IntegerColumn)colProperties).getMaxValue());
                        num.setMinValue(((IntegerColumn)colProperties).getMinValue());
                        num.setGrouping(((IntegerColumn)colProperties).isGrouping());
                    }
                    catch (ClassCastException ex) {
                        Logger.error(this.getClass().getName(), "createValueComponent", "Error while creating an input control for the filter", ex);
                    }
                }
                result = num;
                break;
            }
            case 5: 
            case 9: {
                NumericControl num = new NumericControl();
                if (colProperties != null) {
                    try {
                        num.setDecimals(((DecimalColumn)colProperties).getDecimals());
                        num.setMaxValue(((DecimalColumn)colProperties).getMaxValue());
                        num.setMinValue(((DecimalColumn)colProperties).getMinValue());
                        num.setGrouping(((DecimalColumn)colProperties).isGrouping());
                    }
                    catch (ClassCastException ex) {
                        Logger.error(this.getClass().getName(), "createValueComponent", "Error while creating an input control for the filter", ex);
                    }
                }
                result = num;
                break;
            }
            case 16: {
                NumericControl num = new NumericControl();
                if (colProperties != null) {
                    try {
                        num.setMaxValue(((ProgressBarColumn)colProperties).getMaxValue());
                        num.setMinValue(((ProgressBarColumn)colProperties).getMinValue());
                    }
                    catch (ClassCastException ex) {
                        Logger.error(this.getClass().getName(), "createValueComponent", "Error while creating an input control for the filter", ex);
                    }
                }
                result = num;
                break;
            }
            case 10: {
                CurrencyControl num = new CurrencyControl();
                if (colProperties != null) {
                    try {
                        num.setDecimals(((DecimalColumn)colProperties).getDecimals());
                        num.setMaxValue(((DecimalColumn)colProperties).getMaxValue());
                        num.setMinValue(((DecimalColumn)colProperties).getMinValue());
                        num.setGrouping(((DecimalColumn)colProperties).isGrouping());
                    }
                    catch (ClassCastException ex) {
                        Logger.error(this.getClass().getName(), "createValueComponent", "Error while creating an input control for the filter", ex);
                    }
                }
                result = num;
                break;
            }
            case 0: {
                TextControl edit = new TextControl();
                if (((TextColumn)colProperties).isRpadding() && ((TextColumn)colProperties).getMaxCharacters() > 0) {
                    edit.setRpadding(true);
                }
                try {
                    edit.setMaxCharacters(((TextColumn)colProperties).getMaxCharacters());
                }
                catch (ClassCastException ex) {
                    Logger.error(this.getClass().getName(), "createValueComponent", "Error while creating an input control for the filter", ex);
                }
                result = edit;
                break;
            }
            case 19: {
                TextControl edit = new TextControl();
                result = edit;
                break;
            }
            case 13: {
                FormattedTextBox edit = new FormattedTextBox(((FormattedTextColumn)colProperties).getController());
                edit.setFormatterFactory(((FormattedTextColumn)colProperties).getFormatterFactory());
                edit.setFormatter(((FormattedTextColumn)colProperties).getFormatter());
                edit.setPreferredSize(new Dimension(100, 20));
                result = edit;
                break;
            }
            case 8: {
                BaseInputControl edit = null;
                if (((CodLookupColumn)colProperties).isAllowOnlyNumbers()) {
                    edit = new NumericControl();
                    try {
                        ((NumericControl)edit).setMaxCharacters(((CodLookupColumn)colProperties).getMaxCharacters());
                    }
                    catch (ClassCastException ex) {
                        Logger.error(this.getClass().getName(), "createValueComponent", "Error while creating an input control for the filter", ex);
                    }
                } else {
                    edit = new TextControl();
                    if (((CodLookupColumn)colProperties).isCodePadding() && ((CodLookupColumn)colProperties).getMaxCharacters() > 0) {
                        ((TextControl)edit).setRpadding(true);
                    }
                    try {
                        ((TextControl)edit).setMaxCharacters(((CodLookupColumn)colProperties).getMaxCharacters());
                    }
                    catch (ClassCastException ex) {
                        Logger.error(this.getClass().getName(), "createValueComponent", "Error while creating an input control for the filter", ex);
                    }
                }
                result = edit;
                break;
            }
            default: {
                Logger.error(this.getClass().getName(), "createValueComponent", "Error while creating an input control for the filter: column type not supported", null);
            }
        }
        return result;
    }

    void filterButton_actionPerformed(ActionEvent e) {
        this.orderColumns.clear();
        this.filterColumns.clear();
        String colName = null;
        String versus = null;
        this.grid.getCurrentSortedColumns().clear();
        this.grid.getCurrentSortedVersusColumns().clear();
        int i = 0;
        while (i < this.sortColNames.size()) {
            if (((JComboBox)this.sortColNames.get(i)).getSelectedIndex() > 0 && ((JComboBox)this.sortVersus.get(i)).getSelectedIndex() > 0) {
                colName = ((ComboModel)((JComboBox)this.sortColNames.get(i)).getModel()).getSelectedCode(((JComboBox)this.sortColNames.get(i)).getSelectedIndex());
                boolean alreadyExist = this.grid.getCurrentSortedColumns().contains(colName);
                if (!alreadyExist) {
                    if (((JComboBox)this.sortVersus.get(i)).getSelectedIndex() == 1) {
                        versus = "ASC";
                    } else if (((JComboBox)this.sortVersus.get(i)).getSelectedIndex() == 2) {
                        versus = "DESC";
                    }
                    this.orderColumns.put(colName, new String[]{colName, versus});
                    this.grid.getCurrentSortedColumns().add(colName);
                    this.grid.getCurrentSortedVersusColumns().add(versus);
                }
            }
            ++i;
        }
        Object value = null;
        String op = null;
        this.grid.getQuickFilterValues().clear();
        JComponent[] cc = null;
        int i2 = 0;
        while (i2 < this.filterColOps.size()) {
            FilterWhereClause whereClause;
            int j;
            ArrayList<Object> values;
            cc = (JComponent[])this.filterColValues.get(i2);
            if (((JComboBox)this.filterColOps.get(i2)).getSelectedIndex() > 0 && ((JComboBox)this.filterColOps.get(i2)).getSelectedItem().toString().equals("in")) {
                values = new ArrayList<Object>();
                j = 0;
                while (j < cc.length) {
                    value = this.getValueComponent(cc[j], (Column)this.filterColNames.get(i2));
                    if (value != null && !"".equals(value)) {
                        values.add(value);
                    }
                    ++j;
                }
                if (values.size() > 0) {
                    colName = ((Column)this.filterColNames.get(i2)).getColumnName();
                    int j2 = 0;
                    while (j2 < values.size()) {
                        values.set(j2, this.grid.getGridController().beforeFilterGrid(colName, values.get(j2)));
                        ++j2;
                    }
                    op = ((JComboBox)this.filterColOps.get(i2)).getSelectedItem().toString();
                    whereClause = new FilterWhereClause(colName, op, values);
                    this.filterColumns.put(colName, whereClause);
                    if (this.grid.getQuickFilterValues().get(colName) == null) {
                        this.grid.getQuickFilterValues().put(colName, new FilterWhereClause[]{whereClause, null});
                    } else {
                        ((FilterWhereClause[])this.grid.getQuickFilterValues().get((Object)colName))[1] = whereClause;
                    }
                }
            } else if (!(((JComboBox)this.filterColOps.get(i2)).getSelectedIndex() <= 0 || ((JComboBox)this.filterColOps.get(i2)).getSelectedItem().toString().equals("in") || ((JComboBox)this.filterColOps.get(i2)).getSelectedItem().toString().equals("is not null") || ((JComboBox)this.filterColOps.get(i2)).getSelectedItem().toString().equals("is null"))) {
                values = new ArrayList();
                j = 0;
                while (j < cc.length) {
                    value = this.getValueComponent(cc[j], (Column)this.filterColNames.get(i2));
                    if (value != null && !"".equals(value)) {
                        values.add(value);
                    }
                    ++j;
                }
                if (values.size() > 1) {
                    colName = ((Column)this.filterColNames.get(i2)).getColumnName();
                    int j3 = 0;
                    while (j3 < values.size()) {
                        values.set(j3, this.grid.getGridController().beforeFilterGrid(colName, values.get(j3)));
                        ++j3;
                    }
                    op = ((JComboBox)this.filterColOps.get(i2)).getSelectedItem().toString();
                    whereClause = new FilterWhereClause(colName, op, values);
                    this.filterColumns.put(colName, whereClause);
                    if (this.grid.getQuickFilterValues().get(colName) == null) {
                        this.grid.getQuickFilterValues().put(colName, new FilterWhereClause[]{whereClause, null});
                    } else {
                        ((FilterWhereClause[])this.grid.getQuickFilterValues().get((Object)colName))[1] = whereClause;
                    }
                } else if (((JComboBox)this.filterColOps.get(i2)).getSelectedIndex() > 0 && this.getValueComponent(cc[0], (Column)this.filterColNames.get(i2)) != null) {
                    colName = ((Column)this.filterColNames.get(i2)).getColumnName();
                    value = this.getValueComponent(cc[0], (Column)this.filterColNames.get(i2));
                    value = this.grid.getGridController().beforeFilterGrid(colName, value);
                    op = ((JComboBox)this.filterColOps.get(i2)).getSelectedItem().toString();
                    FilterWhereClause whereClause2 = new FilterWhereClause(colName, op, value);
                    this.filterColumns.put(colName, whereClause2);
                    if (this.grid.getQuickFilterValues().get(colName) == null) {
                        this.grid.getQuickFilterValues().put(colName, new FilterWhereClause[]{whereClause2, null});
                    } else {
                        ((FilterWhereClause[])this.grid.getQuickFilterValues().get((Object)colName))[1] = whereClause2;
                    }
                }
            } else if (((JComboBox)this.filterColOps.get(i2)).getSelectedIndex() > 0 && (((JComboBox)this.filterColOps.get(i2)).getSelectedItem().toString().equals("is not null") || ((JComboBox)this.filterColOps.get(i2)).getSelectedItem().toString().equals("is null"))) {
                colName = ((Column)this.filterColNames.get(i2)).getColumnName();
                op = ((JComboBox)this.filterColOps.get(i2)).getSelectedItem().toString();
                FilterWhereClause whereClause3 = null;
                whereClause3 = new FilterWhereClause(colName, ((JComboBox)this.filterColOps.get(i2)).getSelectedItem().toString(), null);
                this.filterColumns.put(colName, whereClause3);
                if (this.grid.getQuickFilterValues().get(colName) == null) {
                    this.grid.getQuickFilterValues().put(colName, new FilterWhereClause[]{whereClause3, null});
                } else {
                    ((FilterWhereClause[])this.grid.getQuickFilterValues().get((Object)colName))[1] = whereClause3;
                }
            }
            ++i2;
        }
        this.grid.updateColumnHeaderIcons();
        this.grid.reload();
    }

    public final GenericButton getClosePanel() {
        return this.closePanel;
    }

    private Object getInternalValueComponent(JComponent result, Column colProperties) {
        if (colProperties.getColumnType() == 7) {
            Domain domain = ClientSettings.getInstance().getDomain(((ComboColumn)colProperties).getDomainId());
            Object couple = null;
            DomainPair[] pairs = domain.getDomainPairList();
            Vector items = new Vector();
            result = (JComboBox)((JPanel)result).getComponent(0);
            int i = 0;
            while (i < pairs.length) {
                if (ClientSettings.getInstance().getResources().getResource(pairs[i].getDescription()).equals(((JComboBox)result).getSelectedItem())) {
                    return pairs[i].getCode();
                }
                ++i;
            }
            return null;
        }
        if (colProperties.getColumnType() == 6) {
            if ((result = (JCheckBox)((JPanel)result).getComponent(0)) != null && ((JCheckBox)result).isSelected()) {
                return ((CheckBoxColumn)colProperties).getPositiveValue();
            }
            return ((CheckBoxColumn)colProperties).getNegativeValue();
        }
        switch (colProperties.getColumnType()) {
            case 1: 
            case 2: 
            case 3: {
                return ((DateControl)result).getValue();
            }
            case 4: {
                return ((NumericControl)result).getValue();
            }
            case 5: 
            case 9: {
                return ((NumericControl)result).getValue();
            }
            case 16: {
                return ((NumericControl)result).getValue();
            }
            case 10: {
                return ((NumericControl)result).getValue();
            }
            case 0: 
            case 19: {
                return ((TextControl)result).getValue();
            }
            case 13: {
                try {
                    ((JFormattedTextField)result).commitEdit();
                    return ((JFormattedTextField)result).getValue();
                }
                catch (ParseException ex) {
                    return null;
                }
            }
            case 8: {
                if (((CodLookupColumn)colProperties).isAllowOnlyNumbers()) {
                    return ((NumericControl)result).getValue();
                }
                return ((TextControl)result).getValue();
            }
        }
        Logger.error(this.getClass().getName(), "getValueComponent", "Error while retrieving filter value: column type not supported", null);
        return null;
    }

    private Object getValueComponent(JComponent result, Column colProperties) {
        Object value = this.getInternalValueComponent(result, colProperties);
        Class clazz = this.grid.getVOListTableModel().getColumnClass(this.grid.getVOListTableModel().findColumn(colProperties.getColumnName()));
        return ClientUtils.convertObject(value, clazz);
    }

    public void init() {
        this.filterColNames.clear();
        this.filterColOps.clear();
        this.filterColValues.clear();
        this.sortColNames.clear();
        this.sortVersus.clear();
        this.oPanel.removeAll();
        this.fPanel.removeAll();
        this.initialOrderList.clear();
        this.initialFilterList.clear();
        this.prepareSortPanel();
        this.prepareFilterPanel();
        this.oPanel.revalidate();
        this.fPanel.revalidate();
        this.oPanel.repaint();
        this.fPanel.repaint();
    }

    public boolean isLocked() {
        return this.locked;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout5);
        try {
            this.setBackground(new Color(this.getBackground().getRed() - 10, this.getBackground().getGreen() - 10, this.getBackground().getBlue() - 10));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.mainPanel.setLayout(this.borderLayout2);
        this.mainPanel.setOpaque(false);
        this.orderPanel.setLayout(this.borderLayout3);
        this.filterPanel.setLayout(this.gridBagLayout4);
        this.oPanel.setLayout(this.gridBagLayout1);
        this.fPanel.setLayout(this.gridBagLayout2);
        this.topPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setVgap(0);
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterPanel.this.filterButton_actionPerformed(e);
            }
        });
        this.filterScrollPane.setHorizontalScrollBarPolicy(32);
        this.filterScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.orderScrollPane.setBorder(null);
        this.orderPanel.setBorder(BorderFactory.createEtchedBorder());
        this.topPanel.setOpaque(false);
        this.add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.orderPanel.add((Component)this.orderScrollPane, "Center");
        this.tabbedPane.add((Component)this.filterPanel, ClientSettings.getInstance().getResources().getResource("filtering conditions"));
        this.tabbedPane.add((Component)this.orderPanel, ClientSettings.getInstance().getResources().getResource("sorting conditions"));
        this.filterPanel.add((Component)this.filterScrollPane, new GridBagConstraints(1, 0, 1, 1, 2.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.topPanel, "North");
        this.orderScrollPane.getViewport().add((Component)this.oPanel, null);
        this.filterScrollPane.getViewport().add((Component)this.fPanel, null);
        this.topPanel.add((Component)this.filterButton, null);
    }

    void lockPanel_mouseClicked(MouseEvent e) {
        this.setLocked(!this.locked);
    }

    private void prepareFilterPanel() {
        Iterator it = this.grid.getQuickFilterValues().keySet().iterator();
        String attrName = null;
        while (it.hasNext()) {
            attrName = it.next().toString();
            this.initialFilterList.put(attrName, this.grid.getQuickFilterValues().get(attrName));
        }
        int row = 0;
        DefaultComboBoxModel<String> colOpsComboModel = null;
        DefaultComboBoxModel<String> colOpsComboModel2 = null;
        FilterWhereClause[] filter = null;
        String colOpValue = null;
        Object colValue = null;
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].isColumnFilterable() && this.colProperties[i].getColumnType() != 12) {
                colOpValue = null;
                colValue = null;
                filter = (FilterWhereClause[])this.grid.getQuickFilterValues().get(this.colProperties[i].getColumnName());
                if (filter != null) {
                    colOpValue = filter[0].getOperator();
                    colValue = filter[0].getValue();
                }
                colOpsComboModel = new DefaultComboBoxModel<String>();
                colOpsComboModel.addElement("");
                colOpsComboModel.addElement("=");
                colOpsComboModel.addElement("<>");
                if (this.colProperties[i].getColumnType() == 19 || this.colProperties[i].getColumnType() == 11 || this.colProperties[i].getColumnType() == 13 || this.colProperties[i].getColumnType() == 8 || this.colProperties[i].getColumnType() == 14 || this.colProperties[i].getColumnType() == 0) {
                    colOpsComboModel.addElement(ClientSettings.LIKE);
                }
                if (this.colProperties[i].getColumnType() != 6) {
                    colOpsComboModel.addElement("is not null");
                    colOpsComboModel.addElement("is null");
                    colOpsComboModel.addElement(">=");
                    colOpsComboModel.addElement(">");
                    colOpsComboModel.addElement("<=");
                    colOpsComboModel.addElement("<");
                    if (ClientSettings.INCLUDE_IN_OPERATOR) {
                        colOpsComboModel.addElement("in");
                    }
                }
                JComboBox colOpsComboBox = new JComboBox(colOpsComboModel);
                if (colOpValue != null) {
                    colOpsComboBox.setSelectedItem(colOpValue);
                }
                JComponent c = this.createValueComponent(this.colProperties[i]);
                this.fPanel.add((Component)new JLabel(ClientSettings.getInstance().getResources().getResource(this.colProperties[i].getHeaderColumnName())), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.fPanel.add(colOpsComboBox, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
                JPanel aux = new JPanel();
                aux.setLayout(new FlowLayout(0, 0, 0));
                aux.add((Component)c, null);
                this.fPanel.add((Component)aux, new GridBagConstraints(2, row, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
                colOpsComboBox.addItemListener(new ComboItemListener(i, colOpsComboBox, c instanceof JPanel ? (JComponent)c.getComponent(0) : c));
                c.addFocusListener(new OpFocusListener(this.filterColOps.size(), c));
                JComponent[] cc = new JComponent[]{c};
                if (colValue instanceof ArrayList) {
                    ArrayList values = (ArrayList)colValue;
                    this.setValueComponent(c, values.get(0), this.colProperties[i]);
                    int j = 1;
                    while (j < values.size()) {
                        JComponent newc = this.createValueComponent(this.colProperties[i]);
                        newc.addFocusListener(new OpFocusListener(this.filterColOps.size(), newc));
                        JComponent[] newcc = new JComponent[cc.length + 1];
                        System.arraycopy(cc, 0, newcc, 0, cc.length);
                        newcc[newcc.length - 1] = newc;
                        cc = newcc;
                        aux.add((Component)newc, null);
                        this.setValueComponent(newc, values.get(j), this.colProperties[i]);
                        ++j;
                    }
                } else {
                    this.setValueComponent(c, colValue, this.colProperties[i]);
                }
                this.filterColNames.add(this.colProperties[i]);
                this.filterColOps.add(colOpsComboBox);
                this.filterColValues.add(cc);
                ++row;
                if (this.colProperties[i].getColumnType() == 16 || this.colProperties[i].getColumnType() == 4 || this.colProperties[i].getColumnType() == 5 || this.colProperties[i].getColumnType() == 9 || this.colProperties[i].getColumnType() == 10 || this.colProperties[i].getColumnType() == 1 || this.colProperties[i].getColumnType() == 2 || this.colProperties[i].getColumnType() == 3) {
                    colOpValue = null;
                    colValue = null;
                    if (filter != null && filter[1] != null) {
                        colOpValue = filter[1].getOperator();
                        colValue = filter[1].getValue();
                    }
                    colOpsComboModel2 = new DefaultComboBoxModel<String>();
                    colOpsComboModel2.addElement("");
                    colOpsComboModel2.addElement("=");
                    colOpsComboModel2.addElement(">=");
                    colOpsComboModel2.addElement(">");
                    colOpsComboModel2.addElement("is not null");
                    colOpsComboModel2.addElement("is null");
                    colOpsComboModel2.addElement("<=");
                    if (this.colProperties[i].getColumnType() == 19 || this.colProperties[i].getColumnType() == 11 || this.colProperties[i].getColumnType() == 13 || this.colProperties[i].getColumnType() == 8 || this.colProperties[i].getColumnType() == 14 || this.colProperties[i].getColumnType() == 0) {
                        colOpsComboModel2.addElement(ClientSettings.LIKE);
                    }
                    colOpsComboModel2.addElement("<");
                    colOpsComboModel2.addElement("<>");
                    if (ClientSettings.INCLUDE_IN_OPERATOR) {
                        colOpsComboModel2.addElement("in");
                    }
                    final JComboBox colOpsComboBox2 = new JComboBox(colOpsComboModel2);
                    if (colOpValue != null) {
                        colOpsComboBox2.setSelectedItem(colOpValue);
                    }
                    final JComponent c2 = this.createValueComponent(this.colProperties[i]);
                    c2.addFocusListener(new OpFocusListener(this.filterColOps.size(), c2));
                    this.fPanel.add(colOpsComboBox2, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
                    aux = new JPanel();
                    aux.setLayout(new FlowLayout(0, 0, 0));
                    aux.add((Component)c2, null);
                    this.fPanel.add((Component)aux, new GridBagConstraints(2, row, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
                    cc = new JComponent[]{c2};
                    if (colValue instanceof ArrayList) {
                        ArrayList values = (ArrayList)colValue;
                        this.setValueComponent(c2, values.get(0), this.colProperties[i]);
                        int j = 1;
                        while (j < values.size()) {
                            JComponent newc = this.createValueComponent(this.colProperties[i]);
                            newc.addFocusListener(new OpFocusListener(this.filterColOps.size(), newc));
                            JComponent[] newcc = new JComponent[cc.length + 1];
                            System.arraycopy(cc, 0, newcc, 0, cc.length);
                            newcc[newcc.length - 1] = newc;
                            cc = newcc;
                            aux.add((Component)newc, null);
                            this.setValueComponent(newc, values.get(j), this.colProperties[i]);
                            ++j;
                        }
                    } else {
                        this.setValueComponent(c2, colValue, this.colProperties[i]);
                    }
                    colOpsComboBox2.addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent e) {
                            if (e.getStateChange() == 1) {
                                if (colOpsComboBox2.getSelectedItem().equals("is not null") || colOpsComboBox2.getSelectedItem().equals("is null")) {
                                    c2.setEnabled(false);
                                } else {
                                    c2.setEnabled(true);
                                }
                            }
                        }
                    });
                    this.filterColNames.add(this.colProperties[i]);
                    this.filterColOps.add(colOpsComboBox2);
                    this.filterColValues.add(cc);
                    ++row;
                }
            }
            ++i;
        }
        this.fPanel.add((Component)new JLabel(""), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.fPanel.revalidate();
    }

    private void prepareSortPanel() {
        int i = 0;
        while (i < this.grid.getCurrentSortedColumns().size()) {
            this.initialOrderList.add(new String[]{this.grid.getCurrentSortedColumns().get(i).toString(), this.grid.getCurrentSortedVersusColumns().get(i).toString()});
            ++i;
        }
        ArrayList<Integer> colOrdered = new ArrayList<Integer>(this.colProperties.length);
        int i2 = 0;
        while (i2 < this.colProperties.length) {
            colOrdered.add(null);
            ++i2;
        }
        int row = 0;
        ComboModel colNamesComboModel = null;
        DefaultComboBoxModel<String> orderVersusComboModel = null;
        int i3 = 0;
        while (i3 < this.grid.getMaxSortedColumns()) {
            colNamesComboModel = new ComboModel();
            colNamesComboModel.addItem("", "");
            int j = 0;
            while (j < this.colProperties.length) {
                if (this.colProperties[j].isColumnSortable()) {
                    colNamesComboModel.addItem(this.colProperties[j].getColumnName(), ClientSettings.getInstance().getResources().getResource(this.colProperties[j].getHeaderColumnName()));
                }
                ++j;
            }
            orderVersusComboModel = new DefaultComboBoxModel<String>();
            orderVersusComboModel.addElement("");
            orderVersusComboModel.addElement("ASC");
            orderVersusComboModel.addElement("DESC");
            JComboBox colNameComboBox = new JComboBox(colNamesComboModel);
            JComboBox orderVersusComboBox = new JComboBox(orderVersusComboModel);
            this.oPanel.add(colNameComboBox, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.oPanel.add(orderVersusComboBox, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.sortColNames.add(colNameComboBox);
            this.sortVersus.add(orderVersusComboBox);
            ++row;
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.colProperties.length) {
            if (this.colProperties[i4].isColumnSortable() && !this.colProperties[i4].getSortVersus().equals("NO_SORT")) {
                colOrdered.set(this.colProperties[i4].getSortingOrder(), new Integer(i4));
            }
            ++i4;
        }
        this.oPanel.add((Component)new JLabel(""), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        int colIndex = -1;
        row = 0;
        int i5 = 0;
        while (i5 < colOrdered.size()) {
            if (colOrdered.get(i5) != null) {
                colIndex = (Integer)colOrdered.get(i5);
                ((JComboBox)this.sortColNames.get(row)).setSelectedItem(ClientSettings.getInstance().getResources().getResource(this.colProperties[colIndex].getHeaderColumnName()));
                if (this.colProperties[colIndex].getSortVersus().equals("ASC")) {
                    ((JComboBox)this.sortVersus.get(row)).setSelectedIndex(1);
                } else if (this.colProperties[colIndex].getSortVersus().equals("DESC")) {
                    ((JComboBox)this.sortVersus.get(row)).setSelectedIndex(2);
                }
                ++row;
            }
            ++i5;
        }
        this.oPanel.revalidate();
    }

    public void setLocked(boolean value) {
        this.locked = value;
        if (this.locked) {
            this.lockPanel.setIcon(this.lockImage);
        } else {
            this.lockPanel.setIcon(this.unlockImage);
        }
    }

    private void setValueComponent(JComponent result, Object initValue, Column colProperties) {
        if (colProperties.getColumnType() == 7) {
            JComboBox combo = (JComboBox)((JPanel)result).getComponent(0);
            if (initValue == null) {
                combo.setSelectedIndex(0);
            } else {
                Domain domain = ClientSettings.getInstance().getDomain(((ComboColumn)colProperties).getDomainId());
                Object couple = null;
                DomainPair[] pairs = domain.getDomainPairList();
                int i = 0;
                while (i < pairs.length) {
                    if (pairs[i].getCode().equals(initValue)) {
                        combo.setSelectedIndex(i + 1);
                        break;
                    }
                    ++i;
                }
            }
            return;
        }
        if (colProperties.getColumnType() == 6) {
            JCheckBox check = (JCheckBox)((JPanel)result).getComponent(0);
            if (initValue != null) {
                check.setSelected(initValue.equals(((CheckBoxColumn)colProperties).getPositiveValue()));
            }
            return;
        }
        switch (colProperties.getColumnType()) {
            case 1: 
            case 2: 
            case 3: {
                ((DateControl)result).setValue((Date)initValue);
                break;
            }
            case 4: {
                ((NumericControl)result).setValue(initValue == null ? null : new Double(initValue.toString()));
                break;
            }
            case 5: 
            case 9: {
                ((NumericControl)result).setValue(initValue == null ? null : new Double(initValue.toString()));
                break;
            }
            case 16: {
                ((NumericControl)result).setValue(initValue == null ? null : new Double(initValue.toString()));
                break;
            }
            case 10: {
                ((CurrencyControl)result).setValue(initValue == null ? null : new Double(initValue.toString()));
                break;
            }
            case 0: 
            case 8: 
            case 19: {
                ((TextControl)result).setValue(initValue == null ? "" : initValue.toString());
                break;
            }
            case 13: {
                ((JFormattedTextField)result).setValue(initValue == null ? "" : initValue);
                break;
            }
            default: {
                Logger.error(this.getClass().getName(), "setValueComponent", "Error while setting input control value: column type not supported", null);
            }
        }
    }

    class FormattedTextBox
    extends JFormattedTextField
    implements FormatterController {
        private FormatterController controller;

        public FormattedTextBox(FormatterController controller) {
            this.controller = controller;
        }

        public void invalidEdit() {
            try {
                if (this.controller == null) {
                    super.invalidEdit();
                } else {
                    this.controller.invalidEdit();
                }
            }
            catch (Exception ex) {
            }
        }

        public void processKeyEvent(KeyEvent e) {
            try {
                super.processKeyEvent(e);
            }
            catch (Exception ex) {
            }
        }

        public void setFormatter(JFormattedTextField.AbstractFormatter format) {
            try {
                if (this.controller == null) {
                    if (this.getFormatterFactory() == null) {
                        super.setFormatterFactory(new DefaultFormatterFactory(format));
                    } else {
                        super.setFormatter(format);
                    }
                } else {
                    this.controller.setFormatter(format);
                }
            }
            catch (Exception ex) {
            }
        }
    }

    class ComboModel
    extends DefaultComboBoxModel {
        ArrayList codes = new ArrayList();

        ComboModel() {
        }

        public void addItem(String code, String colName) {
            super.addElement(colName);
            this.codes.add(code);
        }

        public String getSelectedCode(int selectedIndex) {
            if (super.getSelectedItem() == null) {
                return null;
            }
            return this.codes.get(selectedIndex).toString();
        }
    }

    class OpFocusListener
    extends FocusAdapter {
        private JComponent field;
        private int pos;

        public OpFocusListener(int pos, JComponent field) {
            this.pos = pos;
            this.field = field;
        }

        static /* synthetic */ FilterPanel access$800(OpFocusListener x0) {
            return x0.FilterPanel.this;
        }

        public void focusGained(FocusEvent e) {
            FilterPanel.this.filterScrollPane.getHorizontalScrollBar().setValue(this.field.getLocation().x);
        }

        public void focusLost(FocusEvent e) {
            String op = ((JComboBox)FilterPanel.this.filterColOps.get(this.pos)).getSelectedItem().toString();
            if (!op.equals("is null") && !op.equals("is not null") && (op.equals("in") || ClientSettings.ALLOW_OR_OPERATOR)) {
                JComponent[] cc = (JComponent[])FilterPanel.this.filterColValues.get(this.pos);
                JPanel parentPanel = (JPanel)this.field.getParent();
                Object value = FilterPanel.this.getValueComponent(this.field, (Column)FilterPanel.this.filterColNames.get(this.pos));
                if (value != null && !"".equals(value) && this.field.equals(cc[cc.length - 1])) {
                    JComponent c = FilterPanel.this.createValueComponent((Column)FilterPanel.this.filterColNames.get(this.pos));
                    c.addFocusListener(new OpFocusListener(this.pos, c));
                    JComponent[] newcc = new JComponent[cc.length + 1];
                    System.arraycopy(cc, 0, newcc, 0, cc.length);
                    newcc[newcc.length - 1] = c;
                    FilterPanel.this.filterColValues.set(this.pos, newcc);
                    parentPanel.add((Component)c, null);
                    c.revalidate();
                    c.repaint();
                    SwingUtilities.invokeLater(new Runnable(this, c){
                        private final /* synthetic */ OpFocusListener this$1;
                        private final /* synthetic */ JComponent val$c;
                        {
                            this.this$1 = this$1;
                            this.val$c = val$c;
                        }

                        public void run() {
                            FilterPanel.access$200(OpFocusListener.access$800(this.this$1)).getHorizontalScrollBar().setValue(FilterPanel.access$200(OpFocusListener.access$800(this.this$1)).getHorizontalScrollBar().getMaximum() - FilterPanel.access$200(OpFocusListener.access$800(this.this$1)).getHorizontalScrollBar().getVisibleAmount());
                            this.val$c.requestFocus();
                        }
                    });
                } else if ((value == null || "".equals(value)) && cc.length > 1) {
                    if (parentPanel != null) {
                        parentPanel.remove(this.field);
                        parentPanel.revalidate();
                        parentPanel.repaint();
                    }
                    int j = 0;
                    while (j < cc.length) {
                        if (cc[j].equals(this.field)) {
                            JComponent[] newcc = new JComponent[cc.length - 1];
                            System.arraycopy(cc, 0, newcc, 0, j);
                            if (cc.length - 1 > j) {
                                System.arraycopy(cc, j + 1, newcc, j, cc.length - j - 1);
                            }
                            FilterPanel.this.filterColValues.set(this.pos, newcc);
                            break;
                        }
                        ++j;
                    }
                }
            }
        }
    }

    class ComboItemListener
    implements ItemListener {
        private JComponent c = null;
        private JComboBox colOpsComboBox = null;
        private int i;

        public ComboItemListener(int i, JComboBox colOpsComboBox, JComponent c) {
            this.i = i;
            this.colOpsComboBox = colOpsComboBox;
            this.c = c;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (this.colOpsComboBox.getSelectedItem().equals("is not null") || this.colOpsComboBox.getSelectedItem().equals("is null")) {
                    this.c.setEnabled(false);
                    FilterPanel.this.setValueComponent(this.c, null, FilterPanel.this.colProperties[this.i]);
                } else {
                    this.c.setEnabled(true);
                }
            }
        }
    }
}

