/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.filter.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuContainer;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import org.openswing.swing.client.CheckBoxControl;
import org.openswing.swing.client.CheckBoxListControl;
import org.openswing.swing.client.CurrencyControl;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.FormatterController;
import org.openswing.swing.client.NumericControl;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.domains.java.DomainPair;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.send.java.FilterWhereClause;
import org.openswing.swing.table.client.ListFilterController;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.CodLookupColumn;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.ComboColumn;
import org.openswing.swing.table.columns.client.CurrencyColumn;
import org.openswing.swing.table.columns.client.DecimalColumn;
import org.openswing.swing.table.columns.client.FormattedTextColumn;
import org.openswing.swing.table.columns.client.IntegerColumn;
import org.openswing.swing.table.columns.client.ProgressBarColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.filter.client.QuickFilterListener;
import org.openswing.swing.util.client.ApplicationEventQueue;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class QuickFilterPanel
extends JPanel
implements MenuElement,
MenuContainer,
KeyListener {
    private String CONTAINS;
    private String ENDS_WITH;
    private String EQUALS;
    public static final int FILTER_TYPE_RANGE = 1;
    public static final int FILTER_TYPE_VALUE = 0;
    private String STARTS_WITH;
    private String attributeName = null;
    private CheckBoxListControl checkBoxListControl;
    private Column colProperties = null;
    private ListFilterController comboFilterController = null;
    private int defaultQuickFilterCriteria;
    private Domain domain = null;
    private FilterWhereClause[] filter = null;
    private JButton filterButton = null;
    private Icon filterIcon = null;
    private QuickFilterListener filterListener = null;
    private int filterType = 0;
    private Object initValue = null;
    private JLabel label1 = new JLabel();
    private JLabel label2 = new JLabel();
    private JButton listButton = null;
    private Domain listControlDomain = null;
    private Icon listIcon;
    private JList opType;
    private JScrollPane opTypeScrollPane;
    private JPopupMenu parentPopup = null;
    private JToggleButton rangeButton = null;
    private boolean showListControl = false;
    private JComponent value1 = null;
    private JComponent value2 = null;

    public QuickFilterPanel(ListFilterController comboFilterController, int defaultQuickFilterCriteria, QuickFilterListener filterListener, int filterType, Column colProperties, FilterWhereClause[] filter, Object initValue) {
        this.EQUALS = ClientSettings.getInstance().getResources().getResource("equals");
        this.CONTAINS = ClientSettings.getInstance().getResources().getResource("contains");
        this.STARTS_WITH = ClientSettings.getInstance().getResources().getResource("starts with");
        this.ENDS_WITH = ClientSettings.getInstance().getResources().getResource("ends with");
        this.opType = new JList<String>(new String[]{this.EQUALS, this.CONTAINS, this.STARTS_WITH, this.ENDS_WITH});
        this.opTypeScrollPane = new JScrollPane();
        this.listIcon = new ImageIcon(ClientUtils.getImage(ClientSettings.LIST_FILTER_BUTTON));
        this.checkBoxListControl = new CheckBoxListControl();
        this.comboFilterController = comboFilterController;
        this.filterListener = filterListener;
        this.filterType = filterType;
        this.defaultQuickFilterCriteria = defaultQuickFilterCriteria;
        this.filter = filter;
        ApplicationEventQueue.getInstance().addKeyListener(this);
        this.filterIcon = new ImageIcon(ClientUtils.getImage("filter.gif"));
        this.rangeButton = new JToggleButton((Icon)new ImageIcon(ClientUtils.getImage("chiuso.gif")), false){

            protected void processMouseEvent(MouseEvent e) {
                if (e.getID() == 500) {
                    if (QuickFilterPanel.this.filterType == 0) {
                        QuickFilterPanel.this.filterType = 1;
                        QuickFilterPanel.this.rangeButton.setIcon(new ImageIcon(ClientUtils.getImage("aperto.gif")));
                    } else {
                        QuickFilterPanel.this.filterType = 0;
                        QuickFilterPanel.this.rangeButton.setIcon(new ImageIcon(ClientUtils.getImage("chiuso.gif")));
                    }
                    QuickFilterPanel.this.updateComponents();
                    if (QuickFilterPanel.this.parentPopup != null) {
                        QuickFilterPanel.this.parentPopup.setVisible(false);
                        QuickFilterPanel.this.parentPopup.setVisible(true);
                        QuickFilterPanel.this.parentPopup.setSelected(QuickFilterPanel.this.value1);
                    }
                    if (!QuickFilterPanel.this.value1.hasFocus()) {
                        QuickFilterPanel.this.value1.requestFocus();
                    }
                }
            }
        };
        this.rangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (QuickFilterPanel.this.filterType == 0) {
                    QuickFilterPanel.this.filterType = 1;
                    QuickFilterPanel.this.rangeButton.setIcon(new ImageIcon(ClientUtils.getImage("aperto.gif")));
                } else {
                    QuickFilterPanel.this.filterType = 0;
                    QuickFilterPanel.this.rangeButton.setIcon(new ImageIcon(ClientUtils.getImage("chiuso.gif")));
                }
                QuickFilterPanel.this.updateComponents();
                if (QuickFilterPanel.this.parentPopup != null) {
                    QuickFilterPanel.this.parentPopup.setVisible(false);
                    QuickFilterPanel.this.parentPopup.setVisible(true);
                    QuickFilterPanel.this.parentPopup.setSelected(QuickFilterPanel.this.value1);
                }
                if (!QuickFilterPanel.this.value1.hasFocus()) {
                    QuickFilterPanel.this.value1.requestFocus();
                }
            }
        });
        this.filterButton = new JButton(this.filterIcon){

            protected void processMouseEvent(MouseEvent e) {
                if (e.getID() == 500) {
                    QuickFilterPanel.this.filter();
                }
            }
        };
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuickFilterPanel.this.filter();
            }
        });
        this.listButton = new JButton(this.listIcon){

            protected void processMouseEvent(MouseEvent e) {
                if (e.getID() == 500) {
                    QuickFilterPanel.this.showComboBoxFilter();
                }
            }
        };
        this.listButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuickFilterPanel.this.showComboBoxFilter();
            }
        });
        this.setFilterConfig(filterType, colProperties, initValue);
        if (comboFilterController != null && filter != null && filter[1] == null && filter[0].getValue() != null && filter[0].getValue() instanceof List) {
            List values = (List)filter[0].getValue();
            this.showComboBoxFilter();
            this.checkBoxListControl.setValue(values);
        }
    }

    private JComponent createValueComponent() {
        JComponent result = null;
        if (this.domain != null) {
            Object couple = null;
            DomainPair[] pairs = this.domain.getDomainPairList();
            Object[] items = new Object[pairs.length];
            int selIndex = -1;
            int i = 0;
            while (i < items.length) {
                items[i] = ClientSettings.getInstance().getResources().getResource(pairs[i].getDescription());
                if (this.initValue != null && pairs[i].getCode().equals(this.initValue)) {
                    selIndex = i;
                }
                ++i;
            }
            final JList<Object> list = new JList<Object>(items);
            final int selectedIndex = selIndex;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    list.setSelectedIndex(selectedIndex);
                    list.ensureIndexIsVisible(selectedIndex);
                }
            });
            list.setToolTipText("");
            list.setVisibleRowCount(1);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.getViewport().add(list, null);
            scrollPane.getVerticalScrollBar().addAdjustmentListener(new ListAdjustmentListener(list));
            list.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        QuickFilterPanel.this.valueKeyPressed(e);
                    }
                }
            });
            scrollPane.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        QuickFilterPanel.this.valueKeyPressed(e);
                    }
                }
            });
            list.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        QuickFilterPanel.this.valueKeyPressed(e);
                    }
                }
            });
            return scrollPane;
        }
        switch (this.colProperties.getColumnType()) {
            case 1: 
            case 2: 
            case 3: {
                result = new DateControl();
                ((DateControl)result).setDateType(this.colProperties.getColumnType());
                if (this.initValue != null) {
                    java.util.Date c = (java.util.Date)this.initValue;
                    ((DateControl)result).setDate(c);
                } else {
                    java.util.Date c = new java.util.Date();
                    ((DateControl)result).setDate(c);
                }
                result.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            QuickFilterPanel.this.valueKeyPressed(e);
                        }
                    }
                });
                break;
            }
            case 6: {
                result = new CheckBoxControl();
                if (this.initValue != null) {
                    ((CheckBoxControl)result).setValue(this.initValue);
                } else {
                    ((CheckBoxControl)result).setValue(Boolean.TRUE);
                }
                result.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        block3: {
                            block2: {
                                if (e.getKeyCode() == 10) break block2;
                                if (e.getKeyCode() != 32) break block3;
                            }
                            QuickFilterPanel.this.valueKeyPressed(e);
                        }
                    }
                });
                break;
            }
            case 4: {
                NumericControl num = new NumericControl();
                num.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        QuickFilterPanel.this.valueKeyPressed(e);
                    }
                });
                if (this.colProperties != null) {
                    try {
                        num.setDecimals(0);
                        num.setMaxValue(((IntegerColumn)this.colProperties).getMaxValue());
                        num.setMinValue(((IntegerColumn)this.colProperties).getMinValue());
                    }
                    catch (ClassCastException ex) {
                        Logger.error(this.getClass().getName(), "QuickFilterPanel", "Error while creating input field of type integer", ex);
                    }
                }
                num.setText(this.initValue == null ? null : this.initValue.toString());
                result = num;
                break;
            }
            case 5: 
            case 9: {
                NumericControl num = new NumericControl();
                num.setPreferredSize(new Dimension(100, 20));
                num.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        QuickFilterPanel.this.valueKeyPressed(e);
                    }
                });
                if (this.colProperties != null) {
                    try {
                        num.setDecimals(((DecimalColumn)this.colProperties).getDecimals());
                        num.setMaxValue(((DecimalColumn)this.colProperties).getMaxValue());
                        num.setMinValue(((DecimalColumn)this.colProperties).getMinValue());
                    }
                    catch (ClassCastException ex) {
                        Logger.error(this.getClass().getName(), "QuickFilterPanel", "Error while creating input field of type decimal", ex);
                    }
                }
                num.setText(this.initValue == null ? null : this.initValue.toString());
                result = num;
                break;
            }
            case 16: {
                NumericControl num = new NumericControl();
                num.setPreferredSize(new Dimension(100, 20));
                num.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        QuickFilterPanel.this.valueKeyPressed(e);
                    }
                });
                if (this.colProperties != null) {
                    try {
                        num.setMaxValue(((ProgressBarColumn)this.colProperties).getMaxValue());
                        num.setMinValue(((ProgressBarColumn)this.colProperties).getMinValue());
                    }
                    catch (ClassCastException ex) {
                        Logger.error(this.getClass().getName(), "QuickFilterPanel", "Error while creating input field of type decimal", ex);
                    }
                }
                num.setText(this.initValue == null ? null : this.initValue.toString());
                result = num;
                break;
            }
            case 10: {
                CurrencyControl num = new CurrencyControl();
                num.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        QuickFilterPanel.this.valueKeyPressed(e);
                    }
                });
                if (this.colProperties != null) {
                    try {
                        num.setDecimals(((CurrencyColumn)this.colProperties).getDecimals());
                        num.setMaxValue(((CurrencyColumn)this.colProperties).getMaxValue());
                        num.setMinValue(((CurrencyColumn)this.colProperties).getMinValue());
                    }
                    catch (ClassCastException ex) {
                        Logger.error(this.getClass().getName(), "QuickFilterPanel", "Error while creating input field of type currency", ex);
                    }
                }
                num.setText(this.initValue == null ? null : this.initValue.toString());
                result = num;
                break;
            }
            case 0: {
                TextControl edit = new TextControl();
                edit.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            QuickFilterPanel.this.valueKeyPressed(e);
                        }
                    }
                });
                try {
                    edit.setMaxCharacters(((TextColumn)this.colProperties).getMaxCharacters());
                }
                catch (ClassCastException ex) {
                    Logger.error(this.getClass().getName(), "createValueComponent", "Column property not supported", ex);
                }
                edit.setText(this.initValue == null ? "" : this.initValue.toString());
                result = edit;
                break;
            }
            case 19: {
                TextControl edit = new TextControl();
                edit.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            QuickFilterPanel.this.valueKeyPressed(e);
                        }
                    }
                });
                edit.setText(this.initValue == null ? "" : this.initValue.toString());
                result = edit;
                break;
            }
            case 13: {
                FormattedTextBox edit = new FormattedTextBox(((FormattedTextColumn)this.colProperties).getController());
                edit.setFormatterFactory(((FormattedTextColumn)this.colProperties).getFormatterFactory());
                edit.setFormatter(((FormattedTextColumn)this.colProperties).getFormatter());
                edit.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            QuickFilterPanel.this.valueKeyPressed(e);
                        }
                    }
                });
                edit.setValue(this.initValue == null ? "" : this.initValue);
                result = edit;
                break;
            }
            case 8: {
                TextControl edit = new TextControl();
                edit.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            QuickFilterPanel.this.valueKeyPressed(e);
                        }
                    }
                });
                try {
                    edit.setMaxCharacters(((CodLookupColumn)this.colProperties).getMaxCharacters());
                }
                catch (ClassCastException ex) {
                    Logger.error(this.getClass().getName(), "createValueComponent", "Column property not supported", ex);
                }
                edit.setText(this.initValue == null ? "" : this.initValue.toString());
                result = edit;
                break;
            }
            default: {
                Logger.error(this.getClass().getName(), "createValueComponent", "Column property not supported", null);
            }
        }
        result.setPreferredSize(new Dimension(120, 20));
        result.setMinimumSize(new Dimension(120, 20));
        return result;
    }

    private void filter() {
        int type = this.colProperties.getColumnType();
        if (this.filterType == 0) {
            Object value = this.getValue1();
            if (value != null && value.toString().indexOf("%") == -1 && this.opType.getSelectedIndex() > 0 && this.domain == null && type != 1 && type != 2 && type != 3 && type != 4 && type != 5 && type != 9 && type != 10) {
                if (this.opType.getSelectedValue().equals(this.CONTAINS)) {
                    value = "%" + value + "%";
                } else if (this.opType.getSelectedValue().equals(this.STARTS_WITH)) {
                    value = value + "%";
                } else if (this.opType.getSelectedValue().equals(this.ENDS_WITH)) {
                    value = "%" + value;
                }
            }
            this.filterListener.filter(this.colProperties, value, null);
        } else {
            this.filterListener.filter(this.colProperties, this.getValue1(), this.getValue2());
        }
    }

    public Component getComponent() {
        return this;
    }

    public final int getFilterType() {
        return this.filterType;
    }

    public JPopupMenu getParentPopup() {
        return this.parentPopup;
    }

    public MenuElement[] getSubElements() {
        return null;
    }

    private Object getValue(JComponent value) {
        if (this.showListControl) {
            return this.checkBoxListControl.getValue();
        }
        Object result = null;
        if (this.domain != null) {
            int idx = ((JList)((JScrollPane)value).getViewport().getComponent(0)).getSelectedIndex();
            DomainPair[] pairs = this.domain.getDomainPairList();
            return pairs[idx].getCode();
        }
        switch (this.colProperties.getColumnType()) {
            case 1: 
            case 2: 
            case 3: {
                if (((DateControl)value).getDate() == null) {
                    result = null;
                    break;
                }
                if (this.colProperties.getColumnType() == 1) {
                    result = new Date(((DateControl)value).getDate().getTime());
                    break;
                }
                result = new Timestamp(((DateControl)value).getDate().getTime());
                break;
            }
            case 6: {
                result = ((CheckBoxControl)value).getValue();
                if (result == null || result instanceof Boolean && !((Boolean)result).booleanValue()) {
                    result = ((CheckBoxColumn)this.colProperties).getNegativeValue();
                    break;
                }
                result = ((CheckBoxColumn)this.colProperties).getPositiveValue();
                break;
            }
            case 4: {
                result = (BigDecimal)((NumericControl)value).getValue();
                break;
            }
            case 5: 
            case 9: {
                result = (BigDecimal)((NumericControl)value).getValue();
                break;
            }
            case 16: {
                result = (BigDecimal)((NumericControl)value).getValue();
                break;
            }
            case 10: {
                result = (BigDecimal)((CurrencyControl)value).getValue();
                break;
            }
            case 0: 
            case 8: 
            case 19: {
                result = ((TextControl)value).getText();
                break;
            }
            case 13: {
                try {
                    ((JFormattedTextField)value).commitEdit();
                    result = ((JFormattedTextField)value).getValue();
                }
                catch (ParseException ex) {
                    result = null;
                }
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public Object getValue1() {
        return this.getValue(this.value1);
    }

    public Object getValue2() {
        if (this.showListControl) {
            return null;
        }
        Object result = this.getValue(this.value2);
        if (result instanceof java.util.Date) {
            Calendar c = GregorianCalendar.getInstance();
            c.setTime((java.util.Date)result);
            c.set(5, c.get(5) + 1);
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            result = this.colProperties.getColumnType() == 1 ? new Date(c.getTime().getTime()) : new Timestamp(c.getTime().getTime());
        }
        return result;
    }

    private void jbInit() throws Exception {
        this.label1.setPreferredSize(new Dimension(70, 20));
        this.label1.setMinimumSize(new Dimension(70, 20));
        this.setLayout(new GridBagLayout());
        this.label2.setText(ClientSettings.getInstance().getResources().getResource("To value"));
        this.value1 = this.createValueComponent();
        this.value2 = this.createValueComponent();
        this.rangeButton.setSelectedIcon(new ImageIcon(ClientUtils.getImage("aperto.gif")));
        this.rangeButton.setContentAreaFilled(false);
        this.rangeButton.setCursor(new Cursor(12));
        this.rangeButton.setPreferredSize(new Dimension(20, 20));
        this.rangeButton.setMaximumSize(new Dimension(20, 20));
        this.rangeButton.setMinimumSize(new Dimension(20, 20));
        this.rangeButton.setBorderPainted(false);
        this.rangeButton.setSelected(this.filterType == 1);
        this.filterButton.setContentAreaFilled(false);
        this.filterButton.setPreferredSize(new Dimension(20, 20));
        this.filterButton.setMinimumSize(new Dimension(20, 20));
        this.filterButton.setMaximumSize(new Dimension(20, 20));
        this.filterButton.setBorderPainted(false);
        this.filterButton.setCursor(new Cursor(12));
        this.listButton.setContentAreaFilled(false);
        this.listButton.setPreferredSize(new Dimension(20, 20));
        this.listButton.setMinimumSize(new Dimension(20, 20));
        this.listButton.setMaximumSize(new Dimension(20, 20));
        this.listButton.setBorderPainted(false);
        this.listButton.setCursor(new Cursor(12));
        this.layoutComponents();
        this.updateComponents();
        if (!this.value1.hasFocus()) {
            this.value1.requestFocus();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.parentPopup.getParent();
            this.parentPopup.setVisible(false);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void layoutComponents() {
        this.removeAll();
        this.add((Component)this.label1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.label2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.opType.setVisibleRowCount(1);
        this.opTypeScrollPane.getViewport().removeAll();
        this.opTypeScrollPane.getViewport().add(this.opType);
        if (this.colProperties.getColumnType() == 8 || this.colProperties.getColumnType() == 0) {
            this.add((Component)this.opTypeScrollPane, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        }
        this.add((Component)this.value1, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)this.value2, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)this.rangeButton, new GridBagConstraints(3, 0, 1, 1, 10.0, 0.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
        if (this.comboFilterController != null) {
            this.add((Component)this.listButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 0, 0, 0), 0, 0));
        }
        this.add((Component)this.filterButton, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 11, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.opTypeScrollPane.getVerticalScrollBar().addAdjustmentListener(new ListAdjustmentListener(this.opType));
    }

    public void menuSelectionChanged(boolean isIncluded) {
        if (!isIncluded) {
            this.transferFocus();
        } else {
            this.requestFocus();
        }
    }

    public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    public final void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!QuickFilterPanel.this.value1.hasFocus()) {
                    Container window = QuickFilterPanel.this.value1;
                    while (window != null && !(window instanceof Window)) {
                        window = window.getParent();
                    }
                    if (window != null || !((Window)window).isFocusableWindow()) {
                        ((Window)window).setFocusableWindowState(true);
                    }
                    QuickFilterPanel.this.value1.requestFocus();
                }
            }
        });
    }

    private void setFilterConfig(int filterType, Column colProperties, Object initValue) {
        this.attributeName = colProperties.getColumnName();
        this.filterType = filterType;
        this.initValue = initValue;
        this.colProperties = colProperties;
        this.domain = colProperties.getColumnType() == 7 ? ClientSettings.getInstance().getDomain(((ComboColumn)colProperties).getDomainId()) : null;
        try {
            this.jbInit();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    QuickFilterPanel.this.opType.ensureIndexIsVisible(QuickFilterPanel.this.defaultQuickFilterCriteria);
                    QuickFilterPanel.this.opType.setSelectedIndex(QuickFilterPanel.this.defaultQuickFilterCriteria);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setParentPopup(JPopupMenu parentPopup) {
        this.parentPopup = parentPopup;
    }

    public final void setVisible(boolean v) {
        super.setVisible(v);
        if (!v) {
            ApplicationEventQueue.getInstance().removeKeyListener(this);
        }
    }

    private void showComboBoxFilter() {
        if (this.listControlDomain == null) {
            if (this.colProperties.getColumnType() == 7) {
                this.listControlDomain = ((ComboColumn)this.colProperties).getDomain();
            } else {
                Response res = this.comboFilterController.getListControlValues(this.attributeName);
                if (res.isError()) {
                    OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while loading data") + ":\n" + res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Loading Data Error"), 0);
                    return;
                }
                List rows = ((VOListResponse)res).getRows();
                this.listControlDomain = new Domain("DOMAIN_LIST_FILTER_" + this.attributeName);
                int i = 0;
                while (i < rows.size()) {
                    this.listControlDomain.addDomainPair(rows.get(i), rows.get(i).toString());
                    ++i;
                }
                this.checkBoxListControl.setTranslateItemDescriptions(false);
            }
            this.checkBoxListControl.setDomain(this.listControlDomain);
        }
        if (!this.showListControl) {
            this.showListControl = true;
            this.add((Component)this.checkBoxListControl, new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.remove(this.label1);
            this.remove(this.label2);
            this.remove(this.rangeButton);
            this.remove(this.value1);
            this.remove(this.value2);
            this.remove(this.opTypeScrollPane);
            if (this.parentPopup != null) {
                this.parentPopup.setVisible(false);
                this.parentPopup.setVisible(true);
            }
        } else {
            this.showListControl = false;
            this.layoutComponents();
            if (this.parentPopup != null) {
                this.parentPopup.setVisible(false);
                this.parentPopup.setVisible(true);
            }
            if (!this.value1.hasFocus()) {
                this.value1.requestFocus();
            }
        }
    }

    private void updateComponents() {
        switch (this.filterType) {
            case 0: {
                this.label1.setText(ClientSettings.getInstance().getResources().getResource("Filter by"));
                this.label2.setVisible(false);
                this.value2.setVisible(false);
                break;
            }
            case 1: {
                this.label1.setText(ClientSettings.getInstance().getResources().getResource("From value"));
                this.label2.setVisible(true);
                this.value2.setVisible(true);
            }
        }
    }

    private void valueKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.filter();
            if (this.parentPopup != null) {
                this.parentPopup.setVisible(false);
            }
        }
    }

    class FormattedTextBox
    extends JFormattedTextField
    implements FormatterController {
        private FormatterController controller;

        public FormattedTextBox(FormatterController controller) {
            this.controller = controller;
        }

        public void invalidEdit() {
            try {
                if (this.controller == null) {
                    super.invalidEdit();
                } else {
                    this.controller.invalidEdit();
                }
            }
            catch (Exception ex) {
            }
        }

        public void processKeyEvent(KeyEvent e) {
            try {
                super.processKeyEvent(e);
            }
            catch (Exception ex) {
            }
        }

        public void setFormatter(JFormattedTextField.AbstractFormatter format) {
            try {
                if (this.controller == null) {
                    if (this.getFormatterFactory() == null) {
                        super.setFormatterFactory(new DefaultFormatterFactory(format));
                    } else {
                        super.setFormatter(format);
                    }
                } else {
                    this.controller.setFormatter(format);
                }
            }
            catch (Exception ex) {
            }
        }
    }

    class ListAdjustmentListener
    implements AdjustmentListener {
        JList theList = null;

        public ListAdjustmentListener(JList theList) {
            this.theList = theList;
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (this.theList.getHeight() > 0 && e.getValue() > 0) {
                this.theList.setSelectedIndex((e.getValue() + 20) / 20);
            } else {
                this.theList.setSelectedIndex(0);
            }
        }
    }
}

