/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.model.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.columns.client.ButtonColumn;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.DecimalColumn;
import org.openswing.swing.table.model.client.VOListAdapter;
import org.openswing.swing.table.model.client.VOListTableModelListener;

public class VOListTableModel
extends AbstractTableModel {
    private ArrayList changedRows = new ArrayList();
    private Hashtable changedVOs = new Hashtable();
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    private Vector data;
    private VOListAdapter fieldAdapter;
    private int mode = 0;
    private VOListTableModelListener modelListener = null;
    private boolean modified = false;

    public VOListTableModel(VOListAdapter fieldAdapter, VOListTableModelListener modelListener) {
        this.fieldAdapter = fieldAdapter;
        this.data = new Vector();
        this.modelListener = modelListener;
        this.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (VOListTableModel.this.mode == 2) {
                    Integer selRow = new Integer(e.getFirstRow());
                    if (!VOListTableModel.this.changedRows.contains(selRow)) {
                        VOListTableModel.this.changedRows.add(selRow);
                    }
                }
            }
        });
    }

    public final void addObject(ValueObject object) {
        int index = this.data.size();
        this.data.addElement(object);
        this.modified = true;
        this.fireTableRowsInserted(index, index);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final void clear() {
        this.data.removeAllElements();
        this.modified = true;
    }

    public final void clearModified() {
        this.modified = false;
    }

    public final ArrayList getChangedRowIndexes() {
        return this.changedRows;
    }

    public final int[] getChangedRowNumbers() {
        int[] rowNumbers = new int[this.changedRows.size()];
        int i = 0;
        while (i < rowNumbers.length) {
            rowNumbers[i] = (Integer)this.changedRows.get(i);
            ++i;
        }
        return rowNumbers;
    }

    public final ArrayList getChangedRows() {
        ArrayList<ValueObject> voList = new ArrayList<ValueObject>();
        int i = 0;
        while (i < this.changedRows.size()) {
            voList.add(this.getObjectForRow((Integer)this.changedRows.get(i)));
            ++i;
        }
        return voList;
    }

    public final Class getColumnClass(int column) {
        return this.fieldAdapter.getFieldClass(column);
    }

    public final int getColumnCount() {
        return this.fieldAdapter.getFieldCount();
    }

    public final String getColumnName(int column) {
        return this.fieldAdapter.getFieldName(column);
    }

    public final int getColumnType(int column) {
        return this.fieldAdapter.getFieldType(column);
    }

    public final Vector getDataVector() {
        return this.data;
    }

    public final Object getField(int row, String attributeName) {
        int colIndex = this.fieldAdapter.getFieldIndex(attributeName);
        if (colIndex != -1) {
            return this.fieldAdapter.getField(this.getObjectForRow(row), colIndex);
        }
        return null;
    }

    public final int getMode() {
        return this.mode;
    }

    public final ValueObject getObjectForRow(int row) {
        if (row < this.data.size() && row >= 0) {
            return (ValueObject)this.data.elementAt(row);
        }
        return null;
    }

    public final ArrayList getOldVOsChanged() {
        ArrayList voList = new ArrayList();
        int i = 0;
        while (i < this.changedRows.size()) {
            voList.add(this.changedVOs.get(this.changedRows.get(i)));
            ++i;
        }
        return voList;
    }

    public final int getRowCount() {
        return this.data.size();
    }

    public final int getRowForObject(ValueObject object) {
        return this.data.indexOf(object);
    }

    public final Object getValueAt(int row, int column) {
        if (this.data.size() - 1 < row) {
            return null;
        }
        ValueObject object = (ValueObject)this.data.elementAt(row);
        return this.fieldAdapter.getField(object, column);
    }

    public final Class getValueObjectType() {
        return this.fieldAdapter.getValueObjectType();
    }

    public final void insertObjectAt(ValueObject object, int row) {
        this.data.insertElementAt(object, row);
        this.modified = true;
        this.fireTableRowsInserted(row, row);
    }

    public final boolean isCellEditable(int row, int column) {
        try {
            if (this.mode == 0) {
                Column col = this.fieldAdapter.getFieldColumn(column);
                if (col.getColumnType() == 11 && ((ButtonColumn)col).isEnableInReadOnlyMode()) {
                    return this.fieldAdapter.getTableContainer().isCellEditable(this.fieldAdapter.getGrids().getGridControl(), row, this.fieldAdapter.getFieldName(column));
                }
                if (col.getColumnType() == 19) {
                    return this.fieldAdapter.getTableContainer().isCellEditable(this.fieldAdapter.getGrids().getGridControl(), row, this.fieldAdapter.getFieldName(column));
                }
                if (col.getColumnType() == 6 && ((CheckBoxColumn)col).isEnableInReadOnlyMode()) {
                    return this.fieldAdapter.getTableContainer().isCellEditable(this.fieldAdapter.getGrids().getGridControl(), row, this.fieldAdapter.getFieldName(column));
                }
                return false;
            }
            if (this.mode == 1) {
                if (this.fieldAdapter.getGrids().isInsertRowsOnTop()) {
                    if (row < this.changedRows.size()) {
                        return this.fieldAdapter.getTableContainer().isCellEditable(this.fieldAdapter.getGrids().getGridControl(), row, this.fieldAdapter.getFieldName(column));
                    }
                    return false;
                }
                if (row >= this.getRowCount() - this.changedRows.size()) {
                    return this.fieldAdapter.getTableContainer().isCellEditable(this.fieldAdapter.getGrids().getGridControl(), row, this.fieldAdapter.getFieldName(column));
                }
                return false;
            }
            if (this.fieldAdapter.getGrids() != null && this.fieldAdapter.getGrids().isEditOnSingleRow() && row != this.fieldAdapter.getGrids().getCurrentEditingRow()) {
                return false;
            }
            return this.fieldAdapter.getTableContainer().isCellEditable(this.fieldAdapter.getGrids().getGridControl(), row, this.fieldAdapter.getFieldName(column));
        }
        catch (Exception ex) {
            Logger.error(this.getClass().getName(), "isCellEditable", "Error defining cell editability", ex);
            return false;
        }
    }

    public final boolean isModified() {
        return this.modified;
    }

    private boolean isValueChanged(Object value, int row, int column) {
        Object oldValue = this.getValueAt(row, column);
        if (this.isCellEditable(row, column)) {
            if (oldValue != null && oldValue instanceof Number && value instanceof Double) {
                oldValue = new Double(oldValue.toString());
            }
            if (value != null && value instanceof BigDecimal && oldValue != null && this.fieldAdapter.getFieldClass(column).equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = VOListTableModel.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                value = this.fieldAdapter.getFieldColumn(column) instanceof DecimalColumn && ((DecimalColumn)this.fieldAdapter.getFieldColumn(column)).getDecimals() > 0 ? new BigDecimal(value.toString()).setScale(((DecimalColumn)this.fieldAdapter.getFieldColumn(column)).getDecimals(), 4) : new BigDecimal(value.toString()).setScale(((BigDecimal)oldValue).scale(), 4);
            } else if (value != null && value instanceof BigDecimal && (this.fieldAdapter.getFieldClass(column).equals(class$java$lang$Integer == null ? (class$java$lang$Integer = VOListTableModel.class$("java.lang.Integer")) : class$java$lang$Integer) || this.fieldAdapter.getFieldClass(column).equals(Integer.TYPE))) {
                value = new Integer(value.toString());
            } else if (value != null && value instanceof BigDecimal && (this.fieldAdapter.getFieldClass(column).equals(class$java$lang$Double == null ? (class$java$lang$Double = VOListTableModel.class$("java.lang.Double")) : class$java$lang$Double) || this.fieldAdapter.getFieldClass(column).equals(Double.TYPE))) {
                value = new Double(value.toString());
            } else if (value != null && value instanceof BigDecimal && (this.fieldAdapter.getFieldClass(column).equals(class$java$lang$Long == null ? (class$java$lang$Long = VOListTableModel.class$("java.lang.Long")) : class$java$lang$Long) || this.fieldAdapter.getFieldClass(column).equals(Long.TYPE))) {
                value = new Long(value.toString());
            } else if (value != null && value instanceof BigDecimal && (this.fieldAdapter.getFieldClass(column).equals(class$java$lang$Short == null ? (class$java$lang$Short = VOListTableModel.class$("java.lang.Short")) : class$java$lang$Short) || this.fieldAdapter.getFieldClass(column).equals(Short.TYPE))) {
                value = new Short(value.toString());
            } else if (value != null && value instanceof BigDecimal && (this.fieldAdapter.getFieldClass(column).equals(class$java$lang$Float == null ? (class$java$lang$Float = VOListTableModel.class$("java.lang.Float")) : class$java$lang$Float) || this.fieldAdapter.getFieldClass(column).equals(Float.TYPE))) {
                value = new Float(value.toString());
            }
            if (oldValue == null && value != null || oldValue != null && value == null || oldValue != null && !oldValue.equals(value)) {
                return true;
            }
        }
        return false;
    }

    public final void removeObjectAt(int row) {
        this.data.removeElementAt(row);
        this.modified = true;
        this.fireTableRowsDeleted(row, row);
    }

    public final void setField(int row, String attributeName, Object value) {
        try {
            if (this.mode == 2 && !this.changedVOs.containsKey(new Integer(row)) && row < this.getRowCount() - this.fieldAdapter.getGrids().getCurrentNumberOfNewRows()) {
                this.changedVOs.put(new Integer(row), this.getObjectForRow(row).clone());
            }
            if (this.isValueChanged(value, row, this.fieldAdapter.getFieldIndex(attributeName)) && !this.changedRows.contains(new Integer(row))) {
                this.changedRows.add(new Integer(row));
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.error(this.getClass().getName(), "setField", "Error while duplicating the edited v.o.", ex);
        }
        this.fieldAdapter.setField(this.getObjectForRow(row), attributeName, value);
    }

    public final void setMode(int mode) {
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new UnsupportedOperationException("Mode not supported: " + mode);
        }
        this.mode = mode;
        this.changedRows.clear();
        this.changedVOs.clear();
        if (mode == 1) {
            try {
                if (this.fieldAdapter.getGrids().isInsertRowsOnTop()) {
                    this.insertObjectAt((ValueObject)this.fieldAdapter.getValueObjectType().getConstructor(new Class[0]).newInstance(new Object[0]), 0);
                    this.changedRows.add(new Integer(0));
                } else {
                    this.insertObjectAt((ValueObject)this.fieldAdapter.getValueObjectType().getConstructor(new Class[0]).newInstance(new Object[0]), this.getRowCount());
                    this.changedRows.add(new Integer(this.getRowCount() - 1));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            catch (Error er) {
                er.printStackTrace();
            }
        }
        this.modelListener.modeChanged(mode);
    }

    public final boolean setValue(Object value, int row, int column) {
        try {
            if (this.mode == 2 && !this.changedVOs.containsKey(new Integer(row)) && row < this.getRowCount() - this.fieldAdapter.getGrids().getCurrentNumberOfNewRows()) {
                this.changedVOs.put(new Integer(row), this.getObjectForRow(row).clone());
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.error(this.getClass().getName(), "setValueAt", "Error while duplicating the edited v.o.", ex);
        }
        Object oldValue = this.getValueAt(row, column);
        if (this.isCellEditable(row, column)) {
            if (this.isValueChanged(value, row, column)) {
                super.setValueAt(value, row, column);
                boolean isOk = this.fieldAdapter.getTableContainer().validateCell(row, this.fieldAdapter.getFieldName(column), oldValue, value);
                if (isOk) {
                    ValueObject object = (ValueObject)this.data.elementAt(row);
                    this.fieldAdapter.setField(object, column, value);
                    this.modified = true;
                    this.fireTableCellUpdated(row, column);
                    return true;
                }
                return false;
            }
            return true;
        }
        super.setValueAt(value, row, column);
        ValueObject object = (ValueObject)this.data.elementAt(row);
        this.fieldAdapter.setField(object, column, value);
        this.modified = false;
        this.fireTableCellUpdated(row, column);
        return true;
    }

    public final void setValueAt(Object value, int row, int column) {
        this.setValue(value, row, column);
    }

    public final void updateObjectAt(ValueObject object, int row) {
        try {
            this.data.setElementAt(object, row);
        }
        catch (Exception ex) {
            Logger.error(this.getClass().getName(), "updateObjectAt", "Error on updating ValueObject", ex);
        }
    }

    public final void updateObjectAt(int row) {
        if (row < 0 || row >= this.data.size()) {
            throw new IllegalArgumentException("Row out of bounds");
        }
        this.fireTableRowsUpdated(row, row);
    }

    public final void updateValueObjectsAt(int[] rowNumbers, ValueObject[] objects) {
        if (rowNumbers.length != objects.length) {
            Logger.error(this.getClass().getName(), "updateValueObjectsAt", "VaLueObjects length is not equals to rowNumbers length.", null);
            return;
        }
        int i = 0;
        while (i < rowNumbers.length) {
            this.updateObjectAt(objects[i], rowNumbers[i]);
            ++i;
        }
    }
}

