/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.profiles.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openswing.swing.message.send.java.FilterWhereClause;
import org.openswing.swing.table.profiles.java.GridProfile;
import org.openswing.swing.table.profiles.java.GridProfileDescription;
import org.openswing.swing.table.profiles.java.GridProfileManager;

public class FileGridProfileManager
extends GridProfileManager {
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");

    public void deleteAllGridProfileIds(String functionId) throws Throwable {
        String userHome = System.getProperty("user.home").replace('\\', '/');
        if (!userHome.endsWith("/")) {
            userHome = userHome + "/";
        }
        userHome = userHome + "profiles";
        File dir = new File(userHome);
        dir.mkdirs();
        File f = new File(userHome + "/" + functionId.replace(' ', '_') + "_" + this.getUsername().replace(' ', '_') + ".ini");
        if (f.exists()) {
            f.delete();
        }
    }

    public void deleteAllGridProfiles(final String functionId) throws Throwable {
        File dir;
        File[] files;
        String userHome = System.getProperty("user.home").replace('\\', '/');
        if (!userHome.endsWith("/")) {
            userHome = userHome + "/";
        }
        if ((files = (dir = new File(userHome = userHome + "profiles")).listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().indexOf(functionId.replace(' ', '_') + "_") != -1 && pathname.getName().endsWith(".cfg");
            }
        })) != null) {
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        }
    }

    public void deleteUserProfile(String functionId, Object id) throws Throwable {
        String userHome = System.getProperty("user.home").replace('\\', '/');
        if (!userHome.endsWith("/")) {
            userHome = userHome + "/";
        }
        userHome = userHome + "profiles";
        File dir = new File(userHome);
        dir.mkdirs();
        File f = new File(userHome + "/" + id);
        if (!f.exists()) {
            throw new IOException("File not found: " + id);
        }
        f.delete();
    }

    public final GridProfile getDefaultProfile(final String functionId) throws Throwable {
        String userHome = System.getProperty("user.home").replace('\\', '/');
        if (!userHome.endsWith("/")) {
            userHome = userHome + "/";
        }
        userHome = userHome + "profiles";
        File dir = new File(userHome);
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().startsWith(functionId.replace(' ', '_') + "_" + FileGridProfileManager.this.getUsername().replace(' ', '_') + "_") && pathname.getName().endsWith(".cfg");
            }
        });
        GridProfile profile = null;
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                profile = this.getUserProfile(functionId, files[i].getName());
                if (profile.isDefaultProfile()) {
                    return profile;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLastGridDigest(String functionId) throws Throwable {
        String string;
        String userHome = System.getProperty("user.home").replace('\\', '/');
        if (!userHome.endsWith("/")) {
            userHome = userHome + "/";
        }
        userHome = userHome + "profiles";
        File dir = new File(userHome);
        dir.mkdirs();
        File f = new File(userHome + "/" + functionId.replace(' ', '_') + ".dig");
        if (!f.exists()) {
            return null;
        }
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                string = br.readLine();
                Object var8_8 = null;
            }
            catch (Throwable ex) {
                throw new IOException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                br.close();
                throw throwable;
            }
            catch (Exception ex1) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ex1) {
            return string;
        }
        br.close();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getLastGridProfileId(String functionId) throws Throwable {
        String string;
        String userHome = System.getProperty("user.home").replace('\\', '/');
        if (!userHome.endsWith("/")) {
            userHome = userHome + "/";
        }
        userHome = userHome + "profiles";
        File dir = new File(userHome);
        dir.mkdirs();
        File f = new File(userHome + "/" + functionId.replace(' ', '_') + "_" + this.getUsername().replace(' ', '_') + ".ini");
        if (!f.exists()) {
            return null;
        }
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                string = br.readLine();
                Object var8_8 = null;
            }
            catch (Throwable ex) {
                throw new IOException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                br.close();
                throw throwable;
            }
            catch (Exception ex1) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ex1) {
            return string;
        }
        br.close();
        return string;
    }

    /*
     * Loose catch block
     */
    public GridProfile getUserProfile(String functionId, Object id) throws Throwable {
        String userHome = System.getProperty("user.home").replace('\\', '/');
        if (!userHome.endsWith("/")) {
            userHome = userHome + "/";
        }
        userHome = userHome + "profiles";
        File dir = new File(userHome);
        File f = new File(userHome + "/" + id);
        if (!f.exists()) {
            throw new IOException("File not found: " + id);
        }
        BufferedReader br = null;
        br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        String description = br.readLine();
        functionId = br.readLine();
        String username = br.readLine();
        String aux = br.readLine();
        ArrayList<String> currentSortedColumns = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(aux, ",");
        while (st.hasMoreTokens()) {
            currentSortedColumns.add(st.nextToken());
        }
        aux = br.readLine();
        ArrayList<String> currentSortedVersusColumns = new ArrayList<String>();
        st = new StringTokenizer(aux, ",");
        while (st.hasMoreTokens()) {
            currentSortedVersusColumns.add(st.nextToken());
        }
        aux = br.readLine();
        st = new StringTokenizer(aux, ",");
        int cols = st.countTokens();
        String[] columnsAttribute = new String[cols];
        int i = 0;
        while (st.hasMoreTokens()) {
            columnsAttribute[i++] = st.nextToken();
        }
        aux = br.readLine();
        boolean[] columnsVisibility = new boolean[cols];
        st = new StringTokenizer(aux, ",");
        i = 0;
        while (st.hasMoreTokens()) {
            columnsVisibility[i++] = st.nextToken().toLowerCase().equals("true");
        }
        aux = br.readLine();
        int[] columnsWidth = new int[cols];
        st = new StringTokenizer(aux, ",");
        i = 0;
        while (st.hasMoreTokens()) {
            columnsWidth[i++] = Integer.parseInt(st.nextToken().trim());
        }
        aux = br.readLine();
        boolean defaultProfile = aux.toLowerCase().endsWith("true");
        HashMap<String, FilterWhereClause[]> quickFilterValues = new HashMap<String, FilterWhereClause[]>();
        String attributeName = null;
        FilterWhereClause[] filter = new FilterWhereClause[2];
        ArrayList<Object> values = null;
        String[] tokens = null;
        while ((aux = br.readLine()) != null) {
            int j;
            st = new StringTokenizer(aux, ",");
            attributeName = st.nextToken();
            String operator1 = st.nextToken();
            String typevalue1 = st.nextToken();
            Object value1 = st.nextToken();
            tokens = value1.toString().split("\t");
            if (tokens.length == 1 && !operator1.equals("in")) {
                if (typevalue1.equals("D")) {
                    value1 = this.sdf.parse(value1.toString());
                } else if (typevalue1.equals("N")) {
                    value1 = new BigDecimal(value1.toString());
                }
            } else {
                values = new ArrayList<Object>();
                j = 0;
                while (j < tokens.length) {
                    if (typevalue1.equals("D")) {
                        values.add(this.sdf.parse(tokens[j]));
                    } else if (typevalue1.equals("N")) {
                        values.add(new BigDecimal(tokens[j]));
                    } else {
                        values.add(tokens[j]);
                    }
                    ++j;
                }
                value1 = values;
            }
            filter[0] = new FilterWhereClause(attributeName, operator1, value1);
            if (st.hasMoreTokens()) {
                String operator2 = st.nextToken();
                String typevalue2 = st.nextToken();
                Object value2 = st.nextToken();
                tokens = value2.toString().split("\t");
                if (tokens.length == 1 && !operator2.equals("in")) {
                    if (typevalue1.equals("D")) {
                        value2 = this.sdf.parse(value2.toString());
                    } else if (typevalue1.equals("N")) {
                        value2 = new BigDecimal(value2.toString());
                    }
                } else {
                    values = new ArrayList();
                    j = 0;
                    while (j < tokens.length) {
                        if (typevalue2.equals("D")) {
                            values.add(this.sdf.parse(tokens[j]));
                        } else if (typevalue2.equals("N")) {
                            values.add(new BigDecimal(tokens[j]));
                        } else {
                            values.add(tokens[j]);
                        }
                        ++j;
                    }
                    value2 = values;
                }
                filter[1] = new FilterWhereClause(attributeName, operator2, value2);
            } else {
                filter[1] = null;
            }
            quickFilterValues.put(attributeName, filter);
        }
        GridProfile gridProfile = new GridProfile(id, description, functionId, username, currentSortedColumns, currentSortedVersusColumns, quickFilterValues, columnsAttribute, columnsVisibility, columnsWidth, defaultProfile);
        Object var32_33 = null;
        try {
            br.close();
        }
        catch (Exception ex) {
        }
        return gridProfile;
        catch (Throwable t) {
            try {
                throw new IOException(t.getMessage());
            }
            catch (Throwable throwable) {
                Object var32_34 = null;
                try {
                    br.close();
                }
                catch (Exception ex) {
                }
                throw throwable;
            }
        }
    }

    public ArrayList getUserProfiles(final String functionId) throws Throwable {
        String userHome = System.getProperty("user.home").replace('\\', '/');
        if (!userHome.endsWith("/")) {
            userHome = userHome + "/";
        }
        userHome = userHome + "profiles";
        File dir = new File(userHome);
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().startsWith(functionId.replace(' ', '_') + "_" + FileGridProfileManager.this.getUsername().replace(' ', '_') + "_") && pathname.getName().endsWith(".cfg");
            }
        });
        ArrayList<GridProfileDescription> profiles = new ArrayList<GridProfileDescription>();
        GridProfile profile = null;
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                try {
                    profile = this.getUserProfile(functionId, files[i].getName());
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                if (profile != null) {
                    profiles.add(new GridProfileDescription(files[i].getName(), profile.getDescription(), profile.isDefaultProfile()));
                }
                ++i;
            }
        }
        return profiles;
    }

    /*
     * Loose catch block
     */
    public void storeGridDigest(String functionId, String gridDigest) throws Throwable {
        block9: {
            String userHome = System.getProperty("user.home").replace('\\', '/');
            if (!userHome.endsWith("/")) {
                userHome = userHome + "/";
            }
            userHome = userHome + "profiles";
            File dir = new File(userHome);
            dir.mkdirs();
            File f = new File(userHome + "/" + functionId.replace(' ', '_') + ".dig");
            if (f.exists()) {
                f.delete();
            }
            PrintWriter pw = null;
            pw = new PrintWriter(new FileOutputStream(f));
            pw.println(gridDigest);
            Object var9_7 = null;
            try {
                pw.close();
            }
            catch (Exception ex1) {
            }
            break block9;
            {
                catch (Throwable ex) {
                    throw new IOException(ex.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    pw.close();
                }
                catch (Exception ex1) {
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void storeGridProfileId(String functionId, Object id) throws Throwable {
        block9: {
            String userHome = System.getProperty("user.home").replace('\\', '/');
            if (!userHome.endsWith("/")) {
                userHome = userHome + "/";
            }
            userHome = userHome + "profiles";
            File dir = new File(userHome);
            dir.mkdirs();
            File f = new File(userHome + "/" + functionId.replace(' ', '_') + "_" + this.getUsername().replace(' ', '_') + ".ini");
            if (f.exists()) {
                f.delete();
            }
            PrintWriter pw = null;
            pw = new PrintWriter(new FileOutputStream(f));
            pw.println(id);
            Object var9_7 = null;
            try {
                pw.close();
            }
            catch (Exception ex1) {
            }
            break block9;
            {
                catch (Throwable ex) {
                    throw new IOException(ex.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    pw.close();
                }
                catch (Exception ex1) {
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public Object storeUserProfile(GridProfile profile) throws Throwable {
        String userHome;
        if (profile.getId() == null) {
            profile.setId(profile.getFunctionId().replace(' ', '_') + "_" + this.getUsername().replace(' ', '_') + "_" + System.currentTimeMillis() + ".cfg");
        }
        if (!(userHome = System.getProperty("user.home").replace('\\', '/')).endsWith("/")) {
            userHome = userHome + "/";
        }
        userHome = userHome + "profiles";
        File dir = new File(userHome);
        dir.mkdirs();
        File f = new File(userHome + "/" + profile.getId());
        if (f.exists()) {
            f.delete();
        }
        PrintWriter pw = null;
        pw = new PrintWriter(new FileOutputStream(f));
        pw.println(profile.getDescription());
        pw.println(profile.getFunctionId());
        pw.println(profile.getUsername());
        String currentSortedColumns = "";
        int i = 0;
        while (i < profile.getCurrentSortedColumns().size()) {
            currentSortedColumns = currentSortedColumns + profile.getCurrentSortedColumns().get(i) + ",";
            ++i;
        }
        if (currentSortedColumns.length() > 0) {
            currentSortedColumns = currentSortedColumns.substring(0, currentSortedColumns.length() - 1);
        }
        pw.println(currentSortedColumns);
        String currentSortedVersusColumns = "";
        int i2 = 0;
        while (i2 < profile.getCurrentSortedVersusColumns().size()) {
            currentSortedVersusColumns = currentSortedVersusColumns + profile.getCurrentSortedVersusColumns().get(i2) + ",";
            ++i2;
        }
        if (currentSortedVersusColumns.length() > 0) {
            currentSortedVersusColumns = currentSortedVersusColumns.substring(0, currentSortedVersusColumns.length() - 1);
        }
        pw.println(currentSortedVersusColumns);
        String columnsAttribute = "";
        int i3 = 0;
        while (i3 < profile.getColumnsAttribute().length) {
            columnsAttribute = columnsAttribute + profile.getColumnsAttribute()[i3] + ",";
            ++i3;
        }
        if (columnsAttribute.length() > 0) {
            columnsAttribute = columnsAttribute.substring(0, columnsAttribute.length() - 1);
        }
        pw.println(columnsAttribute);
        String columnsVisibility = "";
        int i4 = 0;
        while (i4 < profile.getColumnsVisibility().length) {
            columnsVisibility = columnsVisibility + profile.getColumnsVisibility()[i4] + ",";
            ++i4;
        }
        if (columnsVisibility.length() > 0) {
            columnsVisibility = columnsVisibility.substring(0, columnsVisibility.length() - 1);
        }
        pw.println(columnsVisibility);
        String columnsWidth = "";
        int i5 = 0;
        while (i5 < profile.getColumnsWidth().length) {
            columnsWidth = columnsWidth + profile.getColumnsWidth()[i5] + ",";
            ++i5;
        }
        if (columnsWidth.length() > 0) {
            columnsWidth = columnsWidth.substring(0, columnsWidth.length() - 1);
        }
        pw.println(columnsWidth);
        pw.println(profile.isDefaultProfile());
        Iterator it = profile.getQuickFilterValues().keySet().iterator();
        String aux = "";
        FilterWhereClause[] filter = null;
        String attributeName = null;
        while (it.hasNext()) {
            int j;
            ArrayList values;
            attributeName = it.next().toString();
            filter = (FilterWhereClause[])profile.getQuickFilterValues().get(attributeName);
            aux = attributeName + "," + filter[0].getOperator() + ",";
            if (filter[0].getValue() != null) {
                if (filter[0].getOperator().equals("in") || filter[0].getValue() instanceof ArrayList) {
                    values = (ArrayList)filter[0].getValue();
                    j = 0;
                    while (j < values.size()) {
                        aux = values.get(j) instanceof Date ? aux + "D," + this.sdf.format(values.get(j)) + "\t" : (filter[0].getValue() instanceof Number ? aux + "N," + values.get(j) + "\t" : aux + "T," + values.get(j) + "\t");
                        ++j;
                    }
                } else {
                    aux = filter[0].getValue() instanceof Date ? aux + "D," + this.sdf.format(filter[0].getValue()) : (filter[0].getValue() instanceof Number ? aux + "N," + filter[0].getValue() : aux + "T," + filter[0].getValue());
                }
            }
            if (filter[1] != null) {
                aux = aux + "," + filter[1].getOperator() + ",";
                if (filter[1].getValue() != null) {
                    if (filter[1].getOperator().equals("in") || filter[1].getValue() instanceof ArrayList) {
                        values = (ArrayList)filter[1].getValue();
                        j = 0;
                        while (j < values.size()) {
                            aux = values.get(j) instanceof Date ? aux + "D," + this.sdf.format(values.get(j)) + "\t" : (filter[1].getValue() instanceof Number ? aux + "N," + values.get(j) + "\t" : aux + "T," + values.get(j) + "\t");
                            ++j;
                        }
                    } else {
                        aux = filter[1].getValue() instanceof Date ? aux + "D," + this.sdf.format(filter[1].getValue()) : (filter[1].getValue() instanceof Number ? aux + "N," + filter[1].getValue() : aux + "T," + filter[1].getValue());
                    }
                }
            }
            pw.println(aux);
        }
        Object object = profile.getId();
        Object var23_23 = null;
        try {
            pw.close();
        }
        catch (Exception ex) {
        }
        return object;
        catch (Throwable t) {
            try {
                throw new IOException(t.getMessage());
            }
            catch (Throwable throwable) {
                Object var23_24 = null;
                try {
                    pw.close();
                }
                catch (Exception ex) {
                }
                throw throwable;
            }
        }
    }
}

