/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.DateColumnSettings;
import org.openswing.swing.util.client.ClientSettings;

public class DateTableCellRenderer
extends DefaultTableCellRenderer {
    public static final String VALUE_UNKNOWN = "???";
    private int alignement;
    private String attributeName = null;
    private String dateFormat;
    private Font defaultFont = null;
    private DateColumnSettings dynamicSettings = null;
    private GridController gridController = null;
    private int row = -1;
    private int type;

    public DateTableCellRenderer(int type, GridController gridController, int alignement, char separator, int dateFormat, boolean showCentury, String timeFormat, DateColumnSettings dynamicSettings, String attributeName) {
        this.type = type;
        this.gridController = gridController;
        this.dateFormat = ClientSettings.getInstance().getResources().getDateMask(type, dateFormat, separator, showCentury, timeFormat);
        this.alignement = alignement;
        this.dynamicSettings = dynamicSettings;
        this.attributeName = attributeName;
    }

    public final void finalize() {
        this.gridController = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color selColor;
        Color backColor;
        this.row = row;
        JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ((JLabel)c).setHorizontalAlignment(this.alignement);
        if (this.defaultFont == null) {
            this.defaultFont = ((JLabel)c).getFont();
        }
        if (isSelected && !hasFocus) {
            ((JLabel)c).setForeground(table.getSelectionForeground());
            backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            selColor = table.getSelectionBackground();
            c.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
        } else {
            c.setBackground(table.getBackground());
            ((JLabel)c).setForeground(table.getForeground());
        }
        if (hasFocus && table instanceof Grid) {
            Color selColor2 = null;
            try {
                selColor2 = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor2 = ((Grid)table).getActiveCellBackgroundColor();
            }
            Color backColor2 = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            c.setBackground(new Color((backColor2.getRed() + selColor2.getRed()) / 2, (backColor2.getGreen() + selColor2.getGreen()) / 2, (backColor2.getBlue() + selColor2.getBlue()) / 2, 200));
            c.setBorder(BorderFactory.createLineBorder(table.getSelectionForeground()));
        } else if (isSelected && !hasFocus) {
            c.setForeground(table.getSelectionForeground());
            backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * table.getSelectionBackground().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * table.getSelectionBackground().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * table.getSelectionBackground().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getSelectionBackground();
            }
            c.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            c.setBorder(BorderFactory.createEmptyBorder());
        } else {
            c.setForeground(this.gridController.getForegroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            c.setBorder(BorderFactory.createEmptyBorder());
            if (((Grid)table).getMode() == 0 || !((Grid)table).isColorsInReadOnlyMode()) {
                c.setBackground(this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            } else if (table.isCellEditable(row, column)) {
                c.setBackground(ClientSettings.GRID_EDITABLE_CELL_BACKGROUND);
            } else {
                c.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
            }
        }
        Font f = this.gridController.getFont(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value, this.defaultFont);
        if (f != null) {
            c.setFont(f);
        } else {
            c.setFont(this.defaultFont);
        }
        if (table instanceof Grid) {
            c.setToolTipText(this.gridController.getCellTooltip(row, ((Grid)table).getVOListTableModel().getColumnName(table.convertColumnIndexToModel(column))));
        }
        return c;
    }

    protected void setValue(Object value) {
        if (value == null) {
            this.setText(null);
            return;
        }
        Date d = null;
        if (value instanceof Date) {
            d = (Date)value;
        } else if (value instanceof Calendar) {
            d = ((Calendar)value).getTime();
        }
        String s = VALUE_UNKNOWN;
        if (d != null) {
            s = this.dynamicSettings != null ? new SimpleDateFormat(this.dynamicSettings.getDataFormat(this.row, this.attributeName)).format(d) : new SimpleDateFormat(this.dateFormat).format(d);
        }
        this.setText(s);
    }
}

