/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.renderers.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.util.client.ClientSettings;

public class TextTableCellRenderer
extends DefaultTableCellRenderer {
    private String attributeName = null;
    protected int bottomMargin = 0;
    private JPanel container = new JPanel();
    private Font defaultFont = null;
    private boolean encryptText;
    private GridController gridController = null;
    protected int leftMargin = 0;
    protected int rightMargin = 0;
    protected int topMargin = 0;

    public TextTableCellRenderer(GridController gridController, boolean encryptText, int alignement, int leftMargin, int rightMargin, int topMargin, int bottomMargin, ComponentOrientation orientation, String attributeName) {
        this.gridController = gridController;
        this.encryptText = encryptText;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
        this.attributeName = attributeName;
        this.setHorizontalAlignment(alignement);
        if (orientation != null) {
            this.setComponentOrientation(orientation);
        }
    }

    public final void finalize() {
        this.gridController = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Font f;
        JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.defaultFont == null) {
            this.defaultFont = ((JLabel)c).getFont();
        }
        if (hasFocus && table instanceof Grid) {
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * ((Grid)table).getActiveCellBackgroundColor().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex1) {
                selColor = ((Grid)table).getActiveCellBackgroundColor();
            }
            Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            c.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2, 200));
            c.setBorder(BorderFactory.createLineBorder(table.getSelectionForeground()));
        } else if (isSelected && !hasFocus) {
            c.setForeground(table.getSelectionForeground());
            Color backColor = this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value);
            Color selColor = null;
            try {
                selColor = new Color(Math.min(255, 2 * table.getSelectionBackground().getRed() - ClientSettings.GRID_CELL_BACKGROUND.getRed()), Math.min(255, 2 * table.getSelectionBackground().getGreen() - ClientSettings.GRID_CELL_BACKGROUND.getGreen()), Math.min(255, 2 * table.getSelectionBackground().getBlue() - ClientSettings.GRID_CELL_BACKGROUND.getBlue()));
            }
            catch (Exception ex) {
                selColor = table.getSelectionForeground();
            }
            c.setBackground(new Color((backColor.getRed() + selColor.getRed()) / 2, (backColor.getGreen() + selColor.getGreen()) / 2, (backColor.getBlue() + selColor.getBlue()) / 2));
            c.setBorder(BorderFactory.createEmptyBorder());
        } else {
            c.setForeground(this.gridController.getForegroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            c.setBorder(BorderFactory.createEmptyBorder());
            if (((Grid)table).getMode() == 0 || !((Grid)table).isColorsInReadOnlyMode()) {
                c.setBackground(this.gridController.getBackgroundColor(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value));
            } else if (table.isCellEditable(row, column)) {
                c.setBackground(ClientSettings.GRID_EDITABLE_CELL_BACKGROUND);
            } else {
                c.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
            }
        }
        if (value != null && this.encryptText) {
            ((JLabel)c).setText("*********");
        }
        if ((f = this.gridController.getFont(row, table.getModel().getColumnName(table.convertColumnIndexToModel(column)), value, this.defaultFont)) != null) {
            c.setFont(f);
        } else {
            c.setFont(this.defaultFont);
        }
        if (table instanceof Grid) {
            c.setToolTipText(this.gridController.getCellTooltip(row, ((Grid)table).getVOListTableModel().getColumnName(table.convertColumnIndexToModel(column))));
        }
        c.setBorder(BorderFactory.createCompoundBorder(c.getBorder(), BorderFactory.createEmptyBorder(this.topMargin, this.leftMargin, this.bottomMargin, this.rightMargin)));
        return c;
    }
}

