/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.tree.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.text.Format;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.tree.client.AbstractTreeTableModel;
import org.openswing.swing.tree.client.TreeController;
import org.openswing.swing.tree.client.TreeDataLocator;
import org.openswing.swing.tree.client.TreeGrid;
import org.openswing.swing.tree.java.OpenSwingTreeNode;
import org.openswing.swing.util.client.ClientSettings;

public class TreeGridPanel
extends JPanel {
    static /* synthetic */ Class class$org$openswing$swing$tree$client$TreeTableModel;
    private ArrayList columnFormatters;
    private ArrayList columnHeaders;
    private boolean expandAllNodes;
    private boolean expandRoot;
    private boolean firstTime = true;
    private String folderIconName;
    private Method[] getterMethods;
    private Hashtable gridColumnAlignments;
    private ArrayList gridColumnSizes;
    private ArrayList gridColumns = new ArrayList();
    private String leavesImageName;
    private boolean loadWhenVisibile;
    private Hashtable menuItems;
    private JPopupMenu popup;
    private boolean rootVisible = true;
    private TreeGrid tree;
    private TreeController treeController;
    private TreeDataLocator treeDataLocator;
    private JScrollPane treePane;
    private DefaultMutableTreeNode treeRoot;

    public TreeGridPanel() {
        this.gridColumnSizes = new ArrayList();
        this.gridColumnAlignments = new Hashtable();
        this.tree = new TreeGrid(new TreeGridModel(), "", new ArrayList(), this.gridColumnSizes, this.gridColumnAlignments, ClientSettings.PERC_TREE_FOLDER, ClientSettings.PERC_TREE_NODE, null, this.rootVisible);
        this.treePane = new JScrollPane();
        this.popup = new JPopupMenu();
        this.menuItems = new Hashtable();
        ClientSettings.getInstance();
        this.leavesImageName = ClientSettings.PERC_TREE_FOLDER;
        this.loadWhenVisibile = true;
        this.expandAllNodes = false;
        this.folderIconName = ClientSettings.PERC_TREE_FOLDER;
        this.getterMethods = null;
        this.columnHeaders = new ArrayList();
        this.columnFormatters = new ArrayList();
        this.expandRoot = true;
        try {
            this.jbInit();
            this.treePane.getViewport().setBackground(ClientSettings.GRID_CELL_BACKGROUND);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Method[] access$902(TreeGridPanel x0, Method[] x1) {
        x0.getterMethods = x1;
        return x1;
    }

    public final void addGridColumn(String attributeName, int colSize) {
        this.gridColumns.add(attributeName);
        this.gridColumnSizes.add(new Integer(colSize));
        this.columnHeaders.add(attributeName);
        this.columnFormatters.add(null);
    }

    public final void addNotify() {
        super.addNotify();
        if (this.firstTime && this.loadWhenVisibile) {
            this.firstTime = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeGridPanel.this.createTree();
                }
            });
        }
    }

    public final void addPopupMenuItem(String menuName, String parentMenuName, char mnemonic, boolean enabled, ActionListener menuListener) {
        JMenuItem cbMenuItem = new JMenuItem(ClientSettings.getInstance().getResources().getResource(menuName));
        cbMenuItem.setMnemonic(mnemonic);
        cbMenuItem.setEnabled(enabled);
        cbMenuItem.addActionListener(menuListener);
        JMenuItem parentItem = (JMenuItem)this.menuItems.get(parentMenuName);
        if (parentItem != null) {
            parentItem.add(cbMenuItem);
            this.menuItems.put(menuName, cbMenuItem);
        }
    }

    public final void addPopupMenuItem(String menuName, int mnemonic, boolean enabled, ActionListener menuListener) {
        JMenuItem cbMenuItem = new JMenuItem(ClientSettings.getInstance().getResources().getResource(menuName));
        cbMenuItem.setMnemonic(mnemonic);
        cbMenuItem.setEnabled(enabled);
        cbMenuItem.addActionListener(menuListener);
        this.popup.add(cbMenuItem);
        this.menuItems.put(menuName, cbMenuItem);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final void clearTree() {
        this.treeRoot = new OpenSwingTreeNode();
        this.repaintTree();
    }

    public final void collapseNode(int index) {
        this.tree.getTree().collapseRow(index);
    }

    private void createTree() {
        Response response = this.treeDataLocator.getTreeModel(this.tree.getTree());
        this.treeRoot = response.isError() ? new OpenSwingTreeNode() : (DefaultMutableTreeNode)((DefaultTreeModel)((VOResponse)response).getVo()).getRoot();
        this.recreateTree();
        this.treeDataLocator.loadDataCompleted(response.isError());
    }

    private final void expandAllNodes() {
        int i = 0;
        while (i < this.tree.getRowCount()) {
            this.tree.getTree().expandRow(i++);
        }
    }

    public final void expandNode(int index) {
        this.tree.getTree().expandRow(index);
    }

    public final String getFolderIconName() {
        return this.folderIconName;
    }

    public final String getLeavesImageName() {
        return this.leavesImageName;
    }

    public final DefaultMutableTreeNode getSelectedNode() {
        try {
            TreePath selPath = this.tree.getTree().getSelectionPath();
            if (selPath != null) {
                return (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1);
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public final TreeController getTreeController() {
        return this.treeController;
    }

    public final TreeDataLocator getTreeDataLocator() {
        return this.treeDataLocator;
    }

    public final boolean isExpandAllNodes() {
        return this.expandAllNodes;
    }

    public final boolean isExpandRoot() {
        return this.expandRoot;
    }

    public final boolean isLoadWhenVisibile() {
        return this.loadWhenVisibile;
    }

    public final boolean isRootVisible() {
        return this.rootVisible;
    }

    void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.treePane.getViewport().add((Component)this.tree, null);
        this.add((Component)this.treePane, "Center");
        this.treePane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
        this.treePane.setAutoscrolls(true);
    }

    private void recreateTree() {
        this.treePane.getViewport().remove(this.tree);
        TreeExpansionListener[] l1 = this.tree.getTree().getTreeExpansionListeners();
        TreeWillExpandListener[] l2 = this.tree.getTree().getTreeWillExpandListeners();
        TreeSelectionListener[] l3 = this.tree.getTree().getTreeSelectionListeners();
        this.tree = new TreeGrid(new TreeGridModel(this.treeRoot), this.gridColumns.get(0).toString(), this.gridColumns, this.gridColumnSizes, this.gridColumnAlignments, this.folderIconName, this.leavesImageName, (Format)this.columnFormatters.get(0), this.rootVisible);
        this.tree.getTree().setShowsRootHandles(true);
        int i = 0;
        while (i < l1.length) {
            this.tree.getTree().addTreeExpansionListener(l1[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < l2.length) {
            this.tree.getTree().addTreeWillExpandListener(l2[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < l3.length) {
            this.tree.getTree().addTreeSelectionListener(l3[i3]);
            ++i3;
        }
        this.tree.setSelectionMode(1);
        this.treePane.getViewport().add(this.tree);
        this.tree.setSize(new Dimension((int)this.getPreferredSize().getWidth() / 2, (int)this.getPreferredSize().getHeight()));
        this.tree.setMinimumSize(new Dimension(0, 200));
        this.tree.revalidate();
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e)) {
                    TreeGridPanel.this.treeLeftClick(e, TreeGridPanel.this.tree.getTree());
                } else if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {
                    TreeGridPanel.this.treeRightClick(e, TreeGridPanel.this.tree.getTree());
                }
                if (e.getClickCount() == 2) {
                    TreeGridPanel.this.treeDoubleClick(e, TreeGridPanel.this.tree.getTree());
                }
            }
        };
        this.tree.addMouseListener(ml);
        if (this.expandAllNodes) {
            this.expandAllNodes();
        } else if (this.expandRoot && this.rootVisible) {
            this.tree.getTree().expandRow(0);
        }
    }

    public final void reloadTree() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!TreeGridPanel.this.loadWhenVisibile && TreeGridPanel.this.firstTime) {
                    TreeGridPanel.this.firstTime = false;
                    TreeGridPanel.this.createTree();
                    if (TreeGridPanel.this.expandAllNodes) {
                        TreeGridPanel.this.expandAllNodes();
                    } else {
                        TreeGridPanel.this.tree.getTree().collapseRow(0);
                    }
                } else {
                    Response response = TreeGridPanel.this.treeDataLocator.getTreeModel(TreeGridPanel.this.tree.getTree());
                    if (response.isError()) {
                        TreeGridPanel.this.treeRoot = new OpenSwingTreeNode();
                    } else {
                        TreeGridPanel.this.treeRoot = (DefaultMutableTreeNode)((DefaultTreeModel)((VOResponse)response).getVo()).getRoot();
                    }
                    TreeGridPanel.this.recreateTree();
                    TreeGridPanel.this.treeDataLocator.loadDataCompleted(response.isError());
                    if (TreeGridPanel.this.expandAllNodes) {
                        TreeGridPanel.this.expandAllNodes();
                    } else {
                        TreeGridPanel.this.tree.getTree().collapseRow(0);
                    }
                }
            }
        });
    }

    public final void repaintTree() {
        this.recreateTree();
        TreePath selPath = this.tree.getTree().getSelectionPath();
        this.tree.repaint();
        try {
            this.tree.getTree().setSelectionPath(selPath.getParentPath());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.tree.getTree().setSelectionPath(selPath);
        }
        catch (Exception ex) {
        }
    }

    public final void setColumnAlignment(String attributeName, int alignment) {
        int index = this.gridColumns.indexOf(attributeName);
        if (index != -1) {
            this.gridColumnAlignments.put(attributeName, new Integer(alignment));
        }
    }

    public void setColumnFormatter(String attributeName, Format formatter) {
        int index = this.gridColumns.indexOf(attributeName);
        if (index != -1) {
            this.columnFormatters.set(index, formatter);
        }
    }

    public final void setColumnHeader(String attributeName, String description) {
        int index = this.gridColumns.indexOf(attributeName);
        if (index != -1) {
            this.columnHeaders.set(index, description);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.treePane.setEnabled(enabled);
    }

    public final void setExpandAllNodes(boolean expandAllNodes) {
        this.expandAllNodes = expandAllNodes;
    }

    public final void setExpandRoot(boolean expandRoot) {
        this.expandRoot = expandRoot;
    }

    public final void setFolderIconName(String folderIconName) {
        this.folderIconName = folderIconName;
    }

    public final void setLeavesImageName(String leavesImageName) {
        this.leavesImageName = leavesImageName;
    }

    public final void setLoadWhenVisibile(boolean loadWhenVisibile) {
        this.loadWhenVisibile = loadWhenVisibile;
    }

    public final void setMenuItemEnabled(String menuName, boolean enabled) {
        JMenuItem menu = (JMenuItem)this.menuItems.get(menuName);
        if (menu != null) {
            menu.setEnabled(enabled);
        }
    }

    public final void setRootVisible(boolean rootVisible) {
        this.rootVisible = rootVisible;
    }

    public final void setTreeController(TreeController treeController) {
        this.treeController = treeController;
    }

    public final void setTreeDataLocator(TreeDataLocator treeDataLocator) {
        this.treeDataLocator = treeDataLocator;
    }

    public final void treeDoubleClick(MouseEvent e, JTree tree) {
        try {
            TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
            if (selPath != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1);
                this.treeController.doubleClick(node);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void treeLeftClick(MouseEvent e, JTree tree) {
        try {
            int selRow = tree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
            if (selPath != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1);
                this.treeController.leftClick(node);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void treeRightClick(MouseEvent e, JTree tree) {
        try {
            DefaultMutableTreeNode node;
            int selRow = tree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
            if (selPath != null && this.treeController.rightClick(node = (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1)) && this.popup.getComponentCount() > 0 && this.treePane.isEnabled()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class TreeGridModel
    extends AbstractTreeTableModel {
        public TreeGridModel(DefaultMutableTreeNode root) {
            super(root);
        }

        public TreeGridModel() {
            this(new OpenSwingTreeNode());
        }

        public Object getChild(Object node, int childNumber) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
            return treeNode.getChildAt(childNumber);
        }

        public int getChildCount(Object node) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
            return treeNode.getChildCount();
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return class$org$openswing$swing$tree$client$TreeTableModel == null ? (class$org$openswing$swing$tree$client$TreeTableModel = TreeGridPanel.class$("org.openswing.swing.tree.client.TreeTableModel")) : class$org$openswing$swing$tree$client$TreeTableModel;
            }
            if (TreeGridPanel.this.getterMethods == null) {
                return super.getColumnClass(column);
            }
            return TreeGridPanel.this.getterMethods[column].getReturnType();
        }

        public int getColumnCount() {
            return TreeGridPanel.this.gridColumns.size();
        }

        public String getColumnName(int col) {
            return ClientSettings.getInstance().getResources().getResource(TreeGridPanel.this.columnHeaders.get(col).toString());
        }

        public Object getValueAt(Object node, int column) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
            ValueObject vo = (ValueObject)treeNode.getUserObject();
            if (TreeGridPanel.this.getterMethods == null) {
                try {
                    TreeGridPanel.access$902(TreeGridPanel.this, new Method[TreeGridPanel.this.gridColumns.size()]);
                    int i = 0;
                    while (i < TreeGridPanel.this.gridColumns.size()) {
                        ((TreeGridPanel)TreeGridPanel.this).getterMethods[i] = vo.getClass().getMethod("get" + TreeGridPanel.this.gridColumns.get(i).toString().substring(0, 1).toUpperCase() + TreeGridPanel.this.gridColumns.get(i).toString().substring(1), new Class[0]);
                        ++i;
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            if (TreeGridPanel.this.getterMethods == null || TreeGridPanel.this.getterMethods[column] == null) {
                return null;
            }
            try {
                Object value = TreeGridPanel.this.getterMethods[column].invoke((Object)vo, new Object[0]);
                if (value != null && TreeGridPanel.this.columnFormatters.get(column) != null) {
                    Format formatter = (Format)TreeGridPanel.this.columnFormatters.get(column);
                    value = formatter.format(value);
                }
                return value;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public boolean isLeaf(Object node) {
            return !((TreeNode)node).getAllowsChildren();
        }
    }
}

