/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.tree.client;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openswing.swing.tree.client.TreePanel;

public class TreeNodeRendererListener
implements MouseListener,
KeyListener {
    private TreePanel treePanel;

    public TreeNodeRendererListener(TreePanel treePanel) {
        this.treePanel = treePanel;
    }

    private boolean areAllDeselectedCheckBox(TreeNode node) {
        int i = 0;
        while (i < node.getChildCount()) {
            if (this.treePanel.getCheckedNodes().contains(node.getChildAt(i)) || node.getChildAt(i).isLeaf() && !this.treePanel.isShowCheckBoxes()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void checkChanged(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode aux;
        if (this.treePanel.getCheckedNodes().contains(node)) {
            this.treePanel.getCheckedNodes().remove(node);
            this.updateCheckboxesOnSubTree(node, false);
            aux = node;
            while ((aux = (DefaultMutableTreeNode)aux.getParent()) != null) {
                if (!this.areAllDeselectedCheckBox(aux)) continue;
                this.treePanel.getCheckedNodes().remove(aux);
            }
        } else {
            this.treePanel.getCheckedNodes().add(node);
            this.updateCheckboxesOnSubTree(node, true);
            if (node.getParent() != null && !node.getParent().equals(node.getRoot()) && !this.treePanel.getCheckedNodes().contains(node.getParent())) {
                aux = null;
                boolean selectParent = true;
                int i = 0;
                while (i < node.getParent().getChildCount()) {
                    aux = (DefaultMutableTreeNode)node.getParent().getChildAt(i);
                    if (!this.treePanel.getCheckedNodes().contains(aux)) {
                        selectParent = false;
                        break;
                    }
                    ++i;
                }
                if (selectParent) {
                    this.treePanel.getCheckedNodes().add(node.getParent());
                }
            }
        }
        ItemListener[] ll = this.treePanel.getItemListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].itemStateChanged(new ItemEvent(new JCheckBox(), 701, node, this.treePanel.getCheckedNodes().contains(node) ? 1 : 2));
            ++i;
        }
        this.treePanel.getTree().repaint();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (this.treePanel.isEnabled()) {
            DefaultMutableTreeNode node = this.treePanel.getSelectedNode();
            if (e.getKeyChar() == ' ' && node != null && (this.treePanel.isShowCheckBoxesOnLeaves() || !node.isLeaf())) {
                this.checkChanged(node);
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (this.treePanel.isEnabled() && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
            try {
                TreePath path = this.treePanel.getTree().getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node == null) {
                    return;
                }
                if (this.treePanel.isShowCheckBoxesOnLeaves() || !node.isLeaf()) {
                    this.checkChanged(node);
                }
            }
            catch (Exception ex) {
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void updateCheckboxesOnSubTree(TreeNode node, boolean sel) {
        if (sel) {
            this.treePanel.getCheckedNodes().add(node);
        } else {
            this.treePanel.getCheckedNodes().remove(node);
        }
        int i = 0;
        while (i < node.getChildCount()) {
            this.updateCheckboxesOnSubTree(node.getChildAt(i), sel);
            ++i;
        }
    }
}

