/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.tree.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.tree.client.TreeController;
import org.openswing.swing.tree.client.TreeDataLocator;
import org.openswing.swing.tree.client.TreeDragNDropListener;
import org.openswing.swing.tree.client.TreeNodeRenderer;
import org.openswing.swing.tree.java.OpenSwingTreeNode;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;
import org.openswing.swing.util.client.SearchControl;
import org.openswing.swing.util.client.SearchWindowManager;

public class TreePanel
extends JPanel
implements DragSourceListener,
DropTargetListener,
SearchControl {
    private HashSet checkedNodes = new HashSet();
    private TreeDragNDropListener dndListener;
    private Cursor dragCursor;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private boolean expandAllNodes;
    private boolean expandRoot;
    private boolean firstTime = true;
    private String folderIconName;
    private String iconAttributeName;
    private ArrayList itemListeners;
    private ArrayList keyListeners;
    private String leavesImageName;
    private boolean loadWhenVisibile;
    private Hashtable menuItems;
    private ArrayList mouseListeners;
    private JPopupMenu popup;
    private boolean rootVisible;
    private int rowHeight;
    private SearchWindowManager searchWindowManager;
    private Color selectionBackground = ClientSettings.TREE_SELECTION_BACKGROUND;
    private Color selectionForeground = ClientSettings.TREE_SELECTION_FOREGROUND;
    private int selectionMode;
    private boolean showCheckBoxes;
    private boolean showCheckBoxesOnLeaves;
    private boolean showsRootHandles;
    private JTable table;
    private String tooltipAttributeName;
    private JTree tree = new JTree(new OpenSwingTreeNode()){

        public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
            try {
                return super.getNextMatch(prefix, startingRow, bias);
            }
            catch (Exception ex) {
                return null;
            }
        }

        public void setModel(TreeModel model) {
            super.setModel(model);
            try {
                if (TreePanel.this.checkedNodes != null) {
                    TreePanel.this.checkedNodes.clear();
                }
            }
            catch (Exception ex) {
            }
        }
    };
    private boolean treeChanged;
    private TreeController treeController;
    private TreeDataLocator treeDataLocator;
    private String treeId;
    private DefaultTreeModel treeModel;
    private JScrollPane treePane;

    static {
        UIManager.getDefaults().put("Tree.selectionBackground", new ColorUIResource(ClientSettings.TREE_SELECTION_BACKGROUND));
        UIManager.getDefaults().put("Tree.selectionForeground", new ColorUIResource(ClientSettings.TREE_SELECTION_FOREGROUND));
    }

    public TreePanel() {
        this.table = new JTable();
        this.treeModel = new DefaultTreeModel(new OpenSwingTreeNode());
        this.treePane = new JScrollPane();
        this.popup = new JPopupMenu();
        this.menuItems = new Hashtable();
        ClientSettings.getInstance();
        this.leavesImageName = ClientSettings.PERC_TREE_FOLDER;
        this.loadWhenVisibile = true;
        this.expandAllNodes = false;
        this.folderIconName = ClientSettings.PERC_TREE_FOLDER;
        this.dragSource = null;
        this.dropTarget = null;
        this.dndListener = null;
        this.treeId = null;
        this.rootVisible = true;
        this.selectionMode = 1;
        this.rowHeight = this.tree.getRowHeight();
        this.showsRootHandles = true;
        this.keyListeners = new ArrayList();
        this.mouseListeners = new ArrayList();
        this.dragCursor = null;
        this.showCheckBoxes = false;
        this.showCheckBoxesOnLeaves = true;
        this.itemListeners = new ArrayList();
        this.expandRoot = true;
        this.treeChanged = false;
        try {
            this.tree.setRootVisible(this.rootVisible);
            this.tree.setShowsRootHandles(this.showsRootHandles);
            this.jbInit();
            this.dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(ClientUtils.getImage("drag.gif"), new Point(15, 10), ClientSettings.getInstance().getResources().getResource("drag"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void addItemListener(ItemListener listener) {
        this.itemListeners.add(listener);
    }

    public final void addKeyListener(KeyListener listener) {
        this.keyListeners.add(listener);
    }

    public final void addMouseListener(MouseListener listener) {
        this.mouseListeners.add(listener);
    }

    public void addNotify() {
        super.addNotify();
        if (this.firstTime) {
            if (this.loadWhenVisibile) {
                this.firstTime = false;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TreePanel.this.createTree();
                    }
                });
            } else {
                this.recreateTree();
            }
        }
    }

    public final void addPopupMenuItem(String menuName, String parentMenuName, char mnemonic, boolean enabled, ActionListener menuListener) {
        JMenuItem cbMenuItem = new JMenuItem(ClientSettings.getInstance().getResources().getResource(menuName));
        cbMenuItem.setMnemonic(mnemonic);
        cbMenuItem.setEnabled(enabled);
        cbMenuItem.addActionListener(menuListener);
        JMenuItem parentItem = (JMenuItem)this.menuItems.get(parentMenuName);
        if (parentItem != null) {
            parentItem.add(cbMenuItem);
            this.menuItems.put(menuName, cbMenuItem);
        }
    }

    public final void addPopupMenuItem(String menuName, char mnemonic, boolean enabled, ActionListener menuListener) {
        JMenuItem cbMenuItem = new JMenuItem(ClientSettings.getInstance().getResources().getResource(menuName));
        cbMenuItem.setMnemonic(mnemonic);
        cbMenuItem.setEnabled(enabled);
        cbMenuItem.addActionListener(menuListener);
        this.popup.add(cbMenuItem);
        this.menuItems.put(menuName, cbMenuItem);
    }

    public final void addPopupSeparator() {
        this.popup.add(new JSeparator());
    }

    public final void clearTree() {
        this.treeModel = new DefaultTreeModel(new OpenSwingTreeNode());
        this.repaintTree();
    }

    public final void collapseAllNodes() {
        int i = this.tree.getRowCount() - 1;
        while (i > 0) {
            this.tree.collapseRow(i--);
        }
    }

    public final void collapseNode(int index) {
        this.tree.collapseRow(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTree() {
        ClientUtils.fireBusyEvent(true);
        try {
            ClientUtils.getParentFrame(this).setCursor(new Cursor(3));
            ClientUtils.getParentFrame(this).getToolkit().sync();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Response response = null;
        try {
            response = this.treeDataLocator.getTreeModel(this.tree);
        }
        finally {
            try {
                ClientUtils.getParentFrame(this).setCursor(new Cursor(0));
                ClientUtils.getParentFrame(this).getToolkit().sync();
            }
            catch (Exception ex1) {}
            ClientUtils.fireBusyEvent(false);
        }
        this.treeModel = response.isError() ? new DefaultTreeModel(new OpenSwingTreeNode()) : (DefaultTreeModel)((VOResponse)response).getVo();
        this.recreateTree();
        this.treeDataLocator.loadDataCompleted(response.isError());
        if (this.expandAllNodes) {
            this.expandAllNodes();
        } else if (this.expandRoot && this.rootVisible) {
            this.tree.expandRow(0);
        }
    }

    public final boolean disableListener() {
        return false;
    }

    public final void dragDropEnd(DragSourceDropEvent event) {
        this.dndListener.dragDropEnd();
    }

    public final void dragEnter(DropTargetDragEvent event) {
        event.acceptDrag(2);
        this.dndListener.dropEnter();
    }

    public final void dragEnter(DragSourceDragEvent event) {
        this.tree.setCursor(Cursor.getDefaultCursor());
        this.dndListener.dragEnter();
    }

    public final void dragExit(DropTargetEvent event) {
        try {
            this.dndListener.dropExit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void dragExit(DragSourceEvent event) {
        this.tree.setCursor(Cursor.getDefaultCursor());
        this.dndListener.dragExit();
    }

    public final void dragOver(DropTargetDragEvent event) {
        this.dndListener.dropOver();
    }

    public final void dragOver(DragSourceDragEvent e) {
        this.tree.setCursor(this.dragCursor);
        Point loc = this.tree.getLocationOnScreen();
        int row = (e.getY() - loc.y) / this.tree.getRowHeight();
        int firstVisibleRow = this.tree.getVisibleRect().y / this.tree.getRowHeight();
        int lastVisibleRow = (this.tree.getVisibleRect().y + this.tree.getVisibleRect().height) / this.tree.getRowHeight();
        if (row <= firstVisibleRow + 1) {
            this.tree.scrollRowToVisible(row - 1);
        } else if (row >= lastVisibleRow - 1) {
            this.tree.scrollRowToVisible(row + 1);
        }
        this.dndListener.dragOver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drop(DropTargetDropEvent event) {
        try {
            block7: {
                try {
                    this.tree.setCursor(Cursor.getDefaultCursor());
                    Transferable transferable = event.getTransferable();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getClosestPathForLocation(event.getLocation().x, event.getLocation().y).getLastPathComponent();
                    if (node != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        if (this.dndListener.dropEnabled(node, (String)transferable.getTransferData(DataFlavor.stringFlavor))) {
                            event.acceptDrop(2);
                            event.getDropTargetContext().dropComplete(true);
                        } else {
                            event.rejectDrop();
                        }
                        break block7;
                    }
                    event.rejectDrop();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    event.rejectDrop();
                    Object var5_6 = null;
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            throw throwable;
        }
    }

    public final void dropActionChanged(DropTargetDragEvent event) {
        this.dndListener.dropActionChanged();
    }

    public final void dropActionChanged(DragSourceDragEvent event) {
    }

    public final void enableDrag(String treeId, TreeDragNDropListener dndListener) {
        try {
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this.tree, 2, new DragGestureAdapter(this));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.treeId = treeId;
        this.dndListener = dndListener;
    }

    public final void expandAllNodes() {
        int i = 0;
        try {
            while (i < this.tree.getRowCount()) {
                this.tree.expandRow(i++);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void expandNode(int index) {
        this.tree.expandRow(index);
    }

    public final HashSet getCheckedLeaves() {
        HashSet<TreeNode> set = new HashSet<TreeNode>();
        if (this.showCheckBoxesOnLeaves) {
            Iterator it = this.checkedNodes.iterator();
            TreeNode node = null;
            while (it.hasNext()) {
                node = (TreeNode)it.next();
                if (!this.checkedNodes.contains(node) || !node.isLeaf()) continue;
                set.add(node);
            }
        } else {
            Iterator it = this.checkedNodes.iterator();
            TreeNode node = null;
            while (it.hasNext()) {
                node = (TreeNode)it.next();
                if (!this.checkedNodes.contains(node)) continue;
                int i = 0;
                while (i < node.getChildCount()) {
                    if (node.getChildAt(i).isLeaf()) {
                        set.add(node.getChildAt(i));
                    }
                    ++i;
                }
            }
        }
        return set;
    }

    public final HashSet getCheckedNodes() {
        return this.checkedNodes;
    }

    public final JComponent getComponent() {
        return this.tree;
    }

    public final String getFolderIconName() {
        return this.folderIconName;
    }

    public final String getIconAttributeName() {
        return this.iconAttributeName;
    }

    public final ItemListener[] getItemListeners() {
        return this.itemListeners.toArray(new ItemListener[this.itemListeners.size()]);
    }

    public final String getLeavesImageName() {
        return this.leavesImageName;
    }

    public final int getRowCount() {
        return this.tree.getRowCount();
    }

    public final int getRowHeight() {
        return this.rowHeight;
    }

    public final int getSelectedIndex() {
        if (this.tree.getSelectionRows() == null) {
            return -1;
        }
        if (this.tree.getSelectionRows().length > 0) {
            return this.tree.getSelectionRows()[0];
        }
        return -1;
    }

    public final DefaultMutableTreeNode getSelectedNode() {
        try {
            TreePath selPath = this.tree.getSelectionPath();
            if (selPath != null) {
                return (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1);
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public final Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public final Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public final int getSelectionMode() {
        return this.selectionMode;
    }

    public final TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    public final TreePath[] getSelectionPaths() {
        return this.tree.getSelectionPaths();
    }

    public final int[] getSelectionRows() {
        return this.tree.getSelectionRows();
    }

    public final boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public final String getTooltipAttributeName() {
        return this.tooltipAttributeName;
    }

    public final JTree getTree() {
        return this.tree;
    }

    public final TreeController getTreeController() {
        return this.treeController;
    }

    public final TreeDataLocator getTreeDataLocator() {
        return this.treeDataLocator;
    }

    public final String getValueAt(int index) {
        try {
            JPanel p = (JPanel)this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, this.tree.getPathForRow(index).getLastPathComponent(), false, false, this.tree.getModel().isLeaf(this.tree.getPathForRow(index).getLastPathComponent()), index, false);
            JLabel l = null;
            if (p.getComponent(0) instanceof JLabel) {
                l = (JLabel)p.getComponent(0);
            } else if (p.getComponent(1) instanceof JLabel) {
                l = (JLabel)p.getComponent(1);
            }
            if (l != null) {
                return l.getText();
            }
            return "";
        }
        catch (Exception ex) {
            Object obj = this.tree.getPathForRow(index).getLastPathComponent();
            return obj == null ? "" : obj.toString();
        }
    }

    public final boolean isChanged() {
        return this.treeChanged;
    }

    public final boolean isExpandAllNodes() {
        return this.expandAllNodes;
    }

    public final boolean isExpandRoot() {
        return this.expandRoot;
    }

    public final boolean isLoadWhenVisibile() {
        return this.loadWhenVisibile;
    }

    public final boolean isReadOnly() {
        return true;
    }

    public final boolean isRootVisible() {
        return this.rootVisible;
    }

    public final boolean isShowCheckBoxes() {
        return this.showCheckBoxes;
    }

    public final boolean isShowCheckBoxesOnLeaves() {
        return this.showCheckBoxesOnLeaves;
    }

    void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.treePane.getViewport().add((Component)this.tree, null);
        this.add((Component)this.treePane, "Center");
    }

    private void recreateTree() {
        try {
            TreeNodeRenderer renderer = new TreeNodeRenderer(this, this.folderIconName, this.leavesImageName, this.iconAttributeName, this.tooltipAttributeName);
            this.tree.setCellRenderer(renderer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.tree.setRootVisible(this.rootVisible);
        this.tree.setToolTipText("");
        this.tree.setModel(this.treeModel);
        this.tree.revalidate();
        if (this.searchWindowManager == null) {
            this.searchWindowManager = new SearchWindowManager(this);
        }
        this.tree.getSelectionModel().setSelectionMode(this.selectionMode);
        this.tree.setRowHeight(this.rowHeight);
        this.tree.setShowsRootHandles(this.showsRootHandles);
        this.tree.setSize(new Dimension((int)this.getPreferredSize().getWidth() / 2, (int)this.getPreferredSize().getHeight()));
        this.treePane.getViewport().add(this.tree);
        this.treePane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
        this.treePane.setAutoscrolls(true);
        this.tree.setMinimumSize(new Dimension(0, 200));
        this.dropTarget = new DropTarget(this.tree, this);
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e)) {
                    TreePanel.this.treeLeftClick(e, TreePanel.this.tree);
                } else if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {
                    TreePanel.this.treeRightClick(e, TreePanel.this.tree);
                }
                if (e.getClickCount() == 2) {
                    TreePanel.this.treeDoubleClick(e, TreePanel.this.tree);
                }
            }
        };
        this.tree.addMouseListener(ml);
        this.treeChanged = false;
        this.treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                TreePanel.this.treeChanged = true;
            }

            public void treeNodesInserted(TreeModelEvent e) {
                TreePanel.this.treeChanged = true;
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                TreePanel.this.treeChanged = true;
            }

            public void treeStructureChanged(TreeModelEvent e) {
                TreePanel.this.treeChanged = true;
            }
        });
    }

    public final void reloadTree() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!TreePanel.this.loadWhenVisibile && TreePanel.this.firstTime) {
                    TreePanel.this.firstTime = false;
                    TreePanel.this.createTree();
                    if (TreePanel.this.expandAllNodes) {
                        TreePanel.this.expandAllNodes();
                    } else if (TreePanel.this.expandRoot && TreePanel.this.rootVisible) {
                        TreePanel.this.tree.expandRow(0);
                    }
                } else {
                    ClientUtils.fireBusyEvent(true);
                    try {
                        ClientUtils.getParentFrame(TreePanel.this).setCursor(new Cursor(3));
                        ClientUtils.getParentFrame(TreePanel.this).getToolkit().sync();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    Response response = null;
                    try {
                        response = TreePanel.this.treeDataLocator.getTreeModel(TreePanel.this.tree);
                    }
                    finally {
                        try {
                            ClientUtils.getParentFrame(TreePanel.this).setCursor(new Cursor(0));
                            ClientUtils.getParentFrame(TreePanel.this).getToolkit().sync();
                        }
                        catch (Exception ex1) {}
                        ClientUtils.fireBusyEvent(false);
                    }
                    if (response.isError()) {
                        TreePanel.this.treeModel = new DefaultTreeModel(new OpenSwingTreeNode());
                    } else {
                        TreePanel.this.treeModel = (DefaultTreeModel)((VOResponse)response).getVo();
                    }
                    TreePanel.this.tree.setModel(TreePanel.this.treeModel);
                    TreePanel.this.treeDataLocator.loadDataCompleted(response.isError());
                    TreePanel.this.tree.revalidate();
                    if (TreePanel.this.expandAllNodes) {
                        TreePanel.this.expandAllNodes();
                    } else if (TreePanel.this.expandRoot && TreePanel.this.rootVisible) {
                        TreePanel.this.tree.expandRow(0);
                    }
                }
            }
        });
    }

    public final void removeItemListener(ItemListener listener) {
        this.itemListeners.remove(listener);
    }

    public final void removeKeyListener(KeyListener listener) {
        this.keyListeners.remove(listener);
    }

    public final void removeMouseListener(MouseListener listener) {
        this.mouseListeners.remove(listener);
    }

    public final void repaintTree() {
        TreePath selPath = this.tree.getSelectionPath();
        this.treePane.getViewport().remove(this.tree);
        MouseMotionListener[] mml = null;
        MouseWheelListener[] mwl = null;
        TreeSelectionListener[] tsl = null;
        TreeWillExpandListener[] twl = null;
        TreeExpansionListener[] tel = null;
        if (this.tree != null) {
            mml = this.tree.getMouseMotionListeners();
            mwl = this.tree.getMouseWheelListeners();
            tsl = this.tree.getTreeSelectionListeners();
            twl = this.tree.getTreeWillExpandListeners();
            tel = this.tree.getTreeExpansionListeners();
        }
        this.tree = new JTree(this.treeModel){

            public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
                try {
                    return super.getNextMatch(prefix, startingRow, bias);
                }
                catch (Exception ex) {
                    return null;
                }
            }

            public void setModel(TreeModel model) {
                super.setModel(model);
                try {
                    if (TreePanel.this.checkedNodes != null) {
                        TreePanel.this.checkedNodes.clear();
                    }
                }
                catch (Exception ex) {
                }
            }
        };
        this.searchWindowManager = new SearchWindowManager(this);
        int i = 0;
        while (i < this.keyListeners.size()) {
            this.tree.addKeyListener((KeyListener)this.keyListeners.get(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.mouseListeners.size()) {
            this.tree.addMouseListener((MouseListener)this.mouseListeners.get(i2));
            ++i2;
        }
        if (mml != null) {
            int i3 = 0;
            while (i3 < mml.length) {
                this.tree.addMouseMotionListener(mml[i3]);
                ++i3;
            }
        }
        if (mwl != null) {
            int i4 = 0;
            while (i4 < mwl.length) {
                this.tree.addMouseWheelListener(mwl[i4]);
                ++i4;
            }
        }
        if (tsl != null) {
            int i5 = 0;
            while (i5 < tsl.length) {
                this.tree.addTreeSelectionListener(tsl[i5]);
                ++i5;
            }
        }
        if (twl != null) {
            int i6 = 0;
            while (i6 < twl.length) {
                this.tree.addTreeWillExpandListener(twl[i6]);
                ++i6;
            }
        }
        if (tel != null) {
            int i7 = 0;
            while (i7 < tel.length) {
                this.tree.addTreeExpansionListener(tel[i7]);
                ++i7;
            }
        }
        if (this.treeId != null && this.dndListener != null) {
            this.enableDrag(this.treeId, this.dndListener);
        }
        this.recreateTree();
        this.tree.repaint();
        try {
            this.tree.setSelectionPath(selPath.getParentPath());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.tree.setSelectionPath(selPath);
        }
        catch (Exception ex) {
        }
    }

    public final void revalidateTree() {
        TreePath[] paths = this.tree.getSelectionPaths();
        boolean asksAllowsChildren = this.treeModel.asksAllowsChildren();
        this.treeModel = new DefaultTreeModel((DefaultMutableTreeNode)this.tree.getModel().getRoot(), asksAllowsChildren);
        this.tree.setModel(this.treeModel);
        if (paths != null) {
            this.tree.setSelectionPaths(paths);
        }
    }

    public final void scrollPathToVisible(TreePath path) {
        this.tree.scrollPathToVisible(path);
    }

    public final void scrollRowToVisible(int row) {
        this.tree.scrollRowToVisible(row);
    }

    public final int search(String textToSeach) {
        return -1;
    }

    public void setCheckedNodes(HashSet checkedNodes) {
        this.checkedNodes = checkedNodes;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.treePane.setEnabled(enabled);
    }

    public final void setExpandAllNodes(boolean expandAllNodes) {
        this.expandAllNodes = expandAllNodes;
    }

    public final void setExpandRoot(boolean expandRoot) {
        this.expandRoot = expandRoot;
    }

    public final void setFolderIconName(String folderIconName) {
        this.folderIconName = folderIconName;
    }

    public final void setIconAttributeName(String iconAttributeName) {
        this.iconAttributeName = iconAttributeName;
    }

    public final void setLeavesImageName(String leavesImageName) {
        this.leavesImageName = leavesImageName;
    }

    public final void setLoadWhenVisibile(boolean loadWhenVisibile) {
        this.loadWhenVisibile = loadWhenVisibile;
    }

    public final void setMenuItemEnabled(String menuName, boolean enabled) {
        JMenuItem menu = (JMenuItem)this.menuItems.get(menuName);
        if (menu != null) {
            menu.setEnabled(enabled);
        }
    }

    public final void setMenuItemVisible(String menuName, boolean visible) {
        JMenuItem menu = (JMenuItem)this.menuItems.get(menuName);
        if (menu != null) {
            menu.setVisible(visible);
        }
    }

    public final void setRootVisible(boolean rootVisible) {
        this.rootVisible = rootVisible;
        this.tree.setRootVisible(rootVisible);
    }

    public final void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
        this.tree.setRowHeight(rowHeight);
    }

    public final void setSelectedIndex(int index) {
        this.tree.setSelectionRow(index);
        try {
            this.tree.scrollRowToVisible(index);
        }
        catch (Exception ex) {
        }
    }

    public final void setSelectedNode(DefaultMutableTreeNode node) {
        try {
            this.tree.setSelectionPath(new TreePath(node.getPath()));
        }
        catch (Exception ex) {
        }
    }

    public final void setSelectionBackground(Color selectionBackground) {
        this.selectionBackground = selectionBackground;
        UIManager.getDefaults().put("Tree.selectionBackground", new ColorUIResource(selectionBackground));
        this.tree.revalidate();
    }

    public final void setSelectionForeground(Color selectionForeground) {
        this.selectionForeground = selectionForeground;
        UIManager.getDefaults().put("Tree.selectionForeground", new ColorUIResource(selectionForeground));
        this.tree.revalidate();
    }

    public final void setSelectionMode(int mode) {
        this.selectionMode = this.selectionMode;
        this.tree.getSelectionModel().setSelectionMode(this.selectionMode);
        this.tree.setRowHeight(0);
    }

    public final void setSelectionPath(TreePath path) {
        this.tree.setSelectionPath(path);
    }

    public final void setSelectionPaths(TreePath[] paths) {
        this.tree.setSelectionPaths(paths);
    }

    public final void setSelectionRow(int row) {
        this.tree.setSelectionRow(row);
    }

    public final void setSelectionRows(int[] rows) {
        this.tree.setSelectionRows(rows);
    }

    public final void setShowCheckBoxes(boolean showCheckBoxes) {
        this.showCheckBoxes = showCheckBoxes;
    }

    public final void setShowCheckBoxesOnLeaves(boolean showCheckBoxesOnLeaves) {
        this.showCheckBoxesOnLeaves = showCheckBoxesOnLeaves;
    }

    public final void setShowsRootHandles(boolean showsRootHandles) {
        this.showsRootHandles = showsRootHandles;
        this.tree.setShowsRootHandles(showsRootHandles);
    }

    public final void setTooltipAttributeName(String tooltipAttributeName) {
        this.tooltipAttributeName = tooltipAttributeName;
    }

    public final void setTreeController(TreeController treeController) {
        this.treeController = treeController;
    }

    public final void setTreeDataLocator(TreeDataLocator treeDataLocator) {
        this.treeDataLocator = treeDataLocator;
    }

    public final void treeDoubleClick(MouseEvent e, JTree tree) {
        try {
            int selRow = tree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
            if (selPath != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1);
                this.treeController.doubleClick(node);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void treeLeftClick(MouseEvent e, JTree tree) {
        try {
            int selRow = tree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
            if (selPath != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1);
                this.treeController.leftClick(node);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void treeRightClick(MouseEvent e, JTree tree) {
        try {
            DefaultMutableTreeNode node;
            int selRow = tree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
            tree.setSelectionPath(selPath);
            if (selPath != null && this.treeController.rightClick(node = (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1)) && this.popup.getComponentCount() > 0 && this.treePane.isEnabled()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class DragGestureAdapter
    implements DragGestureListener {
        private DragSourceListener dragListener = null;

        public DragGestureAdapter(DragSourceListener dragListener) {
            this.dragListener = dragListener;
        }

        public final void dragGestureRecognized(DragGestureEvent event) {
            if (TreePanel.this.dndListener.dragEnabled()) {
                TreePanel.this.tree.setCursor(TreePanel.this.dragCursor);
                TreePanel.this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, new StringSelection(TreePanel.this.treeId), this.dragListener);
            } else {
                event.getSourceAsDragGestureRecognizer().resetRecognizer();
            }
        }
    }
}

