/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.util.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.message.send.java.Command;
import org.openswing.swing.tree.client.TreeGridPanel;
import org.openswing.swing.tree.client.TreePanel;
import org.openswing.swing.util.client.BusyListener;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.DefaultObjectSender;
import org.openswing.swing.util.client.ObjectSender;

public class ClientUtils
extends JApplet {
    private static JApplet applet;
    private static ArrayList busyListeners;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$org$openswing$swing$mdi$client$MDIFrame;
    private static ObjectSender defaultSender;
    private static String serverUrl;
    private static String sessionId;

    static {
        sessionId = null;
        applet = null;
        busyListeners = new ArrayList();
        defaultSender = new DefaultObjectSender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addBusyListener(BusyListener busyListener) {
        ArrayList arrayList = busyListeners;
        synchronized (arrayList) {
            busyListeners.add(busyListener);
        }
    }

    public static void addTabListener(final JComponent c) {
        if (ClientSettings.AS_TAB != null) {
            c.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == ClientSettings.AS_TAB.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.AS_TAB.getModifiers()) {
                        c.transferFocus();
                    }
                }
            });
        }
    }

    public static void centerDialog(JFrame parentFrame, JDialog d) {
        Dimension dim = parentFrame.getSize();
        d.setLocation(new Point(parentFrame.getLocation().x + (dim.width - d.getWidth()) / 2, Math.max(0, parentFrame.getLocation().y + (dim.height - d.getHeight()) / 2)));
    }

    public static void centerFrame(JFrame frame) {
        Dimension dim = frame.getSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((int)screen.getWidth() / 2 - frame.getWidth() / 2, Math.max(0, (int)screen.getHeight() / 2 - frame.getHeight() / 2));
    }

    public static void centerWindow(JFrame parentFrame, Window w) {
        Dimension dim = parentFrame.getSize();
        w.setLocation(new Point(parentFrame.getLocation().x + (dim.width - w.getWidth()) / 2, Math.max(0, parentFrame.getLocation().y + (dim.height - w.getHeight()) / 2)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final Object convertObject(Object value, Class targetType) {
        if (value == null) {
            return value;
        }
        if (value != null && !targetType.isAssignableFrom(value.getClass())) {
            try {
                if (value instanceof Number) {
                    value = targetType == Integer.TYPE ? (Number)new Integer(((Number)value).intValue()) : (Number)(targetType == Long.TYPE ? (Number)new Long(((Number)value).longValue()) : (Number)(targetType == Float.TYPE ? (Number)new Float(((Number)value).floatValue()) : (Number)(targetType == Double.TYPE ? (Number)new Double(((Number)value).doubleValue()) : (Number)(targetType == Short.TYPE ? (Number)new Short(((Number)value).shortValue()) : (Number)new Long(((Number)value).longValue())))));
                    value = targetType.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ClientUtils.class$("java.lang.String")) : class$java$lang$String).newInstance(value.toString());
                } else if (value instanceof java.util.Date) {
                    if (targetType.equals(class$java$sql$Date == null ? (class$java$sql$Date = ClientUtils.class$("java.sql.Date")) : class$java$sql$Date)) {
                        value = new Date(((java.util.Date)value).getTime());
                    } else if (targetType.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ClientUtils.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
                        value = new Timestamp(((java.util.Date)value).getTime());
                    }
                }
            }
            catch (Throwable ex1) {
            }
        }
        return value;
    }

    public static void displayURL(String url) {
        try {
            if (url.toLowerCase().startsWith("file://")) {
                url = url.substring(7);
            }
            Object desktop = Class.forName("java.awt.Desktop").getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktop.getClass().getMethod("open", class$java$io$File == null ? (class$java$io$File = ClientUtils.class$("java.io.File")) : class$java$io$File).invoke(desktop, new File(url));
        }
        catch (Throwable ex1) {
            if (!(url.toLowerCase().startsWith("file://") || url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://"))) {
                url = "file://" + url;
            }
            boolean windows = false;
            boolean mac = false;
            String os = System.getProperty("os.name");
            if (os != null && os.startsWith("Windows")) {
                windows = true;
            }
            if (os != null && os.toLowerCase().indexOf("mac") != -1) {
                mac = true;
            }
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Process p = Runtime.getRuntime().exec(cmd);
                }
                if (mac) {
                    try {
                        Class<?> clazz = Class.forName("com.apple.mrj.MRJFileUtils");
                        clazz.getMethod("openURL", class$java$lang$String == null ? (class$java$lang$String = ClientUtils.class$("java.lang.String")) : class$java$lang$String).invoke(null, url);
                    }
                    catch (Throwable ex) {
                        String[] commandLine = new String[]{"netscape", url};
                        Process process = Runtime.getRuntime().exec(commandLine);
                    }
                }
                cmd = "netscape -remote openURL(" + url + ")";
                Process p = Runtime.getRuntime().exec(cmd);
                try {
                    int exitCode = p.waitFor();
                    if (exitCode != 0) {
                        cmd = "netscape " + url;
                        p = Runtime.getRuntime().exec(cmd);
                    }
                }
                catch (InterruptedException ex) {
                    Logger.error("org.openswing.swing.util.client.ClientUtils", "displayURL", "Error while showing local document (cmd='" + cmd + "':\n" + ex.getMessage(), ex);
                }
            }
            catch (Throwable ex) {
                Logger.error("org.openswing.swing.util.client.ClientUtils", "displayURL", "Error while local document (cmd='" + cmd + "':\n" + ex.getMessage(), ex);
            }
        }
    }

    public static final void disposeComponents(Component[] c) {
        int i = 0;
        while (i < c.length) {
            if (c[i] instanceof Form) {
                ((Form)c[i]).finalize();
            } else if (c[i] instanceof GridControl) {
                ((GridControl)c[i]).finalize();
            } else if (c[i] instanceof InputControl) {
                int j;
                KeyListener[] ll;
                int j2;
                MouseListener[] ml;
                int j3;
                FocusListener[] fl;
                JComponent cc;
                InputControl ic = (InputControl)((Object)c[i]);
                if (ic instanceof JComponent) {
                    cc = (JComponent)((Object)ic);
                    fl = cc.getFocusListeners();
                    j3 = 0;
                    while (j3 < fl.length) {
                        cc.removeFocusListener(fl[j3]);
                        ++j3;
                    }
                    ml = cc.getMouseListeners();
                    j2 = 0;
                    while (j2 < ml.length) {
                        cc.removeMouseListener(ml[j2]);
                        ++j2;
                    }
                    ll = cc.getKeyListeners();
                    j = 0;
                    while (j < ll.length) {
                        cc.removeKeyListener(ll[j]);
                        ++j;
                    }
                }
                if (ic instanceof BaseInputControl && (cc = ((BaseInputControl)ic).getBindingComponent()) != null) {
                    fl = cc.getFocusListeners();
                    j3 = 0;
                    while (j3 < fl.length) {
                        cc.removeFocusListener(fl[j3]);
                        ++j3;
                    }
                    ml = cc.getMouseListeners();
                    j2 = 0;
                    while (j2 < ml.length) {
                        cc.removeMouseListener(ml[j2]);
                        ++j2;
                    }
                    ll = cc.getKeyListeners();
                    j = 0;
                    while (j < ll.length) {
                        cc.removeKeyListener(ll[j]);
                        ++j;
                    }
                }
                if (ic instanceof DateControl) {
                    ((DateControl)ic).finalize();
                }
            } else if (!(c[i] instanceof TreePanel) && !(c[i] instanceof TreeGridPanel) && c[i] instanceof JComponent) {
                ClientUtils.disposeComponents(((JComponent)c[i]).getComponents());
                JComponent cc = (JComponent)c[i];
                FocusListener[] fl = cc.getFocusListeners();
                int j = 0;
                while (j < fl.length) {
                    cc.removeFocusListener(fl[j]);
                    ++j;
                }
                MouseListener[] ml = cc.getMouseListeners();
                int j4 = 0;
                while (j4 < ml.length) {
                    cc.removeMouseListener(ml[j4]);
                    ++j4;
                }
                KeyListener[] ll = cc.getKeyListeners();
                int j5 = 0;
                while (j5 < ll.length) {
                    cc.removeKeyListener(ll[j5]);
                    ++j5;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < c.length) {
            try {
                if (c[i2].getParent() != null) {
                    c[i2].getParent().removeAll();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void fireBusyEvent(boolean busy) {
        ArrayList arrayList = busyListeners;
        synchronized (arrayList) {
            try {
                int i = 0;
                while (i < busyListeners.size()) {
                    ((BusyListener)busyListeners.get(i)).setBusy(busy);
                    ++i;
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Response getData(String serverMethodName, Object param) {
        try {
            ArrayList arrayList = busyListeners;
            synchronized (arrayList) {
                try {
                    int i = 0;
                    while (i < busyListeners.size()) {
                        ((BusyListener)busyListeners.get(i)).setBusy(true);
                        ++i;
                    }
                }
                catch (Exception ex1) {
                }
            }
            String servletURL = ClientUtils.getServerURL();
            URLConnection urlC = new URL(servletURL).openConnection();
            urlC.setRequestProperty("Content-Type", "application/octet-stream");
            urlC.setDoOutput(true);
            Response response = defaultSender.sendRequest(urlC, new Command(sessionId, serverMethodName, param));
            if (sessionId == null || serverMethodName.equals("login")) {
                sessionId = response.getSessionId();
            }
            ArrayList arrayList2 = busyListeners;
            synchronized (arrayList2) {
                try {
                    int i = 0;
                    while (i < busyListeners.size()) {
                        ((BusyListener)busyListeners.get(i)).setBusy(false);
                        ++i;
                    }
                }
                catch (Exception ex1) {
                }
            }
            return response;
        }
        catch (Throwable ex) {
            ArrayList arrayList = busyListeners;
            synchronized (arrayList) {
                try {
                    int i = 0;
                    while (i < busyListeners.size()) {
                        ((BusyListener)busyListeners.get(i)).setBusy(false);
                        ++i;
                    }
                }
                catch (Exception ex1) {
                }
            }
        }
        return new ErrorResponse(ex.getMessage());
    }

    public static Image getImage(String imageName, Class clazz) {
        if (Beans.isDesignTime()) {
            return new ImageIcon((class$org$openswing$swing$mdi$client$MDIFrame == null ? (class$org$openswing$swing$mdi$client$MDIFrame = ClientUtils.class$("org.openswing.swing.mdi.client.MDIFrame")) : class$org$openswing$swing$mdi$client$MDIFrame).getResource("/images/" + imageName)).getImage();
        }
        try {
            Image i = null;
            Class<?> jimi = null;
            try {
                jimi = Class.forName("com.sun.jimi.core.Jimi");
            }
            catch (ClassNotFoundException ex1) {
                // empty catch block
            }
            i = jimi != null && (imageName.toLowerCase().endsWith(".ico") || imageName.toLowerCase().endsWith(".bmp") || imageName.toLowerCase().endsWith(".png") || imageName.toLowerCase().endsWith(".pic") || imageName.toLowerCase().endsWith(".pcx") || imageName.toLowerCase().endsWith(".tif") || imageName.toLowerCase().endsWith(".tiff")) ? (Image)jimi.getMethod("getImage", class$java$net$URL == null ? (class$java$net$URL = ClientUtils.class$("java.net.URL")) : class$java$net$URL).invoke(null, (class$org$openswing$swing$mdi$client$MDIFrame == null ? (class$org$openswing$swing$mdi$client$MDIFrame = ClientUtils.class$("org.openswing.swing.mdi.client.MDIFrame")) : class$org$openswing$swing$mdi$client$MDIFrame).getResource("/images/" + imageName)) : (imageName.toLowerCase().endsWith(".tif") || imageName.toLowerCase().endsWith(".tiff") || imageName.toLowerCase().endsWith(".bmp") || imageName.toLowerCase().endsWith(".png") ? ImageIO.read(clazz.getResource("/images/" + imageName)) : new ImageIcon(clazz.getResource("/images/" + imageName)).getImage());
            if (i != null) {
                return i;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
        return null;
    }

    public static Image getImage(String imageName) {
        return ClientUtils.getImage(imageName, class$org$openswing$swing$mdi$client$MDIFrame == null ? (class$org$openswing$swing$mdi$client$MDIFrame = ClientUtils.class$("org.openswing.swing.mdi.client.MDIFrame")) : class$org$openswing$swing$mdi$client$MDIFrame);
    }

    private static Form getLinkedForm(Container c, HashSet panels) {
        Component comp = null;
        Iterator it = null;
        Form form = null;
        if (c == null) {
            return null;
        }
        int i = 0;
        while (i < c.getComponentCount()) {
            comp = c.getComponent(i);
            if (!(comp instanceof InputControl)) {
                if (comp instanceof Form) {
                    it = panels.iterator();
                    while (it.hasNext()) {
                        if (!((Form)comp).containsLinkedPanel((Container)it.next())) continue;
                        return (Form)comp;
                    }
                } else if (comp instanceof Container && (form = ClientUtils.getLinkedForm((Container)comp, panels)) != null) {
                    return form;
                }
            }
            ++i;
        }
        return null;
    }

    public static Form getLinkedForm(JComponent comp) {
        Container c = comp.getParent();
        HashSet<Container> panels = new HashSet<Container>();
        Container root = null;
        while (c != null && !(c instanceof Form)) {
            panels.add(c);
            root = c;
            c = c.getParent();
        }
        if (c != null) {
            return (Form)c;
        }
        return ClientUtils.getLinkedForm(root, panels);
    }

    public static JFrame getParentFrame(JComponent comp) {
        Container parentFrame = comp.getParent();
        while (parentFrame != null) {
            if (parentFrame instanceof JInternalFrame) {
                parentFrame = ((JInternalFrame)parentFrame).getDesktopPane().getParent();
            } else if (parentFrame instanceof JFrame) {
                return (JFrame)parentFrame;
            }
            parentFrame = parentFrame.getParent();
        }
        return null;
    }

    public static JInternalFrame getParentInternalFrame(JComponent comp) {
        Container parentFrame = comp.getParent();
        while (parentFrame != null) {
            if (parentFrame instanceof JInternalFrame) {
                return (JInternalFrame)parentFrame;
            }
            parentFrame = parentFrame.getParent();
        }
        return null;
    }

    public static final PropertyDescriptor getPropertyDescriptor(Class clazz, String attributeName) throws Exception {
        PropertyDescriptor[] props = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        int i = 0;
        while (i < props.length) {
            if (props[i].getName().equals(attributeName)) {
                return props[i];
            }
            ++i;
        }
        return null;
    }

    public static String getServerURL() throws Exception {
        if (serverUrl != null) {
            return serverUrl;
        }
        try {
            serverUrl = System.getProperty("SERVERURL");
            return serverUrl;
        }
        catch (Exception ex) {
            String msg = "An error occours on retrieving the server url";
            Logger.error("org.openswing.util.client.ClientUtils", "getServerURL", msg, ex);
            throw ex;
        }
    }

    public static Object getValue(ValueObject vo, String attributeName) throws Exception {
        String aName = attributeName;
        Method getter = null;
        Class<?> clazz = vo.getClass();
        Object obj = vo;
        while (aName.indexOf(".") != -1) {
            try {
                getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
            }
            obj = getter.invoke(obj, new Object[0]);
            if (obj == null) break;
            aName = aName.substring(aName.indexOf(".") + 1);
            clazz = getter.getReturnType();
        }
        if (obj != null) {
            try {
                getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            obj = getter.invoke(obj, new Object[0]);
        }
        return obj;
    }

    public final void init() {
        applet = this;
        serverUrl = this.getParameter("SERVERURL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeBusyListener(BusyListener busyListener) {
        ArrayList arrayList = busyListeners;
        synchronized (arrayList) {
            busyListeners.remove(busyListener);
        }
    }

    public static final void setObjectSender(ObjectSender objectSender) {
        defaultSender = objectSender;
    }

    public static void setSessionId(String id) {
        sessionId = id;
    }

    public static void showDocument(String docId) throws Exception {
        URL url = null;
        try {
            url = new URL(ClientUtils.getServerURL() + "?sessionId=" + sessionId + "&docId=" + docId);
            BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            bs.showDocument(url);
        }
        catch (Exception ex) {
            try {
                if (applet == null) {
                    Runtime.getRuntime().exec("C:/Programmi/Internet Explorer/IEXPLORE.EXE " + url);
                } else {
                    applet.getAppletContext().showDocument(url, "_blank");
                }
            }
            catch (Exception ex1) {
                String msg = "An error occours while opening the document";
                Logger.error("org.openswing.util.client.ClientUtils", "getServerURL", msg, ex1);
                throw ex1;
            }
        }
    }
}

