/*
 * Decompiled with CFR 0.152.
 */
package com.rp.database;

import com.rp.database.CacheableCallableStatement;
import com.rp.database.CacheablePreparedStatement;
import com.rp.database.CacheableStatement;
import com.rp.database.PooledConnection;
import com.rp.util.Cache;
import com.rp.util.Loggable;
import com.rp.util.pool.ObjectPool;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class CSConnection
extends PooledConnection {
    protected String CLASS_NAME = "CSConnection";
    protected Cache statementCache = null;
    protected boolean cacheable = false;
    protected String keyCode;
    protected static Random random = new Random();
    protected List keyList = null;

    public CSConnection(Connection con, ObjectPool pool, String logKey, Loggable log, boolean cacheable, Cache statementCache) {
        super(con, pool, logKey, log);
        super.setClassName(this.CLASS_NAME);
        String method = "Constructor";
        this.info(method, "in constructor");
        this.cacheable = cacheable;
        this.statementCache = statementCache;
        this.keyList = new ArrayList();
        this.keyCode = String.valueOf(random.nextInt(10000)) + String.valueOf(System.currentTimeMillis());
        this.info(method, "leaving constructor");
    }

    protected void setClassName(String name) {
        this.CLASS_NAME = name;
        super.setClassName(name);
    }

    protected PreparedStatement checkCachePrepared(String sql) {
        String method = "checkCachePrepared";
        this.info(method, "entering . . .");
        PreparedStatement ps = null;
        this.debug(method, "cacheable = " + this.cacheable);
        if (this.cacheable) {
            this.debug(method, "sql = " + sql);
            Object obj = this.statementCache.get(sql);
            if (obj != null) {
                this.debug(method, "object is not null");
                if (obj instanceof PreparedStatement) {
                    this.debug(method, "object instance of PreparedStatement");
                    try {
                        this.debug(method, "clearing statement");
                        ps = (PreparedStatement)obj;
                        ps.clearParameters();
                        ps.clearWarnings();
                        ps.clearBatch();
                        this.debug(method, "done clearing statement");
                    }
                    catch (Exception e) {
                        this.error(method, e.toString());
                        this.statementCache.remove(sql);
                    }
                }
            }
        }
        this.info(method, "leaving . . .");
        return ps;
    }

    protected CallableStatement checkCacheCallable(String sql) {
        String method = "checkCacheCallable";
        this.info(method, "entering . . .");
        CallableStatement cs = null;
        this.debug(method, "cacheable = " + this.cacheable);
        if (this.cacheable) {
            this.debug(method, "sql = " + sql);
            Object obj = this.statementCache.get(sql);
            if (obj != null) {
                this.debug(method, "object is not null");
                if (obj instanceof CallableStatement) {
                    this.debug(method, "object instance of CallableStatement");
                    try {
                        this.debug(method, "clearing statement");
                        cs = (CallableStatement)obj;
                        cs.clearParameters();
                        cs.clearWarnings();
                        cs.clearBatch();
                        this.debug(method, "done clearing statement");
                    }
                    catch (Exception e) {
                        this.error(method, e.toString());
                        this.statementCache.remove(sql);
                    }
                }
            }
        }
        this.info(method, "leaving . . .");
        return cs;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String method = "prepareStatement(String)";
        this.info(method, "entering . . .");
        this.debug(method, "sql = " + sql);
        PreparedStatement p = null;
        String key = this.keyCode + sql;
        this.debug(method, "key = " + key);
        this.debug(method, "calling checkCachePrepared()");
        PreparedStatement temp = this.checkCachePrepared(key);
        this.debug(method, "call complete");
        if (temp != null) {
            this.debug(method, "statement retrieved from cache");
            p = temp;
        } else {
            this.debug(method, "statement not found in cache");
            this.debug(method, "preparing statement");
            temp = this.con.prepareStatement(sql);
            this.debug(method, "statement prepared");
            this.debug(method, "cacheable = " + this.cacheable);
            if (this.cacheable) {
                this.debug(method, "creating CacheablePreparedStatement");
                p = new CacheablePreparedStatement(temp);
                this.debug(method, "done creating CacheablePreparedStatement");
                this.debug(method, "trying to add statement to cache");
                boolean b = this.statementCache.put(key, p);
                if (!b) {
                    this.debug(method, "cache is full, could not add statement");
                    this.debug(method, "converting to regular PreparedStatement");
                    p = temp;
                    this.statements.add(p);
                } else {
                    this.debug(method, "statement added to cache");
                    this.keyList.add(key);
                }
            } else {
                p = temp;
                this.statements.add(p);
            }
        }
        this.info(method, "leaving . . .");
        return p;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        String method = "prepareCall(String)";
        this.info(method, "entering . . .");
        this.debug(method, "sql = " + sql);
        CallableStatement c = null;
        String key = this.keyCode + sql;
        this.debug(method, "key = " + key);
        this.debug(method, "calling checkCacheCallable()");
        CallableStatement temp = this.checkCacheCallable(key);
        this.debug(method, "call complete");
        if (temp != null) {
            this.debug(method, "statement retrieved from cache");
            c = temp;
        } else {
            this.debug(method, "statement not found in cache");
            this.debug(method, "preparing call");
            temp = this.con.prepareCall(sql);
            this.debug(method, "call prepared");
            this.debug(method, "cacheable = " + this.cacheable);
            if (this.cacheable) {
                this.debug(method, "creating CacheableCallableStatement");
                c = new CacheableCallableStatement(temp);
                this.debug(method, "statement created");
                this.debug(method, "trying to add statement to cache");
                boolean b = this.statementCache.put(key, c);
                if (!b) {
                    this.debug(method, "cache is full. could not add statement");
                    this.debug(method, "converting to regular CallableStatement");
                    c = temp;
                    this.statements.add(c);
                } else {
                    this.debug(method, "statement added to cache");
                    this.keyList.add(key);
                }
            } else {
                c = temp;
                this.statements.add(c);
            }
        }
        this.info(method, "leaving . . .");
        return c;
    }

    protected void emptyCache() {
        String method = "emptyCache()";
        this.info(method, "entering . . .");
        if (this.keyList != null) {
            int size = this.keyList.size();
            this.debug(method, "number of keys = " + size);
            String key = null;
            this.debug(method, "attempting to remove objects from cache");
            for (int i = 0; i < size; ++i) {
                key = (String)this.keyList.get(i);
                Object obj = this.statementCache.get(key);
                if (obj == null || !(obj instanceof CacheableStatement)) continue;
                this.debug(method, "removing " + key + " from cache");
                this.statementCache.remove(key);
                CacheableStatement temp = (CacheableStatement)obj;
                this.debug(method, "destroying statement");
                try {
                    temp.destroy();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.info(method, "leaving . . .");
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() throws SQLException {
        String method = "destroy";
        this.info(method, "entering . . .");
        SQLException sqle = null;
        try {
            try {
                this.debug(method, "calling closeResources()");
                this.closeResources();
                this.debug(method, "done calling closeResources()");
            }
            catch (SQLException e) {
                sqle = e;
            }
            this.debug(method, "emptying cache");
            this.emptyCache();
            this.debug(method, "done emptying cache");
            try {
                this.debug(method, "closing connection");
                this.closeConnection();
                this.debug(method, "done closing connection");
            }
            catch (SQLException e) {
                sqle = e;
            }
        }
        finally {
            this.statements = null;
            this.pool = null;
        }
        if (sqle != null) {
            throw sqle;
        }
        this.info(method, "leaving . . .");
    }

    static {
        random = new Random();
    }
}

