/*
 * Decompiled with CFR 0.152.
 */
package com.rp.database;

import com.rp.database.ConnectionWrapper;
import com.rp.util.Loggable;
import com.rp.util.pool.ObjectPool;
import com.rp.util.pool.PoolException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class PooledConnection
extends ConnectionWrapper {
    protected Connection con = null;
    protected ObjectPool pool = null;
    protected List statements = null;
    protected Loggable log = null;
    protected String logKey = null;
    protected String CLASS_NAME = "PooledConnection";
    private long time = 0L;

    public PooledConnection(Connection con, ObjectPool pool, String logKey, Loggable log) {
        super(con);
        this.log = log;
        this.logKey = logKey;
        String method = "Constructor";
        this.info(method, "in constructor");
        this.con = con;
        this.pool = pool;
        this.statements = new ArrayList();
        this.time = this.getCurrentTime();
        this.info(method, "leaving constructor");
    }

    public PooledConnection(Connection con, ObjectPool pool) {
        this(con, pool, null, null);
        this.time = this.getCurrentTime();
    }

    public long getTime() {
        return this.time;
    }

    protected void setClassName(String name) {
        this.CLASS_NAME = name;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public Statement createStatement() throws SQLException {
        String method = "createStatement()";
        this.info(method, "entering . . .");
        this.debug(method, "creating statement . . .");
        Statement s = this.con.createStatement();
        this.statements.add(s);
        this.info(method, "leaving . . . ");
        return s;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String method = "prepareStatement(String)";
        this.info(method, "entering . . .");
        this.debug(method, "preparing statement with sql: " + sql);
        PreparedStatement p = this.con.prepareStatement(sql);
        this.debug(method, "statement prepared");
        this.statements.add(p);
        this.info(method, "leaving . . .");
        return p;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        String method = "prepareCall(String)";
        this.info(method, "entering . . .");
        this.debug(method, "preparing call with sql: " + sql);
        CallableStatement c = this.con.prepareCall(sql);
        this.debug(method, "statement prepared");
        this.statements.add(c);
        this.info(method, "leaving . . .");
        return c;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        String method = "createStatement(int, int)";
        this.info(method, "entering . . .");
        this.debug(method, "creating statement: " + resultSetType + ", " + resultSetConcurrency);
        Statement s = this.con.createStatement(resultSetType, resultSetConcurrency);
        this.debug(method, "statement created");
        this.statements.add(s);
        this.info(method, "leaving . . .");
        return s;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String method = "prepareStatement(String, int, int)";
        this.info(method, "entering . . .");
        this.debug(method, "preparing statement " + sql + ", " + resultSetType + ", " + resultSetConcurrency);
        PreparedStatement p = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        this.debug(method, "statement prepared");
        this.statements.add(p);
        this.info(method, "leaving . . .");
        return p;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String method = "prepareCall(String, int, int)";
        this.info(method, "entering . . .");
        this.debug(method, "preparing call " + sql + ", " + resultSetType + ", " + resultSetConcurrency);
        CallableStatement c = this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        this.debug(method, "call prepared");
        this.statements.add(c);
        this.info(method, "leaving . . .");
        return c;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String method = "createStatement(int, int, int)";
        this.info(method, "entering . . .");
        this.debug(method, "creating statement " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability);
        Statement s = this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.debug(method, "statement created");
        this.statements.add(s);
        this.info(method, "leaving . . .");
        return s;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String method = "prepareStatement (String, int, int, int)";
        this.info(method, "entering . . .");
        this.debug(method, "preparing statement " + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability);
        PreparedStatement p = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.debug(method, "statement prepared");
        this.statements.add(p);
        this.info(method, "leaving . . .");
        return p;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String method = "prepareCall (String, int, int, int)";
        this.info(method, "entering . . .");
        this.debug(method, "preparing call " + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability);
        CallableStatement c = this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.debug(method, "call prepared");
        this.statements.add(c);
        this.info(method, "leaving . . .");
        return c;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String method = "prepareStatement(String, int)";
        this.info(method, "entering . . .");
        this.debug(method, "preparing statement " + sql + ", " + autoGeneratedKeys);
        PreparedStatement p = this.con.prepareStatement(sql, autoGeneratedKeys);
        this.debug(method, "statement prepared");
        this.statements.add(p);
        this.info(method, "leaving . . .");
        return p;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        String method = "prepareStatement (String, int[]";
        this.info(method, "entering . . .");
        this.debug(method, "preparing statement " + sql);
        PreparedStatement p = this.con.prepareStatement(sql, columnIndexes);
        this.debug(method, "statement prepared");
        this.statements.add(p);
        this.info(method, "leaving . . .");
        return p;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String method = "prepareStatement(String, String[])";
        this.info(method, "entering . . .");
        this.debug(method, "preparing statement " + sql);
        PreparedStatement p = this.con.prepareStatement(sql, columnNames);
        this.debug(method, "statement prepared");
        this.statements.add(p);
        this.info(method, "leaving . . .");
        return p;
    }

    public void close() throws SQLException {
        String method = "close()";
        this.info(method, "entering . . .");
        try {
            this.debug(method, "closing connection resources . . .");
            this.closeResources();
            this.debug(method, "done closing connection resources .");
            this.debug(method, "freeing connection back to pool . . .");
            this.pool.freeObject(this);
            this.debug(method, "done freeing connection.");
        }
        catch (PoolException e) {
            this.error(method, "Exception trying to free object: " + e.toString());
            throw new SQLException(e.toString());
        }
        this.info(method, "leaving . . .");
    }

    protected void closeConnection() throws SQLException {
        String method = "closeConnection()";
        this.info(method, "entering . . .");
        if (this.con != null) {
            this.debug(method, "connection not null, attempting to close");
            this.con.close();
            this.debug(method, "connection is closed");
            this.con = null;
        }
        this.info(method, "leaving . . .");
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() throws SQLException {
        String method = "destroy()";
        this.info(method, "entering . . .");
        SQLException sqle = null;
        try {
            try {
                this.debug(method, "attempting to close resources");
                this.closeResources();
                this.debug(method, "resources closed");
            }
            catch (SQLException e) {
                this.error(method, e.toString());
                sqle = e;
            }
            try {
                this.debug(method, "attempting to close connection");
                this.closeConnection();
                this.debug(method, "connection closed");
            }
            catch (SQLException e) {
                this.error(method, e.toString());
                sqle = e;
            }
        }
        finally {
            this.statements = null;
            this.pool = null;
        }
        if (sqle != null) {
            throw sqle;
        }
        this.info(method, "leaving . . .");
    }

    protected void closeResources() throws SQLException {
        String method = "closeResources()";
        this.info(method, "entering . . .");
        SQLException eThrow = null;
        if (this.statements != null) {
            int size = this.statements.size();
            this.debug(method, "statements size = " + size);
            this.debug(method, "closing statements");
            ListIterator i = this.statements.listIterator();
            while (i.hasNext()) {
                try {
                    Statement s = (Statement)i.next();
                    if (s != null) {
                        s.close();
                    }
                    i.remove();
                }
                catch (SQLException e) {
                    this.error(method, "error closing statement.  index = " + i + " total indices = " + size);
                    eThrow = e;
                }
            }
            this.debug(method, "done closing statements");
        }
        if (eThrow != null) {
            throw eThrow;
        }
        this.info(method, "leaving . . .");
    }

    protected void fatal(String method, String s) {
        if (this.log != null) {
            this.log.fatal(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void error(String method, String s) {
        if (this.log != null) {
            this.log.error(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void warn(String method, String s) {
        if (this.log != null) {
            this.log.warn(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void info(String method, String s) {
        if (this.log != null) {
            this.log.info(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void debug(String method, String s) {
        if (this.log != null) {
            this.log.debug(this.CLASS_NAME, method, s, this.logKey);
        }
    }
}

