/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.springframework.web.servlet.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openswing.springframework.web.servlet.view.OpenSwingViewResolver;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.send.java.Command;
import org.openswing.swing.util.server.DefaultObjectReceiver;
import org.openswing.swing.util.server.ObjectReceiver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class OpenSwingHandlerMapping
extends AbstractHandlerMapping {
    public static final String COMMAND_ATTRIBUTE_NAME = "COMMAND_ATTRIBUTE_NAME";
    public static final String USERS_AUTHENTICATED = "USERS_AUTHENTICATED";
    private HandlerInterceptor[] newinterceptors = null;
    private ObjectReceiver objectReceiver = new DefaultObjectReceiver();
    private OpenSwingViewResolver resolver = new OpenSwingViewResolver();

    protected final HandlerExecutionChain getHandlerExecutionChain(Object handler, HttpServletRequest request) {
        if (this.newinterceptors == null) {
            HandlerInterceptor[] interceptors = this.getAdaptedInterceptors();
            if (interceptors == null) {
                interceptors = new HandlerInterceptor[]{};
            }
            this.newinterceptors = interceptors;
            if (interceptors.length == 0 || !(interceptors[0] instanceof CommandInterceptor)) {
                this.newinterceptors = new HandlerInterceptor[interceptors.length + 1];
                this.newinterceptors[0] = new CommandInterceptor();
                System.arraycopy(interceptors, 0, this.newinterceptors, 1, interceptors.length);
            }
        }
        return new HandlerExecutionChain(handler, this.newinterceptors);
    }

    protected final Object getHandlerInternal(HttpServletRequest request) throws Exception {
        Command command = (Command)request.getAttribute(COMMAND_ATTRIBUTE_NAME);
        if (command != null) {
            return command.getMethodName();
        }
        if (request.getMethod().equals("GET") && request.getParameter("docId") != null) {
            request.setAttribute(COMMAND_ATTRIBUTE_NAME, (Object)new Command(request.getParameter("sessionId"), "getDoc", request.getParameter("docId")));
            return command.getMethodName();
        }
        command = this.objectReceiver.getObjectFromRequest(request);
        request.setAttribute(COMMAND_ATTRIBUTE_NAME, (Object)command);
        return command.getMethodName();
    }

    protected final void initInterceptors() {
        super.initInterceptors();
        this.newinterceptors = null;
    }

    public final void setObjectReceiver(ObjectReceiver objectReceiver) {
        this.objectReceiver = objectReceiver;
        this.resolver.setObjectReceiver(objectReceiver);
    }

    class CommandInterceptor
    extends HandlerInterceptorAdapter {
        CommandInterceptor() {
        }

        public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView model) throws Exception {
            Command command = (Command)request.getAttribute(OpenSwingHandlerMapping.COMMAND_ATTRIBUTE_NAME);
            Object answer = model.getModel().get("response");
            if (answer == null) {
                answer = model.getModel().values().iterator().next();
            }
            if (answer != null && answer instanceof Response) {
                String sessionId = command.getSessionId();
                if (sessionId == null) {
                    sessionId = "" + System.currentTimeMillis() + Math.random();
                }
                if (((Response)answer).getSessionId() == null) {
                    ((Response)answer).setSessionId(sessionId);
                }
                model.setView((View)OpenSwingHandlerMapping.this.resolver);
            }
        }
    }
}

