/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.springframework.web.servlet.handler;

import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.send.java.Command;
import org.openswing.swing.util.server.DefaultObjectReceiver;
import org.openswing.swing.util.server.ObjectReceiver;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SessionCheckInterceptor
extends HandlerInterceptorAdapter {
    private String loginMethodName;
    private ObjectReceiver objectReceiver = new DefaultObjectReceiver();

    public final String getLoginMethodName() {
        return this.loginMethodName;
    }

    public final boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean ok;
        Command command = (Command)request.getAttribute("COMMAND_ATTRIBUTE_NAME");
        HashSet sessionIds = (HashSet)request.getSession().getServletContext().getAttribute("USERS_AUTHENTICATED");
        if (sessionIds == null) {
            sessionIds = new HashSet();
            request.getSession().getServletContext().setAttribute("USERS_AUTHENTICATED", sessionIds);
        }
        boolean bl = ok = command != null && (command.getMethodName().equals(this.loginMethodName) || command.getSessionId() != null && sessionIds.contains(command.getSessionId()));
        if (!ok) {
            ErrorResponse answer = new ErrorResponse("Cannot process the request: authentication needed!");
            this.objectReceiver.setObjectToResponse(response, answer);
        }
        return ok;
    }

    public final void setLoginMethodName(String loginMethodName) {
        this.loginMethodName = loginMethodName;
    }

    public final void setObjectReceiver(ObjectReceiver objectReceiver) {
        this.objectReceiver = objectReceiver;
    }
}

