/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.springframework.web.servlet.utils;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openswing.swing.message.send.java.Command;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class DocumentController
implements Controller {
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mav = new ModelAndView();
        Command command = (Command)request.getAttribute("COMMAND_ATTRIBUTE_NAME");
        String docId = command.getInputParam().toString();
        byte[] bytes = (byte[])request.getSession().getServletContext().getAttribute(docId);
        new TimeoutDocIdThread(request.getSession().getServletContext(), docId);
        if (docId.endsWith(".xls")) {
            response.setContentType("application/vnd.ms-excel");
        } else if (docId.endsWith(".xls") || docId.endsWith(".csv")) {
            response.setContentType("application/vnd.ms-excel");
        } else if (docId.endsWith(".pdf")) {
            response.setContentType("application/pdf");
        } else if (docId.endsWith(".rtf")) {
            response.setContentType("application/rtf");
        } else if (docId.endsWith(".html")) {
            response.setContentType("text/html");
        } else if (docId.endsWith(".xml")) {
            response.setContentType("text/xml");
        }
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(bytes);
            out.close();
        }
        catch (IOException ex) {
            return null;
        }
        return null;
    }

    class TimeoutDocIdThread
    extends Thread {
        private ServletContext context = null;
        private String docId;

        public TimeoutDocIdThread(ServletContext context, String docId) {
            this.context = context;
            this.docId = docId;
            this.start();
        }

        public void run() {
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            try {
                this.context.removeAttribute(this.docId);
            }
            catch (Exception ex1) {
            }
        }
    }
}

