/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.springframework.web.servlet.utils;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openswing.swing.export.java.ExportOptions;
import org.openswing.swing.export.java.ExportToCSV;
import org.openswing.swing.export.java.ExportToExcel;
import org.openswing.swing.export.java.ExportToHTML;
import org.openswing.swing.export.java.ExportToPDF;
import org.openswing.swing.export.java.ExportToRTF;
import org.openswing.swing.export.java.ExportToXML;
import org.openswing.swing.export.java.ExportToXMLFat;
import org.openswing.swing.export.java.GridExportOptions;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.TextResponse;
import org.openswing.swing.message.send.java.Command;
import org.openswing.swing.message.send.java.GridParams;
import org.openswing.swing.table.java.GridDataLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class ExportController
implements Controller {
    private void exportGrid(final GridExportOptions opt, final Command command, final HttpServletRequest request, final HttpServletResponse response) {
        ApplicationContext context = (ApplicationContext)request.getAttribute("org.springframework.web.servlet.DispatcherServlet.CONTEXT");
        final Controller controller = (Controller)context.getBean(opt.getServerMethodName());
        GridDataLocator newDataLocator = new GridDataLocator(){

            public Response loadData(int gridAction, int startIndex, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, Map otherGridParams) {
                request.setAttribute("COMMAND_ATTRIBUTE_NAME", (Object)new Command(command.getSessionId(), opt.getServerMethodName(), new GridParams(gridAction, startIndex, filteredColumns, currentSortedColumns, currentSortedVersusColumns, otherGridParams)));
                try {
                    return (Response)controller.handleRequest(request, response).getModel().get("response");
                }
                catch (Exception ex) {
                    return new ErrorResponse(ex.toString());
                }
            }
        };
        opt.setGridDataLocator(newDataLocator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) {
        String docId;
        byte[] doc;
        ModelAndView mav;
        block12: {
            mav = new ModelAndView();
            Command command = (Command)request.getAttribute("COMMAND_ATTRIBUTE_NAME");
            ExportOptions opt = (ExportOptions)command.getInputParam();
            Object obj = null;
            int i = 0;
            while (i < opt.getComponentsExportOptions().size()) {
                obj = opt.getComponentsExportOptions().get(i);
                if (obj instanceof GridExportOptions) {
                    this.exportGrid(obj, command, request, response);
                }
                ++i;
            }
            doc = null;
            docId = null;
            try {
                block14: {
                    block13: {
                        if (opt.getExportType().equals("XLS")) {
                            doc = new ExportToExcel().getDocument(opt);
                            docId = "doc" + System.currentTimeMillis() + ".xls";
                            break block12;
                        }
                        if (opt.getExportType().equals("CSV (,)")) break block13;
                        if (!opt.getExportType().equals("CSV (;)")) break block14;
                    }
                    doc = new ExportToCSV().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".csv";
                    break block12;
                }
                if (opt.getExportType().equals("XML (small format)")) {
                    doc = new ExportToXML().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".xml";
                    break block12;
                }
                if (opt.getExportType().equals("XML (large format)")) {
                    doc = new ExportToXMLFat().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".xml";
                    break block12;
                }
                if (opt.getExportType().equals("HTML")) {
                    doc = new ExportToHTML().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".html";
                    break block12;
                }
                if (opt.getExportType().equals("PDF")) {
                    doc = new ExportToPDF().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".pdf";
                    break block12;
                }
                if (opt.getExportType().equals("RTF")) {
                    doc = new ExportToRTF().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".rtf";
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                new ErrorResponse(ex.getMessage());
            }
        }
        request.getSession().getServletContext().setAttribute(docId, (Object)doc);
        mav.addObject("response", (Object)new TextResponse(docId));
        return mav;
    }
}

