/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.export.java;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.openswing.swing.export.java.ComponentExportOptions;
import org.openswing.swing.export.java.ExportOptions;
import org.openswing.swing.export.java.GridExportCallbacks;
import org.openswing.swing.export.java.GridExportOptions;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;

public class ExportToXMLFat {
    String newline = System.getProperty("line.separator");

    private void appendRow(ExportOptions exportOptions, StringBuffer sb, Object vo, GridExportOptions opt, Hashtable gettersMethods, SimpleDateFormat sdf, SimpleDateFormat sdatf, SimpleDateFormat stf, String newline, int rownum, int tableType) throws Throwable {
        String aName = null;
        Method getter = null;
        Class<?> clazz = null;
        Object obj = null;
        String tagName = null;
        sb.append("\t<row>").append(newline);
        int i = 0;
        while (i < opt.getExportColumns().size()) {
            clazz = vo.getClass();
            obj = vo;
            aName = opt.getExportAttrColumns().get(i).toString();
            while (aName.indexOf(".") != -1) {
                try {
                    getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                }
                catch (NoSuchMethodException ex2) {
                    getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                }
                aName = aName.substring(aName.indexOf(".") + 1);
                clazz = getter.getReturnType();
                obj = getter.invoke(obj, new Object[0]);
                if (obj == null) break;
            }
            try {
                getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            if (obj != null) {
                obj = getter.invoke(obj, new Object[0]);
            }
            tagName = opt.getExportAttrColumns().get(i).toString();
            sb.append("\t\t<" + tagName).append(" type=\"").append(getter.getReturnType().getName()).append("\" >");
            if (obj != null) {
                if (obj instanceof java.sql.Date || obj instanceof Date || obj instanceof Timestamp) {
                    int type = (Integer)opt.getColumnsType().get(opt.getExportAttrColumns().get(i));
                    if (type == 1) {
                        sb.append(sdf.format((Date)obj)).append("</" + tagName + ">").append(newline);
                    } else if (type == 2) {
                        sb.append(sdatf.format((Date)obj)).append("</" + tagName + ">").append(newline);
                    } else if (type == 3) {
                        sb.append(stf.format((Date)obj)).append("</" + tagName + ">").append(newline);
                    }
                } else {
                    sb.append(this.encodeText(obj.toString())).append("</" + tagName + ">").append(newline);
                }
            } else {
                sb.append("</" + tagName + ">").append(newline);
            }
            ++i;
        }
        sb.append("\t</row>").append(newline);
        if (opt.getCallbacks() != null) {
            if (tableType == 0) {
                this.processComponent(sb, exportOptions, opt.getCallbacks().getComponentPerRowInHeader((ValueObject)vo, rownum));
            } else if (tableType == 1) {
                ComponentExportOptions compOpts = opt.getCallbacks().getComponentPerRow((ValueObject)vo, rownum);
                if (compOpts != null) {
                    this.processComponent(sb, exportOptions, compOpts);
                }
            } else if (tableType == 2) {
                this.processComponent(sb, exportOptions, opt.getCallbacks().getComponentPerRowInFooter((ValueObject)vo, rownum));
            }
        }
    }

    private String encodeText(String text) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) >= '.' && text.charAt(i) <= 'Z' || text.charAt(i) >= 'a' && text.charAt(i) <= 'z' || text.charAt(i) == ' ') {
                sb.append(text.charAt(i));
            } else {
                sb.append("&#").append((int)text.charAt(i)).append(";");
            }
            ++i;
        }
        return sb.toString();
    }

    public byte[] getDocument(ExportOptions opt) throws Throwable {
        StringBuffer sb = new StringBuffer("");
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(this.newline);
        sb.append("<content>").append(this.newline);
        Object obj = null;
        int i = 0;
        while (i < opt.getComponentsExportOptions().size()) {
            obj = opt.getComponentsExportOptions().get(i);
            this.processComponent(sb, opt, obj);
            ++i;
        }
        sb.append("</content>").append(this.newline);
        byte[] doc = sb.toString().getBytes();
        return doc;
    }

    private void prepareGenericComponent(StringBuffer sb, ExportOptions exportOptions, ComponentExportOptions opt) throws Throwable {
        Object[] row = null;
        Object obj = null;
        SimpleDateFormat sdatf = new SimpleDateFormat(exportOptions.getDateTimeFormat());
        String newline = System.getProperty("line.separator");
        if (opt.getCellsContent() != null) {
            int i = 0;
            while (i < opt.getCellsContent().length) {
                row = opt.getCellsContent()[i];
                sb.append("<row>").append(newline);
                int j = 0;
                while (j < row.length) {
                    obj = row[j];
                    sb.append("\t<cell>").append(newline);
                    if (obj != null) {
                        if (obj instanceof Boolean) {
                            sb.append((Boolean)obj);
                        } else if (obj.getClass().equals(Boolean.TYPE)) {
                            sb.append((Boolean)obj);
                        } else if (obj instanceof java.sql.Date || obj instanceof Date || obj instanceof Timestamp) {
                            sb.append(sdatf.format((Date)obj));
                        } else {
                            sb.append(this.encodeText(obj.toString()));
                        }
                    }
                    sb.append("\t<cell>").append(newline);
                    ++j;
                }
                sb.append("</row>").append(newline);
                ++i;
            }
        }
    }

    private void prepareGrid(StringBuffer sb, ExportOptions exportOptions, GridExportOptions opt) throws Throwable {
        int j;
        String[] filters;
        String methodName = null;
        String attributeName = null;
        Hashtable<String, Method> gettersMethods = new Hashtable<String, Method>();
        Method[] voMethods = opt.getValueObjectType().getMethods();
        int i = 0;
        while (i < voMethods.length) {
            methodName = voMethods[i].getName();
            if (methodName.startsWith("get")) {
                attributeName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                if (opt.getExportAttrColumns().contains(attributeName)) {
                    gettersMethods.put(attributeName, voMethods[i]);
                }
            }
            ++i;
        }
        Response response = null;
        int start = 0;
        int rownum = 0;
        Object value = null;
        Object vo = null;
        SimpleDateFormat sdf = new SimpleDateFormat(exportOptions.getDateFormat());
        SimpleDateFormat sdatf = new SimpleDateFormat(exportOptions.getDateTimeFormat());
        SimpleDateFormat stf = new SimpleDateFormat(exportOptions.getTimeFormat());
        String newline = System.getProperty("line.separator");
        Object tagName = null;
        if (opt.getTitle() != null && !opt.getTitle().equals("")) {
            sb.append("<title>").append(opt.getTitle()).append("</title>").append(newline);
        }
        if ((filters = opt.getFilteringConditions()) != null) {
            sb.append("<filters>").append(newline);
            int i2 = 0;
            while (i2 < filters.length) {
                sb.append("<filter>").append(filters[i2]).append("</filter>").append(newline);
                ++i2;
            }
            sb.append("</filters>").append(newline);
        }
        int j2 = 0;
        while (j2 < opt.getTopRows().size()) {
            vo = opt.getTopRows().get(j2);
            this.appendRow(exportOptions, sb, vo, opt, gettersMethods, sdf, sdatf, stf, newline, j2, 0);
            ++j2;
        }
        do {
            if ((response = opt.getGridDataLocator().loadData(1, start, opt.getFilteredColumns(), opt.getCurrentSortedColumns(), opt.getCurrentSortedVersusColumns(), opt.getValueObjectType(), opt.getOtherGridParams())).isError()) {
                throw new Exception(response.getErrorMessage());
            }
            j = 0;
            while (j < ((VOListResponse)response).getRows().size()) {
                vo = ((VOListResponse)response).getRows().get(j);
                this.appendRow(exportOptions, sb, vo, opt, gettersMethods, sdf, sdatf, stf, newline, rownum, 1);
                ++rownum;
                ++j;
            }
            start += ((VOListResponse)response).getRows().size();
        } while (((VOListResponse)response).isMoreRows() && rownum < opt.getMaxRows());
        j = 0;
        while (j < opt.getBottomRows().size()) {
            vo = opt.getBottomRows().get(j);
            this.appendRow(exportOptions, sb, vo, opt, gettersMethods, sdf, sdatf, stf, newline, j, 2);
            ++j;
        }
    }

    private void processComponent(StringBuffer sb, ExportOptions exportOptions, Object obj) throws Throwable {
        if (obj != null) {
            GridExportCallbacks callbacks = null;
            if (obj instanceof GridExportOptions) {
                callbacks = ((GridExportOptions)obj).getCallbacks();
                if (callbacks != null) {
                    this.processComponent(sb, exportOptions, callbacks.getHeaderComponent());
                }
                this.prepareGrid(sb, exportOptions, (GridExportOptions)obj);
                if (callbacks != null) {
                    this.processComponent(sb, exportOptions, callbacks.getFooterComponent());
                }
            } else if (obj instanceof ComponentExportOptions) {
                this.prepareGenericComponent(sb, exportOptions, (ComponentExportOptions)obj);
            } else {
                return;
            }
            sb.append(this.newline);
        }
    }
}

