/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.export.server;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openswing.swing.export.java.ExportOptions;
import org.openswing.swing.export.java.ExportToCSV;
import org.openswing.swing.export.java.ExportToExcel;
import org.openswing.swing.export.java.ExportToHTML;
import org.openswing.swing.export.java.ExportToPDF;
import org.openswing.swing.export.java.ExportToRTF;
import org.openswing.swing.export.java.ExportToXML;
import org.openswing.swing.export.java.ExportToXMLFat;
import org.openswing.swing.export.java.GridExportOptions;
import org.openswing.swing.logger.server.Logger;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.TextResponse;
import org.openswing.swing.message.send.java.GridParams;
import org.openswing.swing.server.Action;
import org.openswing.swing.server.ActionsCollection;
import org.openswing.swing.server.UserSessionParameters;
import org.openswing.swing.table.java.GridDataLocator;

public class ExportAction
implements Action {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Response executeCommand(Object inputPar, UserSessionParameters userSessionPars, HttpServletRequest request, HttpServletResponse response, HttpSession userSession, ServletContext context) {
        String docId;
        byte[] doc;
        block12: {
            ExportOptions opt = (ExportOptions)inputPar;
            Object obj = null;
            int i = 0;
            while (i < opt.getComponentsExportOptions().size()) {
                obj = opt.getComponentsExportOptions().get(i);
                if (obj instanceof GridExportOptions) {
                    this.exportGrid(obj, userSessionPars, request, response, userSession, context);
                }
                ++i;
            }
            doc = null;
            docId = null;
            try {
                block14: {
                    block13: {
                        if (opt.getExportType().equals("XLS")) {
                            doc = new ExportToExcel().getDocument(opt);
                            docId = "doc" + System.currentTimeMillis() + ".xls";
                            break block12;
                        }
                        if (opt.getExportType().equals("CSV (,)")) break block13;
                        if (!opt.getExportType().equals("CSV (;)")) break block14;
                    }
                    doc = new ExportToCSV().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".csv";
                    break block12;
                }
                if (opt.getExportType().equals("XML (small format)")) {
                    doc = new ExportToXML().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".xml";
                    break block12;
                }
                if (opt.getExportType().equals("XML (large format)")) {
                    doc = new ExportToXMLFat().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".xml";
                    break block12;
                }
                if (opt.getExportType().equals("HTML")) {
                    doc = new ExportToHTML().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".html";
                    break block12;
                }
                if (opt.getExportType().equals("PDF")) {
                    doc = new ExportToPDF().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".pdf";
                    break block12;
                }
                if (opt.getExportType().equals("RTF")) {
                    doc = new ExportToRTF().getDocument(opt);
                    docId = "doc" + System.currentTimeMillis() + ".rtf";
                }
            }
            catch (Throwable ex) {
                Logger.error(userSessionPars.getUsername(), this.getClass().getName(), "executeCommand", "Error while exporting data:\n" + ex.getMessage(), ex);
                new ErrorResponse(ex.getMessage());
            }
        }
        context.setAttribute(docId, (Object)doc);
        return new TextResponse(docId);
    }

    private void exportGrid(GridExportOptions opt, final UserSessionParameters userSessionPars, final HttpServletRequest request, final HttpServletResponse response, final HttpSession userSession, final ServletContext context) {
        ActionsCollection actions = (ActionsCollection)context.getAttribute("ACTION_CLASSES");
        final Action action = (Action)actions.get(opt.getServerMethodName());
        GridDataLocator newDataLocator = new GridDataLocator(){

            public Response loadData(int gridAction, int startIndex, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, Map otherGridParams) {
                return action.executeCommand(new GridParams(gridAction, startIndex, filteredColumns, currentSortedColumns, currentSortedVersusColumns, otherGridParams), userSessionPars, request, response, userSession, context);
            }
        };
        opt.setGridDataLocator(newDataLocator);
    }

    public final String getRequestName() {
        return "exportDataGrid";
    }
}

